/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.config.SizeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class Threshold {
    public static final Threshold NONE;
    public static final Threshold DEFAULT;
    private static final Pattern PATTERN;
    private final long size;
    private final SizeUnit unit;
    private final long bytes;
    static final long serialVersionUID = 8133458803105919517L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private Threshold(long size, SizeUnit unit) {
        this.size = size;
        this.unit = unit == null ? SizeUnit.BYTE : unit;
        this.bytes = size > 0L ? this.unit.toBytes(size) : -1L;
    }

    public static Threshold of(long size, SizeUnit unit) {
        if (size < 0L) {
            return NONE;
        }
        return new Threshold(size, unit);
    }

    public long toBytes() {
        return this.bytes;
    }

    public SizeUnit sizeUnit() {
        return this.unit;
    }

    public boolean reached(long size) {
        if (this.bytes == -1L) {
            return false;
        }
        return size > this.bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.size) + Objects.hash(new Object[]{this.unit});
    }

    public static Threshold valueOf(String value) {
        Matcher matcher = PATTERN.matcher(Objects.requireNonNull(value, Messages.MESSAGES.nullParameter("value")).toUpperCase(Locale.ROOT));
        if (!matcher.find()) {
            return DEFAULT;
        }
        String stringSize = matcher.group("size");
        String stringUnit = matcher.group("unit");
        if (stringSize == null || stringSize.isBlank()) {
            return DEFAULT;
        }
        long size = Long.parseLong(stringSize);
        if (size < 0L) {
            return NONE;
        }
        SizeUnit unit = null;
        for (SizeUnit u : SizeUnit.values()) {
            if (!u.abbreviation().equals(stringUnit)) continue;
            unit = u;
            break;
        }
        return Threshold.of(size, unit == null ? SizeUnit.BYTE : unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Threshold)) {
            return false;
        }
        Threshold other = (Threshold)obj;
        return this.size == other.size && this.unit == other.unit;
    }

    public String toString() {
        return this.size + this.unit.abbreviation();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.spi.config.Threshold", Threshold.class, null, null);
        NONE = new Threshold(-1L, SizeUnit.BYTE);
        DEFAULT = new Threshold(512L, SizeUnit.KILOBYTE);
        PATTERN = Pattern.compile("(?<size>-?(?!0)\\d+)\\s*(?<unit>(?:ZB|EB|TB|PB|GB|MB|KB|B)\\b)?");
    }
}

