/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.context.impl;

import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.context.JobContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JobContextImpl
implements JobContext {
    private static final String sourceClass = JobContextImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Object transientUserData;
    private static final boolean cloneContextProperties = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
        static final long serialVersionUID = 8618054059242900056L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Boolean run() {
            return Boolean.getBoolean("clone.context.properties");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.context.impl.JobContextImpl$1", 1.class, (String)"wsbatch", null);
        }
    });
    private WorkUnitDescriptor delegate;
    static final long serialVersionUID = -3496956485964388963L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobContextImpl(WorkUnitDescriptor rwue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "<init>", new Object[]{rwue});
        }
        this.transientUserData = null;
        this.delegate = null;
        this.delegate = rwue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getExitStatus() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getExitStatus", new Object[0]);
        }
        String string = this.delegate.getExitStatus();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getExitStatus", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExitStatus(String exitStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "setExitStatus", new Object[]{exitStatus});
        }
        logger.fine("Setting exitStatus = " + exitStatus);
        this.delegate.setExitStatus(exitStatus);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "setExitStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchStatus getBatchStatus() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getBatchStatus", new Object[0]);
        }
        BatchStatus batchStatus = this.delegate.getBatchStatus();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchStatus = batchStatus;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getBatchStatus", batchStatus);
        }
        return batchStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Properties getProperties() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getProperties", new Object[0]);
        }
        Properties properties = this.delegate.getTopLevelJobProperties();
        if (cloneContextProperties) {
            logger.fine("Cloning job context properties");
            Properties properties2 = (Properties)properties.clone();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                properties2 = properties2;
                logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getProperties", properties2);
            }
            return properties2;
        }
        logger.fine("Returing ref (non-clone) to job context properties");
        Properties properties3 = properties;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            properties3 = properties3;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getProperties", properties3);
        }
        return properties3;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJobName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getJobName", new Object[0]);
        }
        String string = this.delegate.getTopLevelJobName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getJobName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getExecutionId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getExecutionId", new Object[0]);
        }
        long l = this.delegate.getTopLevelExecutionId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getExecutionId", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getInstanceId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getInstanceId", new Object[0]);
        }
        long l = this.delegate.getTopLevelInstanceId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getInstanceId", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getTransientUserData() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "getTransientUserData", new Object[0]);
        }
        Object object = this.transientUserData;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            object = object;
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "getTransientUserData", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTransientUserData(Object data) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.context.impl.JobContextImpl", "setTransientUserData", new Object[]{data});
        }
        this.transientUserData = data;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.context.impl.JobContextImpl", "setTransientUserData");
        }
    }
}

