/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence.jpa;

import com.ibm.jbatch.container.persistence.jpa.EntityConstants;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityExtractor;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.annotations.ClassExtractor;

@NamedQueries(value={@NamedQuery(name="JobInstanceEntity.getJobInstancesByNameAndStatus", query="SELECT i.instanceId FROM JobInstanceEntity i WHERE i.batchStatus IN :status AND i.jobName = :name"), @NamedQuery(name="JobInstanceEntity.getJobInstancesSortIdAllQuery", query="SELECT i FROM JobInstanceEntity i ORDER BY i.createTime DESC"), @NamedQuery(name="JobInstanceEntity.getJobInstancesSortIdBySubmitterQuery", query="SELECT i FROM JobInstanceEntity i WHERE i.submitter = :submitter ORDER BY i.createTime DESC"), @NamedQuery(name="JobInstanceEntity.getJobNamesSetQuery", query="SELECT DISTINCT i.jobName FROM JobInstanceEntity i"), @NamedQuery(name="JobInstanceEntity.getJobNamesSetBySubmitterQuery", query="SELECT DISTINCT i.jobName FROM JobInstanceEntity i WHERE i.submitter = :submitter"), @NamedQuery(name="JobInstanceEntity.getJobInstanceCountByJobNameQuery", query="SELECT COUNT(i.instanceId) FROM JobInstanceEntity i WHERE i.jobName = :name"), @NamedQuery(name="JobInstanceEntity.getJobInstanceCountByJobNameAndSubmitterQuery", query="SELECT COUNT(i.instanceId) FROM JobInstanceEntity i WHERE i.jobName = :name AND i.submitter = :submitter"), @NamedQuery(name="JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameQuery", query="SELECT i FROM JobInstanceEntity i WHERE i.jobName=:name ORDER BY i.createTime DESC"), @NamedQuery(name="JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameAndSubmitterQuery", query="SELECT i FROM JobInstanceEntity i WHERE i.jobName=:name AND i.submitter = :submitter ORDER BY i.createTime DESC")})
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@ClassExtractor(value=JobInstanceEntityExtractor.class)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobInstanceEntity
implements JobInstance,
WSJobInstance,
EntityConstants {
    public static final String GET_JOBINSTANCES_SORT_CREATETIME_BY_JOBNAME_QUERY = "JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameQuery";
    public static final String GET_JOBINSTANCES_SORT_CREATETIME_BY_JOBNAME_AND_SUBMITTER_QUERY = "JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameAndSubmitterQuery";
    public static final String GET_JOBINSTANCES_SORT_BY_CREATETIME_FIND_ALL_QUERY = "JobInstanceEntity.getJobInstancesSortIdAllQuery";
    public static final String GET_JOBINSTANCES_SORT_BY_CREATETIME_FIND_BY_SUBMITTER_QUERY = "JobInstanceEntity.getJobInstancesSortIdBySubmitterQuery";
    public static final String GET_JOBINSTANCE_COUNT_BY_JOBNAME_QUERY = "JobInstanceEntity.getJobInstanceCountByJobNameQuery";
    public static final String GET_JOBINSTANCE_COUNT_BY_JOBNAME_AND_SUBMITTER_QUERY = "JobInstanceEntity.getJobInstanceCountByJobNameAndSubmitterQuery";
    public static final String GET_JOB_NAMES_SET_QUERY = "JobInstanceEntity.getJobNamesSetQuery";
    public static final String GET_JOB_NAMES_SET_BY_SUBMITTER_QUERY = "JobInstanceEntity.getJobNamesSetBySubmitterQuery";
    public static final String GET_JOBINSTANCEIDS_BY_NAME_AND_STATUSES_QUERY = "JobInstanceEntity.getJobInstancesByNameAndStatus";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="JOBINSTANCEID", nullable=false)
    private long instanceId;
    @Column(name="JOBNAME", length=256)
    private String jobName;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATETIME", nullable=false)
    private Date createTime;
    @Column(name="SUBMITTER", length=256)
    private String submitter;
    @Column(name="AMCNAME", length=512)
    private String amcName;
    @Column(name="JOBXMLNAME", length=128)
    private String jobXMLName;
    @Column(name="BATCHSTATUS", nullable=false)
    private BatchStatus batchStatus;
    @Column(name="EXITSTATUS", length=512)
    private String exitStatus;
    @Lob
    @Column(name="JOBXML")
    private byte[] jobXml;
    @Column(name="RESTARTON", length=128)
    private String restartOn;
    @Column(name="NUMEXECS", nullable=false)
    private int numberOfExecutions = 0;
    @Column(name="INSTANCESTATE", nullable=false)
    private InstanceState instanceState;
    @OneToMany(mappedBy="jobInstance", cascade={CascadeType.REMOVE})
    @OrderBy(value="executionNumberForThisInstance DESC")
    private List<JobExecutionEntity> jobExecutions;
    @OneToMany(mappedBy="jobInstance", cascade={CascadeType.REMOVE})
    private Collection<StepThreadInstanceEntity> stepThreadInstances;
    static final long serialVersionUID = 4223035370408911100L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public JobInstanceEntity() {
    }

    public JobInstanceEntity(long instanceId) {
        this.instanceId = instanceId;
        this.jobExecutions = Collections.synchronizedList(new ArrayList());
        this.stepThreadInstances = Collections.synchronizedList(new ArrayList());
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String name) {
        this.jobName = name;
    }

    @Override
    public String getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    @Override
    public String getAmcName() {
        return this.amcName;
    }

    public void setAmcName(String appName) {
        this.amcName = appName;
    }

    @Override
    public String getJobXMLName() {
        return this.jobXMLName;
    }

    public void setJobXmlName(String jobXMLName) {
        this.jobXMLName = jobXMLName;
    }

    @Override
    public String getJobXml() {
        return this.jobXml == null ? null : new String(this.jobXml, StandardCharsets.UTF_8);
    }

    public void setJobXml(String jobXml) {
        if (jobXml != null) {
            this.jobXml = jobXml.getBytes(StandardCharsets.UTF_8);
        }
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public void setRestartOn(String restartOn) {
        this.restartOn = restartOn;
    }

    @Override
    public List<JobExecutionEntity> getJobExecutions() {
        return this.jobExecutions;
    }

    public void setJobExecutions(List<JobExecutionEntity> jobExecutions) {
        this.jobExecutions = jobExecutions;
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    @Override
    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getLastUpdatedTime() {
        return null;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
    }

    public int getNumberOfExecutions() {
        return this.numberOfExecutions;
    }

    public void setNumberOfExecutions(int numberOfExecutions) {
        this.numberOfExecutions = numberOfExecutions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("For JobInstanceEntity: ");
        buf.append(" instanceId = " + this.instanceId);
        buf.append(", batchStatus = " + this.batchStatus);
        buf.append(", instanceState = " + (Object)((Object)this.instanceState));
        return buf.toString();
    }

    public Collection<StepThreadInstanceEntity> getStepThreadInstances() {
        return this.stepThreadInstances;
    }

    public void setStepThreadInstances(Collection<StepThreadInstanceEntity> stepThreadInstances) {
        this.stepThreadInstances = stepThreadInstances;
    }

    @Override
    public Set<String> getGroupNames() {
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity", JobInstanceEntity.class, (String)"wsbatch", null);
    }
}

