/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.util.BatchContainerConstants;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import com.ibm.wsspi.threading.WSExecutorService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class ContextBasedThreadPoolServiceImpl
implements IBatchThreadPoolService,
BatchContainerConstants {
    private static final String sourceClass = ContextBasedThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final Map<String, ?>[] CapturedContexts = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.javaee.metadata.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.classloader.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.thread.zos.context.provider")};
    WSExecutorService execSvc;
    private WSContextService contextService;
    static final long serialVersionUID = 4168926305061353498L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ContextBasedThreadPoolServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setExecutorService(ExecutorService ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "setExecutorService", new Object[]{ref});
        }
        this.execSvc = (WSExecutorService)ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "setExecutorService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(target="(service.pid=com.ibm.ws.context.manager)")
    protected void setContextService(WSContextService contextService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "setContextService", new Object[]{contextService});
        }
        this.contextService = contextService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "setContextService");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "init");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        String method = "shutdown";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> executeTask(Runnable work, Object config) {
        String method = "executeTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Future<?> retVal = this.executeWork(work, config);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Future<?> executeWork(Runnable work, Object config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "executeWork", new Object[]{work, config});
        }
        Runnable batchWork = this.createContextualProxy(work);
        Future future = this.execSvc.submit(batchWork);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            future = future;
            logger.exiting("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "executeWork", future);
        }
        return future;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> executeParallelTask(Runnable work, Object config) {
        String method = "executeParallelTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Future<?> retVal = this.executeWork(work, config);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Runnable createContextualProxy(Runnable work) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "createContextualProxy", new Object[]{work});
        }
        ThreadContextDescriptor tcDescriptor = this.contextService.captureThreadContext(new HashMap(), (Map[])CapturedContexts);
        Runnable runnable = (Runnable)this.contextService.createContextualProxy(tcDescriptor, (Object)work, Runnable.class);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            runnable = runnable;
            logger.exiting("com.ibm.jbatch.container.services.impl.ContextBasedThreadPoolServiceImpl", "createContextualProxy", runnable);
        }
        return runnable;
    }
}

