/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.transaction.Synchronization;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
class TranSynchronization
implements Synchronization {
    private static final String sourceClass = TranSynchronization.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private RuntimeStepExecution runtimeStepExecution;
    static final long serialVersionUID = -9190923310567481722L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    TranSynchronization(RuntimeStepExecution runtimeStepExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.TranSynchronization", "<init>", new Object[]{runtimeStepExecution});
        }
        this.runtimeStepExecution = runtimeStepExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.TranSynchronization", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void afterCompletion(int status) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.TranSynchronization", "afterCompletion", new Object[]{status});
        }
        logger.log(Level.FINE, "The status of the transaction commit is: " + status);
        if (status == 3) {
            this.runtimeStepExecution.setCommittedMetrics();
        } else {
            this.runtimeStepExecution.rollBackMetrics();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.TranSynchronization", "afterCompletion");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void beforeCompletion() {
    }
}

