/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry10.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.openliberty.microprofile.telemetry.internal.common.rest.AbstractTelemetryContainerFilter;
import io.openliberty.microprofile.telemetry.internal.common.rest.RestRouteCache;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryContainerFilter
extends AbstractTelemetryContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(TelemetryContainerFilter.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final String INSTRUMENTATION_NAME = "io.openliberty.microprofile.telemetry";
    private static final String REST_RESOURCE_CLASS = "rest.resource.class";
    private static final String REST_RESOURCE_METHOD = "rest.resource.method";
    private static final String SPAN_CONTEXT = "otel.span.server.context";
    private static final String SPAN_PARENT_CONTEXT = "otel.span.server.parentContext";
    private static final HttpServerAttributesGetterImpl HTTP_SERVER_ATTRIBUTES_GETTER = new HttpServerAttributesGetterImpl();
    private static final NetServerAttributesGetterImpl NET_SERVER_ATTRIBUTES_GETTER = new NetServerAttributesGetterImpl();
    private static final RestRouteCache ROUTE_CACHE = new RestRouteCache();
    private Instrumenter<ContainerRequestContext, ContainerResponseContext> instrumenter;
    private volatile boolean lazyCreate = false;
    private final AtomicReference<Instrumenter<ContainerRequestContext, ContainerResponseContext>> lazyInstrumenter = new AtomicReference();
    @jakarta.ws.rs.core.Context
    private ResourceInfo resourceInfo;
    static final long serialVersionUID = -9039727665846401962L;

    public TelemetryContainerFilter() {
        if (!CheckpointPhase.getPhase().restored()) {
            this.lazyCreate = true;
        } else {
            this.instrumenter = this.createInstrumenter();
        }
    }

    private Instrumenter<ContainerRequestContext, ContainerResponseContext> getInstrumenter() {
        if (this.instrumenter != null) {
            return this.instrumenter;
        }
        if (this.lazyCreate) {
            this.instrumenter = this.lazyInstrumenter.updateAndGet(i -> {
                if (i == null) {
                    return this.createInstrumenter();
                }
                return i;
            });
            this.lazyCreate = false;
        }
        return this.instrumenter;
    }

    /*
     * WARNING - void declaration
     */
    private Instrumenter<ContainerRequestContext, ContainerResponseContext> createInstrumenter() {
        try {
            OpenTelemetryInfoInternal openTelemetry = OpenTelemetryAccessor.getOpenTelemetryInfo();
            if (openTelemetry.isEnabled() && !AgentDetection.isAgentActive()) {
                InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry.getOpenTelemetry(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER));
                Instrumenter result = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)HttpServerAttributesExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)NetServerAttributesExtractor.create((NetServerAttributesGetter)NET_SERVER_ATTRIBUTES_GETTER)).buildServerInstrumenter((TextMapGetter)new ContainerRequestContextTextMapGetter());
                return result;
            }
            return null;
        }
        catch (Exception openTelemetry) {
            void e;
            FFDCFilter.processException((Throwable)openTelemetry, (String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryContainerFilter", (String)"125", (Object)((Object)this), (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void filter(ContainerRequestContext request) {
        Instrumenter<ContainerRequestContext, ContainerResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter == null) {
            return;
        }
        try {
            Context parentContext = Context.current();
            if (currentInstrumenter.shouldStart(parentContext, (Object)request)) {
                request.setProperty(REST_RESOURCE_CLASS, (Object)this.resourceInfo.getResourceClass());
                request.setProperty(REST_RESOURCE_METHOD, (Object)this.resourceInfo.getResourceMethod());
                Context spanContext = currentInstrumenter.start(parentContext, (Object)request);
                Scope scope = spanContext.makeCurrent();
                request.setProperty(SPAN_CONTEXT, (Object)spanContext);
                request.setProperty(SPAN_PARENT_CONTEXT, (Object)parentContext);
                request.setProperty("otel.span.server.scope", (Object)scope);
            } else {
                Method resourceMethod;
                Class resourceClass;
                String route;
                Span currentSpan = Span.current();
                if (currentSpan != null && (route = TelemetryContainerFilter.getRoute(request, resourceClass = this.resourceInfo.getResourceClass(), resourceMethod = this.resourceInfo.getResourceMethod())) != null) {
                    currentSpan.setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)route);
                    currentSpan.updateName(route);
                }
            }
        }
        catch (Exception parentContext) {
            void e;
            FFDCFilter.processException((Throwable)parentContext, (String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryContainerFilter", (String)"164", (Object)((Object)this), (Object[])new Object[]{request});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Instrumenter<ContainerRequestContext, ContainerResponseContext> currentInstrumenter = this.getInstrumenter();
        try {
            if (currentInstrumenter == null) {
                return;
            }
            Context spanContext = (Context)request.getProperty(SPAN_CONTEXT);
            if (spanContext == null) {
                return;
            }
            try {
                currentInstrumenter.end(spanContext, (Object)request, (Object)response, null);
            }
            finally {
                request.removeProperty(REST_RESOURCE_CLASS);
                request.removeProperty(REST_RESOURCE_METHOD);
                request.removeProperty(SPAN_CONTEXT);
                request.removeProperty(SPAN_PARENT_CONTEXT);
            }
        }
        catch (Exception spanContext) {
            void e;
            FFDCFilter.processException((Throwable)spanContext, (String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryContainerFilter", (String)"191", (Object)((Object)this), (Object[])new Object[]{request, response});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
        }
    }

    private static String getRoute(ContainerRequestContext request, Class<?> resourceClass, Method resourceMethod) {
        int checkResourceSize;
        String route = ROUTE_CACHE.getRoute(resourceClass, resourceMethod);
        if (route == null && (checkResourceSize = request.getUriInfo().getMatchedResources().size()) == 1) {
            String contextRoot = request.getUriInfo().getBaseUri().getPath();
            UriBuilder template = UriBuilder.fromPath((String)contextRoot);
            if (resourceClass.isAnnotationPresent(Path.class)) {
                template.path(resourceClass);
            }
            if (resourceMethod.isAnnotationPresent(Path.class)) {
                template.path(resourceMethod);
            }
            route = template.toTemplate();
            ROUTE_CACHE.putRoute(resourceClass, resourceMethod, route);
        }
        return route;
    }

    public boolean isEnabled() {
        if (!CheckpointPhase.getPhase().restored()) {
            return true;
        }
        return this.getInstrumenter() != null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpServerAttributesGetterImpl
    implements HttpServerAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        static final long serialVersionUID = -784219774348508635L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpServerAttributesGetterImpl() {
        }

        public String flavor(ContainerRequestContext request) {
            return null;
        }

        public String route(ContainerRequestContext request) {
            Class resourceClass = (Class)request.getProperty(TelemetryContainerFilter.REST_RESOURCE_CLASS);
            Method resourceMethod = (Method)request.getProperty(TelemetryContainerFilter.REST_RESOURCE_METHOD);
            return TelemetryContainerFilter.getRoute(request, resourceClass, resourceMethod);
        }

        public String method(ContainerRequestContext request) {
            return request.getMethod();
        }

        public String target(ContainerRequestContext request) {
            URI requestUri = request.getUriInfo().getRequestUri();
            String path = requestUri.getPath();
            String query = requestUri.getQuery();
            if (path != null && query != null && !query.isEmpty()) {
                return path + "?" + query;
            }
            return path;
        }

        public String scheme(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getScheme();
        }

        public Integer statusCode(ContainerRequestContext request, ContainerResponseContext response, @Nullable Throwable error) {
            return response.getStatus();
        }

        public List<String> requestHeader(ContainerRequestContext request, String name) {
            return (List)request.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public List<String> responseHeader(ContainerRequestContext request, ContainerResponseContext response, String name) {
            return (List)response.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryContainerFilter$HttpServerAttributesGetterImpl", HttpServerAttributesGetterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NetServerAttributesGetterImpl
    implements NetServerAttributesGetter<ContainerRequestContext> {
        static final long serialVersionUID = 6058854407318869607L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NetServerAttributesGetterImpl() {
        }

        public String transport(ContainerRequestContext request) {
            return "ip_tcp";
        }

        public String hostName(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getHost();
        }

        public Integer hostPort(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getPort();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryContainerFilter$NetServerAttributesGetterImpl", NetServerAttributesGetterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerRequestContextTextMapGetter
    implements TextMapGetter<ContainerRequestContext> {
        static final long serialVersionUID = -2384422373903704423L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ContainerRequestContextTextMapGetter() {
        }

        public Iterable<String> keys(ContainerRequestContext carrier) {
            return carrier.getHeaders().keySet();
        }

        public String get(ContainerRequestContext carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return (String)((List)carrier.getHeaders().getOrDefault((Object)key, Collections.singletonList(null))).get(0);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry10.internal.rest.TelemetryContainerFilter$ContainerRequestContextTextMapGetter", ContainerRequestContextTextMapGetter.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }
}

