/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.jwk.RemoteJwkData;
import io.openliberty.security.common.jwt.jws.JwsSignatureVerifier;
import io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper;
import io.openliberty.security.oidcclientcore.client.Client;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.config.OidcMetadataService;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.exceptions.VerificationKeyException;
import java.net.SocketTimeoutException;
import java.security.Key;
import java.util.Arrays;
import org.apache.http.conn.ConnectTimeoutException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtUtils {
    public static final TraceComponent tc = Tr.register(JwtUtils.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    static final long serialVersionUID = 1467129669130517531L;

    public static JwsSignatureVerifier.Builder verifyJwsAlgHeaderAndCreateJwsSignatureVerifierBuilder(JwtContext jwtContext, OidcClientConfig clientConfig, String[] signingAlgsAllowed) throws Exception {
        JwsSignatureVerifier.verifyJwsAlgHeaderOnly((JwtContext)jwtContext, Arrays.asList(signingAlgsAllowed));
        JsonWebStructure jws = JwtParsingUtils.getJsonWebStructureFromJwtContext((JwtContext)jwtContext);
        Key jwtVerificationKey = JwtUtils.getJwsVerificationKey(jws, clientConfig);
        JwsSignatureVerifier.Builder verifierBuilder = new JwsSignatureVerifier.Builder();
        verifierBuilder.signatureAlgorithmsSupported(signingAlgsAllowed);
        verifierBuilder.key(jwtVerificationKey);
        return verifierBuilder;
    }

    @FFDCIgnore(value={ConnectTimeoutException.class, SocketTimeoutException.class})
    public static Key getJwsVerificationKey(JsonWebStructure jws, OidcClientConfig clientConfig) throws Exception {
        JwsVerificationKeyHelper.Builder keyHelperBuilder = new JwsVerificationKeyHelper.Builder();
        keyHelperBuilder.configId(clientConfig.getClientId());
        JwtUtils.setKeyData(jws, clientConfig, keyHelperBuilder);
        JwsVerificationKeyHelper keyHelper = keyHelperBuilder.build();
        try {
            return keyHelper.getVerificationKey(jws);
        }
        catch (ConnectTimeoutException e) {
            throw new VerificationKeyException(clientConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"JWK_CONNECTION_TIMED_OUT", (Object[])new Object[]{keyHelper.getRemoteJwkData().getJwksUri(), keyHelper.getRemoteJwkData().getJwksConnectTimeout()}));
        }
        catch (SocketTimeoutException e) {
            throw new VerificationKeyException(clientConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"JWK_READ_TIMED_OUT", (Object[])new Object[]{keyHelper.getRemoteJwkData().getJwksUri(), keyHelper.getRemoteJwkData().getJwksReadTimeout()}));
        }
    }

    static void setKeyData(JsonWebStructure jws, OidcClientConfig clientConfig, JwsVerificationKeyHelper.Builder keyHelperBuilder) throws OidcDiscoveryException, OidcClientConfigurationException {
        String algFromHeader = jws.getAlgorithmHeaderValue();
        if (algFromHeader == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JWT is missing the \"alg\" header", (Object[])new Object[0]);
            }
            return;
        }
        if (algFromHeader.equalsIgnoreCase("none")) {
            return;
        }
        if (algFromHeader.startsWith("HS")) {
            keyHelperBuilder.sharedSecret(clientConfig.getClientSecret());
        } else {
            RemoteJwkData jwkData = JwtUtils.initializeRemoteJwkData(clientConfig);
            keyHelperBuilder.remoteJwkData(jwkData).jwkSet(Client.getJwkSet());
        }
    }

    private static RemoteJwkData initializeRemoteJwkData(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        RemoteJwkData jwkData = new RemoteJwkData();
        String jwksUri = MetadataUtils.getJwksUri(oidcClientConfig);
        jwkData.setJwksUri(jwksUri);
        jwkData.setSslSupport(OidcMetadataService.getSSLSupport());
        jwkData.setJwksConnectTimeout(oidcClientConfig.getJwksConnectTimeout());
        jwkData.setJwksReadTimeout(oidcClientConfig.getJwksReadTimeout());
        return jwkData;
    }
}

