/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.token.TokenClaimMismatchException;
import io.openliberty.security.oidcclientcore.token.TokenValidationException;
import java.util.ArrayList;
import java.util.List;
import org.jose4j.jwt.NumericDate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenValidator {
    private String issuer;
    private String issuerconfigured;
    private String subject = null;
    private List<String> audiences;
    private String azp = null;
    private NumericDate iat;
    private NumericDate exp;
    private NumericDate notBefore = null;
    protected OidcClientConfig oidcConfig;
    private final long clockSkewInSeconds = 120L;
    public static final TraceComponent tc = Tr.register(TokenValidator.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    static final long serialVersionUID = 4755963174740616436L;

    public TokenValidator(OidcClientConfig clientConfig) {
        this.oidcConfig = clientConfig;
    }

    public TokenValidator issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public TokenValidator subject(String subject) {
        this.subject = subject;
        return this;
    }

    public TokenValidator audiences(List<String> audience) {
        this.audiences = new ArrayList<String>(audience);
        return this;
    }

    public TokenValidator azp(String azp) {
        this.azp = azp;
        return this;
    }

    public TokenValidator iat(NumericDate iat) {
        this.iat = iat;
        return this;
    }

    public TokenValidator exp(NumericDate exp) {
        this.exp = exp;
        return this;
    }

    public TokenValidator nbf(NumericDate notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public void validate() throws TokenValidationException {
        this.validateIssuer();
        this.validateSubject();
        this.validateAudiences();
        this.validateAZP();
        this.validateExpiration();
        this.validateIssuedAt();
        this.validateNotBefore();
    }

    protected void validateNotBefore() throws TokenValidationException {
        long now;
        if (this.notBefore != null && (now = System.currentTimeMillis()) + this.clockSkewInSeconds * 1000L < this.notBefore.getValueInMillis()) {
            NumericDate nd = NumericDate.now();
            nd.addSeconds(this.clockSkewInSeconds);
            throw new TokenValidationException(this.oidcConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_CLAIM_IN_FUTURE", (Object[])new Object[]{this.notBefore, "nbf", nd, this.clockSkewInSeconds}));
        }
    }

    protected void validateIssuedAt() throws TokenValidationException {
        long now = System.currentTimeMillis();
        if (now + this.clockSkewInSeconds * 1000L < this.iat.getValueInMillis()) {
            NumericDate nd = NumericDate.now();
            nd.addSeconds(this.clockSkewInSeconds);
            throw new TokenValidationException(this.oidcConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_CLAIM_IN_FUTURE", (Object[])new Object[]{this.iat, "iat", nd, this.clockSkewInSeconds}));
        }
    }

    protected void validateExpiration() throws TokenValidationException {
        long now = System.currentTimeMillis();
        if (now - this.clockSkewInSeconds * 1000L > this.exp.getValueInMillis()) {
            NumericDate nd = NumericDate.now();
            nd.setValue(now / 1000L - this.clockSkewInSeconds);
            throw new TokenValidationException(this.oidcConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_EXP_IN_PAST", (Object[])new Object[]{this.exp, nd, this.clockSkewInSeconds}));
        }
    }

    protected void validateAZP() throws TokenValidationException {
        if (this.azp != null && !this.oidcConfig.getClientId().equals(this.azp)) {
            throw new TokenClaimMismatchException(this.oidcConfig.getClientId(), this.azp, "azp", this.oidcConfig.getClientId());
        }
    }

    protected void validateAudiences() throws TokenValidationException {
        if (this.audiences == null || this.audiences.isEmpty()) {
            throw new TokenValidationException(this.oidcConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_MISSING_REQUIRED_CLAIM", (Object[])new Object[]{"aud"}));
        }
        if (this.audiences.contains(this.oidcConfig.getClientId())) {
            if (this.audiences.size() > 1 && this.azp == null) {
                throw new TokenValidationException(this.oidcConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_MISSING_REQUIRED_CLAIM", (Object[])new Object[]{"azp"}));
            }
        } else {
            StringBuffer audience = new StringBuffer();
            for (String aud : this.audiences) {
                audience.append("\"").append(aud).append("\"").append(" ");
            }
            throw new TokenClaimMismatchException(this.oidcConfig.getClientId(), audience.toString(), "aud", this.oidcConfig.getClientId());
        }
    }

    protected void validateSubject() throws TokenValidationException {
        if (this.subject != null && this.subject.isEmpty()) {
            throw new TokenValidationException(this.oidcConfig.getClientId(), Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_EMPTY_CLAIM", (Object[])new Object[]{"sub"}));
        }
    }

    protected void validateIssuer() throws TokenValidationException {
        if (!this.issuerconfigured.equals(this.issuer)) {
            throw new TokenClaimMismatchException(this.oidcConfig.getClientId(), this.issuer, "iss", this.issuerconfigured);
        }
    }

    public TokenValidator issuerconfigured(String issuerFromProviderMetadata) {
        this.issuerconfigured = issuerFromProviderMetadata;
        return this;
    }
}

