/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.monitor.internal.MappingTable;
import io.openliberty.microprofile.telemetry.internal.monitor.internal.MonitorMetrics;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={MonitorMetricsHandler.class}, name="io.openliberty.microprofile.telemetry.internal.monitor.MonitorMetricsHandler", property={"service.vendor=IBM"}, immediate=true)
public class MonitorMetricsHandler {
    private static final TraceComponent tc = Tr.register(MonitorMetricsHandler.class, null, null);
    protected ExecutorService execServ;
    protected MappingTable mappingTable;
    protected Set<MonitorMetrics> mmonitorMetricsSet = new HashSet<MonitorMetrics>();
    protected NotificationListener listener;
    static final long serialVersionUID = -247637624528825176L;

    @Activate
    protected void activate(ComponentContext context) {
        this.mappingTable = MappingTable.getInstance();
        this.register();
        this.addMBeanListener();
    }

    @Reference
    public void setExecutorService(ExecutorService execServ) {
        this.execServ = execServ;
    }

    public void unsetExecutorService(ExecutorService execServ) {
        this.execServ = null;
    }

    /*
     * WARNING - void declaration
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (this.listener != null) {
            try {
                mbs.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.monitor.MonitorMetricsHandler", (String)"74", (Object)this, (Object[])new Object[]{context});
                if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"deactivate exception message: ", (Object[])new Object[]{e.getMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"deactivate:Exception");
            }
            this.listener = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addMBeanListener() {
        this.listener = new NotificationListener(){
            static final long serialVersionUID = -7371386514662714078L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void handleNotification(Notification notification, Object handback) {
                MBeanServerNotification mbsn = (MBeanServerNotification)notification;
                String objectName = mbsn.getMBeanName().toString();
                if ("JMX.mbean.registered".equals(mbsn.getType())) {
                    String[][] data;
                    if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"MBean Registered [", (Object[])new Object[]{objectName + "]"});
                    }
                    if ((data = MonitorMetricsHandler.this.mappingTable.getData(objectName)) != null) {
                        MonitorMetricsHandler.this.register(objectName, data);
                    }
                } else if ("JMX.mbean.unregistered".equals(mbsn.getType())) {
                    if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("MBean Unregistered [" + objectName + "]"), (Object[])new Object[0]);
                    }
                    if (MonitorMetricsHandler.this.mappingTable.contains(objectName)) {
                        MonitorMetricsHandler.this.unregister(objectName);
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.monitor.MonitorMetricsHandler$1", 1.class, null, null);
            }
        };
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, null, null);
        }
        catch (InstanceNotFoundException mbs) {
            void e;
            FFDCFilter.processException((Throwable)mbs, (String)"io.openliberty.microprofile.telemetry.internal.monitor.MonitorMetricsHandler", (String)"113", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while adding listener: ", (Object[])new Object[]{e.getMessage()});
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"addMBeanListener:Exception");
        }
    }

    protected void unregister(String objectName) {
        HashSet<MonitorMetrics> removeSet = new HashSet<MonitorMetrics>();
        for (MonitorMetrics mm : this.mmonitorMetricsSet) {
            if (!mm.getObjectName().equals(objectName)) continue;
            removeSet.add(mm);
            mm.unregisterMetrics();
            if (!tc.isDebugEnabled() || !TraceComponent.isAnyTracingEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Monitoring MXBean " + objectName + " was unregistered."), (Object[])new Object[0]);
        }
        this.mmonitorMetricsSet.removeAll(removeSet);
    }

    /*
     * WARNING - void declaration
     */
    protected void register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (String sName : this.mappingTable.getKeys()) {
            try {
                Set<ObjectInstance> mBeanObjectInstanceSet = mbs.queryMBeans(new ObjectName(sName), null);
                if (sName.contains("ThreadPoolStats") && mBeanObjectInstanceSet.isEmpty() && this.execServ != null) {
                    this.execServ.execute(() -> {
                        int MAX_TIME_OUT = 5000;
                        Set<ObjectInstance> mBeanObjectInstanceSetTemp = mBeanObjectInstanceSet;
                        for (int currentTimeOut = 0; mBeanObjectInstanceSetTemp.isEmpty() && currentTimeOut <= 5000; currentTimeOut += 50) {
                            try {
                                Thread.sleep(50L);
                                mBeanObjectInstanceSetTemp = mbs.queryMBeans(new ObjectName(sName), null);
                                continue;
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"register exception message: ", (Object[])new Object[]{e.getMessage()});
                                }
                                FFDCFilter.processException((Throwable)e, (String)MonitorMetricsHandler.class.getSimpleName(), (String)"register:Exception");
                                break;
                            }
                        }
                        this.registerMbeanObjects(mBeanObjectInstanceSetTemp);
                    });
                }
                this.registerMbeanObjects(mBeanObjectInstanceSet);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.monitor.MonitorMetricsHandler", (String)"171", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"register exception message: ", (Object[])new Object[]{e.getMessage()});
                }
                FFDCFilter.processException((Throwable)e, (String)MonitorMetricsHandler.class.getSimpleName(), (String)"register:Exception");
            }
        }
    }

    private synchronized void registerMbeanObjects(Set<ObjectInstance> mBeanObjectInstanceSet) {
        for (ObjectInstance objInstance : mBeanObjectInstanceSet) {
            String objectName = objInstance.getObjectName().toString();
            String[][] data = this.mappingTable.getData(objectName);
            if (data == null) continue;
            this.register(objectName, data);
        }
    }

    protected synchronized void register(String objectName, String[][] data) {
        MonitorMetrics monitorMetricsInsts = null;
        if (!this.containMetrics(objectName)) {
            monitorMetricsInsts = new MonitorMetrics(objectName);
            monitorMetricsInsts.createMetrics(data);
            this.mmonitorMetricsSet.add(monitorMetricsInsts);
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Monitoring MXBean " + objectName + " is registered to mpTelemetry."), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(objectName + " is already registered."), (Object[])new Object[0]);
        }
    }

    protected boolean containMetrics(String objectName) {
        for (MonitorMetrics mm : this.mmonitorMetricsSet) {
            if (!mm.getObjectName().equals(objectName)) continue;
            return true;
        }
        return false;
    }
}

