/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.monitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MappingTable {
    public static final int METRIC_NAME = 0;
    public static final int METRIC_DESCRIPTION = 1;
    public static final int METRIC_TYPE = 2;
    public static final int METRIC_UNIT = 3;
    public static final int MBEAN_ATTRIBUTE = 4;
    public static final int MBEAN_SUBATTRIBUTE = 5;
    public static final int MBEAN_STATS_NAME = 6;
    public static final int MBEAN_SECOND_ATTRIBUTE = 7;
    public static final int MBEAN_SECOND_SUBATTRIBUTE = 8;
    public static final String THREADPOOL_TAG_NAME = "threadpool.name";
    public static final String CONNECTIONPOOL_TAG_NAME = "datasource.name";
    public static final String SESSION_TAG_NAME = "app.name";
    public static final String LONG_UP_DOWN_COUNTER = "LONGUPDOWNCOUNTER";
    public static final String LONG_COUNTER = "LONGCOUNTER";
    public static final String LONG_GAUGE = "LONGGAUGE";
    public static final String REQUEST_UNIT = "{request}";
    public static final String THREAD_UNIT = "{thread}";
    public static final String SESSION_UNIT = "{session}";
    public static final String CONNECTION_UNIT = "{connection}";
    public static final String CONNECTION_HANDLE_UNIT = "{connection_handle}";
    private static MappingTable singleton;
    private Map<String, String[][]> mappingTable = new HashMap<String, String[][]>();
    static final long serialVersionUID = -27445432216399664L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static MappingTable getInstance() {
        if (singleton == null) {
            singleton = new MappingTable();
        }
        return singleton;
    }

    private MappingTable() {
        String[][] requestTimeTable = new String[][]{{"request_timing.processed", "requestTiming.processed.description", LONG_COUNTER, REQUEST_UNIT, "RequestCount", null, null}, {"request_timing.active", "requestTiming.active.description", LONG_UP_DOWN_COUNTER, REQUEST_UNIT, "ActiveRequestCount", null, null}, {"request_timing.slow", "requestTiming.slow.description", LONG_UP_DOWN_COUNTER, REQUEST_UNIT, "SlowRequestCount", null, null}, {"request_timing.hung", "requestTiming.hung.description", LONG_UP_DOWN_COUNTER, REQUEST_UNIT, "HungRequestCount", null, null}};
        this.mappingTable.put("WebSphere:type=RequestTimingStats,name=*", requestTimeTable);
        String[][] threadPoolTable = new String[][]{{"threadpool.active_threads", "threadpool.activeThreads.description", LONG_UP_DOWN_COUNTER, THREAD_UNIT, "ActiveThreads", null, THREADPOOL_TAG_NAME}, {"threadpool.size", "threadpool.size.description", LONG_UP_DOWN_COUNTER, THREAD_UNIT, "PoolSize", null, THREADPOOL_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=ThreadPoolStats,name=*", threadPoolTable);
        String[][] sessionTable = new String[][]{{"session.created", "session.created.description", LONG_COUNTER, SESSION_UNIT, "CreateCount", null, SESSION_TAG_NAME}, {"session.live", "session.live.description", LONG_UP_DOWN_COUNTER, SESSION_UNIT, "LiveCount", null, SESSION_TAG_NAME}, {"session.active", "session.activeSessions.description", LONG_UP_DOWN_COUNTER, SESSION_UNIT, "ActiveCount", null, SESSION_TAG_NAME}, {"session.invalidated", "session.invalidated.description", LONG_COUNTER, SESSION_UNIT, "InvalidatedCount", null, SESSION_TAG_NAME}, {"session.invalidated_by_timeout", "session.invalidatedbyTimeout.description", LONG_COUNTER, SESSION_UNIT, "InvalidatedCountbyTimeout", null, SESSION_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=SessionStats,name=*", sessionTable);
        String[][] connectionPoolTable = new String[][]{{"connection_pool.connection.created", "connectionpool.connection.created.description", LONG_COUNTER, CONNECTION_UNIT, "CreateCount", null, CONNECTIONPOOL_TAG_NAME}, {"connection_pool.connection.destroyed", "connectionpool.connection.destroyed.description", LONG_COUNTER, CONNECTION_UNIT, "DestroyCount", null, CONNECTIONPOOL_TAG_NAME}, {"connection_pool.connection.count", "connectionpool.connection.count.description", LONG_UP_DOWN_COUNTER, CONNECTION_UNIT, "ManagedConnectionCount", null, CONNECTIONPOOL_TAG_NAME}, {"connection_pool.handle.count", "connectionpool.handle.count.description", LONG_UP_DOWN_COUNTER, CONNECTION_HANDLE_UNIT, "ConnectionHandleCount", null, CONNECTIONPOOL_TAG_NAME}, {"connection_pool.connection.free", "connectionpool.connection.free.description", LONG_UP_DOWN_COUNTER, CONNECTION_UNIT, "FreeConnectionCount", null, CONNECTIONPOOL_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=ConnectionPoolStats,name=*", connectionPoolTable);
    }

    private String getType(String objectName) {
        for (String subString : objectName.split(",")) {
            if (!(subString = subString.trim()).contains("type=")) continue;
            return subString.split("=")[1];
        }
        return "notype";
    }

    public String[][] getData(String objectName) {
        for (String k : this.mappingTable.keySet()) {
            if (!objectName.contains(this.getType(k))) continue;
            return this.mappingTable.get(k);
        }
        return null;
    }

    public boolean contains(String objectName) {
        for (String k : this.mappingTable.keySet()) {
            if (!objectName.contains(this.getType(k))) continue;
            return true;
        }
        return false;
    }

    public Set<String> getKeys() {
        return this.mappingTable.keySet();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.monitor.internal.MappingTable", MappingTable.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        singleton = null;
    }
}

