/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperType;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class EJBHomeImpl {
    private static final TraceComponent tc = Tr.register(EJBHomeImpl.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");

    static Class<?> getComponentInterface(Class<?> homeInterface, String beanName) throws EJBConfigurationException {
        java.lang.reflect.Method[] methods;
        Class<?> compInterface = null;
        for (java.lang.reflect.Method method : methods = homeInterface.getMethods()) {
            if (!method.getName().startsWith("create")) continue;
            compInterface = method.getReturnType();
            if (compInterface != Void.TYPE) break;
            Tr.error((TraceComponent)tc, (String)"JIT_VOID_CREATE_RETURN_CNTR5018E", (Object[])new Object[]{beanName, homeInterface.getName(), method.getName()});
            throw new EJBConfigurationException("EJB home interface " + homeInterface.getName() + " 'create' method must return the component interface : " + method + " : " + beanName);
        }
        if (compInterface == null) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_CREATE_METHOD_CNTR5019E", (Object[])new Object[]{beanName, homeInterface.getName()});
            throw new EJBConfigurationException("EJB home interface " + homeInterface.getName() + " must define a 'create' method : " + beanName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getComponentInterface : " + compInterface), (Object[])new Object[0]);
        }
        return compInterface;
    }

    static void validateInterfaceBasics(Class<?> homeInterface, Class<?> componentInterface, EJBWrapperType wrapperType, String beanName, int beanType) throws EJBConfigurationException {
        if (!Modifier.isInterface(homeInterface.getModifiers())) {
            Tr.error((TraceComponent)tc, (String)"JIT_INTERFACE_NOT_INTERFACE_CNTR5011E", (Object[])new Object[]{beanName, homeInterface.getName()});
            throw new EJBConfigurationException("EJB home interface " + homeInterface.getName() + " must be an interface : " + beanName);
        }
        if (wrapperType == EJBWrapperType.LOCAL_HOME) {
            if (!EJBLocalHome.class.isAssignableFrom(homeInterface)) {
                Tr.error((TraceComponent)tc, (String)"JIT_MUST_EXTEND_EJBLOCALHOME_CNTR5016E", (Object[])new Object[]{beanName, homeInterface.getName()});
                throw new EJBConfigurationException("EJB local home interface " + homeInterface.getName() + " must extend jakarta.ejb.EJBLocalHome : " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.REMOTE_HOME && !EJBHome.class.isAssignableFrom(homeInterface)) {
            Tr.error((TraceComponent)tc, (String)"JIT_MUST_EXTEND_EJBHOME_CNTR5017E", (Object[])new Object[]{beanName, homeInterface.getName()});
            throw new EJBConfigurationException("EJB remote home interface " + homeInterface.getName() + " must extend jakarta.ejb.EJBHome : " + beanName);
        }
        if (beanType == 3 || beanType == 4) {
            java.lang.reflect.Method[] methods;
            Class<?> returnType = null;
            for (java.lang.reflect.Method method : methods = homeInterface.getMethods()) {
                Class<?>[] exceptions;
                if (!method.getName().startsWith("create")) continue;
                returnType = method.getReturnType();
                if (returnType != componentInterface) {
                    Tr.error((TraceComponent)tc, (String)"JIT_WRONG_CREATE_RETURN_CNTR5020E", (Object[])new Object[]{beanName, homeInterface.getName(), method.getName(), componentInterface.getName()});
                    throw new EJBConfigurationException("EJB home interface " + homeInterface.getName() + " 'create' method must return the component interface : " + method + " does not return " + componentInterface.getName() + " : " + beanName);
                }
                boolean throwsCreateException = false;
                for (Class<?> exception : exceptions = method.getExceptionTypes()) {
                    if (CreateException.class != exception) continue;
                    throwsCreateException = true;
                    break;
                }
                if (throwsCreateException) continue;
                Tr.error((TraceComponent)tc, (String)"JIT_MISSING_CREATE_EX_CNTR5021E", (Object[])new Object[]{beanName, homeInterface.getName(), method.getName()});
                throw new EJBConfigurationException("EJB home method " + method + " must throw jakarta.ejb.CreateException : " + beanName);
            }
            if (returnType == null) {
                Tr.error((TraceComponent)tc, (String)"JIT_NO_CREATE_METHOD_CNTR5019E", (Object[])new Object[]{beanName, homeInterface.getName()});
                throw new EJBConfigurationException("EJB home interface " + homeInterface.getName() + " must define a 'create' method : " + beanName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validateInterfaceBasics : successful : " + homeInterface.getName()), (Object[])new Object[0]);
        }
    }

    static byte[] generateClassBytes(String homeClassName, Class<?> remoteHomeInterface, Class<?> localHomeInterface, Class<?> ejbClass, Class<?> pkeyClass, HashMap<String, String> initMethods, String beanName, int beanType) throws EJBConfigurationException {
        Class<?> declaringClass;
        String methodName;
        java.lang.reflect.Method method;
        int i;
        java.lang.reflect.Method[] methods = null;
        HashMap<String, java.lang.reflect.Method> homeMethods = new HashMap<String, java.lang.reflect.Method>();
        String internalClassName = JITUtils.convertClassName(homeClassName);
        String internalRemoteHomeInterfaceName = remoteHomeInterface == null ? null : JITUtils.convertClassName(remoteHomeInterface.getName());
        String internalLocalHomeInterfaceName = localHomeInterface == null ? null : JITUtils.convertClassName(localHomeInterface.getName());
        String internalEJBClassName = JITUtils.convertClassName(ejbClass.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateEJBHomeImplBytes", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     className = " + internalClassName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("     remote    = " + internalRemoteHomeInterfaceName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("     local     = " + internalLocalHomeInterfaceName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("     ejb       = " + internalEJBClassName), (Object[])new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(46, 33, internalClassName, null, "com/ibm/ejs/container/EJSHome", null);
        String sourceFileName = homeClassName.substring(homeClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        EJBHomeImpl.addEJBHomeImplCtor(cw);
        if (remoteHomeInterface != null) {
            methods = remoteHomeInterface.getMethods();
            block10: for (i = 0; i < methods.length; ++i) {
                method = methods[i];
                methodName = method.getName();
                declaringClass = method.getDeclaringClass();
                if (declaringClass.equals(EJBHome.class)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("     skipping      : " + declaringClass.getName() + "." + methodName), (Object[])new Object[0]);
                    continue;
                }
                switch (beanType) {
                    case 3: {
                        if (methodName.equals("create") && method.getReturnType() != Void.TYPE) {
                            EJBHomeImpl.addEJBHomeStatelessMethod(cw, method, false);
                            continue block10;
                        }
                        Tr.error((TraceComponent)tc, (String)"JIT_INVALID_SL_HOME_METHOD_CNTR5022E", (Object[])new Object[]{beanName, remoteHomeInterface.getName(), methodName});
                        throw new EJBConfigurationException("EJB stateless session home interface " + remoteHomeInterface.getName() + " must have only one method, and it must be create() : " + beanName + " : " + methodName);
                    }
                    case 4: {
                        if (methodName.startsWith("create") && method.getReturnType() != Void.TYPE) {
                            EJBHomeImpl.addEJBHomeCreateMethod(cw, method, initMethods, internalEJBClassName, beanName, false);
                            continue block10;
                        }
                        Tr.error((TraceComponent)tc, (String)"JIT_INVALID_SF_HOME_METHOD_CNTR5023E", (Object[])new Object[]{beanName, remoteHomeInterface.getName(), methodName});
                        throw new EJBConfigurationException("EJB stateful session home interface " + remoteHomeInterface.getName() + " must define only create methods : " + beanName + " : " + methodName);
                    }
                    case 5: {
                        if (methodName.startsWith("create")) {
                            EJBHomeImpl.addBMPEJBHomeCreateMethod(cw, method, ejbClass, pkeyClass, internalEJBClassName, beanName, false);
                            continue block10;
                        }
                        if (methodName.equals("findByPrimaryKey")) {
                            EJBHomeImpl.addBMPEJBHomeFindByPrimaryKeyMethod(cw, method, ejbClass, pkeyClass, internalEJBClassName, beanName, false);
                            continue block10;
                        }
                        if (methodName.startsWith("find")) {
                            EJBHomeImpl.addBMPEJBHomeFindMethod(cw, method, ejbClass, pkeyClass, internalEJBClassName, beanName, false);
                            continue block10;
                        }
                        if (methodName.startsWith("remove")) {
                            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_BMP_HOME_METHOD_CNTR5024E", (Object[])new Object[]{beanName, remoteHomeInterface.getName(), methodName});
                            throw new EJBConfigurationException("EJB entity bean home interface " + remoteHomeInterface.getName() + " must not define a method that starts with remove : " + beanName + " : " + methodName);
                        }
                        EJBHomeImpl.addBMPEJBHomeHomeMethod(cw, method, ejbClass, internalEJBClassName, beanName);
                        homeMethods.put(JITUtils.methodKey(method), method);
                        continue block10;
                    }
                    default: {
                        throw new ContainerEJBException("EJBContainer internal error: Bean Type not supported: " + beanType);
                    }
                }
            }
        }
        if (localHomeInterface != null) {
            methods = localHomeInterface.getMethods();
            block11: for (i = 0; i < methods.length; ++i) {
                method = methods[i];
                methodName = method.getName();
                declaringClass = method.getDeclaringClass();
                if (declaringClass.equals(EJBLocalHome.class)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("     skipping      : " + declaringClass.getName() + "." + methodName), (Object[])new Object[0]);
                    continue;
                }
                switch (beanType) {
                    case 3: {
                        if (methodName.equals("create") && method.getReturnType() != Void.TYPE) {
                            EJBHomeImpl.addEJBHomeStatelessMethod(cw, method, true);
                            continue block11;
                        }
                        Tr.error((TraceComponent)tc, (String)"JIT_INVALID_SL_HOME_METHOD_CNTR5022E", (Object[])new Object[]{beanName, localHomeInterface.getName(), methodName});
                        throw new EJBConfigurationException("EJB stateless session home interface " + localHomeInterface.getName() + " must have only one method, and it must be create() : " + beanName + " : " + methodName);
                    }
                    case 4: {
                        if (methodName.startsWith("create") && method.getReturnType() != Void.TYPE) {
                            EJBHomeImpl.addEJBHomeCreateMethod(cw, method, initMethods, internalEJBClassName, beanName, true);
                            continue block11;
                        }
                        Tr.error((TraceComponent)tc, (String)"JIT_INVALID_SF_HOME_METHOD_CNTR5023E", (Object[])new Object[]{beanName, localHomeInterface.getName(), methodName});
                        throw new EJBConfigurationException("EJB stateful session home interface " + localHomeInterface.getName() + " must define only create methods : " + beanName + " : " + methodName);
                    }
                    case 5: {
                        if (methodName.startsWith("create")) {
                            EJBHomeImpl.addBMPEJBHomeCreateMethod(cw, method, ejbClass, pkeyClass, internalEJBClassName, beanName, true);
                            continue block11;
                        }
                        if (methodName.equals("findByPrimaryKey")) {
                            EJBHomeImpl.addBMPEJBHomeFindByPrimaryKeyMethod(cw, method, ejbClass, pkeyClass, internalEJBClassName, beanName, true);
                            continue block11;
                        }
                        if (methodName.startsWith("find")) {
                            EJBHomeImpl.addBMPEJBHomeFindMethod(cw, method, ejbClass, pkeyClass, internalEJBClassName, beanName, true);
                            continue block11;
                        }
                        if (methodName.startsWith("remove")) {
                            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_BMP_HOME_METHOD_CNTR5024E", (Object[])new Object[]{beanName, localHomeInterface.getName(), methodName});
                            throw new EJBConfigurationException("EJB entity bean home interface " + localHomeInterface.getName() + " must not define a method that starts with remove : " + beanName + " : " + methodName);
                        }
                        String methodSig = JITUtils.methodKey(method);
                        if (homeMethods.containsKey(methodSig)) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue block11;
                            Tr.debug((TraceComponent)tc, (String)("     skipping      : " + methodSig + " : home method already added for remote interface"), (Object[])new Object[0]);
                            continue block11;
                        }
                        EJBHomeImpl.addBMPEJBHomeHomeMethod(cw, method, ejbClass, internalEJBClassName, beanName);
                        continue block11;
                    }
                    default: {
                        throw new ContainerEJBException("EJBContainer internal error: Bean Type not supported: " + beanType);
                    }
                }
            }
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalClassName, classBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateEJBHomeImplBytes: " + classBytes.length + " bytes"));
        }
        return classBytes;
    }

    private static void addEJBHomeImplCtor(ClassWriter cw) {
        String[] exceptions = new String[]{"java/rmi/RemoteException"};
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, exceptions);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addEJBHomeStatelessMethod(ClassWriter cw, java.lang.reflect.Method method, boolean isLocal) {
        String implMethodSignature;
        String methodName = isLocal ? method.getName() + "_Local" : method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        String implMethodName = isLocal ? "createWrapper_Local" : "createWrapper";
        String string = implMethodSignature = isLocal ? "(Lcom/ibm/ejs/container/BeanId;)Lcom/ibm/ejs/container/EJSLocalWrapper;" : "(Lcom/ibm/ejs/container/BeanId;)Lcom/ibm/ejs/container/EJSWrapper;";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                     -> " + implMethodName + " " + implMethodSignature), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitInsn(1);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", implMethodName, implMethodSignature);
        mg.visitTypeInsn(192, returnType.getInternalName());
        mg.storeLocal(returnValue);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label[] main_catch_label = new Label[exceptionTypes.length];
        int caught_ex = mg.newLocal(Type.getType((String)"Ljava/lang/Exception;"));
        for (int i = 0; i < exceptionTypes.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_catch_throwable = new Label();
        mg.visitLabel(main_catch_throwable);
        int main_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_th);
        mg.visitTypeInsn(187, "com/ibm/ejs/container/CreateFailureException");
        mg.visitInsn(89);
        mg.loadLocal(main_th);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/CreateFailureException", "<init>", "(Ljava/lang/Throwable;)V");
        mg.visitInsn(191);
        mg.visitLabel(main_tcf_exit);
        mg.loadLocal(returnValue);
        mg.returnValue();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], exceptionTypes[i].getInternalName());
        }
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_throwable, "java/lang/Throwable");
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addEJBHomeCreateMethod(ClassWriter cw, java.lang.reflect.Method method, HashMap<String, String> initMethods, String implClassName, String beanName, boolean isLocal) throws EJBConfigurationException {
        String postCreate_sig;
        String methodName = isLocal ? method.getName() + "_Local" : method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        if (initMethods == null) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_INIT_METHOD_CNTR5025E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), implClassName});
            throw new EJBConfigurationException("ejbCreate or init method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and no ejbCreate or init methods are present on class " + implClassName);
        }
        String implMethodSignature = methodSignature.substring(0, methodSignature.lastIndexOf(")") + 1) + "V";
        String implMethodName = initMethods.get(method.getName() + implMethodSignature);
        if (implMethodName == null) {
            implMethodName = initMethods.get(implMethodSignature);
        }
        if (implMethodName == null) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_INIT_METHOD_CNTR5025E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), implClassName});
            throw new EJBConfigurationException("ejbCreate or init method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and a corresponding method was not found on class " + implClassName);
        }
        String postCreate = isLocal ? "postCreate_Local" : "postCreate";
        String string = postCreate_sig = isLocal ? "(Lcom/ibm/ejs/container/BeanO;)Ljakarta/ejb/EJBLocalObject;" : "(Lcom/ibm/ejs/container/BeanO;)Ljakarta/ejb/EJBObject;";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                   : " + implMethodName + " " + implMethodSignature), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int beanO = mg.newLocal(Type.getType((String)"Lcom/ibm/ejs/container/BeanO;"));
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        int exceptionOccurred = mg.newLocal(Type.BOOLEAN_TYPE);
        mg.push(false);
        mg.storeLocal(exceptionOccurred);
        int preEjbCreateCalled = mg.newLocal(Type.BOOLEAN_TYPE);
        mg.push(false);
        mg.storeLocal(preEjbCreateCalled);
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "createBeanO", "()Lcom/ibm/ejs/container/BeanO;");
        mg.storeLocal(beanO);
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        mg.loadLocal(beanO);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/BeanO", "getBeanInstance", "()Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "preEjbCreate", "(Lcom/ibm/ejs/container/BeanO;)Z");
        mg.storeLocal(preEjbCreateCalled);
        mg.loadLocal(bean);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, implMethodName, implMethodSignature);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", postCreate, postCreate_sig);
        mg.checkCast(returnType);
        mg.storeLocal(returnValue);
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[exceptionTypes.length];
        int caught_ex = mg.newLocal(Type.getType((String)"Ljava/lang/Exception;"));
        for (int i = 0; i < exceptionTypes.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.push(true);
            mg.storeLocal(exceptionOccurred);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_catch_throwable = new Label();
        mg.visitLabel(main_catch_throwable);
        int main_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_th);
        mg.push(true);
        mg.storeLocal(exceptionOccurred);
        if (isLocal) {
            mg.loadThis();
            mg.loadLocal(main_th);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "newCreateFailureException_Local", "(Ljava/lang/Throwable;)Ljakarta/ejb/EJBException;");
        } else {
            mg.visitTypeInsn(187, "com/ibm/ejs/container/CreateFailureException");
            mg.visitInsn(89);
            mg.loadLocal(main_th);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/CreateFailureException", "<init>", "(Ljava/lang/Throwable;)V");
        }
        mg.visitInsn(191);
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(Type.getType((String)"Ljava/lang/Object;"));
        mg.storeLocal(main_finally_return);
        Label if_exception_else = mg.newLabel();
        Label if_exception_end = mg.newLabel();
        mg.loadLocal(exceptionOccurred);
        mg.visitJumpInsn(153, if_exception_else);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "createFailure", "(Lcom/ibm/ejs/container/BeanO;)V");
        mg.visitJumpInsn(167, if_exception_end);
        mg.visitLabel(if_exception_else);
        mg.loadLocal(preEjbCreateCalled);
        mg.visitJumpInsn(153, if_exception_end);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "afterPostCreateCompletion", "(Lcom/ibm/ejs/container/BeanO;)V");
        mg.visitLabel(if_exception_end);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        mg.loadLocal(returnValue);
        mg.returnValue();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], exceptionTypes[i].getInternalName());
        }
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_throwable, "java/lang/Throwable");
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addBMPEJBHomeCreateMethod(ClassWriter cw, java.lang.reflect.Method method, Class<?> ejbClass, Class<?> pkeyClass, String implClassName, String beanName, boolean isLocal) throws EJBConfigurationException {
        String postCreate_sig;
        java.lang.reflect.Method ejbPostCreateMethod;
        java.lang.reflect.Method ejbCreateMethod;
        String methodName = method.getName();
        String ejbCreateMethodName = "ejbC" + methodName.substring(1);
        String ejbPostCreateMethodName = "ejbPostC" + methodName.substring(1);
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        if (isLocal) {
            methodName = methodName + "_Local";
        }
        try {
            ejbCreateMethod = ejbClass.getMethod(ejbCreateMethodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_EJBCREATE_METHOD_CNTR5026E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), ejbClass.getName()});
            throw new EJBConfigurationException("ejbCreate method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and a corresponding method was not found on class " + ejbClass.getName());
        }
        if (ejbCreateMethod.getReturnType() != pkeyClass) {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_CREATE_RETURN_CNTR5027E", (Object[])new Object[]{beanName, ejbClass.getName(), ejbCreateMethod.getName(), ejbCreateMethod.getReturnType().getName(), pkeyClass.getName()});
            throw new EJBConfigurationException("Method " + ejbCreateMethod.getName() + " of class " + ejbCreateMethod.getReturnType().getName() + " with return type " + ejbCreateMethod.getReturnType().getName() + " must return the primary key type " + pkeyClass.getName() + " : " + beanName);
        }
        String ejbCreateMethodSignature = MethodAttribUtils.jdiMethodSignature(ejbCreateMethod);
        try {
            ejbPostCreateMethod = ejbClass.getMethod(ejbPostCreateMethodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_POSTCREATE_METHOD_CNTR5028E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), ejbClass.getName()});
            throw new EJBConfigurationException("ejbPostCreate method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and a corresponding method was not found on class " + ejbClass.getName());
        }
        if (!"void".equals(ejbPostCreateMethod.getReturnType().getName())) {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_POSTCREATE_RETURN_CNTR5029E", (Object[])new Object[]{beanName, ejbClass.getName(), ejbPostCreateMethod.getName(), ejbPostCreateMethod.getReturnType().getName()});
            throw new EJBConfigurationException("Method " + ejbPostCreateMethod.getName() + " of class " + ejbPostCreateMethod.getReturnType().getName() + " with return type " + ejbPostCreateMethod.getReturnType().getName() + " must return void : " + beanName);
        }
        String ejbPostCreateMethodSignature = MethodAttribUtils.jdiMethodSignature(ejbPostCreateMethod);
        String postCreate = isLocal ? "postCreate_Local" : "postCreate";
        String string = postCreate_sig = isLocal ? "(Lcom/ibm/ejs/container/BeanO;Ljava/lang/Object;Z)Ljakarta/ejb/EJBLocalObject;" : "(Lcom/ibm/ejs/container/BeanO;Ljava/lang/Object;Z)Ljakarta/ejb/EJBObject;";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                   : " + ejbCreateMethodName + " " + ejbCreateMethodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                   : " + ejbPostCreateMethodName + " " + ejbPostCreateMethodSignature), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int beanO = mg.newLocal(Type.getType((String)"Lcom/ibm/ejs/container/BeanO;"));
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        int exceptionOccurred = mg.newLocal(Type.BOOLEAN_TYPE);
        mg.push(false);
        mg.storeLocal(exceptionOccurred);
        int preEjbCreateCalled = mg.newLocal(Type.BOOLEAN_TYPE);
        mg.push(false);
        mg.storeLocal(preEjbCreateCalled);
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "createBeanO", "()Lcom/ibm/ejs/container/BeanO;");
        mg.storeLocal(beanO);
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        mg.loadLocal(beanO);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/BeanO", "getBeanInstance", "()Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "preEjbCreate", "(Lcom/ibm/ejs/container/BeanO;)Z");
        mg.storeLocal(preEjbCreateCalled);
        int pkey = mg.newLocal(Type.getType(pkeyClass));
        mg.loadLocal(bean);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, ejbCreateMethodName, ejbCreateMethodSignature);
        mg.storeLocal(pkey);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.loadLocal(pkey);
        mg.push(true);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", postCreate, postCreate_sig);
        mg.checkCast(returnType);
        mg.storeLocal(returnValue);
        mg.loadLocal(bean);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, ejbPostCreateMethodName, ejbPostCreateMethodSignature);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.loadLocal(pkey);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "afterPostCreate", "(Lcom/ibm/ejs/container/BeanO;Ljava/lang/Object;)V");
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[exceptionTypes.length];
        int caught_ex = mg.newLocal(Type.getType((String)"Ljava/lang/Exception;"));
        for (int i = 0; i < exceptionTypes.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.push(true);
            mg.storeLocal(exceptionOccurred);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_catch_throwable = new Label();
        mg.visitLabel(main_catch_throwable);
        int main_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_th);
        mg.push(true);
        mg.storeLocal(exceptionOccurred);
        if (isLocal) {
            mg.loadThis();
            mg.loadLocal(main_th);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "newCreateFailureException_Local", "(Ljava/lang/Throwable;)Ljakarta/ejb/EJBException;");
        } else {
            mg.visitTypeInsn(187, "com/ibm/ejs/container/CreateFailureException");
            mg.visitInsn(89);
            mg.loadLocal(main_th);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/CreateFailureException", "<init>", "(Ljava/lang/Throwable;)V");
        }
        mg.visitInsn(191);
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(Type.getType((String)"Ljava/lang/Object;"));
        mg.storeLocal(main_finally_return);
        Label if_exception_else = mg.newLabel();
        Label if_exception_end = mg.newLabel();
        mg.loadLocal(exceptionOccurred);
        mg.visitJumpInsn(153, if_exception_else);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "createFailure", "(Lcom/ibm/ejs/container/BeanO;)V");
        mg.visitJumpInsn(167, if_exception_end);
        mg.visitLabel(if_exception_else);
        mg.loadLocal(preEjbCreateCalled);
        mg.visitJumpInsn(153, if_exception_end);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "afterPostCreateCompletion", "(Lcom/ibm/ejs/container/BeanO;)V");
        mg.visitLabel(if_exception_end);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        mg.loadLocal(returnValue);
        mg.returnValue();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], exceptionTypes[i].getInternalName());
        }
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_throwable, "java/lang/Throwable");
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addBMPEJBHomeFindByPrimaryKeyMethod(ClassWriter cw, java.lang.reflect.Method method, Class<?> ejbClass, Class<?> pkeyClass, String implClassName, String beanName, boolean isLocal) throws EJBConfigurationException {
        java.lang.reflect.Method ejbFindMethod;
        String methodName = method.getName();
        String ejbFindMethodName = "ejbF" + methodName.substring(1);
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        try {
            ejbFindMethod = ejbClass.getMethod(ejbFindMethodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_EJBFIND_METHOD_CNTR5030E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), ejbClass.getName()});
            throw new EJBConfigurationException("ejbfind method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and a corresponding method was not found on class " + ejbClass.getName());
        }
        if (ejbFindMethod.getReturnType() != pkeyClass) {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_EJBFIND_RETURN_CNTR5031E", (Object[])new Object[]{beanName, ejbClass.getName(), ejbFindMethod.getName(), ejbFindMethod.getReturnType().getName(), pkeyClass.getName()});
            throw new EJBConfigurationException("Method " + ejbFindMethod.getName() + " of class " + ejbFindMethod.getReturnType().getName() + " with return type " + ejbFindMethod.getReturnType().getName() + " must return the primary key type " + pkeyClass.getName() + " : " + beanName);
        }
        String ejbFindMethodSignature = MethodAttribUtils.jdiMethodSignature(ejbFindMethod);
        String getBean = "getBean";
        String getBean_sig = "(Ljava/lang/Object;)Ljakarta/ejb/EJBObject;";
        String activateBean = "activateBean";
        String activateBean_sig = "(Ljava/lang/Object;)Ljakarta/ejb/EJBObject;";
        if (isLocal) {
            methodName = methodName + "_Local";
            getBean = "getBean_Local";
            getBean_sig = "(Ljava/lang/Object;)Ljakarta/ejb/EJBLocalObject;";
            activateBean = "activateBean_Local";
            activateBean_sig = "(Ljava/lang/Object;)Ljakarta/ejb/EJBLocalObject;";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                   : " + ejbFindMethodName + " " + ejbFindMethodSignature), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        mg.loadThis();
        mg.loadArgs(0, 1);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", getBean, getBean_sig);
        mg.checkCast(returnType);
        mg.storeLocal(returnValue);
        Label if_returnValue_end = mg.newLabel();
        mg.loadLocal(returnValue);
        mg.visitJumpInsn(199, if_returnValue_end);
        int beanO = mg.newLocal(Type.getType((String)"Lcom/ibm/ejs/container/EntityBeanO;"));
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        int pkey = mg.newLocal(Type.getType(pkeyClass));
        mg.visitInsn(1);
        mg.storeLocal(pkey);
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "getFindByPrimaryKeyEntityBeanO", "()Lcom/ibm/ejs/container/EntityBeanO;");
        mg.storeLocal(beanO);
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        mg.loadLocal(beanO);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/BeanO", "getBeanInstance", "()Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        mg.loadLocal(bean);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, ejbFindMethodName, ejbFindMethodSignature);
        mg.storeLocal(pkey);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseFinderEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[exceptionTypes.length];
        int caught_ex = mg.newLocal(Type.getType((String)"Ljava/lang/Exception;"));
        for (int i = 0; i < exceptionTypes.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.loadThis();
            mg.loadLocal(beanO);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseFinderEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
            mg.visitInsn(1);
            mg.storeLocal(beanO);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(Type.getType((String)"Ljava/lang/Object;"));
        mg.storeLocal(main_finally_return);
        Label if_notBeanO_end = mg.newLabel();
        mg.loadLocal(beanO);
        mg.visitJumpInsn(198, if_notBeanO_end);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "discardFinderEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
        mg.visitLabel(if_notBeanO_end);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        mg.loadThis();
        mg.loadLocal(pkey);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", activateBean, activateBean_sig);
        mg.checkCast(returnType);
        mg.storeLocal(returnValue);
        mg.visitLabel(if_returnValue_end);
        mg.loadLocal(returnValue);
        mg.returnValue();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], exceptionTypes[i].getInternalName());
        }
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addBMPEJBHomeFindMethod(ClassWriter cw, java.lang.reflect.Method method, Class<?> ejbClass, Class<?> pkeyClass, String implClassName, String beanName, boolean isLocal) throws EJBConfigurationException {
        java.lang.reflect.Method ejbFindMethod;
        String methodName = method.getName();
        String ejbFindMethodName = "ejbF" + methodName.substring(1);
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        try {
            ejbFindMethod = ejbClass.getMethod(ejbFindMethodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_EJBFIND_METHOD_CNTR5030E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), ejbClass.getName()});
            throw new EJBConfigurationException("ejbfind method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and a corresponding method was not found on class " + ejbClass.getName());
        }
        String ejbFindMethodSignature = MethodAttribUtils.jdiMethodSignature(ejbFindMethod);
        String postEjbFindMethodName = null;
        String postEjbFindMethodSignature = null;
        Class<?> returnTypeClass = ejbFindMethod.getReturnType();
        Type ejbFindReturnType = Type.getType(returnTypeClass);
        boolean postEjbFindIsActivate = false;
        if (returnTypeClass == pkeyClass) {
            postEjbFindIsActivate = true;
            postEjbFindMethodName = "activateBean";
            postEjbFindMethodSignature = "(Ljava/lang/Object;)Ljakarta/ejb/EJBObject;";
        } else if (returnTypeClass == Collection.class) {
            postEjbFindMethodName = "getCMP20Collection";
            postEjbFindMethodSignature = "(Ljava/util/Collection;)Ljava/util/Collection;";
        } else if (returnTypeClass == Enumeration.class) {
            postEjbFindMethodName = "getCMP20Enumeration";
            postEjbFindMethodSignature = "(Ljava/util/Enumeration;)Ljava/util/Enumeration;";
        } else {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_CUSTOM_EJBFIND_RETURN_CNTR5032E", (Object[])new Object[]{beanName, ejbClass.getName(), ejbFindMethod.getName(), ejbFindMethod.getReturnType().getName(), pkeyClass.getName()});
            throw new EJBConfigurationException("Method " + ejbFindMethod.getName() + " of class " + ejbFindMethod.getReturnType().getName() + " with return type " + ejbFindMethod.getReturnType().getName() + " must return the primary key type " + pkeyClass.getName() + ", Collection, or Enumeration : " + beanName);
        }
        if (isLocal) {
            methodName = methodName + "_Local";
            postEjbFindMethodName = postEjbFindMethodName + "_Local";
            if (postEjbFindIsActivate) {
                postEjbFindMethodSignature = "(Ljava/lang/Object;)Ljakarta/ejb/EJBLocalObject;";
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                   : " + ejbFindMethodName + " " + ejbFindMethodSignature), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int beanO = mg.newLocal(Type.getType((String)"Lcom/ibm/ejs/container/EntityBeanO;"));
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "getFinderEntityBeanO", "()Lcom/ibm/ejs/container/EntityBeanO;");
        mg.storeLocal(beanO);
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        mg.loadLocal(beanO);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/BeanO", "getBeanInstance", "()Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        int ejbFindReturnValue = mg.newLocal(ejbFindReturnType);
        mg.loadLocal(bean);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, ejbFindMethodName, ejbFindMethodSignature);
        mg.storeLocal(ejbFindReturnValue);
        mg.loadThis();
        mg.loadLocal(ejbFindReturnValue);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", postEjbFindMethodName, postEjbFindMethodSignature);
        if (postEjbFindIsActivate) {
            mg.checkCast(returnType);
        }
        mg.storeLocal(returnValue);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseFinderEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[exceptionTypes.length];
        int caught_ex = mg.newLocal(Type.getType((String)"Ljava/lang/Exception;"));
        for (int i = 0; i < exceptionTypes.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.loadThis();
            mg.loadLocal(beanO);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseFinderEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
            mg.visitInsn(1);
            mg.storeLocal(beanO);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(Type.getType((String)"Ljava/lang/Object;"));
        mg.storeLocal(main_finally_return);
        Label if_notBeanO_end = mg.newLabel();
        mg.loadLocal(beanO);
        mg.visitJumpInsn(198, if_notBeanO_end);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "discardFinderEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
        mg.visitLabel(if_notBeanO_end);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        mg.loadLocal(returnValue);
        mg.returnValue();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], exceptionTypes[i].getInternalName());
        }
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addBMPEJBHomeHomeMethod(ClassWriter cw, java.lang.reflect.Method method, Class<?> ejbClass, String implClassName, String beanName) throws EJBConfigurationException {
        java.lang.reflect.Method ejbHomeMethod;
        String methodName = method.getName();
        StringBuilder ejbHomeBuilder = new StringBuilder("ejbHome");
        ejbHomeBuilder.append(methodName.substring(0, 1).toUpperCase());
        ejbHomeBuilder.append(methodName.substring(1));
        String ejbHomeMethodName = ejbHomeBuilder.toString();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        try {
            ejbHomeMethod = ejbClass.getMethod(ejbHomeMethodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            Tr.error((TraceComponent)tc, (String)"JIT_NO_EJBHOME_METHOD_CNTR5033E", (Object[])new Object[]{beanName, method.getDeclaringClass().getName(), method.getName(), ejbClass.getName()});
            throw new EJBConfigurationException("ejbHome method required for home method " + method.getName() + methodSignature + " of interface " + method.getDeclaringClass().getName() + " for bean " + beanName + ", and a corresponding method was not found on class " + ejbClass.getName());
        }
        if (ejbHomeMethod.getReturnType() != method.getReturnType()) {
            Tr.error((TraceComponent)tc, (String)"JIT_INVALID_EJBHOME_RETURN_CNTR5034E", (Object[])new Object[]{beanName, ejbClass.getName(), ejbHomeMethod.getName(), ejbHomeMethod.getReturnType().getName(), method.getReturnType()});
            throw new EJBConfigurationException("Method " + ejbHomeMethod.getName() + " of class " + ejbHomeMethod.getReturnType().getName() + " with return type " + ejbHomeMethod.getReturnType().getName() + " must return " + method.getReturnType() + " : " + beanName);
        }
        String ejbHomeMethodSignature = MethodAttribUtils.jdiMethodSignature(ejbHomeMethod);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("                   : " + ejbHomeMethodName + " " + ejbHomeMethodSignature), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int beanO = mg.newLocal(Type.getType((String)"Lcom/ibm/ejs/container/EntityBeanO;"));
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "getHomeMethodEntityBeanO", "()Lcom/ibm/ejs/container/EntityBeanO;");
        mg.storeLocal(beanO);
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        mg.loadLocal(beanO);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/BeanO", "getBeanInstance", "()Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        mg.loadLocal(bean);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, ejbHomeMethodName, ejbHomeMethodSignature);
        if (returnType != Type.VOID_TYPE) {
            mg.storeLocal(returnValue);
        }
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseHomeMethodEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
        mg.visitInsn(1);
        mg.storeLocal(beanO);
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[exceptionTypes.length];
        int caught_ex = mg.newLocal(Type.getType((String)"Ljava/lang/Exception;"));
        for (int i = 0; i < exceptionTypes.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.loadThis();
            mg.loadLocal(beanO);
            mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseHomeMethodEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
            mg.visitInsn(1);
            mg.storeLocal(beanO);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(Type.getType((String)"Ljava/lang/Throwable;"));
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(Type.getType((String)"Ljava/lang/Object;"));
        mg.storeLocal(main_finally_return);
        Label if_notBeanO_end = mg.newLabel();
        mg.loadLocal(beanO);
        mg.visitJumpInsn(198, if_notBeanO_end);
        mg.loadThis();
        mg.loadLocal(beanO);
        mg.visitMethodInsn(183, "com/ibm/ejs/container/EJSHome", "releaseHomeMethodEntityBeanO", "(Lcom/ibm/ejs/container/EntityBeanO;)V");
        mg.visitLabel(if_notBeanO_end);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], exceptionTypes[i].getInternalName());
        }
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }
}

