/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.channel.ssl.internal.SSLChannelFactoryImpl;
import com.ibm.ws.channel.ssl.internal.SSLChannelOptions;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.ssl.SSLConfiguration;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;

public class SSLChannelProvider
implements ChannelFactoryProvider,
ManagedServiceFactory {
    private static final TraceComponent tc = Tr.register(SSLChannelProvider.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    static final String SSL_CFG_SUPPRESS_HANDSHAKE_ERRORS = "suppressHandshakeErrors";
    static final String SSL_CFG_SUPPRESS_HANDSHAKE_ERRORS_COUNT = "suppressHandshakeErrorsCount";
    static final String SSL_CFG_REF = "sslRef";
    static final String SSL_CFG_ID = "id";
    private static final AtomicReference<SSLChannelProvider> instance = new AtomicReference<Object>(null);
    private EventEngine eventService = null;
    private SSLSupport sslSupport = null;
    private CHFWBundle cfwBundle = null;
    private final ConcurrentServiceReferenceMap<String, SSLConfiguration> sslConfigs = new ConcurrentServiceReferenceMap("sslConfig");
    private final ConcurrentHashMap<String, SSLChannelOptions> sslOptions = new ConcurrentHashMap();
    private final Map<String, Class<? extends ChannelFactory>> factories = new HashMap<String, Class<? extends ChannelFactory>>();
    private volatile BundleContext bContext;
    private volatile String defaultId = null;

    public SSLChannelProvider() {
        this.factories.put("SSLChannel", SSLChannelFactoryImpl.class);
        this.factories.put("SSLInboundChannel", SSLChannelFactoryImpl.class);
        this.factories.put("SSLOutboundChannel", SSLChannelFactoryImpl.class);
    }

    protected synchronized void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating", (Object[])new Object[0]);
        }
        this.bContext = context.getBundleContext();
        instance.set(this);
        this.sslConfigs.activate(context);
        this.cfwBundle.getFramework().registerFactories((ChannelFactoryProvider)this);
    }

    protected synchronized void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivating", (Object[])new Object[0]);
        }
        while (!this.sslOptions.isEmpty()) {
            Iterator<Map.Entry<String, SSLChannelOptions>> i = this.sslOptions.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, SSLChannelOptions> entry = i.next();
                entry.getValue().unregister();
                i.remove();
            }
        }
        this.sslConfigs.deactivate(context);
        this.cfwBundle.getFramework().deregisterFactories((ChannelFactoryProvider)this);
        this.bContext = null;
        instance.compareAndSet(this, null);
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (FrameworkState.isStopping() || this.bContext == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updated", (Object[])new Object[]{properties});
        }
        SSLChannelOptions options = null;
        SSLChannelOptions old = this.sslOptions.get(pid);
        if (old == null) {
            options = new SSLChannelOptions();
            old = this.sslOptions.putIfAbsent(pid, options);
        }
        if (old != null) {
            options = old;
        }
        options.updateConfguration(properties, this.defaultId);
        options.updateRegistration(this.bContext, this.sslConfigs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updated", (Object)properties);
        }
    }

    public void deleted(String pid) {
        SSLChannelOptions old = this.sslOptions.remove(pid);
        if (old != null) {
            old.unregister();
        }
    }

    public String getName() {
        return "SSL Channel provider";
    }

    public Map<String, Class<? extends ChannelFactory>> getTypes() {
        return this.factories;
    }

    public void init() {
    }

    protected void setSslSupport(SSLSupport service, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSslSupport", (Object[])new Object[]{props});
        }
        this.sslSupport = service;
        this.defaultId = (String)props.get(SSL_CFG_REF);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSslSupport", (Object)("defaultConfigId=" + this.defaultId));
        }
    }

    protected void updatedSslSupport(SSLSupport service, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updatedSslSupport", (Object[])new Object[]{props});
        }
        this.sslSupport = service;
        String id = (String)props.get(SSL_CFG_REF);
        if (id != null && this.defaultId == null || id != null && !this.defaultId.equals(id)) {
            for (SSLChannelOptions options : this.sslOptions.values()) {
                options.updateRefId(id);
                options.updateRegistration(this.bContext, this.sslConfigs);
            }
            this.defaultId = id;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updatedSslSupport", (Object)("defaultConfigId=" + this.defaultId));
        }
    }

    protected void unsetSslSupport(SSLSupport service) {
        this.sslSupport = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetSslSupport", (Object[])new Object[]{service});
        }
    }

    protected void setSslConfig(ServiceReference<SSLConfiguration> service) {
        String id = (String)service.getProperty(SSL_CFG_ID);
        this.sslConfigs.putReference((Object)id, service);
        for (SSLChannelOptions options : this.sslOptions.values()) {
            options.updateRegistration(this.bContext, this.sslConfigs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setSslConfig", (Object[])new Object[]{"id=" + id, service});
        }
    }

    protected void unsetSslConfig(ServiceReference<SSLConfiguration> service) {
        String id = (String)service.getProperty(SSL_CFG_ID);
        this.sslConfigs.removeReference((Object)id, service);
        for (SSLChannelOptions options : this.sslOptions.values()) {
            options.updateRegistration(this.bContext, this.sslConfigs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetSslConfig", (Object[])new Object[]{"id=" + id, service});
        }
    }

    protected void setEventService(EventEngine service) {
        this.eventService = service;
    }

    protected void unsetEventService(EventEngine service) {
    }

    protected void setChfwBundle(CHFWBundle service) {
        this.cfwBundle = service;
    }

    protected void unsetChfwBundle(ServiceReference<CHFWBundle> service) {
    }

    public static ChannelFramework getCfw() {
        SSLChannelProvider p = instance.get();
        if (p != null) {
            return p.cfwBundle.getFramework();
        }
        throw new IllegalStateException("Requested service is null: no active component instance");
    }

    public static JSSEProvider getJSSEProvider() {
        SSLChannelProvider p = instance.get();
        if (p != null) {
            return p.sslSupport.getJSSEProvider();
        }
        throw new IllegalStateException("Requested service is null: no active component instance");
    }

    public static JSSEHelper getJSSEHelper() {
        SSLChannelProvider p = instance.get();
        if (p != null) {
            return p.sslSupport.getJSSEHelper();
        }
        throw new IllegalStateException("Requested service is null: no active component instance");
    }

    public static EventEngine getEventService() {
        SSLChannelProvider p = instance.get();
        if (p != null) {
            return p.eventService;
        }
        throw new IllegalStateException("Requested service is null: no active component instance");
    }

    public static long getApproxTime() {
        return System.currentTimeMillis();
    }
}

