/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.translator.resource.JspResourcesFactoryImpl;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.jsp.compiler.JspCompilerFactory;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationEnvironment;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import com.ibm.wsspi.jsp.resource.translation.JspResourcesFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JSPExtensionContext
implements JspTranslationContext {
    protected IServletContext context;
    protected DocumentRootUtils dru;
    protected URL contextURL;
    protected JspResourcesFactory jspResourcesFactory;
    protected JspInputSourceFactory jspInputSourceFactory;
    protected JspClassloaderContext jspClassloaderContext;
    protected JspCompilerFactory jspCompilerFactory;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.webcontainerext.JSPExtensionContext";
    static final long serialVersionUID = -1355088300886060655L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSPExtensionContext(IServletContext context, JspOptions jspOptions, String extDocRoot, String preFragExtDocRoot, JspClassloaderContext jspClassloaderContext, JspCompilerFactory jspCompilerFactory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{context, jspOptions, extDocRoot, preFragExtDocRoot, jspClassloaderContext, jspCompilerFactory});
        }
        this.context = null;
        this.dru = null;
        this.contextURL = null;
        this.jspResourcesFactory = null;
        this.jspInputSourceFactory = null;
        this.jspClassloaderContext = null;
        this.jspCompilerFactory = null;
        this.context = context;
        this.jspClassloaderContext = jspClassloaderContext;
        this.jspCompilerFactory = jspCompilerFactory;
        this.dru = new DocumentRootUtils((ServletContext)context, extDocRoot, preFragExtDocRoot);
        String docRoot = null;
        try {
            Container container = context.getModuleContainer();
            if (container == null) {
                docRoot = context.getRealPath("/");
                this.contextURL = new File(docRoot).toURL();
            } else {
                docRoot = null;
                this.contextURL = null;
            }
        }
        catch (MalformedURLException e) {
            logger.logp(Level.WARNING, "JSPExtensionContext", "JSPExtensionContext", "Failed to create context URL for docRoot: " + context.getRealPath("/"), e);
        }
        this.jspResourcesFactory = new JspResourcesFactoryImpl(jspOptions, this, context.getModuleContainer());
        this.jspInputSourceFactory = new JspInputSourceFactoryImpl(docRoot, this.contextURL, this.dru, false, context.getModuleContainer(), jspClassloaderContext.getClassLoader(), (ServletContext)context);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRealTimeStamp(String path) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRealTimeStamp", new Object[]{path});
        }
        JspInputSource inputSource = this.getJspInputSourceFactory().createJspInputSource(path);
        long l = inputSource.getLastModified();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getRealTimeStamp", l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRealPath(String path) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getRealPath", path);
        }
        if (this.context != null) {
            String realPath = this.context.getRealPath(path);
            if (realPath == null || !new File(realPath).exists()) {
                DocumentRootUtils documentRootUtils = this.dru;
                synchronized (documentRootUtils) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "Checking extendedDocumentRoot path: " + path);
                        }
                        this.dru.handleDocumentRoots(path);
                        realPath = this.dru.getFilePath();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "Path was retrieved from the extendedDoucumentRoots realPath: " + realPath);
                        }
                    }
                    catch (FileNotFoundException fne_io) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getRealPath", "FileNotFound exception while obtaining realPath: " + realPath + ", exception was: " + fne_io);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jsp.webcontainerext.JspExtensionContext.getResourceAsStream", (String)"102", (Object)this);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "getRealPath", realPath);
            }
            return realPath;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getRealPath", path);
        }
        return path;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set getResourcePaths(String paths) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResourcePaths", new Object[]{paths});
        }
        Set set = this.context.getResourcePaths(paths);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting(CLASS_NAME, "getResourcePaths", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set getResourcePaths(String path, boolean searchMetaInfResources) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResourcePaths", new Object[]{path, searchMetaInfResources});
        }
        Set set = this.context.getResourcePaths(path, searchMetaInfResources);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting(CLASS_NAME, "getResourcePaths", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspResourcesFactory getJspResourcesFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspResourcesFactory", new Object[0]);
        }
        JspResourcesFactory jspResourcesFactory = this.jspResourcesFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspResourcesFactory = jspResourcesFactory;
            logger.exiting(CLASS_NAME, "getJspResourcesFactory", jspResourcesFactory);
        }
        return jspResourcesFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSourceFactory getJspInputSourceFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspInputSourceFactory", new Object[0]);
        }
        JspInputSourceFactory jspInputSourceFactory = this.jspInputSourceFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspInputSourceFactory = jspInputSourceFactory;
            logger.exiting(CLASS_NAME, "getJspInputSourceFactory", jspInputSourceFactory);
        }
        return jspInputSourceFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspClassloaderContext getJspClassloaderContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspClassloaderContext", new Object[0]);
        }
        JspClassloaderContext jspClassloaderContext = this.jspClassloaderContext;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspClassloaderContext = jspClassloaderContext;
            logger.exiting(CLASS_NAME, "getJspClassloaderContext", jspClassloaderContext);
        }
        return jspClassloaderContext;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerFactory getJspCompilerFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspCompilerFactory", new Object[0]);
        }
        JspCompilerFactory jspCompilerFactory = this.jspCompilerFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspCompilerFactory = jspCompilerFactory;
            logger.exiting(CLASS_NAME, "getJspCompilerFactory", jspCompilerFactory);
        }
        return jspCompilerFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJspTranslationEnviroment(JspTranslationEnvironment jspEnvironment) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setJspTranslationEnviroment", new Object[]{jspEnvironment});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setJspTranslationEnviroment");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IServletContext getServletContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServletContext", new Object[0]);
        }
        IServletContext iServletContext = this.context;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iServletContext = iServletContext;
            logger.exiting(CLASS_NAME, "getServletContext", iServletContext);
        }
        return iServletContext;
    }
}

