/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.callbacks;

import io.smallrye.openapi.model.ReferenceType;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class CallbackIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Callback, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_OPERATIONS = "operations";
    private static final String PROP_CALLBACK_URL_EXPRESSION = "callbackUrlExpression";
    private static final String PROP_PATH_ITEM_REF = "pathItemRef";

    public CallbackIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.CALLBACK, DotName.createSimple(Callback.class));
    }

    @Override
    public Callback read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Callback");
        Callback callback = OASFactory.createCallback();
        callback.setRef(ReferenceType.CALLBACK.refValue(annotation));
        Optional.ofNullable((String)this.value(annotation, PROP_PATH_ITEM_REF)).map(arg_0 -> ((ReferenceType)ReferenceType.PATH_ITEM).referenceOf(arg_0)).ifPresent(ref -> callback.addPathItem((String)this.value(annotation, PROP_CALLBACK_URL_EXPRESSION), (PathItem)OASFactory.createPathItem().ref(ref)));
        Optional.ofNullable(this.value(annotation, PROP_OPERATIONS)).map(AnnotationInstance[].class::cast).map(this.pathItemIO()::readCallbackOperations).ifPresent(pathItem -> callback.addPathItem((String)this.value(annotation, PROP_CALLBACK_URL_EXPRESSION), pathItem));
        callback.setExtensions(this.extensionIO().readExtensible(annotation));
        return callback;
    }
}

