/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.jaxrs.JaxRsLogging;
import io.smallrye.openapi.jaxrs.JaxRsParameter;
import io.smallrye.openapi.jaxrs.JaxRsParameterProcessor;
import io.smallrye.openapi.jaxrs.JaxRsSubResourceLocator;
import io.smallrye.openapi.jaxrs.RestEasyConstants;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JaxRsAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String JAVAX_PACKAGE = "javax.ws.rs";
    private static final String JAKARTA_PACKAGE = "jakarta.ws.rs";
    private static final Predicate<DotName> isParameter = JaxRsParameter::isParameter;
    private static final Predicate<DotName> inJaxRsPackage = name -> {
        String nameString = name.toString();
        return nameString.startsWith(JAKARTA_PACKAGE) || nameString.startsWith(JAVAX_PACKAGE);
    };
    private final Deque<JaxRsSubResourceLocator> subResourceStack = new LinkedList<JaxRsSubResourceLocator>();

    public String getName() {
        return "JAX-RS";
    }

    public boolean isWrapperType(Type type) {
        return type.name().equals((Object)RestEasyConstants.REACTIVE_REST_RESPONSE) && type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return method.parameterTypes().stream().map(Type::name).anyMatch(JaxRsConstants.ASYNC_RESPONSE::contains);
    }

    public boolean isPostMethod(MethodInfo method) {
        return this.context.annotations().hasAnnotation((AnnotationTarget)method, JaxRsConstants.POST);
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return this.context.annotations().hasAnnotation((AnnotationTarget)method, JaxRsConstants.DELETE);
    }

    public boolean isScannerInternalResponse(Type returnType) {
        return JaxRsConstants.RESPONSE.contains(returnType.name());
    }

    public boolean isMultipartOutput(Type returnType) {
        return RestEasyConstants.MULTIPART_OUTPUTS.contains(returnType.name());
    }

    public boolean isMultipartInput(Type inputType) {
        return RestEasyConstants.MULTIPART_INPUTS.contains(inputType.name());
    }

    public boolean isFrameworkContextType(Type type) {
        return JaxRsConstants.CONTEXTS.contains(type.name());
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        if (JaxRsAnnotationScanner.containsJaxrsAnnotations(instances)) {
            return true;
        }
        for (AnnotationInstance instance : instances) {
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsJaxrsAnnotations(List<AnnotationInstance> instances) {
        return instances.stream().map(AnnotationInstance::name).anyMatch(isParameter.or(inJaxRsPackage));
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.context = context;
        this.processApplicationClasses(openApi);
        this.processResourceClasses(openApi);
        return openApi;
    }

    private void processApplicationClasses(OpenAPI openApi) {
        ArrayList applications = new ArrayList();
        for (DotName applicationindicator : JaxRsConstants.APPLICATION) {
            applications.addAll(this.context.getIndex().getAllKnownSubclasses(applicationindicator));
        }
        this.processScannerExtensions(this.context, applications);
        for (ClassInfo classInfo : applications) {
            OpenAPI applicationOpenApi = this.processApplicationClass(classInfo);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processApplicationClass(ClassInfo applicationClass) {
        AnnotationInstance applicationPathAnnotation = this.context.annotations().getAnnotation((AnnotationTarget)applicationClass, JaxRsConstants.APPLICATION_PATH);
        if (applicationPathAnnotation == null || this.context.getConfig().applicationPathDisable()) {
            applicationPathAnnotation = this.context.annotations().getAnnotation((AnnotationTarget)applicationClass, JaxRsConstants.PATH);
        }
        this.currentAppPath = applicationPathAnnotation != null ? applicationPathAnnotation.value().asString() : "/";
        OpenAPI openApi = this.processDefinitionAnnotation(this.context, applicationClass);
        this.processSecuritySchemeAnnotation(this.context, applicationClass, openApi);
        this.processServerAnnotation(this.context, applicationClass, openApi);
        return openApi;
    }

    private void processResourceClasses(OpenAPI openApi) {
        ArrayList<ClassInfo> resourceClasses = new ArrayList<ClassInfo>();
        resourceClasses.addAll(this.getJaxRsResourceClasses());
        resourceClasses.addAll(this.getConfigurationResourceClasses());
        for (ClassInfo resourceClass : resourceClasses) {
            TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)this.context, (ClassInfo)resourceClass, null);
            this.context.getResolverStack().push(resolver);
            Set<String> tags = this.processResourceClassTags(openApi, resourceClass);
            this.processResourceClass(openApi, resourceClass, null, tags);
            this.context.getResolverStack().pop();
        }
    }

    private Set<String> processResourceClassTags(OpenAPI openApi, ClassInfo resourceClass) {
        Set tags = null;
        while ((tags = this.processTags(this.context, (AnnotationTarget)resourceClass, openApi, true)) == null) {
            Type superType = resourceClass.superClassType();
            if ((resourceClass = superType != null ? this.context.getAugmentedIndex().getClass(superType) : null) != null) continue;
            tags = Collections.emptySet();
            break;
        }
        return tags;
    }

    private void processResourceClass(OpenAPI openApi, ClassInfo resourceClass, List<Parameter> locatorPathParameters, Set<String> tagRefs) {
        JaxRsLogging.log.processingClass(resourceClass.simpleName());
        this.processSecuritySchemeAnnotation(this.context, resourceClass, openApi);
        this.processJavaSecurity(this.context, resourceClass, openApi);
        this.processResourceMethods(resourceClass, openApi, locatorPathParameters, tagRefs);
    }

    private void processResourceMethods(ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters, Set<String> tagRefs) {
        Map<DotName, Map<String, APIResponse>> exceptionResponseMap = this.processExceptionMappers();
        List methods = this.getResourceMethods(this.context, resourceClass);
        Collections.reverse(methods);
        for (MethodInfo methodInfo : methods) {
            AtomicInteger resourceCount = new AtomicInteger(0);
            JaxRsConstants.HTTP_METHODS.stream().filter(arg_0 -> ((MethodInfo)methodInfo).hasAnnotation(arg_0)).map(DotName::withoutPackagePrefix).map(PathItem.HttpMethod::valueOf).distinct().forEach(httpMethod -> {
                resourceCount.incrementAndGet();
                this.processResourceMethod(resourceClass, methodInfo, (PathItem.HttpMethod)httpMethod, tagRefs, locatorPathParameters, exceptionResponseMap);
            });
            if (resourceCount.get() != 0 || !this.context.annotations().hasAnnotation((AnnotationTarget)methodInfo, JaxRsConstants.PATH)) continue;
            this.processSubResource(resourceClass, methodInfo, openApi, locatorPathParameters, tagRefs);
        }
    }

    private Map<DotName, Map<String, APIResponse>> processExceptionMappers() {
        HashMap<DotName, Map<String, APIResponse>> exceptionMappers = new HashMap<DotName, Map<String, APIResponse>>();
        for (DotName mapperName : JaxRsConstants.EXCEPTION_MAPPER) {
            for (ClassInfo mapper : this.context.getIndex().getKnownDirectImplementors(mapperName)) {
                exceptionMappers.putAll(this.exceptionResponseAnnotations(mapper));
            }
        }
        for (AnnotationInstance mapperAnnotation : this.context.getIndex().getAnnotations(RestEasyConstants.SERVER_EXCEPTION_MAPPER)) {
            MethodInfo mapperMethod = mapperAnnotation.target().asMethod();
            if (mapperMethod.parametersCount() != 1) continue;
            DotName exceptionName = mapperMethod.parameterType(0).name();
            exceptionMappers.put(exceptionName, this.context.io().apiResponsesIO().readAll((AnnotationTarget)mapperMethod));
        }
        return exceptionMappers;
    }

    private Map<DotName, Map<String, APIResponse>> exceptionResponseAnnotations(ClassInfo classInfo) {
        Type exceptionType = classInfo.interfaceTypes().stream().filter(it -> JaxRsConstants.EXCEPTION_MAPPER.contains(it.name())).filter(it -> Type.Kind.PARAMETERIZED_TYPE.equals((Object)it.kind())).map(Type::asParameterizedType).map(type -> (Type)type.arguments().get(0)).findAny().orElse(null);
        if (exceptionType == null) {
            return Collections.emptyMap();
        }
        Stream methodAnnotations = Stream.of(classInfo.method("toResponse", new Type[]{exceptionType})).filter(Objects::nonNull).flatMap(m -> this.context.io().apiResponsesIO().readAll((AnnotationTarget)m).entrySet().stream());
        Stream classAnnotations = this.context.io().apiResponsesIO().readAll((AnnotationTarget)classInfo).entrySet().stream();
        BinaryOperator latest = (v1, v2) -> v2;
        Map annotations = Stream.concat(classAnnotations, methodAnnotations).filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, latest, LinkedHashMap::new));
        if (annotations.isEmpty()) {
            return Collections.emptyMap();
        }
        return Map.of(exceptionType.name(), annotations);
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    private void processSubResource(ClassInfo resourceClass, MethodInfo method, OpenAPI openApi, List<Parameter> locatorPathParameters, Set<String> tagRefs) {
        Type methodReturnType = this.context.getResourceTypeResolver().resolve(method.returnType());
        if (Type.Kind.VOID.equals((Object)methodReturnType.kind())) {
            return;
        }
        JaxRsSubResourceLocator locator = new JaxRsSubResourceLocator(resourceClass, method);
        ClassInfo subResourceClass = this.context.getIndex().getClassByName(methodReturnType.name());
        if (subResourceClass != null && !this.subResourceStack.contains(locator)) {
            Function<AnnotationInstance, Parameter> reader = t -> this.context.io().parameterIO().read(t);
            ResourceParameters params = JaxRsParameterProcessor.process(this.context, this.currentAppPath, resourceClass, method, reader, this.context.getExtensions());
            String originalAppPath = this.currentAppPath;
            List operationPaths = this.subResourceStack.isEmpty() ? params.getFullOperationPaths() : params.getOperationPaths();
            boolean operationsPathIsEmpty = operationPaths == null || operationPaths.isEmpty();
            String subResourcePath = !operationsPathIsEmpty ? (String)operationPaths.get(0) : null;
            this.currentAppPath = JaxRsAnnotationScanner.createPathFromSegments((String[])new String[]{this.currentAppPath, subResourcePath});
            this.subResourceStack.push(locator);
            TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)this.context, (ClassInfo)subResourceClass, (Type)methodReturnType);
            this.context.getResolverStack().push(resolver);
            Set subresourceTags = Optional.ofNullable(this.processTags(this.context, (AnnotationTarget)method, openApi, true)).orElseGet(() -> Optional.ofNullable(this.processTags(this.context, (AnnotationTarget)subResourceClass, openApi, true)).orElse(tagRefs));
            this.processResourceClass(openApi, subResourceClass, ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters(), params.getOperationParameters()}), subresourceTags);
            this.context.getResolverStack().pop();
            this.subResourceStack.pop();
            this.currentAppPath = originalAppPath;
        }
    }

    private void processResourceMethod(ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, Set<String> resourceTags, List<Parameter> locatorPathParameters, Map<DotName, Map<String, APIResponse>> exceptionResponseMap) {
        JaxRsLogging.log.processingMethod(method.toString());
        String[] defaultConsumes = this.getDefaultConsumes(this.context, method, this.getResourceParameters(resourceClass, method));
        this.context.setDefaultConsumes(defaultConsumes);
        this.context.setCurrentConsumes((String[])this.getMediaTypes(method, JaxRsConstants.CONSUMES, defaultConsumes).orElse(null));
        String[] defaultProduces = this.getDefaultProduces(this.context, method);
        this.context.setDefaultProduces(defaultProduces);
        this.context.setCurrentProduces((String[])this.getMediaTypes(method, JaxRsConstants.PRODUCES, defaultProduces).orElse(null));
        Optional maybeOperation = this.processOperation(this.context, resourceClass, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(this.context, method, this.context.getOpenApi(), resourceTags, operation);
        ResourceParameters params = this.getResourceParameters(resourceClass, method);
        List operationParams = params.getOperationParameters();
        operation.setParameters(operationParams);
        if (locatorPathParameters != null && operationParams != null) {
            locatorPathParameters = JaxRsAnnotationScanner.excludeOperationParameters(locatorPathParameters, operationParams);
        }
        PathItem pathItem = OASFactory.createPathItem();
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(this.context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(this.context, resourceClass, method, operation, exceptionResponseMap);
        this.processSecurityRequirementAnnotation(this.context, resourceClass, method, operation);
        this.processCallback(this.context, method, operation);
        this.processServerAnnotation(this.context, method, operation);
        this.processExtensions(this.context, method, operation);
        this.context.getJavaSecurityProcessor().processSecurityRoles(method, operation);
        pathItem.setOperation(methodType, operation);
        if (!JaxRsAnnotationScanner.processProfiles((OpenApiConfig)this.context.getConfig(), (Extensible)operation)) {
            return;
        }
        List operationPaths = this.subResourceStack.isEmpty() ? params.getFullOperationPaths() : params.getOperationPaths();
        boolean operationsPathIsEmpty = operationPaths == null || operationPaths.isEmpty();
        String path = super.makePath(!operationsPathIsEmpty ? (String)operationPaths.get(0) : null);
        PathItem existingPath = ModelUtil.paths((OpenAPI)this.context.getOpenApi()).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)this.context.getOpenApi()).addPathItem(path, pathItem);
        } else {
            MergeUtil.mergeObjects((Constructible)existingPath, (Constructible)pathItem);
        }
    }

    private ResourceParameters getResourceParameters(ClassInfo resourceClass, MethodInfo method) {
        Function<AnnotationInstance, Parameter> reader = t -> this.context.io().parameterIO().read(t);
        return JaxRsParameterProcessor.process(this.context, this.currentAppPath, resourceClass, method, reader, this.context.getExtensions());
    }

    static List<Parameter> excludeOperationParameters(List<Parameter> locatorParams, List<Parameter> operationParams) {
        return locatorParams.stream().filter(param -> operationParams.stream().noneMatch(oParam -> Objects.equals(param.getName(), oParam.getName()) && Objects.equals(param.getIn(), oParam.getIn()))).collect(Collectors.toList());
    }

    Optional<String[]> getMediaTypes(MethodInfo resourceMethod, Set<DotName> annotationName, String[] defaultValue) {
        return this.context.getAugmentedIndex().ancestry(resourceMethod).entrySet().stream().map(e -> this.getMediaTypeAnnotation((ClassInfo)e.getKey(), (MethodInfo)e.getValue(), annotationName)).filter(Objects::nonNull).map(annotation -> JaxRsAnnotationScanner.mediaTypeValue(annotation, defaultValue)).findFirst();
    }

    AnnotationInstance getMediaTypeAnnotation(ClassInfo clazz, MethodInfo method, Set<DotName> annotationName) {
        AnnotationInstance annotation = null;
        if (method != null) {
            annotation = this.context.annotations().getAnnotation((AnnotationTarget)method, annotationName);
        }
        if (annotation == null) {
            annotation = this.context.annotations().getAnnotation((AnnotationTarget)clazz, annotationName);
        }
        return annotation;
    }

    static String[] mediaTypeValue(AnnotationInstance mediaTypeAnnotation, String[] defaultValue) {
        AnnotationValue annotationValue = mediaTypeAnnotation.value();
        if (annotationValue != null) {
            return JaxRsAnnotationScanner.flattenAndTrimMediaTypes(annotationValue.asStringArray());
        }
        return defaultValue;
    }

    static String[] flattenAndTrimMediaTypes(String[] mediaTypes) {
        return (String[])Arrays.stream(mediaTypes).map(mediaType -> mediaType.split(",")).flatMap(Arrays::stream).map(String::trim).toArray(String[]::new);
    }

    private Collection<ClassInfo> getJaxRsResourceClasses() {
        ArrayList pathAnnotations = new ArrayList();
        for (DotName dn : JaxRsConstants.PATH) {
            pathAnnotations.addAll(this.context.getIndex().getAnnotations(dn));
        }
        return pathAnnotations.stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(this::hasImplementationOrIsIncluded).collect(Collectors.toCollection(() -> new TreeSet((one, two) -> one.name().compareTo(two.name()))));
    }

    private Collection<ClassInfo> getConfigurationResourceClasses() {
        return this.context.getConfig().getScanResourceClasses().keySet().stream().map(DotName::createSimple).map(className -> this.context.getIndex().getClassByName(className)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean hasImplementationOrIsIncluded(ClassInfo clazz) {
        if (this.neitherAbstractNorSyntheticRestClient(clazz)) {
            return true;
        }
        FilteredIndexView filteredIndex = this.context.getIndex();
        if (filteredIndex.getAllKnownImplementors(clazz.name()).stream().anyMatch(this::neitherAbstractNorSynthetic)) {
            return true;
        }
        return filteredIndex.explicitlyAccepts(clazz.name());
    }

    private boolean neitherAbstractNorSyntheticRestClient(ClassInfo clazz) {
        if (Modifier.isAbstract(clazz.flags())) {
            return false;
        }
        if (!clazz.isSynthetic()) {
            return true;
        }
        AugmentedIndexView index = this.context.getAugmentedIndex();
        return index.inheritanceChain(clazz, Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS)).entrySet().stream().flatMap(e -> index.interfaces((ClassInfo)e.getKey()).stream()).map(arg_0 -> ((AugmentedIndexView)index).getClass(arg_0)).filter(Objects::nonNull).noneMatch(iface -> this.context.annotations().getAnnotation((AnnotationTarget)iface, new DotName[]{JaxRsConstants.REGISTER_REST_CLIENT}) != null);
    }

    private boolean neitherAbstractNorSynthetic(ClassInfo clazz) {
        return !Modifier.isAbstract(clazz.flags()) && !clazz.isSynthetic();
    }
}

