/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EnabledOpenTelemetryInfo
implements OpenTelemetryInfoInternal {
    private static final TraceComponent tc = Tr.register(EnabledOpenTelemetryInfo.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final String INSTRUMENTATION_NAME = "io.openliberty.microprofile.telemetry";
    private final boolean enabled;
    private final OpenTelemetry openTelemetry;
    static final long serialVersionUID = -6430526469076220597L;

    public EnabledOpenTelemetryInfo(boolean enabled, OpenTelemetry openTelemetry, String appName) {
        this.enabled = enabled;
        this.openTelemetry = openTelemetry;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dispose() {
        try {
            if (AgentDetection.isAgentActive()) {
                return;
            }
            if (this.openTelemetry instanceof OpenTelemetrySdk) {
                SdkLoggerProvider loggerProvider;
                SdkMeterProvider meterProvider;
                OpenTelemetrySdk sdk = (OpenTelemetrySdk)this.openTelemetry;
                ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
                SdkTracerProvider tracerProvider = sdk.getSdkTracerProvider();
                if (tracerProvider != null) {
                    results.add(tracerProvider.shutdown());
                }
                if ((meterProvider = sdk.getSdkMeterProvider()) != null) {
                    results.add(meterProvider.shutdown());
                }
                if ((loggerProvider = sdk.getSdkLoggerProvider()) != null) {
                    results.add(loggerProvider.shutdown());
                }
                CompletableResultCode.ofAll(results).join(10L, TimeUnit.SECONDS);
            }
        }
        catch (Exception sdk) {
            void e;
            FFDCFilter.processException((Throwable)sdk, (String)"io.openliberty.microprofile.telemetry.internal.common.info.EnabledOpenTelemetryInfo", (String)"100", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
        }
    }
}

