/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.interfaces;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryLifecycleManager;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenTelemetryAccessor {
    private static final TraceComponent tc = Tr.register(OpenTelemetryAccessor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final ServiceCaller<OpenTelemetryLifecycleManager> openTelemetryLifecycleManagerService = new ServiceCaller(OpenTelemetryAccessor.class, OpenTelemetryLifecycleManager.class);
    private static final ServiceCaller<CDIService> cdiService = new ServiceCaller(OpenTelemetryAccessor.class, CDIService.class);
    static final long serialVersionUID = 1216853547996868937L;

    public static OpenTelemetryInfoInternal getOpenTelemetryInfo() {
        Optional openTelemetryInfo = openTelemetryLifecycleManagerService.run(lifecycle -> lifecycle.getOpenTelemetryInfo());
        return openTelemetryInfo.orElseGet(ErrorOpenTelemetryInfo::getInstance);
    }

    public static Tracer getTracer() {
        return OpenTelemetryAccessor.getOpenTelemetryInfo().getOpenTelemetry().getTracer("io.openliberty.microprofile.telemetry");
    }

    public static Span getSpan() {
        return Span.current();
    }

    public static Baggage getBaggage() {
        return Baggage.current();
    }

    public static Set<Annotation> getInterceptorBindingsFromInvocationContext(InvocationContext context) {
        Optional bindings = cdiService.run(service -> service.getInterceptorBindingsFromInvocationContext(context));
        return (Set)bindings.orElseThrow(() -> new IllegalStateException("Unable to get CDIService"));
    }

    public static boolean isRuntimeEnabled() {
        Optional isRuntimeEnabled = openTelemetryLifecycleManagerService.run(lifecycle -> lifecycle.isRuntimeEnabled());
        return isRuntimeEnabled.orElse(false);
    }
}

