/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jfap.inbound.channel.NettyInboundChain;
import com.ibm.ws.sib.comms.server.GenericTransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.IOReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.NettyConnectionReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.server.impl.InboundConnection;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.openliberty.netty.internal.exception.NettyException;
import java.util.Map;

public class NettyJMSServerHandler
extends SimpleChannelInboundHandler<WsByteBuffer> {
    private static final TraceComponent tc = SibTr.register(NettyJMSServerHandler.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final AttributeKey<String> CHAIN_ATTR_KEY;
    public static final AttributeKey<NettyInboundChain> ATTR_KEY;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InboundConnection connection;
        GenericTransportAcceptListener acceptListener;
        block20: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object)ctx.channel());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object)(ctx.channel().remoteAddress() + " connected for chain " + (String)ctx.channel().attr(CHAIN_ATTR_KEY).get() + " running: " + ((NettyInboundChain)ctx.channel().attr(ATTR_KEY).get()).isRunning()));
            }
            acceptListener = new GenericTransportAcceptListener();
            int heartbeatInterval = this.determineHeartbeatInterval(null);
            int heartbeatTimeout = this.determineHeartbeatTimeout(null);
            NettyNetworkConnection conn = new NettyNetworkConnection(ctx.channel(), (String)ctx.channel().attr(CHAIN_ATTR_KEY).get(), true);
            connection = null;
            try {
                connection = new InboundConnection((NetworkConnectionContext)new NettyNetworkConnectionContext(conn), (NetworkConnection)conn, acceptListener, heartbeatInterval, heartbeatTimeout, true);
            }
            catch (FrameworkException fe) {
                FFDCFilter.processException((Throwable)fe, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090004");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Exception occurred creating InboundConnection. Closing channel.");
                }
                ctx.close();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block20;
                SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)((Object)fe));
            }
        }
        if (connection != null) {
            ConversationReceiveListener rl;
            ConversationImpl conversation;
            block21: {
                ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION).set((Object)connection);
                conversation = new ConversationImpl(1, true, (Connection)connection, null);
                rl = null;
                try {
                    rl = acceptListener.acceptConnection((Conversation)conversation);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090001");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Exception occurred in acceptConnection callback");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block21;
                    SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Throwable)t);
                }
            }
            if (rl == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Null receive listener, closing conversation");
                }
                conversation.setDefaultReceiveListener((ConversationReceiveListener)new CloseConversationReceiveListener());
                try {
                    conversation = connection.startNewConversation(conversation);
                    conversation.close();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.JFapInboundConnLink", (String)"00090002");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)((Object)e));
                    }
                    connection.invalidate(true, e, "SIConnectionLostException thrown during conversation close");
                }
            } else {
                conversation.setDefaultReceiveListener(rl);
                try {
                    connection.startNewConversation(conversation);
                }
                catch (SIResourceException e) {
                    try {
                        conversation.close();
                    }
                    catch (SIConnectionLostException sIConnectionLostException) {
                        // empty catch block
                    }
                    connection.invalidate(true, e, "Resource exception thrown when starting new conversation");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object)ctx.channel());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void channelRead0(ChannelHandlerContext ctx, WsByteBuffer msg) throws Exception {
        block8: {
            Attribute attr;
            Connection connection;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object)ctx.channel());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object)(ctx.channel() + ". [" + msg.array() + "] bytes received"));
            }
            if ((connection = (Connection)(attr = ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION)).get()) != null) {
                IOReadCompletedCallback callback = connection.getReadCompletedCallback();
                IOReadRequestContext readCtx = connection.getReadRequestContext();
                NetworkConnection networkConnection = connection.getNetworkConnection();
                if (callback instanceof NettyConnectionReadCompletedCallback && readCtx instanceof NettyIOReadRequestContext && networkConnection instanceof NettyNetworkConnection) {
                    ((NettyConnectionReadCompletedCallback)callback).readCompleted(msg, readCtx, (NettyNetworkConnection)networkConnection);
                    break block8;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                        SibTr.warning((TraceComponent)tc, (String)"channelRead0: Something's wrong. Callback, network connection, or read context is not netty specific. This shouldn't happen.", (Object)new Object[]{connection, callback, readCtx, networkConnection});
                    }
                    this.exceptionCaught(ctx, (Throwable)new NettyException("Illegal callback type for channel."));
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                SibTr.warning((TraceComponent)tc, (String)"channelRead0: could not associate an incoming message with a Connection. Message will be ignored and channel will be closed.", (Object)new Object[]{ctx.channel()});
                ctx.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object)ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object)ctx.channel());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object)(ctx.channel().remoteAddress() + " has been disconnected"));
        }
        Connection conn = (Connection)ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION).get();
        ctx.channel().attr(NettyNetworkConnectionFactory.CONNECTION).set(null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object)ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)ctx.channel());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)cause);
        }
        ctx.close();
        super.exceptionCaught(ctx, cause);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object)ctx.channel());
        }
    }

    private int determineHeartbeatInterval(Map properties) {
        String intervalStr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatInterval", (Object)properties);
        }
        int heartbeatInterval = 300;
        try {
            heartbeatInterval = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL", (String)("" + heartbeatInterval)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (properties != null && (intervalStr = (String)properties.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL_PROPERTY")) != null) {
            try {
                heartbeatInterval = Integer.parseInt(intervalStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatInterval", (Object)heartbeatInterval);
        }
        return heartbeatInterval;
    }

    private int determineHeartbeatTimeout(Map properties) {
        String timeoutStr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatTimeout", (Object)properties);
        }
        int heartbeatTimeout = 7;
        try {
            heartbeatTimeout = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT", (String)("" + heartbeatTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (properties != null && (timeoutStr = (String)properties.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT_PROPERTY")) != null) {
            try {
                heartbeatTimeout = Integer.parseInt(timeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"determineHeartbeatTimeout", (Object)heartbeatTimeout);
        }
        return heartbeatTimeout;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/server/impl/NettyJMSServerHandler.java, SIB.comms, WASX.SIB, uu1215.01 1.1");
        }
        CHAIN_ATTR_KEY = AttributeKey.valueOf((String)"CHAIN_NAME");
        ATTR_KEY = AttributeKey.valueOf((String)"CHAIN");
    }

    private static class CloseConversationReceiveListener
    implements ConversationReceiveListener {
        private CloseConversationReceiveListener() {
        }

        public ConversationReceiveListener dataReceived(WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.dataReceived");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.dataReceived");
            }
            return null;
        }

        public void errorOccurred(SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.errorOccurred");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)exception));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.errorOccurred");
            }
        }

        public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer data, int segmentType) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.getThreadContext");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"CloseConversationReceiveListener.getThreadContext");
            }
            return null;
        }
    }
}

