/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.config.DefaultConfigurationProvider;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.LeaseTimeoutManager;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.util.TranLogConfiguration;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.resource.ResourceFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class TxRecoveryAgentImpl
implements RecoveryAgent {
    private static final TraceComponent tc = Tr.register(TxRecoveryAgentImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int transactionLogRLI = 1;
    private static final int partnerLogRLI = 2;
    private static final int TRANSACTION_RECOVERYLOG_FORMAT_VERSION = 1;
    protected RecoveryDirector _recoveryDirector;
    private RecoveryManager _recoveryManager;
    protected final HashMap<String, FailureScopeController> failureScopeControllerTable = new HashMap();
    private RecoveryLog _homePartnerLog;
    SharedServerLeaseLog _leaseLog;
    private String _recoveryGroup;
    private boolean _isPeerRecoverySupported;
    protected String localRecoveryIdentity;
    private ClassLoadingService clService;
    private volatile boolean _serverStopping;
    private static ThreadLocal<Boolean> _replayThread = new ThreadLocal();

    protected TxRecoveryAgentImpl() {
    }

    public TxRecoveryAgentImpl(RecoveryDirector rd) throws Exception {
        this._recoveryDirector = rd;
        RecoveryLogManager rlm = rd.registerService((RecoveryAgent)this, 2);
        Configuration.setLogManager(rlm);
        FailureScope currentFailureScope = rd.currentFailureScope();
        Configuration.setServerName(currentFailureScope.serverName());
        this.localRecoveryIdentity = currentFailureScope.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"TxRecoveryAgentImpl constructor - localRecoveryIdentity set to ", (Object[])new Object[]{this.localRecoveryIdentity});
        }
        FailureScopeController fsc = this.createFailureScopeController(currentFailureScope);
        this.failureScopeControllerTable.put(currentFailureScope.serverName(), fsc);
        Configuration.setFailureScopeController(fsc);
        byte[] newApplId = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        _replayThread.set(false);
        byte[] applId = cp.getApplId();
        if (applId == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"TXAGENT, cp applid null - {0} set applid - {1}", (Object[])new Object[]{cp, Util.toHexString(newApplId)});
            }
            cp.setApplId(newApplId);
            Configuration.setApplId(newApplId);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"TXAGENT, do not reset cp - {0} set applid - {1}", (Object[])new Object[]{cp, Util.toHexString(applId)});
            }
            Configuration.setApplId(applId);
        }
    }

    public void agentReportedFailure(int clientId, FailureScope failureScope) {
    }

    public int clientIdentifier() {
        return 1;
    }

    public String clientName() {
        return "transaction";
    }

    public int clientVersion() {
        return 1;
    }

    public boolean disableFileLocking() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initiateRecovery(FailureScope fs) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initiateRecovery", (Object[])new Object[]{this, fs});
        }
        String recoveredServerIdentity = fs.serverName();
        FailureScopeController fsc = null;
        ConfigurationProvider cp = null;
        RecoveryLog transactionLog = null;
        RecoveryLog partnerLog = null;
        boolean localRecovery = recoveredServerIdentity.equals(this.localRecoveryIdentity);
        try {
            TranLogConfiguration tlc;
            TxRecoveryAgentImpl txRecoveryAgentImpl;
            block60: {
                block59: {
                    txRecoveryAgentImpl = this;
                    // MONITORENTER : txRecoveryAgentImpl
                    if (!localRecovery) {
                        if (this._serverStopping) {
                            if (!tc.isEntryEnabled()) throw new RecoveryFailedException("server stopping");
                            Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"server stopping");
                            throw new RecoveryFailedException("server stopping");
                        }
                        Tr.audit((TraceComponent)tc, (String)"WTRN0108I: Recovery initiated for server {0}", (Object[])new Object[]{recoveredServerIdentity});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Recovery initiated for server {0}", (Object[])new Object[]{recoveredServerIdentity});
                    }
                    boolean isCustom = false;
                    cp = ConfigurationProviderManager.getConfigurationProvider();
                    if (cp == null) {
                        if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                        throw new RecoveryFailedException("ConfigurationProvider is null");
                    }
                    String logDir = cp.getTransactionLogDirectory();
                    int logSize = cp.getTransactionLogSize();
                    if (logDir.startsWith("custom")) {
                        isCustom = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found a custom tran log directory", (Object[])new Object[0]);
                        }
                    }
                    tlc = null;
                    tlc = isCustom ? this.createCustomTranLogConfiguration(recoveredServerIdentity, logDir, this._isPeerRecoverySupported) : this.createFileTranLogConfiguration(recoveredServerIdentity, fs, logDir, logSize, this._isPeerRecoverySupported);
                    fsc = this.failureScopeControllerTable.get(recoveredServerIdentity);
                    if (fsc == null) break block59;
                    if (fsc.getRecoveryManager() != null) {
                        if (!this._isPeerRecoverySupported) {
                            if (!tc.isEntryEnabled()) throw new RecoveryFailedException("Already recovering failure scope " + fs);
                            Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)("already recovering failure scope " + fs));
                            throw new RecoveryFailedException("Already recovering failure scope " + fs);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Where peer recovery is supported, a pre-existing RM is ok", (Object[])new Object[0]);
                        }
                    }
                    break block60;
                }
                try {
                    fsc = this.createFailureScopeController(fs);
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.TxRecoveryAgentImpl.initiateRecovery", (String)"259", (Object)this);
                    if (!tc.isDebugEnabled()) throw new RecoveryFailedException((Throwable)exc);
                    Tr.debug((TraceComponent)tc, (String)"Exception caught whist creating FailureScopeController", (Object[])new Object[]{exc});
                    throw new RecoveryFailedException((Throwable)exc);
                }
                this.failureScopeControllerTable.put(recoveredServerIdentity, fsc);
            }
            if ((cp = ConfigurationProviderManager.getConfigurationProvider()) == null) {
                if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                throw new RecoveryFailedException("ConfigurationProvider is null");
            }
            byte[] applId = cp.getApplId();
            int epoch = Configuration.getCurrentEpoch();
            if (tlc != null && tlc.enabled()) {
                CustomLogProperties partnerLogProps;
                CustomLogProperties transactionLogProps;
                if (tlc.type() == 3) {
                    transactionLogProps = new CustomLogProperties(1, "tranlog", tlc.customId(), tlc.customProperties());
                    partnerLogProps = new CustomLogProperties(2, "partnerlog", tlc.customId(), tlc.customProperties());
                    cp = ConfigurationProviderManager.getConfigurationProvider();
                    if (cp == null) {
                        if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                        throw new RecoveryFailedException("ConfigurationProvider is null");
                    }
                    ResourceFactory nontranDSResourceFactory = cp.getResourceFactory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Retrieved non tran DS Resource Factory, ", (Object[])new Object[]{nontranDSResourceFactory});
                    }
                    transactionLogProps.setResourceFactory(nontranDSResourceFactory);
                    partnerLogProps.setResourceFactory(nontranDSResourceFactory);
                } else {
                    String recLogDirStem = tlc.expandedLogDirectory().trim();
                    Path tranLogDirToUse = Paths.get(recLogDirStem, "tranlog");
                    transactionLogProps = new FileLogProperties(1, "tranlog", tranLogDirToUse, tlc.logFileSize(), recLogDirStem);
                    Path partnerLogDirToUse = Paths.get(recLogDirStem, "partnerlog");
                    partnerLogProps = new FileLogProperties(2, "partnerlog", partnerLogDirToUse, tlc.logFileSize());
                }
                RecoveryLogManager rlm = Configuration.getLogManager();
                transactionLog = rlm.getRecoveryLog(fs, (LogProperties)transactionLogProps);
                partnerLog = rlm.getRecoveryLog(fs, (LogProperties)partnerLogProps);
                if (localRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set the home partnerLog to " + partnerLog), (Object[])new Object[0]);
                    }
                    this._homePartnerLog = partnerLog;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Test to see if peer recovery is supported - {0}", (Object[])new Object[]{this._isPeerRecoverySupported});
                }
                if ((cp = ConfigurationProviderManager.getConfigurationProvider()) == null) {
                    if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                    throw new RecoveryFailedException("ConfigurationProvider is null");
                }
                if (this._isPeerRecoverySupported) {
                    this._leaseLog = rlm.getLeaseLog(this.localRecoveryIdentity, this._recoveryGroup, cp.getLeaseCheckInterval(), cp.getLeaseCheckStrategy(), cp.getLeaseLength(), (LogProperties)transactionLogProps);
                }
            }
            if (fsc != null) {
                fsc.createRecoveryManager(this, transactionLog, partnerLog, null, applId, epoch);
                this._recoveryManager = fsc.getRecoveryManager();
            }
            if (localRecovery && this._isPeerRecoverySupported && this._leaseLog == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Cannot lock server's own logs", (Object[])new Object[0]);
                }
                Object[] errorObject = new Object[]{this.localRecoveryIdentity};
                RecoveryFailedException rex = new RecoveryFailedException("Cannot lock server's own logs");
                Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object[])errorObject);
                Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object[])new Object[]{rex});
                this._recoveryManager.recoveryFailed(rex);
                if (!this.doNotShutdownOnRecoveryFailure()) {
                    cp = ConfigurationProviderManager.getConfigurationProvider();
                    if (cp == null) {
                        if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                        throw new RecoveryFailedException("ConfigurationProvider is null");
                    }
                    cp.shutDownFramework();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                }
                Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{rex});
                throw rex;
            }
            this._recoveryManager.configurePeerRecovery(this._leaseLog, this._recoveryGroup, this.localRecoveryIdentity);
            // MONITOREXIT : txRecoveryAgentImpl
            txRecoveryAgentImpl = this;
            // MONITORENTER : txRecoveryAgentImpl
            if (!localRecovery && this._serverStopping) {
                if (!tc.isEntryEnabled()) throw new RecoveryFailedException("server stopping");
                Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"server stopping");
                throw new RecoveryFailedException("server stopping");
            }
            final Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return new Thread((Runnable)TxRecoveryAgentImpl.this._recoveryManager, "Recovery Thread");
                }
            });
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RecoveryFailedException {
                    ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
                    if (cp == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"initiateRecovery.run", (Object)"ConfigurationProvider is null");
                        }
                        throw new RecoveryFailedException("ConfigurationProvider is null");
                    }
                    if (!cp.getClass().getCanonicalName().equals(DefaultConfigurationProvider.class.getCanonicalName())) {
                        ClassLoader cl = TxRecoveryAgentImpl.this.getThreadContextClassLoader(TxRecoveryAgentImpl.class);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Setting Context ClassLoader on " + t.getName() + " (" + String.format("%08X", t.getId()) + ")"), (Object[])new Object[]{cl});
                        }
                        t.setContextClassLoader(cl);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("unit testing so not setting Context ClassLoader on " + t.getName() + " (" + String.format("%08X", t.getId()) + ")"), (Object[])new Object[0]);
                    }
                    return null;
                }
            });
            t.start();
            this._recoveryDirector.serialRecoveryComplete((RecoveryAgent)this, fs);
            // MONITOREXIT : txRecoveryAgentImpl
            if (!localRecovery && this._serverStopping) {
                if (!tc.isEntryEnabled()) throw new RecoveryFailedException("server stopping");
                Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"server stopping");
                throw new RecoveryFailedException("server stopping");
            }
            if (fsc != null) {
                fsc.getRecoveryManager().waitForReplayCompletion(localRecovery);
            }
            boolean recoveryFailed = false;
            if (fsc != null) {
                recoveryFailed = fsc.getRecoveryManager().recoveryFailed();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Replay completed but did recovery fail -  " + recoveryFailed), (Object[])new Object[0]);
            }
            if (!localRecovery) {
                if (this._serverStopping) {
                    if (!tc.isEntryEnabled()) throw new RecoveryFailedException("server stopping");
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"server stopping");
                    throw new RecoveryFailedException("server stopping");
                }
                if (fsc != null && fsc.getRecoveryManager() != null) {
                    fsc.getRecoveryManager().waitForRecoveryCompletion(localRecovery);
                }
            }
            TxRecoveryAgentImpl txRecoveryAgentImpl2 = this;
            // MONITORENTER : txRecoveryAgentImpl2
            if (!localRecovery && this._serverStopping) {
                if (!tc.isEntryEnabled()) throw new RecoveryFailedException("server stopping");
                Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"server stopping");
                throw new RecoveryFailedException("server stopping");
            }
            if (this._leaseLog != null) {
                RecoveryManager rm;
                if (fsc != null && (rm = fsc.getRecoveryManager()) != null && rm.recoveryFailed() && localRecovery) {
                    if (!this.doNotShutdownOnRecoveryFailure()) {
                        cp = ConfigurationProviderManager.getConfigurationProvider();
                        if (cp == null) {
                            if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                            Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                            throw new RecoveryFailedException("ConfigurationProvider is null");
                        }
                        cp.shutDownFramework();
                    }
                    RecoveryFailedException rex = new RecoveryFailedException("Home server recovery failed in peer environment");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                    }
                    Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{rex.toString()});
                    throw rex;
                }
                if (localRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Local server recovery identity so spawn lease timeout manager", (Object[])new Object[0]);
                    }
                    if ((cp = ConfigurationProviderManager.getConfigurationProvider()) == null) {
                        if (!tc.isEntryEnabled()) throw new RecoveryFailedException("ConfigurationProvider is null");
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)"ConfigurationProvider is null");
                        throw new RecoveryFailedException("ConfigurationProvider is null");
                    }
                    LeaseTimeoutManager.setTimeouts(this._leaseLog, recoveredServerIdentity, this._recoveryGroup, this, this._recoveryDirector, cp.getLeaseLength() * cp.getLeaseRenewalThreshold() / 100, cp.getLeaseCheckInterval());
                }
            } else if (fsc != null && fsc.getRecoveryManager().recoveryFailed()) {
                RecoveryFailedException rex = new RecoveryFailedException("Server recovery failed");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                }
                Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{rex.toString()});
                throw rex;
            }
            // MONITOREXIT : txRecoveryAgentImpl2
        }
        catch (InvalidFailureScopeException | InvalidLogPropertiesException | URISyntaxException | PrivilegedActionException e) {
            if (!this._serverStopping) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.TxRecoveryAgentImpl.initiateRecovery", (String)"586", (Object)this);
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
            if (!tc.isEntryEnabled()) throw new RecoveryFailedException(e);
            Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)e);
            throw new RecoveryFailedException(e);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"initiateRecovery");
    }

    private ClassLoader getThreadContextClassLoader(Class<? extends TxRecoveryAgentImpl> cl) throws RecoveryFailedException {
        return this.getClassLoadingService().createThreadContextClassLoader(cl.getClassLoader());
    }

    public synchronized ClassLoadingService getClassLoadingService() throws RecoveryFailedException {
        if (this.clService == null) {
            this.clService = this.getService(ClassLoadingService.class);
        }
        return this.clService;
    }

    private <T> T getService(Class<T> service) throws RecoveryFailedException {
        Object impl = null;
        BundleContext context = FrameworkUtil.getBundle(service).getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        if (ref == null) {
            throw new RecoveryFailedException("Unable to locate service: " + service);
        }
        impl = context.getService(ref);
        return (T)impl;
    }

    public void terminateRecovery(FailureScope fs) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminateRecovery", (Object[])new Object[]{fs});
        }
        String terminateServerName = fs.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The transaction service has received a request to terminate recovery processing for server " + terminateServerName), (Object[])new Object[0]);
        }
        RecoveryDirector recoveryDirector = null;
        try {
            recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.TxRecoveryAgentImpl.terminateRecovery", (String)"650", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException((Throwable)exc);
        }
        boolean terminatingThisServer = terminateServerName.equals(Configuration.getServerName());
        if (terminatingThisServer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected request to terminate recovery processing for local failure scope", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException();
        }
        FailureScopeController fsc = this.failureScopeControllerTable.remove(terminateServerName);
        if (fsc != null) {
            fsc.shutdown(false);
        }
        try {
            recoveryDirector.terminationComplete((RecoveryAgent)this, fs);
        }
        catch (InvalidFailureScopeException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.TxRecoveryAgentImpl.terminateRecovery", (String)"683", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to indicate termination completion to recovery director: " + (Object)((Object)exc)), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
        }
    }

    public synchronized void stop(boolean immediate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object[])new Object[]{this, immediate});
        }
        this._serverStopping = true;
        LeaseTimeoutManager.stopTimeout();
        if (this._homePartnerLog != null && this._homePartnerLog instanceof HeartbeatLog) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The log is a Heartbeatlog", (Object[])new Object[0]);
            }
            HeartbeatLog heartbeatLog = (HeartbeatLog)this._homePartnerLog;
            heartbeatLog.serverStopping();
        }
        Collection<FailureScopeController> failureScopeControllerTableValues = this.failureScopeControllerTable.values();
        for (FailureScopeController fsc : failureScopeControllerTableValues) {
            fsc.shutdown(immediate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void logFileWarning(String logname, int bytesInUse, int bytesTotal) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logFileWarning", (Object[])new Object[]{logname, bytesInUse, bytesTotal});
        }
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setRecoveryGroup", (Object[])new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
    }

    public String getRecoveryGroup() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryGroup", (Object[])new Object[]{this._recoveryGroup});
        }
        return this._recoveryGroup;
    }

    public void setPeerRecoverySupported(boolean isPeerRecoverySupported) {
        this._isPeerRecoverySupported = isPeerRecoverySupported;
    }

    public ArrayList<String> processLeasesForPeers(String recoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLeasesForPeers", (Object[])new Object[]{this, recoveryIdentity, recoveryGroup});
        }
        ArrayList peersToRecover = null;
        if (this._leaseLog != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"work with leaseLog {0}", (Object[])new Object[]{this._leaseLog});
            }
            try {
                PeerLeaseTable peerLeaseTable = new PeerLeaseTable();
                this._leaseLog.getLeasesForPeers(peerLeaseTable, recoveryGroup);
                peersToRecover = peerLeaseTable.getExpiredPeers();
                if (tc.isDebugEnabled()) {
                    if (peersToRecover != null && !peersToRecover.isEmpty()) {
                        Tr.debug((TraceComponent)tc, (String)("Have checked leases for " + peerLeaseTable.size() + " peer" + (peerLeaseTable.size() != 1 ? "s" : "") + " in recovery group " + recoveryGroup), (Object[])new Object[0]);
                        if (peersToRecover.size() > 0) {
                            for (String peer : peersToRecover) {
                                Tr.debug((TraceComponent)tc, (String)("Need to recover: " + peer), (Object[])new Object[0]);
                            }
                        }
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"No peer servers will be recovered", (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Caught exception when trying to get leases for peers: " + e);
                e.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLeasesForPeers", peersToRecover);
        }
        return peersToRecover;
    }

    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        boolean peerClaimed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, this});
        }
        if (!(peerClaimed = this._leaseLog.claimPeerLeaseForRecovery(recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo))) {
            try {
                this._leaseLog.releasePeerLease(recoveryIdentityToRecover);
            }
            catch (Exception e) {
                RecoveryFailedException rfex = new RecoveryFailedException((Throwable)e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)((Object)rfex));
                }
                throw rfex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)peerClaimed);
        }
        return peerClaimed;
    }

    public void releasePeerLeaseForRecovery(String recoveryIdentityToRecover) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releasePeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, this});
        }
        try {
            this._leaseLog.releasePeerLease(recoveryIdentityToRecover);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releasePeerLeaseForRecovery", (Object)e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releasePeerLeaseForRecovery");
        }
    }

    private TranLogConfiguration createCustomTranLogConfiguration(String recoveredServerIdentity, String logDir, boolean isPeerRecoverySupported) throws URISyntaxException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCustomTranLogConfiguration", (Object[])new Object[]{recoveredServerIdentity, logDir, this});
        }
        TranLogConfiguration tlc = null;
        Properties props = new Properties();
        URI logSettingURI = new URI(logDir);
        String scheme = logSettingURI.getScheme();
        String logSetting = logSettingURI.getAuthority();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Scheme read from URI {0}, log setting {1}", (Object[])new Object[]{scheme, logSetting});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Test to see if peer recovery is supported - {0}", (Object[])new Object[]{isPeerRecoverySupported});
        }
        if (isPeerRecoverySupported) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Work with server recovery identity - {0}, reset current logdir", (Object[])new Object[]{recoveredServerIdentity});
            }
            if (recoveredServerIdentity != null) {
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty,tablesuffix=" + recoveredServerIdentity;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"log dir is now - {0}", (Object[])new Object[]{logDir});
                }
            }
        }
        props.setProperty("LOG_DIRECTORY", logDir);
        tlc = new TranLogConfiguration(logSetting, props);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCustomTranLogConfiguration", (Object)tlc);
        }
        return tlc;
    }

    private TranLogConfiguration createFileTranLogConfiguration(String recoveredServerIdentity, FailureScope fs, String logDir, int logSize, boolean isPeerRecoverySupported) throws URISyntaxException, RecoveryFailedException {
        FileFailureScope ffs;
        LeaseInfo li;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFileTranLogConfiguration", (Object[])new Object[]{recoveredServerIdentity, fs, logDir, logSize, this});
        }
        TranLogConfiguration tlc = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Work with server recovery identity - {0}", (Object[])new Object[]{recoveredServerIdentity});
        }
        if (recoveredServerIdentity.equals(this.localRecoveryIdentity)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Local server recovery identity so no need to reset the logDir", (Object[])new Object[0]);
            }
            tlc = new TranLogConfiguration(logDir, logDir, logSize);
        } else if (fs instanceof FileFailureScope && (li = (ffs = (FileFailureScope)fs).getLeaseInfo()) != null) {
            String s = li.getLeaseDetail().getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using log directory", (Object[])new Object[]{s});
            }
            tlc = new TranLogConfiguration(s, s, logSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFileTranLogConfiguration", (Object)tlc);
        }
        return tlc;
    }

    private boolean doNotShutdownOnRecoveryFailure() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doNotShutdownOnRecoveryFailure", (Object[])new Object[0]);
        }
        boolean doCheck = true;
        Boolean doNotShutdownOnRecoveryFailure = null;
        try {
            doNotShutdownOnRecoveryFailure = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    Boolean theResult = Boolean.getBoolean("com.ibm.ws.recoverylog.spi.DoNotShutdownOnRecoveryFailure");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Have retrieved jvm property with result, {0}", (Object[])new Object[]{(boolean)theResult});
                    }
                    return theResult;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting DoNotShutdownOnRecoveryFailure property", (Object[])new Object[]{e});
            }
            doNotShutdownOnRecoveryFailure = null;
        }
        if (doNotShutdownOnRecoveryFailure == null) {
            doNotShutdownOnRecoveryFailure = Boolean.TRUE;
        }
        doCheck = doNotShutdownOnRecoveryFailure;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doNotShutdownOnRecoveryFailure", (Object)doCheck);
        }
        return doCheck;
    }

    protected FailureScopeController createFailureScopeController(FailureScope currentFailureScope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFailureScopeController", (Object[])new Object[]{currentFailureScope});
        }
        FailureScopeController fsc = new FailureScopeController(currentFailureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFailureScopeController", (Object)fsc);
        }
        return fsc;
    }

    public HeartbeatLog getHeartbeatLog(FailureScope fs) {
        HeartbeatLog heartbeatLog;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getHeartbeatLog", (Object[])new Object[]{this, fs});
            }
            RecoveryLog partnerLog = null;
            heartbeatLog = null;
            String recoveredServerIdentity = null;
            ConfigurationProvider cp = null;
            recoveredServerIdentity = fs.serverName();
            boolean localRecovery = recoveredServerIdentity.equals(this.localRecoveryIdentity);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getHeartbeatLog for server - {0}", (Object[])new Object[]{recoveredServerIdentity});
                }
                cp = ConfigurationProviderManager.getConfigurationProvider();
                if (!localRecovery && this._serverStopping) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getHeartbeatLog", (Object)"server stopping");
                    }
                    throw new RecoveryFailedException("server stopping");
                }
                if (cp == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getHeartbeatLog", (Object)"ConfigurationProvider is null");
                    }
                    throw new RecoveryFailedException("ConfigurationProvider is null");
                }
                boolean isCustom = false;
                String logDir = cp.getTransactionLogDirectory();
                if (logDir.startsWith("custom")) {
                    isCustom = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found a custom tran log directory", (Object[])new Object[0]);
                    }
                }
                TranLogConfiguration tlc = null;
                if (isCustom && (tlc = this.createCustomTranLogConfiguration(recoveredServerIdentity, logDir, this._isPeerRecoverySupported)) != null && tlc.enabled() && tlc.type() == 3) {
                    CustomLogProperties partnerLogProps = new CustomLogProperties(2, "partnerlog", tlc.customId(), tlc.customProperties());
                    ResourceFactory nontranDSResourceFactory = cp.getResourceFactory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Retrieved non tran DS Resource Factory {0}", (Object[])new Object[]{nontranDSResourceFactory});
                    }
                    partnerLogProps.setResourceFactory(nontranDSResourceFactory);
                    RecoveryLogManager rlm = Configuration.getLogManager();
                    partnerLog = rlm.getRecoveryLog(fs, (LogProperties)partnerLogProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Custom PartnerLog is set - {0}", (Object[])new Object[]{partnerLog});
                    }
                    if (partnerLog instanceof HeartbeatLog) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The log is a Heartbeatlog", (Object[])new Object[0]);
                        }
                        heartbeatLog = (HeartbeatLog)partnerLog;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block16;
                Tr.exit((TraceComponent)tc, (String)"getHeartbeatLog", (Object)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHeartbeatLog", heartbeatLog);
        }
        return heartbeatLog;
    }

    @Trivial
    public boolean isLogLockingEnabled() {
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        boolean enableLocking = cp.enableLogLocking();
        return enableLocking;
    }

    public boolean isSQLRecoveryLog() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSQLRecoveryLog", (Object[])new Object[0]);
        }
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        boolean isSQLLog = cp.isSQLRecoveryLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSQLRecoveryLog", (Object)isSQLLog);
        }
        return isSQLLog;
    }

    public RecoveryManager getRecoveryManager() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryManager", (Object[])new Object[]{this._recoveryManager});
        }
        return this._recoveryManager;
    }

    public boolean isReplayThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isReplayThread", (Object[])new Object[0]);
        }
        boolean isReplayThread = false;
        if (_replayThread.get() != null) {
            isReplayThread = _replayThread.get();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isReplayThread", (Object)isReplayThread);
        }
        return isReplayThread;
    }

    public void setReplayThread() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReplayThread", (Object[])new Object[0]);
        }
        _replayThread.set(Boolean.TRUE);
    }

    public void terminateServer() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"terminateServer", (Object[])new Object[0]);
        }
        ConfigurationProviderManager.getConfigurationProvider().shutDownFramework();
    }

    public boolean isServerStopping() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isServerStopping", (Object[])new Object[]{this._serverStopping});
        }
        return this._serverStopping;
    }

    public void deleteServerLease(String recoveryIdentity, boolean isPeerServer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteServerLease", (Object[])new Object[]{this, recoveryIdentity, isPeerServer});
        }
        if (this._recoveryManager != null) {
            this._recoveryManager.deleteServerLease(recoveryIdentity, isPeerServer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerLease");
        }
    }
}

