/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.csiv2.config.CompatibleMechanisms;
import com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechListConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CSSCompoundSecMechListConfig
implements Serializable {
    private static TraceComponent tc = Tr.register(CSSCompoundSecMechListConfig.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private boolean stateful;
    private final ArrayList<CSSCompoundSecMechConfig> mechs = new ArrayList();
    private static final String spaces = "  ";
    static final long serialVersionUID = -8733071167470314010L;

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public void add(CSSCompoundSecMechConfig mech) {
        this.mechs.add(mech);
    }

    public CSSCompoundSecMechConfig mechAt(int i) {
        return this.mechs.get(i);
    }

    public int size() {
        return this.mechs.size();
    }

    public LinkedList<CompatibleMechanisms> findCompatibleList(TSSCompoundSecMechListConfig mechList) {
        LinkedList<CompatibleMechanisms> compatibleMechanismsList = new LinkedList<CompatibleMechanisms>();
        StringBuilder cantHandleMsg = new StringBuilder();
        int size = mechList.size();
        for (int i = 0; i < size; ++i) {
            TSSCompoundSecMechConfig requirement = mechList.mechAt(i);
            for (CSSCompoundSecMechConfig aConfig : this.mechs) {
                if (aConfig.canHandle(requirement)) {
                    compatibleMechanismsList.add(new CompatibleMechanisms(aConfig, requirement));
                    continue;
                }
                this.buildCantHandleMsg(cantHandleMsg, aConfig);
            }
        }
        if (compatibleMechanismsList.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"CSIv2_CLIENT_COMPATIBLE_CHECK_FAILED", (Object[])new Object[]{cantHandleMsg.toString()});
        }
        return compatibleMechanismsList;
    }

    private void buildCantHandleMsg(StringBuilder cantHandleMsg, CSSCompoundSecMechConfig aConfig) {
        cantHandleMsg.append(spaces).append(spaces);
        cantHandleMsg.append(aConfig.getCantHandleMsg()).append("\n");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)aConfig.getCantHandleMsg(), (Object[])new Object[0]);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    void toString(String spaces, StringBuilder buf) {
        buf.append(spaces).append("CSSCompoundSecMechListConfig: [\n");
        for (CSSCompoundSecMechConfig aConfig : this.mechs) {
            aConfig.toString(spaces + spaces, buf);
            buf.append("\n");
        }
        buf.append(spaces).append("]\n");
    }
}

