/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.IOP;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.yoko.orb.IOP.MutableServiceContexts;
import org.apache.yoko.util.IntegerComparator;
import org.omg.IOP.ServiceContext;

public final class ServiceContexts
implements Iterable<ServiceContext> {
    private static final ServiceContext[] EMPTY_SERVICE_CONTEXT_ARRAY = new ServiceContext[0];
    public static final ServiceContexts EMPTY = ServiceContexts.unmodifiable(EMPTY_SERVICE_CONTEXT_ARRAY);
    private final MutableServiceContexts mutableContexts;
    private final Collection<ServiceContext> contexts;

    public ServiceContexts() {
        this(new TreeMap<Integer, ServiceContext>((Comparator<Integer>)IntegerComparator.UNSIGNED));
    }

    public ServiceContexts(Iterable<ServiceContext> contexts) {
        this();
        for (ServiceContext sc : contexts) {
            this.mutableContexts.add(sc);
        }
    }

    public static ServiceContexts unmodifiable(ServiceContext ... contexts) {
        return new ServiceContexts(Collections.unmodifiableMap(ServiceContexts.asMap(contexts)));
    }

    private static Map<Integer, ServiceContext> asMap(ServiceContext ... contexts) {
        TreeMap<Integer, ServiceContext> map = new TreeMap<Integer, ServiceContext>((Comparator<Integer>)IntegerComparator.UNSIGNED);
        for (ServiceContext context : contexts) {
            map.put(context.context_id, context);
        }
        return map;
    }

    private ServiceContexts(Map<Integer, ServiceContext> contexts) {
        this.mutableContexts = new MutableServiceContexts(contexts);
        this.contexts = Collections.unmodifiableCollection(contexts.values());
    }

    public int size() {
        return this.contexts.size();
    }

    @Override
    public Iterator<ServiceContext> iterator() {
        return this.contexts.iterator();
    }

    public boolean isEmpty() {
        return this.contexts.isEmpty();
    }

    public MutableServiceContexts mutable() {
        return this.mutableContexts;
    }

    public ServiceContext get(int id) {
        return this.mutableContexts.get(id);
    }

    public ServiceContext[] toArray() {
        return this.contexts.toArray(EMPTY_SERVICE_CONTEXT_ARRAY);
    }

    public String toString() {
        return "ServiceContexts" + this.contexts;
    }
}

