/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.PortableInterceptor.PolicyFactory;

public final class PolicyFactoryManager {
    private boolean destroy;
    Map<Integer, PolicyFactory> policyFactoryTableExternal = new HashMap<Integer, PolicyFactory>();
    Map<Integer, PolicyFactory> policyFactoryTableInternal = new HashMap<Integer, PolicyFactory>();

    void destroy() {
        Assert.ensure((!this.destroy ? 1 : 0) != 0);
        this.destroy = true;
        this.policyFactoryTableInternal.clear();
        this.policyFactoryTableExternal.clear();
    }

    public void registerPolicyFactory(int type, PolicyFactory factory, boolean internal) {
        Map<Integer, PolicyFactory> table;
        Map<Integer, PolicyFactory> map = table = internal ? this.policyFactoryTableInternal : this.policyFactoryTableExternal;
        if (table.containsKey(type)) {
            throw new BAD_PARAM();
        }
        table.put(type, factory);
    }

    public Policy createPolicy(int type, Any any) throws PolicyError {
        PolicyFactory factory = Stream.of(this.policyFactoryTableInternal, this.policyFactoryTableExternal).map(m -> (PolicyFactory)m.get(type)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new PolicyError(0));
        return factory.create_policy(type, any);
    }

    public boolean isPolicyRegistered(int type) {
        return this.policyFactoryTableInternal.containsKey(type) || this.policyFactoryTableExternal.containsKey(type);
    }
}

