/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Net;
import org.apache.yoko.orb.OCI.AccFactory;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.IIOP.AccFactoryInfo;
import org.apache.yoko.orb.OCI.IIOP.AccFactoryInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.Acceptor_impl;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.UnifiedConnectionHelper;
import org.apache.yoko.orb.OCI.InvalidParam;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.IORHolder;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;

final class AccFactory_impl
extends LocalObject
implements AccFactory {
    static final Logger logger = Logger.getLogger(AccFactory_impl.class.getName());
    private static final Encoding CDR_1_2_ENCODING = new Encoding(0, 1, 2);
    private final AccFactoryInfo_impl info_;
    private final ORB orb_;
    private final UnifiedConnectionHelper connectionHelper;
    private final ListenerMap listenMap_;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public AccFactoryInfo get_info() {
        return this.info_;
    }

    @Override
    public Acceptor create_acceptor(String[] params) throws InvalidParam {
        Codec codec;
        String bind = null;
        String[] hosts = null;
        boolean keepAlive = true;
        Acceptor_impl.ProfileCardinality numProfiles = Acceptor_impl.ProfileCardinality.ONE;
        int port = 0;
        int backlog = 0;
        boolean numeric = false;
        block29: for (int i = 0; i < params.length; ++i) {
            String option = params[i];
            try {
                switch (option) {
                    case "--backlog": {
                        String backlogArg = params[++i];
                        try {
                            backlog = Integer.parseInt(backlogArg);
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidParam("invalid argument for --backlog: " + backlogArg);
                        }
                        if (backlog >= 1 && backlog <= 65535) continue block29;
                        throw new InvalidParam("invalid backlog value: " + backlogArg);
                    }
                    case "--bind": {
                        bind = params[++i];
                        break;
                    }
                    case "--host": {
                        ArrayList<String> list = new ArrayList<String>();
                        int start = 0;
                        String hostArg = params[++i];
                        while (true) {
                            if (start < hostArg.length() && hostArg.charAt(start) == ' ') {
                                ++start;
                                continue;
                            }
                            if (start >= hostArg.length()) break;
                            int comma = hostArg.indexOf(44, start);
                            if (comma == start) {
                                ++start;
                                continue;
                            }
                            if (comma == -1) {
                                comma = hostArg.length();
                            }
                            int end = comma - 1;
                            while (hostArg.charAt(end) == ' ') {
                                --end;
                            }
                            list.add(hostArg.substring(start, end + 1));
                            start = comma + 1;
                        }
                        if (list.isEmpty()) {
                            throw new InvalidParam("invalid argument for --host: " + hostArg);
                        }
                        hosts = list.toArray(new String[0]);
                        break;
                    }
                    case "--multi-profile": {
                        numProfiles = Acceptor_impl.ProfileCardinality.MANY;
                        break;
                    }
                    case "--no-profile": {
                        numProfiles = Acceptor_impl.ProfileCardinality.ZERO;
                        break;
                    }
                    case "--no-keepalive": {
                        keepAlive = false;
                        break;
                    }
                    case "--numeric": {
                        numeric = true;
                        break;
                    }
                    case "--port": {
                        String portArg = params[++i];
                        try {
                            port = Integer.parseInt(portArg);
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidParam("invalid argument for --port: " + portArg);
                        }
                        if (port >= 1 && port <= 65535) continue block29;
                        throw new InvalidParam("invalid port");
                    }
                    default: {
                        if (this.connectionHelper.isExtended()) continue block29;
                        throw new InvalidParam("unknown parameter: " + option);
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw (InvalidParam)((Object)new InvalidParam("argument expected for " + option).initCause(e));
            }
        }
        if (hosts == null) {
            hosts = new String[]{Net.getCanonicalHostname(numeric)};
        }
        logger.fine("Creating acceptor for port=" + port);
        try {
            codec = ((CodecFactory)this.orb_.resolve_initial_references("CodecFactory")).create_codec(CDR_1_2_ENCODING);
        }
        catch (InvalidName e) {
            throw new InvalidParam("Could not obtain codec factory using name 'CodecFactory'");
        }
        catch (UnknownEncoding e) {
            throw new InvalidParam("Could not obtain codec using encoding " + CDR_1_2_ENCODING);
        }
        return new Acceptor_impl(bind, hosts, numProfiles, port, backlog, keepAlive, this.connectionHelper, this.listenMap_, params, codec);
    }

    @Override
    public void change_key(IORHolder ior, byte[] key) {
        for (int profile = 0; profile < ior.value.profiles.length; ++profile) {
            TaggedComponent[] components;
            if (ior.value.profiles[profile].tag != 0) continue;
            InputStream in = new InputStream(ior.value.profiles[profile].profile_data);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
            if (body.iiop_version.major > 1 || body.iiop_version.minor > 0) {
                int len = in.read_ulong();
                components = new TaggedComponent[len];
                for (int j = 0; j < len; ++j) {
                    components[j] = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
                }
            } else {
                components = new TaggedComponent[]{};
            }
            body.object_key = key;
            try (OutputStream out = new OutputStream();){
                out._OB_writeEndian();
                ProfileBody_1_0Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_0)body);
                if (body.iiop_version.major > 1 || body.iiop_version.minor > 0) {
                    out.write_ulong(components.length);
                    for (TaggedComponent component : components) {
                        TaggedComponentHelper.write((org.omg.CORBA.portable.OutputStream)out, (TaggedComponent)component);
                    }
                }
                ior.value.profiles[profile].profile_data = out.copyWrittenBytes();
                continue;
            }
        }
    }

    public AccFactory_impl(ORB orb, ListenerMap lm, UnifiedConnectionHelper helper) {
        this.connectionHelper = Objects.requireNonNull(helper);
        this.orb_ = orb;
        this.info_ = new AccFactoryInfo_impl();
        this.listenMap_ = lm;
    }
}

