/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.yoko.orb.CORBA.ORB;
import org.apache.yoko.orb.OB.OptionFilter;
import org.apache.yoko.orb.OCI.IIOP.Plugin_impl;
import org.apache.yoko.orb.OCI.IIOP.UnifiedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.UnifiedConnectionHelperProvider;
import org.apache.yoko.orb.OCI.Plugin;
import org.apache.yoko.orb.OCI.PluginInit;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.util.AssertionFailed;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.PrivilegedActions;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.StringSeqHolder;

public class iiop
implements PluginInit {
    static final Logger logger = Logger.getLogger(iiop.class.getName());
    public static final String ROOT_POAMGR_ENDPOINT_KEY = "yoko.orb.poamanager.RootPOAManager.endpoint";
    public static final String OA_ENDPOINT_KEY = "yoko.orb.oa.endpoint";
    private String connectionHelper = "org.apache.yoko.orb.OCI.IIOP.DefaultConnectionHelper";
    private String helperArgs = "";

    @Override
    public void version(org.omg.CORBA.ORB orb, String ver) {
    }

    @Override
    public Plugin init(org.omg.CORBA.ORB orb, StringSeqHolder args) {
        ORB oborb = (ORB)orb;
        Properties props = oborb.properties();
        args.value = this.parse_args(args.value, props);
        try {
            Class c = ProviderLocator.loadClass((String)this.connectionHelper, this.getClass(), (ClassLoader)((ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER)));
            UnifiedConnectionHelper connectionHelper = ((UnifiedConnectionHelperProvider)((Constructor)AccessController.doPrivileged(PrivilegedActions.getNoArgConstructor((Class)c))).newInstance(new Object[0])).getUnifiedConnectionHelper();
            connectionHelper.init(orb, this.helperArgs);
            return new Plugin_impl(orb, connectionHelper);
        }
        catch (AssertionFailed | INITIALIZE e) {
            throw e;
        }
        catch (Exception e) {
            throw (INITIALIZE)Exceptions.as(INITIALIZE::new, (Throwable)e, (Object)("unable to load IIOP ConnectionHelper plug-in `" + this.connectionHelper + "'"));
        }
    }

    public String[] parse_args(String[] args, Properties props) {
        OptionParser.parse(props).parse(args).apply(this).update(props);
        OptionFilter filter = new OptionFilter("iiop.parse_args", "-OA");
        filter.add("host", 1);
        filter.add("numeric", 0);
        filter.add("port", 1);
        args = filter.filter(args);
        filter = new OptionFilter("iiop.parse_args", "-IIOP");
        filter.add("backlog", 1);
        filter.add("bind", 1);
        filter.add("host", 1);
        filter.add("numeric", 0);
        filter.add("port", 1);
        return filter.filter(args);
    }

    static class OptionParser {
        private String backlog;
        private String bind;
        private String host;
        private boolean numeric;
        private String port;
        private String connHelper;
        private String connHelperArgs;
        private boolean noArgs = true;

        OptionParser() {
        }

        static ArgParser parse(Properties props) {
            OptionParser op = new OptionParser();
            props.entrySet().forEach(op::parseProperty);
            return op::parseArguments;
        }

        private void parseProperty(Map.Entry<Object, Object> property) {
            String key = String.valueOf(property.getKey());
            String value = String.valueOf(property.getValue());
            switch (key) {
                case "org.omg.CORBA.ORBInitialHost": 
                case "yoko.iiop.host": {
                    this.setHost(value);
                    logger.fine("Using " + key + " value of " + value);
                    break;
                }
                case "org.omg.CORBA.ORBInitialPort": 
                case "yoko.iiop.port": {
                    this.setPort(value);
                    logger.fine("Using " + key + " value of " + value);
                    break;
                }
                case "org.omg.CORBA.ORBListenEndpoints": {
                    int sep = value.indexOf(58);
                    if (sep == -1) break;
                    this.setHost(value.substring(0, sep));
                    this.setPort(value.substring(sep + 1));
                    logger.fine("Using " + key + " value of " + value);
                    break;
                }
                case "yoko.iiop.numeric": {
                    this.setNumeric();
                    logger.fine("Using " + key + " value of " + value);
                    break;
                }
                default: {
                    if (!key.startsWith("yoko.iiop.")) break;
                    throw new INITIALIZE("iiop: unknown property " + key);
                }
            }
        }

        private IIOPSetter parseArguments(String[] args) {
            Consumer<String> pending = null;
            for (String arg : args) {
                if (null == pending) {
                    pending = this.parseArgument(arg);
                    continue;
                }
                pending.accept(arg);
                pending = null;
            }
            if (null == pending) {
                return this::applyConnectionHelperSettings;
            }
            throw new INITIALIZE("iiop: argument expected for " + args[args.length - 1]);
        }

        private Consumer<String> parseArgument(String arg) {
            switch (arg) {
                case "-IIOPbacklog": {
                    return this::setBacklog;
                }
                case "-IIOPbind": {
                    return this::setBind;
                }
                case "-IIOPhost": 
                case "-OAhost": {
                    return this::setHost;
                }
                case "-IIOPport": 
                case "-OAport": {
                    return this::setPort;
                }
                case "-IIOPconnectionHelper": {
                    return this::setConnHelper;
                }
                case "-IIOPconnectionHelperArgs": {
                    return this::setConnHelperArgs;
                }
                case "-IIOPnumeric": 
                case "-OAnumeric": {
                    this.setNumeric();
                    return null;
                }
            }
            if (arg.startsWith("-IIOP")) {
                throw new INITIALIZE("iiop: unknown option `" + arg + "'");
            }
            return null;
        }

        private PropertySetter applyConnectionHelperSettings(iiop target) {
            if (null != this.connHelper) {
                target.connectionHelper = this.connHelper;
            }
            if (null != this.connHelperArgs) {
                target.helperArgs = this.connHelperArgs;
            }
            return this::updateProperties;
        }

        private void updateProperties(Properties target) {
            if (this.noArgs) {
                return;
            }
            String key = Stream.of(iiop.ROOT_POAMGR_ENDPOINT_KEY, iiop.OA_ENDPOINT_KEY).filter(target::containsKey).findFirst().orElse(iiop.OA_ENDPOINT_KEY);
            StringBuilder value = new StringBuilder(Optional.of(key).map(target::getProperty).map(oldValue -> oldValue + ", ").orElse(""));
            value.append(this.numeric ? "iiop --numeric" : "iiop");
            Optional.ofNullable(this.host).map(s -> " --host \"" + s + "\"").map(value::append);
            Optional.ofNullable(this.port).map(s -> " --port " + s).map(value::append);
            Optional.ofNullable(this.backlog).map(s -> " --backlog " + s).map(value::append);
            Optional.ofNullable(this.bind).map(s -> " --bind " + s).map(value::append);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("Setting endpoint property \"%s\" to \"%s\"", key, value));
            }
            target.put(key, value);
        }

        private void setBacklog(String s) {
            this.noArgs = false;
            this.backlog = s;
        }

        private void setBind(String s) {
            this.noArgs = false;
            this.bind = s;
        }

        private void setHost(String s) {
            this.noArgs = false;
            this.host = s;
        }

        private void setPort(String s) {
            this.noArgs = false;
            this.port = s;
        }

        private void setNumeric() {
            this.noArgs = false;
            this.numeric = true;
        }

        private void setConnHelper(String s) {
            this.connHelper = s;
        }

        private void setConnHelperArgs(String s) {
            this.connHelperArgs = s;
        }

        static interface ArgParser {
            public IIOPSetter parse(String[] var1);
        }

        static interface IIOPSetter {
            public PropertySetter apply(iiop var1);
        }

        static interface PropertySetter {
            public void update(Properties var1);
        }
    }
}

