/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.viewer;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.logging.hpel.FormatSet;
import com.ibm.ws.logging.hpel.viewer.LogViewer;
import com.ibm.ws.logging.internal.hpel.HpelHeader;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class BinaryLog
extends LogViewer {
    private final String action;
    private final File unvalidatedRepositoryDir;
    private final File unvalidatedTargetDir;
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.viewer.internal.resources.BinaryLogMessages";
    private static final String NAME_VALUE_PAIR_SEPARATOR = "=";
    private static final String ACTION_VIEW = "view";
    private static final String ACTION_COPY = "copy";
    private static final String ACTION_LISTINSTANCES = "listinstances";
    private static final String ACTION_HELP = "help";
    private static final String LATEST_INSTANCE = "latest";
    private static final int RC_SUCCESS = 0;
    private static final int RC_BAD_INPUT = 20;
    private static final String DEFAULT_SERVER_NAME = "defaultServer";
    private final DateFormat defaultDateFormat = DateFormat.getDateInstance(3);
    private final DateFormat defaultDateTimeFormat = FormatSet.customizeDateFormat(DateFormat.getDateTimeInstance(3, 2));
    private final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private static final Map<String, LogViewer.LevelDetails> LEVELS = new HashMap<String, LogViewer.LevelDetails>(3);
    private final Option[] filterOptions = new Option[]{new OneArgOption("--minDate"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setStartDate(arg);
        }
    }, new OneArgOption("--maxDate"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setStopDate(arg);
        }
    }, new OneArgOption("--minLevel"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setMinLevel(arg);
        }
    }, new OneArgOption("--maxLevel"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setMaxLevel(arg);
        }
    }, new OneArgOption("--includeLogger"){

        @Override
        void setValue(String arg) {
            BinaryLog.this.setIncludeLoggers(arg);
        }
    }, new OneArgOption("--excludeLogger"){

        @Override
        void setValue(String arg) {
            BinaryLog.this.setExcludeLoggers(arg);
        }
    }, new OneArgOption("--includeMessage"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setMessage(arg);
        }
    }, new OneArgOption("--excludeMessage"){

        @Override
        void setValue(String arg) {
            BinaryLog.this.setExcludeMessages(arg);
        }
    }, new OneArgOption("--includeThread"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setHexThreadID(arg);
        }
    }, new OneArgOption("--includeExtension"){

        @Override
        public void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setExtensions(arg);
        }
    }, new OneArgOption("--includeInstance"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            if (arg.toLowerCase().equals(BinaryLog.LATEST_INSTANCE)) {
                BinaryLog.this.setLatestInstance(true);
            } else {
                BinaryLog.this.setInstanceId(arg);
            }
        }
    }};
    private final Option[] formatOptions = new Option[]{new OneArgOption("--format"){

        @Override
        void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setOutFormat(arg);
        }
    }, new OneArgOption("--encoding"){

        @Override
        public void setValue(String arg) throws IllegalArgumentException {
            BinaryLog.this.setEncoding(arg);
        }
    }, new OneArgOption("--locale"){

        @Override
        void setValue(String arg) {
            BinaryLog.this.setLocale(arg);
        }
    }};
    private final Option[] monitorOptions = new Option[]{new TailOption("--monitor")};
    private final Option[] isoDateFormatOptions = new Option[]{new TailOption("--isoDateFormat"){

        @Override
        public void enableOption() throws IllegalArgumentException {
            BinaryLog.this.setDateFormat();
            BinaryLog.this.useISODateFormatObjects();
        }
    }};
    private final Option[][] viewActionOptions = new Option[][]{this.filterOptions, this.monitorOptions, this.formatOptions, this.isoDateFormatOptions};
    private final Option[][] copyActionOptions = new Option[][]{this.filterOptions};
    private final Option[][] listInstancesActionOptions = new Option[][]{this.isoDateFormatOptions};

    private static boolean looksLikeHelp(String taskname) {
        int start;
        if (taskname == null) {
            return false;
        }
        int len = taskname.length();
        for (start = 0; start < len && !Character.isLetter(taskname.charAt(start)); ++start) {
        }
        return ACTION_HELP.equalsIgnoreCase(taskname.substring(start).toLowerCase());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            BinaryLog.printShortUsage();
            System.exit(0);
        }
        int numProcessedArgs = 0;
        String actionLowerCase = args[0].toLowerCase();
        if (BinaryLog.looksLikeHelp(actionLowerCase)) {
            actionLowerCase = ACTION_HELP;
        }
        if (!(actionLowerCase.equals(ACTION_HELP) || actionLowerCase.equals(ACTION_VIEW) || actionLowerCase.equals(ACTION_COPY) || actionLowerCase.equals(ACTION_LISTINSTANCES))) {
            System.err.println(BinaryLog.getLocalizedParmString("BL_INVALID_ACTION", new Object[]{args[0]}));
            System.err.println(BinaryLog.getLocalizedString("BL_USE_HELP"));
            System.exit(20);
        }
        ++numProcessedArgs;
        File repositoryDir = null;
        if (!actionLowerCase.equals(ACTION_HELP)) {
            String serverNameOrRepositoryPath;
            if (args.length > 1) {
                serverNameOrRepositoryPath = args[1];
                if (serverNameOrRepositoryPath.isEmpty()) {
                    serverNameOrRepositoryPath = DEFAULT_SERVER_NAME;
                    ++numProcessedArgs;
                } else if (serverNameOrRepositoryPath.startsWith("-")) {
                    serverNameOrRepositoryPath = DEFAULT_SERVER_NAME;
                } else {
                    ++numProcessedArgs;
                }
            } else {
                serverNameOrRepositoryPath = DEFAULT_SERVER_NAME;
            }
            repositoryDir = new File(serverNameOrRepositoryPath);
            if (!serverNameOrRepositoryPath.contains(File.separator)) {
                File serverOutputDir = Utils.getServerOutputDir((String)serverNameOrRepositoryPath);
                if (repositoryDir.exists()) {
                    File currentDir = new File(".", serverNameOrRepositoryPath);
                    try {
                        if (currentDir.getCanonicalFile().equals(serverOutputDir.getCanonicalFile())) {
                            repositoryDir = new File(serverOutputDir, "logs");
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    repositoryDir = new File(serverOutputDir, "logs");
                }
            }
        }
        File targetDir = null;
        if (actionLowerCase.equals(ACTION_COPY)) {
            String targetDirString = null;
            if (args.length > 2 && !args[2].startsWith("-")) {
                targetDirString = args[2];
                ++numProcessedArgs;
            }
            if (targetDirString != null) {
                targetDir = new File(targetDirString);
            } else {
                System.err.println(BinaryLog.getLocalizedString("BL_COPY_REQUIRES_TARGETDIR"));
                System.err.println(BinaryLog.getLocalizedString("BL_USE_HELP"));
                System.exit(20);
            }
        }
        String[] newArgs = new String[args.length - numProcessedArgs];
        System.arraycopy(args, numProcessedArgs, newArgs, 0, newArgs.length);
        args = newArgs;
        BinaryLog viewer = new BinaryLog(actionLowerCase, repositoryDir, targetDir);
        int code = viewer.execute(args, LEVELS, HpelHeader.getLibertyRuntimeHeader());
        if (code > 0) {
            System.err.println(BinaryLog.getLocalizedString("BL_USE_HELP"));
            System.exit(20);
        }
        System.exit(0);
    }

    BinaryLog(String action, File repositoryDir, File targetDir) {
        this.action = action;
        this.unvalidatedRepositoryDir = repositoryDir;
        this.unvalidatedTargetDir = targetDir;
        this.dateFormat = this.defaultDateFormat;
        this.dateTimeFormat = this.defaultDateTimeFormat;
        this.dateFormat.setLenient(false);
        this.dateTimeFormat.setLenient(false);
        this.isoDateFormat.setLenient(false);
        this.isoDateTimeFormat.setLenient(false);
    }

    @Override
    protected boolean parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        if (this.action.equals(ACTION_HELP)) {
            if (args.length == 0) {
                this.helpAction(null);
            } else {
                this.helpAction(args[0]);
            }
            return true;
        }
        if (this.action.equals(ACTION_VIEW)) {
            BinaryLog.parseOptions(args, this.viewActionOptions);
            return false;
        }
        if (this.action.equals(ACTION_LISTINSTANCES)) {
            BinaryLog.parseOptions(args, this.listInstancesActionOptions);
            this.setListInstances(true);
            return false;
        }
        if (this.action.equals(ACTION_COPY)) {
            BinaryLog.parseOptions(args, this.copyActionOptions);
            return false;
        }
        return true;
    }

    private static void parseOptions(String[] args, Option[][] actionOptions) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            String argName;
            boolean accepted = false;
            String argValue = null;
            int equalsIndex = args[i].indexOf(NAME_VALUE_PAIR_SEPARATOR);
            if (equalsIndex < 0) {
                argName = args[i];
            } else {
                argName = args[i].substring(0, equalsIndex);
                if (equalsIndex + 1 < args[i].length()) {
                    argValue = args[i].substring(equalsIndex + 1);
                }
            }
            block1: for (Option[] options : actionOptions) {
                if (accepted) break;
                for (Option option : options) {
                    if (!argName.equalsIgnoreCase(option.name)) continue;
                    if (option.hasArg && argValue == null) {
                        throw new IllegalArgumentException(BinaryLog.getLocalizedParmString("BL_OPTION_REQUIRES_A_VALUE", new Object[]{option.name}));
                    }
                    option.accept(argValue);
                    accepted = true;
                    continue block1;
                }
            }
            if (accepted) continue;
            throw new IllegalArgumentException(BinaryLog.getLocalizedParmString("BL_UNKNOWN_OPTION", new Object[]{args[i]}));
        }
    }

    @Override
    protected boolean validateSettings() throws IllegalArgumentException {
        Date startDate = this.getStartDate();
        Date stopDate = this.getStopDate();
        if (startDate != null && stopDate != null && startDate.after(stopDate)) {
            throw new IllegalArgumentException(BinaryLog.getLocalizedString("BL_MINDATE_AFTER_MAXDATE"));
        }
        Level minLevel = this.getMinLevel();
        Level maxLevel = this.getMaxLevel();
        if (maxLevel != null && minLevel != null && minLevel.intValue() > maxLevel.intValue()) {
            throw new IllegalArgumentException(BinaryLog.getLocalizedString("BL_MINLEVEL_GREATER_THAN_MAXLEVEL"));
        }
        try {
            this.setBinaryRepositoryDir(this.unvalidatedRepositoryDir.getCanonicalPath());
            System.out.println(BinaryLog.getLocalizedParmString("BL_REPOSITORY_DIRECTORY", new Object[]{this.getValidatedBinaryRepositoryDir()}));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(BinaryLog.getLocalizedParmString("BL_INVALID_REPOSITORYDIR", new Object[]{this.unvalidatedRepositoryDir}));
        }
        try {
            if (this.unvalidatedTargetDir != null) {
                String dir = this.unvalidatedTargetDir.getCanonicalPath();
                this.setOutputRepositoryDir(dir);
                System.out.println(BinaryLog.getLocalizedParmString("BL_TARGET_DIRECTORY", new Object[]{dir}));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(BinaryLog.getLocalizedParmString("BL_INVALID_TARGETDIR", new Object[]{this.unvalidatedTargetDir}));
        }
        return false;
    }

    @Override
    void setStartDate(String newStartDate) throws IllegalArgumentException {
        try {
            if (newStartDate.contains(":")) {
                this.setStartDate(this.defaultDateTimeFormat.parse(newStartDate));
            } else {
                this.setStartDate(this.defaultDateFormat.parse(newStartDate));
            }
        }
        catch (ParseException e) {
            try {
                if (newStartDate.contains(":")) {
                    this.setStartDate(this.isoDateTimeFormat.parse(newStartDate));
                } else {
                    this.setStartDate(this.isoDateFormat.parse(newStartDate));
                }
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(BinaryLog.getLocalizedString("BL_INVALID_MINDATE"), e);
            }
        }
    }

    @Override
    void setStopDate(String newStopDate) throws IllegalArgumentException {
        try {
            if (newStopDate.contains(":")) {
                this.setStopDate(this.defaultDateTimeFormat.parse(newStopDate));
            } else {
                Date stopDate = new Date(this.defaultDateFormat.parse(newStopDate).getTime() + 86400000L - 1L);
                this.setStopDate(stopDate);
            }
        }
        catch (ParseException e) {
            try {
                if (newStopDate.contains(":")) {
                    this.setStopDate(this.isoDateTimeFormat.parse(newStopDate));
                } else {
                    Date stopDate = new Date(this.isoDateFormat.parse(newStopDate).getTime() + 86400000L - 1L);
                    this.setStopDate(stopDate);
                }
            }
            catch (ParseException p) {
                throw new IllegalArgumentException(BinaryLog.getLocalizedString("BL_INVALID_MAXDATE"), e);
            }
        }
    }

    private void helpAction(String arg) {
        if (arg == null) {
            this.printMainUsage();
            return;
        }
        String helpTarget = arg.toLowerCase();
        if (helpTarget.equals(ACTION_VIEW)) {
            this.printViewUsage();
        } else if (helpTarget.equals(ACTION_COPY)) {
            this.printCopyUsage();
        } else if (helpTarget.equals(ACTION_LISTINSTANCES)) {
            this.printListInstancesUsage();
        } else {
            this.printMainUsage();
        }
    }

    private static void printShortUsage() {
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_001") + "\n\n");
    }

    private void printMainUsage() {
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_001"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_004"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_005"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_006"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_007"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_008"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_009"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_010"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_011"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_012"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_013"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_014"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_015"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_016"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_017"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_018"));
        System.out.println();
    }

    private void printViewUsage() {
        Date sampleDate = new Date();
        String dateSample = this.dateFormat.format(sampleDate);
        String dateTimeSample = this.dateTimeFormat.format(sampleDate);
        String isoDateSample = this.isoDateFormat.format(sampleDate);
        String isoDateTimeSample = this.isoDateTimeFormat.format(sampleDate);
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_001"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_004"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_005"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_006"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_007"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_008"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_002"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_003"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_004"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_005"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_006", new Object[]{dateSample, dateTimeSample, isoDateSample, isoDateTimeSample}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_007"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_008", new Object[]{dateSample, dateTimeSample, isoDateSample, isoDateTimeSample}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_009"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_010", new Object[]{this.getLevelString()}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_011"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_012", new Object[]{this.getLevelString()}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_013"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_014"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_015"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_016"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_017"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_018"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_035"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_036"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_019"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_020"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_021"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_022"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_023"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_024"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_025"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_026"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_027"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_028"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_029"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_030"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_031"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_032"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_033"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_034"));
        System.out.println();
    }

    private void printCopyUsage() {
        Date sampleDate = new Date();
        String dateSample = this.dateFormat.format(sampleDate);
        String dateTimeSample = this.dateTimeFormat.format(sampleDate);
        String isoDateSample = this.isoDateFormat.format(sampleDate);
        String isoDateTimeSample = this.isoDateTimeFormat.format(sampleDate);
        System.out.println(BinaryLog.getLocalizedString("BL_COPY_USAGE_001"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_004"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_005"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_006"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_007"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_COPY_USAGE_002"));
        System.out.println(BinaryLog.getLocalizedString("BL_COPY_USAGE_003"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_008"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_COPY_USAGE_004"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_003"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_004"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_005"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_006", new Object[]{dateSample, dateTimeSample, isoDateSample, isoDateTimeSample}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_007"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_008", new Object[]{dateSample, dateTimeSample, isoDateSample, isoDateTimeSample}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_009"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_010", new Object[]{this.getLevelString()}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_011"));
        System.out.println(BinaryLog.getLocalizedParmString("BL_VIEW_USAGE_012", new Object[]{this.getLevelString()}));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_013"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_014"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_015"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_016"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_017"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_018"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_035"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_036"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_019"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_020"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_021"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_022"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_023"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_024"));
        System.out.println();
    }

    private void printListInstancesUsage() {
        System.out.println(BinaryLog.getLocalizedString("BL_LISTINSTANCES_USAGE_001"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_004"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_005"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_006"));
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_007"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_MAIN_USAGE_008"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_LISTINSTANCES_USAGE_002"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_028"));
        System.out.println();
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_033"));
        System.out.println(BinaryLog.getLocalizedString("BL_VIEW_USAGE_034"));
        System.out.println();
    }

    @Override
    String getLocalizedString_UNABLE_TO_COPY() {
        return BinaryLog.getLocalizedString("BL_UNABLE_TO_COPY");
    }

    @Override
    String getLocalizedString_NO_FILES_FOUND_MONITOR() {
        return BinaryLog.getLocalizedString("BL_NO_FILES_FOUND_MONITOR");
    }

    @Override
    String getLocalizedString_NO_FILES_FOUND() {
        return BinaryLog.getLocalizedString("BL_NO_FILES_FOUND");
    }

    @Override
    String getLocalizedParmString_BAD_FORMAT(Object[] parms) {
        return BinaryLog.getLocalizedParmString("BL_BAD_FORMAT", parms);
    }

    private static String getLocalizedString(String key) {
        return BinaryLog.getLocalizedString(BUNDLE_NAME, key);
    }

    private static String getLocalizedParmString(String key, Object[] parms) {
        return BinaryLog.getLocalizedParmString(BUNDLE_NAME, key, parms);
    }

    @Override
    String getFormattedDateTime(Date dateTime) {
        return this.dateTimeFormat.format(dateTime);
    }

    @Override
    public String toString() {
        String str = super.toString() + ", action=" + this.action;
        String[] values = str.split(",");
        StringBuffer buf = new StringBuffer();
        if (this.getStartDate() != null && this.getStopDate() != null) {
            values[3] = " startDate=" + this.dateTimeFormat.format(this.getStartDate());
            values[4] = " stopDate=" + this.dateTimeFormat.format(this.getStopDate());
            for (int i = 0; i < values.length; ++i) {
                if (i != values.length - 1) {
                    buf.append(values[i]).append(",");
                    continue;
                }
                buf.append(values[i]);
            }
            return buf.toString();
        }
        return str;
    }

    public void useISODateFormatObjects() {
        this.dateFormat = this.isoDateFormat;
        this.dateTimeFormat = this.isoDateTimeFormat;
    }

    static {
        LEVELS.put("FATAL", new LogViewer.LevelDetails(1100, "F", null));
        LEVELS.put("AUDIT", new LogViewer.LevelDetails(850, "A", null));
        LEVELS.put("DETAIL", new LogViewer.LevelDetails(625, "D", null));
    }

    private static abstract class Option {
        final String name;
        final boolean hasArg;

        Option(String name, boolean hasArg) {
            this.name = name;
            this.hasArg = hasArg;
        }

        abstract void accept(String var1) throws IllegalArgumentException;
    }

    private class TailOption
    extends NoArgOption {
        TailOption(String name) {
            super(name);
        }

        @Override
        void enableOption() throws IllegalArgumentException {
            BinaryLog.this.setTailInterval(1);
        }
    }

    private static abstract class NoArgOption
    extends Option {
        NoArgOption(String name) {
            super(name, false);
        }

        @Override
        void accept(String value) throws IllegalArgumentException {
            this.enableOption();
        }

        abstract void enableOption();
    }

    private static abstract class OneArgOption
    extends Option {
        OneArgOption(String name) {
            super(name, true);
        }

        @Override
        void accept(String value) throws IllegalArgumentException {
            this.setValue(value);
        }

        abstract void setValue(String var1) throws IllegalArgumentException;
    }
}

