/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.clientcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.clientcontainer.security.JaxWsProxySSLSocketFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsSSLManager {
    private static final TraceComponent tc = Tr.register(JaxWsSSLManager.class, null, null);
    private static final AtomicReference<AtomicServiceReference<SSLSupport>> sslSupportServiceRef = new AtomicReference();
    static final long serialVersionUID = -999924952838508219L;

    protected static void init(AtomicServiceReference<SSLSupport> sslSupportSR) {
        sslSupportServiceRef.set(sslSupportSR);
    }

    public static SSLSocketFactory getProxySSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props) {
        return new JaxWsProxySSLSocketFactory(sslRef, props);
    }

    public static SSLSocketFactory getProxyDefaultSSLSocketFactory(Map<String, Object> props) {
        return new JaxWsProxySSLSocketFactory("defaultSSLConfig", props);
    }

    /*
     * WARNING - void declaration
     */
    public static SSLSocketFactory getSSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props, boolean fallbackOnDefault) {
        SSLSupport sslSupportService = JaxWsSSLManager.tryGetSSLSupport();
        if (null == sslSupportService) {
            return null;
        }
        JSSEHelper jsseHelper = sslSupportService.getJSSEHelper();
        Properties sslConfig = null;
        SSLConfig sslConfigCopy = null;
        try {
            sslConfig = jsseHelper.getProperties(sslRef);
            if (null != sslConfig) {
                sslConfigCopy = new SSLConfig(sslConfig);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cannot get the ssl configuration by sslRef=" + sslRef), (Object[])new Object[0]);
                }
                if (fallbackOnDefault) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Try to get the default ssl configuration of server", (Object[])new Object[0]);
                    }
                    if (null != (sslConfig = jsseHelper.getProperties(null, null, null))) {
                        sslConfigCopy = new SSLConfig(sslConfig);
                    }
                }
            }
            if (null == sslConfigCopy) {
                return null;
            }
            if (null != props && !props.isEmpty()) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(entry.getKey() + "=" + entry.getValue() + " is overriden in SSLConfig=" + sslRef), (Object[])new Object[0]);
                    }
                    sslConfigCopy.put((Object)entry.getKey(), entry.getValue());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Get the SSLSocketFactory by sslRef=" + sslRef), (Object[])new Object[0]);
            }
            return sslSupportService.getJSSEProvider().getSSLSocketFactory(null, sslConfigCopy);
        }
        catch (SSLException iter) {
            void e;
            FFDCFilter.processException((Throwable)iter, (String)"com.ibm.ws.jaxws.clientcontainer.security.JaxWsSSLManager", (String)"110", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"err.when.get.ssl.config", (Object[])new Object[]{sslRef});
            }
            throw new IllegalArgumentException((Throwable)e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.clientcontainer.security.JaxWsSSLManager", (String)"115", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"err.when.get.ssl.socket.factory", (Object[])new Object[]{sslRef});
            }
            throw new IllegalStateException(e);
        }
    }

    private static SSLSupport tryGetSSLSupport() {
        AtomicServiceReference<SSLSupport> serviceRef = sslSupportServiceRef.get();
        if (null == serviceRef) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The sslSupportService is not set yet", (Object[])new Object[0]);
            }
            return null;
        }
        return (SSLSupport)serviceRef.getService();
    }
}

