/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.FileLogHeader;
import com.ibm.ws.objectManager.LogFileFullException;
import com.ibm.ws.objectManager.LogFileSizeTooSmallException;
import com.ibm.ws.objectManager.LogOutput;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.NegativePaddingSpaceException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PaddingLogRecord;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.ThreadNotRunningException;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import com.ibm.ws.objectManager.utils.concurrent.atomic.AtomicIntegerArray;
import com.ibm.ws.objectManager.utils.concurrent.atomic.AtomicIntegerArrayImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;

public class FileLogOutput
extends LogOutput {
    private static final Class cclass = FileLogOutput.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLog");
    private RandomAccessFile logFile;
    private FileLogHeader fileLogHeader;
    private long filePosition;
    private byte filePositionSectorByte;
    long bufferFilePosition;
    byte bufferSectorByte;
    private long fileSpaceLeft;
    private long[] fileSpaceAvailable = new long[16];
    private Object[] fileSpaceAvailableLock = new Object[this.fileSpaceAvailable.length];
    private long logFullReserved = 0L;
    private Object logFullReservedLock = new Object();
    private long fileMark;
    private byte fileMarkSectorByte;
    private Object fileMarkLock = new Object();
    private boolean truncateRequested = false;
    private long uncheckedBytes = 0L;
    private long uncheckedBytesUpToMarkPoint = 0L;
    private ObjectManagerState objectManagerState;
    private boolean ocupancyHigh = false;
    private long newFileSize = 0L;
    private boolean newFileSizeRequested = false;
    private Object newFileSizeRequestLock = new Object();
    private long logFileSizeRequested = 0L;
    private PermanentIOException newFileSizeException = null;
    protected static final int pageSize = 4096;
    protected static final int sectorSize = 512;
    private LogBuffer logBuffer = new LogBuffer(16);
    private LogBufferLock logBufferLock = new LogBufferLock();
    private long paddingSpaceAvailable = 0L;
    private long PADDING_SPACE_TARGET = 0L;
    private static final long PADDING_SPACE_MINIMUM = 10L;
    private PaddingSpaceLock paddingSpaceLock = new PaddingSpaceLock();
    private int firstPageToFlush = 0;
    private int lastPageNotified;
    private int nextPageToNotify;
    private int firstPageFilling = 0;
    private int lastPageFilling = 0;
    private int nextFreeByteInLogBuffer = 1;
    private int newLogBufferPages = 0;
    private static final int maximumLogBufferPages = 256;
    protected static final int partHeaderLength = 4;
    private static final int maximumLogRecordPart = 16380;
    private static final int batchSizeOfNewPagesToFormat = 1024;
    protected static final byte PART_First = 0;
    protected static final byte PART_Middle = 1;
    protected static final byte PART_Last = 2;
    protected static final byte PART_Padding = 3;
    private boolean[] multiPartIdentifersUsed = new boolean[127];
    private long[] multiPartFileStart = new long[127];
    private byte[] multiPartSectorByte = new byte[127];
    private long[] multiPartUncheckedBytes = new long[127];
    private Object multiPartIDLock = new Object();
    public static long coldStartLogFileSize = 0xA00000L;
    protected FlushHelper flushHelper = null;
    protected NotifyHelper notifyHelper = null;
    private final int helperThreadPriority = 6;
    private long totalBytesWritten = 0L;
    private long totalNumberOfFlushRequests = 0L;
    private long totalNumberOfLogBufferWrites = 0L;
    private long totalNumberOfThreadsFindingFullLogBuffers = 0L;
    private long totalNumberOfFlushHelperWaits = 0L;
    private long totalNumberOfLogCycles = 0L;
    private long writeStalledMilliseconds = 0L;
    private long writeCopyingMilliseconds = 0L;
    private long paddingStalledMilliseconds = 0L;
    private long writeUpdateStateMilliseconds = 0L;
    private long lastFlushMilliseconds = 0L;
    private long flushingMilliseconds = 0L;
    private long otherMilliseconds = 0L;
    private long flushHelperWaitingMilliseconds = 0L;
    private long logFullCheckpointsTriggered = 0L;
    private long stalledForMultiPartID = 0L;
    private long totalPaddingBytesWritten = 0L;
    private long totalPaddingRecords = 0L;
    private int[] numberOfFlushWaitersFrequency = new int[17];
    private int[] numberOfPagesWrittenFrequency = new int[17];

    protected FileLogOutput(RandomAccessFile logFile, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFile, objectManagerState});
        }
        this.logFile = logFile;
        this.logBuffer.sequenceNumberOfFirstPage = 1L;
        this.objectManagerState = objectManagerState;
        this.fileLogHeader = new FileLogHeader();
        this.fileLogHeader.startByteAddress = 8192L;
        this.fileLogHeader.fileSize = coldStartLogFileSize / 4096L * 4096L;
        byte[] newPages = new byte[(int)Math.min(0x400000L, this.fileLogHeader.fileSize)];
        for (int iStart = 0; iStart < newPages.length; iStart += 4096) {
            FileLogOutput.setSectorBits(newPages, iStart, (byte)0);
        }
        try {
            logFile.setLength(this.fileLogHeader.fileSize);
            logFile.seek(0L);
            for (long istart = 0L; istart < this.fileLogHeader.fileSize; istart += (long)newPages.length) {
                logFile.write(newPages, 0, (int)Math.min((long)newPages.length, this.fileLogHeader.fileSize - istart));
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:335:1.52");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.filePosition = this.fileLogHeader.writeHeader(logFile);
        this.filePositionSectorByte = this.fileLogHeader.sectorByte;
        this.bufferFilePosition = this.filePosition;
        this.bufferSectorByte = this.filePositionSectorByte;
        try {
            logFile.seek(this.filePosition);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:361:1.52");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.open();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected FileLogOutput(RandomAccessFile logFile, long initialLogSequenceNumber, long page, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFile, new Long(initialLogSequenceNumber), new Long(page), objectManagerState});
        }
        this.logFile = logFile;
        this.logBuffer.sequenceNumberOfFirstPage = ++initialLogSequenceNumber;
        this.objectManagerState = objectManagerState;
        this.fileLogHeader = new FileLogHeader(logFile);
        try {
            if (logFile.length() > this.fileLogHeader.fileSize) {
                logFile.setLength(this.fileLogHeader.fileSize);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:423:1.52");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.filePosition = page * 4096L;
        this.filePositionSectorByte = this.fileLogHeader.sectorByte;
        if (this.filePosition < this.fileLogHeader.startByteAddress) {
            this.filePositionSectorByte = this.filePositionSectorByte == 0 ? (byte)1 : 0;
        }
        this.bufferFilePosition = this.filePosition;
        this.bufferSectorByte = this.filePositionSectorByte;
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug((Object)this, cclass, "<init>", new Object[]{new Byte(this.filePositionSectorByte), new Long(this.fileLogHeader.startByteAddress), new Long(this.filePosition)});
        }
        try {
            logFile.seek(this.filePosition);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:464:1.52");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.open();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected void open() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "open");
        }
        this.multiPartIdentifersUsed[0] = true;
        for (int i = 1; i < this.multiPartIdentifersUsed.length; ++i) {
            this.multiPartIdentifersUsed[i] = false;
            this.multiPartFileStart[i] = -1L;
        }
        this.setFileSpaceLeft();
        long totalFileSpaceAvailable = this.fileSpaceLeft - 8192L - (this.fileLogHeader.fileSize - 8192L) / 4096L - 4096L;
        for (int i = 0; i < this.fileSpaceAvailable.length; ++i) {
            this.fileSpaceAvailable[i] = totalFileSpaceAvailable / (long)this.fileSpaceAvailable.length;
            this.fileSpaceAvailableLock[i] = new Object();
        }
        this.fileSpaceAvailable[0] = this.fileSpaceAvailable[0] + totalFileSpaceAvailable % (long)this.fileSpaceAvailable.length;
        this.calculatePaddingSpaceTarget();
        this.notifyHelper = new NotifyHelper();
        this.flushHelper = new FlushHelper();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculatePaddingSpaceTarget() throws ObjectManagerException {
        long oldTarget;
        if (trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "calculatePaddingSpaceTarget", new Object[]{this.PADDING_SPACE_TARGET});
        }
        PaddingSpaceLock paddingSpaceLock = this.paddingSpaceLock;
        synchronized (paddingSpaceLock) {
            oldTarget = this.PADDING_SPACE_TARGET;
            long numberOfBuffersPerLog = (this.fileLogHeader.fileSize - 4096L) / (long)(this.logBuffer.numberOfPages * 4096);
            this.PADDING_SPACE_TARGET = Math.max(numberOfBuffersPerLog * 4096L, 40960L);
        }
        long paddingSpaceDelta = this.PADDING_SPACE_TARGET - oldTarget;
        if (paddingSpaceDelta > 0L) {
            this.reserve(paddingSpaceDelta);
            this.paddingReserveLogSpace(-paddingSpaceDelta);
        }
        if (trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "calculatePaddingSpaceTarget", new Object[]{this.PADDING_SPACE_TARGET});
        }
    }

    @Override
    protected void close() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "close");
        }
        if (this.flushHelper != null) {
            this.flushHelper.shutdown();
        }
        if (this.notifyHelper != null) {
            this.notifyHelper.shutdown();
        }
        this.logFile = null;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setLogFileSize(long newFileSize) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setLogFileSize", "newFileSize=" + newFileSize + "(long)");
        }
        long initialFilePosition = this.filePosition;
        Object object = this.newFileSizeRequestLock;
        synchronized (object) {
            this.newFileSize = newFileSize / 4096L * 4096L;
            this.newFileSizeRequested = true;
            this.newFileSizeException = null;
            this.logFileSizeRequested = newFileSize;
            boolean wrapped = false;
            while (this.newFileSizeRequested) {
                long fileSpaceAvailable = this.getLogFileSpaceLeft();
                long newFileSpaceAvailable = fileSpaceAvailable - this.fileLogHeader.fileSize + newFileSize;
                float newOcupancy = 1.0f - (float)newFileSpaceAvailable / (float)newFileSize;
                if (newOcupancy > this.objectManagerState.logFullPostCheckpointThreshold || wrapped) {
                    this.newFileSizeRequested = false;
                    this.logFileSizeRequested = 0L;
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "setLogFileSize", new Object[]{new Long(this.fileLogHeader.fileSize), new Long(newFileSize), new Float(newOcupancy)});
                    }
                    throw new LogFileSizeTooSmallException(this, this.fileLogHeader.fileSize, newFileSize, fileSpaceAvailable, newOcupancy, this.objectManagerState.logFullPostCheckpointThreshold);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "setLogFileSize", new Object[]{new Long(this.filePosition), new Long(initialFilePosition)});
                }
                if (this.filePosition < initialFilePosition) {
                    wrapped = true;
                }
                this.objectManagerState.waitForCheckpoint(true);
            }
            this.logFileSizeRequested = 0L;
        }
        if (this.newFileSizeException != null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setLogFileSize", "via PermanentIOException newFileSizeException=" + this.newFileSizeException + "(PermanentIOException)");
            }
            throw this.newFileSizeException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setLogFileSize");
        }
    }

    @Override
    protected long getLogFileSize() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getLogFileSIze");
        }
        long logFileSize = this.fileLogHeader.fileSize;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getLogFileSize", "returns logFileSize=" + logFileSize + "(long)");
        }
        return logFileSize;
    }

    @Override
    protected long getLogFileSizeRequested() {
        return this.logFileSizeRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getLogFileSpaceLeft() {
        long fileSpaceLeft = 0L;
        for (int i = 0; i < this.fileSpaceAvailable.length; ++i) {
            Object object = this.fileSpaceAvailableLock[i];
            synchronized (object) {
                fileSpaceLeft += this.fileSpaceAvailable[i];
                continue;
            }
        }
        return fileSpaceLeft;
    }

    @Override
    protected boolean isOcupancyHigh() {
        return this.ocupancyHigh;
    }

    private void setFileSpaceLeft() throws ObjectManagerException {
        long newFileSpaceLeft;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setFileSpaceLeft", new Object[]{new Long(this.fileLogHeader.fileSize), new Long(this.fileLogHeader.startByteAddress), new Long(this.filePosition)});
        }
        if ((newFileSpaceLeft = this.fileLogHeader.startByteAddress - this.filePosition) <= 0L) {
            newFileSpaceLeft = newFileSpaceLeft + this.fileLogHeader.fileSize - 8192L;
        }
        this.fileSpaceLeft = newFileSpaceLeft;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setFileSpaceLeft", new Object[]{new Long(this.fileSpaceLeft)});
        }
    }

    protected static void setSectorBits(byte[] byteArray, int offset, byte requiredSectorByte) {
        byte sectorByte;
        byteArray[offset] = sectorByte = (byte)((byteArray[offset + 512 - 1] & 1) + (byteArray[offset + 1024 - 1] & 1) * 2 + (byteArray[offset + 1536 - 1] & 1) * 4 + (byteArray[offset + 2048 - 1] & 1) * 8 + (byteArray[offset + 2560 - 1] & 1) * 16 + (byteArray[offset + 3072 - 1] & 1) * 32 + (byteArray[offset + 3584 - 1] & 1) * 64 + (byteArray[offset + 4096 - 1] & 1) * 128);
        if (requiredSectorByte == 0) {
            int n = offset + 512 - 1;
            byteArray[n] = (byte)(byteArray[n] & 0xFE);
            int n2 = offset + 1024 - 1;
            byteArray[n2] = (byte)(byteArray[n2] & 0xFE);
            int n3 = offset + 1536 - 1;
            byteArray[n3] = (byte)(byteArray[n3] & 0xFE);
            int n4 = offset + 2048 - 1;
            byteArray[n4] = (byte)(byteArray[n4] & 0xFE);
            int n5 = offset + 2560 - 1;
            byteArray[n5] = (byte)(byteArray[n5] & 0xFE);
            int n6 = offset + 3072 - 1;
            byteArray[n6] = (byte)(byteArray[n6] & 0xFE);
            int n7 = offset + 3584 - 1;
            byteArray[n7] = (byte)(byteArray[n7] & 0xFE);
            int n8 = offset + 4096 - 1;
            byteArray[n8] = (byte)(byteArray[n8] & 0xFE);
        } else {
            int n = offset + 512 - 1;
            byteArray[n] = (byte)(byteArray[n] | 1);
            int n9 = offset + 1024 - 1;
            byteArray[n9] = (byte)(byteArray[n9] | 1);
            int n10 = offset + 1536 - 1;
            byteArray[n10] = (byte)(byteArray[n10] | 1);
            int n11 = offset + 2048 - 1;
            byteArray[n11] = (byte)(byteArray[n11] | 1);
            int n12 = offset + 2560 - 1;
            byteArray[n12] = (byte)(byteArray[n12] | 1);
            int n13 = offset + 3072 - 1;
            byteArray[n13] = (byte)(byteArray[n13] | 1);
            int n14 = offset + 3584 - 1;
            byteArray[n14] = (byte)(byteArray[n14] | 1);
            int n15 = offset + 4096 - 1;
            byteArray[n15] = (byte)(byteArray[n15] | 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flush() throws ObjectManagerException {
        String methodName = "flush";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "flush");
        }
        int startPage = 0;
        LogBuffer flushLogBuffer = null;
        LogBufferLock logBufferLock = this.logBufferLock;
        synchronized (logBufferLock) {
            startPage = this.lastPageFilling;
            flushLogBuffer = this.logBuffer;
            flushLogBuffer.pageWaiterExists[startPage] = true;
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "flush", new Object[]{"logBuffer_flushing", new Integer(startPage), new Integer(this.firstPageFilling), new Integer(this.lastPageFilling), new Integer(flushLogBuffer.pageWritersActive.get(startPage))});
            }
        }
        flushLogBuffer.waitForFlush(startPage);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "flush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void truncate() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "truncate", new Object[]{new Long(this.fileMark)});
        }
        this.flush();
        Object object = this.fileMarkLock;
        synchronized (object) {
            this.truncateRequested = true;
            this.flush();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "truncate");
        }
    }

    @Override
    protected void reserve(long reservedDelta) throws ObjectManagerException {
        long unavailable;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "reserve", new Object[]{new Long(reservedDelta)});
        }
        if ((unavailable = this.reserveLogFileSpace(reservedDelta)) != 0L) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "reserve", new Object[]{"via LogFileFullException", new Long(unavailable), new Long(reservedDelta)});
            }
            throw new LogFileFullException((Object)this, reservedDelta, reservedDelta, reservedDelta - unavailable);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "reserve");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reserveLogFileSpace(long reservedDelta) {
        int index;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "reserveLogFileSpace", new Object[]{new Long(reservedDelta)});
        }
        long stillToReserve = reservedDelta;
        int startIndex = index = new Random(Thread.currentThread().hashCode()).nextInt(this.fileSpaceAvailable.length);
        while (stillToReserve != 0L) {
            Object object = this.fileSpaceAvailableLock[index];
            synchronized (object) {
                if (stillToReserve <= this.fileSpaceAvailable[index]) {
                    this.fileSpaceAvailable[index] = this.fileSpaceAvailable[index] - stillToReserve;
                    stillToReserve = 0L;
                } else {
                    stillToReserve -= this.fileSpaceAvailable[index];
                    this.fileSpaceAvailable[index] = 0L;
                    if (++index == this.fileSpaceAvailable.length) {
                        index = 0;
                    }
                    if (index == startIndex) {
                        break;
                    }
                }
            }
        }
        if (stillToReserve != 0L) {
            long giveBack = reservedDelta - stillToReserve;
            for (int i = 0; i < this.fileSpaceAvailable.length; ++i) {
                Object object = this.fileSpaceAvailableLock[i];
                synchronized (object) {
                    this.fileSpaceAvailable[i] = this.fileSpaceAvailable[i] + giveBack / (long)this.fileSpaceAvailable.length;
                    if (i == startIndex) {
                        this.fileSpaceAvailable[i] = this.fileSpaceAvailable[i] + giveBack % (long)this.fileSpaceAvailable.length;
                    }
                    continue;
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "reserveLogFileSpace", new Object[]{new Long(stillToReserve), new Integer(startIndex)});
        }
        return stillToReserve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long paddingReserveLogSpace(long spaceToReserve) throws ObjectManagerException {
        if (trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "paddingReserveLogSpace", new Object[]{new Long(spaceToReserve)});
        }
        PaddingSpaceLock paddingSpaceLock = this.paddingSpaceLock;
        synchronized (paddingSpaceLock) {
            this.paddingSpaceAvailable -= spaceToReserve;
            if (spaceToReserve > 0L) {
                if (this.paddingSpaceAvailable < 0L) {
                    NegativePaddingSpaceException exception = new NegativePaddingSpaceException((Object)this, this.paddingSpaceAvailable);
                    ObjectManager.ffdc.processException(this, cclass, "paddingReserveLogSpace", exception, "1:1088:1.52");
                    spaceToReserve = -this.paddingSpaceAvailable;
                    this.paddingSpaceAvailable = 0L;
                } else {
                    spaceToReserve = 0L;
                }
            } else if (this.paddingSpaceAvailable > this.PADDING_SPACE_TARGET) {
                spaceToReserve = this.PADDING_SPACE_TARGET - this.paddingSpaceAvailable;
                this.paddingSpaceAvailable = this.PADDING_SPACE_TARGET;
            } else {
                spaceToReserve = 0L;
            }
        }
        if (spaceToReserve != 0L) {
            this.reserve(spaceToReserve);
        }
        if (trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "paddingReserveLogSpace", new Object[]{new Long(spaceToReserve)});
        }
        return spaceToReserve;
    }

    @Override
    protected final long writeNext(LogRecord logRecord, long reservedDelta, boolean checkSpace, boolean flush) throws ObjectManagerException {
        long logSequenceNumber = this.addLogRecord(logRecord, reservedDelta, false, checkSpace, flush);
        return logSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final long markAndWriteNext(LogRecord logRecord, long reservedDelta, boolean checkSpace, boolean flush) throws ObjectManagerException {
        long logSequenceNumber;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "markAndWriteNext", new Object[]{logRecord, new Long(reservedDelta), new Boolean(checkSpace), new Boolean(flush)});
        }
        Object object = this.fileMarkLock;
        synchronized (object) {
            logSequenceNumber = this.addLogRecord(logRecord, reservedDelta, true, checkSpace, flush);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "markAndWriteNext", new Object[]{new Long(logSequenceNumber), new Long(this.fileMark)});
        }
        return logSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addLogRecord(LogRecord logRecord, long reservedDelta, boolean setMark, boolean checkSpace, boolean flush) throws ObjectManagerException {
        long unavailable2;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addLogRecord", new Object[]{logRecord, new Long(reservedDelta), new Boolean(setMark), new Boolean(checkSpace), new Boolean(flush)});
        }
        int totalBytes = logRecord.getBytesLeft();
        long newSpaceAllocatedInLogFile = 0L;
        newSpaceAllocatedInLogFile = reservedDelta + (long)totalBytes + (long)(4 * (totalBytes / 16380));
        if (totalBytes % 16380 > 0) {
            newSpaceAllocatedInLogFile += 4L;
        }
        if (checkSpace && newSpaceAllocatedInLogFile > 0L && (unavailable2 = this.reserveLogFileSpace(newSpaceAllocatedInLogFile)) != 0L) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "addLogRecord", new Object[]{"via LogFileFullException", new Long(unavailable2), new Long(newSpaceAllocatedInLogFile), new Long(reservedDelta)});
            }
            throw new LogFileFullException((Object)this, newSpaceAllocatedInLogFile, reservedDelta, newSpaceAllocatedInLogFile - unavailable2);
        }
        if (totalBytes > 16380) {
            block8: while (logRecord.multiPartID == 0) {
                Object lock;
                Object unavailable2 = this.multiPartIDLock;
                synchronized (unavailable2) {
                    for (int i = 1; i < this.multiPartIdentifersUsed.length; ++i) {
                        if (this.multiPartIdentifersUsed[i]) continue;
                        logRecord.multiPartID = (byte)i;
                        this.multiPartIdentifersUsed[i] = true;
                        break block8;
                    }
                }
                Object object = lock = new Object();
                synchronized (object) {
                    ++this.stalledForMultiPartID;
                    try {
                        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                            trace.debug((Object)this, cclass, "addLogRecord", "About to wait for 10 milliseconds.");
                        }
                        lock.wait(10L);
                    }
                    catch (InterruptedException exception) {
                        ObjectManager.ffdc.processException(this, cclass, "addLogRecord", exception, "1:1324:1.52");
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "addLogRecord", exception);
                        }
                        throw new UnexpectedExceptionException((Object)this, exception);
                    }
                }
            }
        }
        long logSequenceNumber = 0L;
        while (true) {
            if ((logSequenceNumber = this.addBuffers(logRecord, setMark, checkSpace, flush)) == -1L) {
                this.flush();
                continue;
            }
            if (logSequenceNumber > 0L) break;
        }
        if (checkSpace && newSpaceAllocatedInLogFile < 0L) {
            this.paddingReserveLogSpace(newSpaceAllocatedInLogFile);
        }
        if (logRecord.multiPartID != 0) {
            this.multiPartIdentifersUsed[logRecord.multiPartID] = false;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "addLogRecord", new Object[]{new Long(logSequenceNumber)});
        }
        return logSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addBuffers(LogRecord logRecord, boolean setMark, boolean checkSpace, boolean flush) throws ObjectManagerException {
        LogBuffer endFillingLogBuffer;
        LogBuffer startFillingLogBuffer;
        String methodName = "addBuffers";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addBuffers", new Object[]{logRecord, new Boolean(setMark), new Boolean(checkSpace), new Boolean(flush)});
        }
        int reservedAddress = 0;
        int startPage = 0;
        int endPage = 0;
        long returnLogSequenceNumber = 0L;
        int totalBytes = logRecord.getBytesLeft();
        boolean completed = false;
        if (totalBytes > 16380) {
            totalBytes = 16380;
        } else {
            completed = true;
        }
        long startWriteMilliseconds = System.currentTimeMillis();
        LogBufferLock logBufferLock = this.logBufferLock;
        synchronized (logBufferLock) {
            long now = System.currentTimeMillis();
            this.writeStalledMilliseconds += now - startWriteMilliseconds;
            startWriteMilliseconds = now;
            reservedAddress = this.nextFreeByteInLogBuffer;
            startPage = this.lastPageFilling;
            int pagesStarted = (totalBytes + 4 + reservedAddress % 4096 - 1) / 4095;
            int updatedNextFreeByteInLogBuffer = reservedAddress + totalBytes + 4 + pagesStarted;
            boolean wrappedLogBuffer = false;
            startFillingLogBuffer = this.logBuffer;
            int nextToLastPageNotified = this.lastPageNotified - 1;
            if (nextToLastPageNotified < 0) {
                nextToLastPageNotified = startFillingLogBuffer.numberOfPages - 1;
            }
            if (updatedNextFreeByteInLogBuffer >= startFillingLogBuffer.buffer.length) {
                updatedNextFreeByteInLogBuffer -= startFillingLogBuffer.buffer.length;
                wrappedLogBuffer = true;
            }
            endPage = updatedNextFreeByteInLogBuffer / 4096;
            if (startPage < nextToLastPageNotified && (endPage < startPage || endPage >= nextToLastPageNotified) || startPage > nextToLastPageNotified && endPage < startPage && endPage >= nextToLastPageNotified) {
                ++this.totalNumberOfThreadsFindingFullLogBuffers;
                if (this.newLogBufferPages == 0 && startFillingLogBuffer.numberOfPages < 256) {
                    this.newLogBufferPages = Math.min(startFillingLogBuffer.numberOfPages * 2, 256);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "addBuffers", new Object[]{"logBuffer_full", new Integer(startPage), new Integer(endPage), new Integer(startFillingLogBuffer.pageWritersActive.get(startPage)), new Integer(nextToLastPageNotified)});
                }
                return -1L;
            }
            if (setMark) {
                long fileMarkOffsetFromStart;
                if (logRecord.atStart()) {
                    this.fileMark = this.bufferFilePosition + (long)reservedAddress;
                    this.fileMarkSectorByte = this.bufferSectorByte;
                    this.uncheckedBytesUpToMarkPoint = this.uncheckedBytes;
                    if (this.fileMark > this.fileLogHeader.fileSize) {
                        this.fileMark = this.fileMark - this.fileLogHeader.fileSize + 8192L;
                        byte by = this.fileMarkSectorByte = this.fileMarkSectorByte == 0 ? (byte)1 : 0;
                    }
                    if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                        trace.debug((Object)this, cclass, "addBuffers", new Object[]{"setMark", new Long(this.fileMark), new Byte(this.fileMarkSectorByte), new Long(this.bufferFilePosition), new Byte(this.bufferSectorByte)});
                    }
                }
                long smallestFileMarkOffsetFromStart = fileMarkOffsetFromStart = this.offsetFromStart(this.fileMark);
                for (int i = 1; i < this.multiPartFileStart.length; ++i) {
                    long offsetFromStart;
                    if (this.multiPartFileStart[i] < 0L || (offsetFromStart = this.offsetFromStart(this.multiPartFileStart[i])) >= smallestFileMarkOffsetFromStart) continue;
                    smallestFileMarkOffsetFromStart = offsetFromStart;
                    this.fileMark = this.multiPartFileStart[i];
                    this.fileMarkSectorByte = this.multiPartSectorByte[i];
                    this.uncheckedBytesUpToMarkPoint = this.multiPartUncheckedBytes[logRecord.multiPartID];
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "addBuffers", new Object[]{"truncateMarkSet", new Long(this.fileMark), new Byte(this.fileMarkSectorByte), new Long(this.uncheckedBytesUpToMarkPoint)});
                }
                this.uncheckedBytes -= this.uncheckedBytesUpToMarkPoint;
            }
            if (!checkSpace) {
                this.uncheckedBytes = this.uncheckedBytes + (long)totalBytes + 4L;
            }
            if (wrappedLogBuffer) {
                startFillingLogBuffer.wrapped();
            }
            endFillingLogBuffer = this.logBuffer;
            if (completed) {
                this.logSequenceNumber = returnLogSequenceNumber = endFillingLogBuffer.sequenceNumberOfFirstPage + (long)endPage;
                if (flush) {
                    endFillingLogBuffer.pageWaiterExists[endPage] = true;
                }
            }
            startFillingLogBuffer.pageWritersActive.incrementAndGet(startPage);
            this.nextFreeByteInLogBuffer = updatedNextFreeByteInLogBuffer;
            this.lastPageFilling = endPage;
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "addBuffers", new Object[]{"logBuffer_reserved", new Long(endFillingLogBuffer.sequenceNumberOfFirstPage), new Integer(this.firstPageFilling), new Integer(this.lastPageFilling), new Integer(reservedAddress), new Integer(startPage), new Integer(endPage), new Integer(nextToLastPageNotified), new Integer(startFillingLogBuffer.pageWritersActive.get(startPage))});
            }
        }
        this.addPart(logRecord, startFillingLogBuffer.buffer, completed, reservedAddress, totalBytes);
        long now = System.currentTimeMillis();
        this.writeCopyingMilliseconds += now - startWriteMilliseconds;
        startWriteMilliseconds = now;
        boolean startFlush = false;
        int iPage = startPage;
        while (true) {
            if (iPage == startFillingLogBuffer.numberOfPages) {
                iPage = 0;
                startFillingLogBuffer = this.logBuffer;
            }
            LogBuffer.PageStateLock pageStateLock = startFillingLogBuffer.pageStateLock[iPage];
            synchronized (pageStateLock) {
                if (!startFlush) {
                    startFillingLogBuffer.pageWritersActive.decrementAndGet(startPage);
                }
                if (iPage == this.lastPageFilling) {
                    break;
                }
                if (startFillingLogBuffer.pageWritersActive.get(iPage) == 0 && iPage == this.firstPageFilling) {
                    startFillingLogBuffer.pageFlushPending[iPage] = true;
                    this.firstPageFilling = this.firstPageFilling + 1 == startFillingLogBuffer.numberOfPages ? 0 : ++this.firstPageFilling;
                } else {
                    break;
                }
                startFlush = true;
            }
            ++iPage;
        }
        long now2 = System.currentTimeMillis();
        this.writeUpdateStateMilliseconds += now2 - startWriteMilliseconds;
        startWriteMilliseconds = now2;
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug((Object)this, cclass, "addBuffers", new Object[]{"firstPageFilling update done", new Integer(this.firstPageFilling), new Integer(this.lastPageFilling), new Integer(startPage), new Integer(endPage), new Integer(startFillingLogBuffer.pageWritersActive.get(startPage)), new Boolean(startFillingLogBuffer.pageFlushPending[startPage])});
        }
        if (startFlush) {
            this.flushHelper.startFlush();
        }
        if (flush && completed) {
            endFillingLogBuffer.waitForFlush(endPage);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "addBuffers", new Object[]{new Long(returnLogSequenceNumber)});
        }
        return returnLogSequenceNumber;
    }

    private int addPart(LogRecord logRecord, byte[] fillingBuffer, boolean completed, int offset, int partLength) throws ObjectManagerException {
        String methodName = "addPart";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addPart", new Object[]{logRecord, fillingBuffer, new Boolean(completed), new Integer(offset), new Integer(partLength)});
        }
        byte[] partHeader = new byte[]{completed ? (byte)2 : (logRecord.atStart() ? (byte)0 : 1), logRecord.multiPartID, (byte)(partLength >>> 8), (byte)(partLength >>> 0)};
        int remainder = 4096 - offset % 4096;
        int length = Math.min(remainder, 4);
        System.arraycopy(partHeader, 0, fillingBuffer, offset, length);
        offset += length;
        if (remainder <= 4) {
            ++offset;
        }
        if (offset >= fillingBuffer.length) {
            fillingBuffer = this.logBuffer.buffer;
            offset = 1;
        }
        if (length < 4) {
            System.arraycopy(partHeader, length, fillingBuffer, offset, 4 - length);
            offset = offset + 4 - length;
        }
        int bytesToAdd = Math.min(4096 - offset % 4096, partLength);
        while (true) {
            if (offset >= fillingBuffer.length) {
                fillingBuffer = this.logBuffer.buffer;
                offset = 1;
            }
            offset = logRecord.fillBuffer(fillingBuffer, offset, bytesToAdd);
            if ((partLength -= bytesToAdd) == 0) break;
            bytesToAdd = Math.min(4095, partLength);
            ++offset;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "addPart", new Object[]{new Integer(offset)});
        }
        return offset;
    }

    final long offsetFromStart(long address) {
        long offsetFromStart = address - this.fileLogHeader.startByteAddress;
        if (offsetFromStart <= 0L) {
            offsetFromStart = offsetFromStart + this.fileLogHeader.fileSize - 8192L;
        }
        return offsetFromStart;
    }

    @Override
    protected Map captureStatistics() {
        int n;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        Map statistics = super.captureStatistics();
        statistics.put("totalBytesWritten", Long.toString(this.totalBytesWritten));
        statistics.put("totalNumberOfFlushRequests", Long.toString(this.totalNumberOfFlushRequests));
        statistics.put("totalNumberOfLogBufferWrites", Long.toString(this.totalNumberOfLogBufferWrites));
        statistics.put("totalNumberOfThreadsFindingFullLogBuffers", Long.toString(this.totalNumberOfThreadsFindingFullLogBuffers));
        statistics.put("totalNumberOfFlusHelperWaits", Long.toString(this.totalNumberOfFlushHelperWaits));
        statistics.put("totalNumberOfLogCycles", Long.toString(this.totalNumberOfLogCycles));
        statistics.put("writeStalledMilliseconds", Long.toString(this.writeStalledMilliseconds));
        statistics.put("writeCopyingMilliseconds", Long.toString(this.writeCopyingMilliseconds));
        statistics.put("flushingMilliseconds", Long.toString(this.flushingMilliseconds));
        statistics.put("otherMilliseconds", Long.toString(this.otherMilliseconds));
        statistics.put("flushHelperWaitingMilliseconds", Long.toString(this.flushHelperWaitingMilliseconds));
        statistics.put("paddingStalledMilliseconds", Long.toString(this.paddingStalledMilliseconds));
        statistics.put("writeUpdateStatedMilliseconds", Long.toString(this.writeUpdateStateMilliseconds));
        statistics.put("logFullCheckpointsTriggered", Long.toString(this.logFullCheckpointsTriggered));
        statistics.put("uncheckedBytes", Long.toString(this.uncheckedBytes));
        statistics.put("uncheckedBytesUpToTruncatePoint", Long.toString(this.uncheckedBytesUpToMarkPoint));
        statistics.put("getLogFileSpaceLeft()", Long.toString(this.getLogFileSpaceLeft()));
        statistics.put("fileLogHeader.fileSize", Long.toString(this.fileLogHeader.fileSize));
        statistics.put("bufferFilePosition+nextFreeByteInLogBuffer", Long.toString(this.bufferFilePosition + (long)this.nextFreeByteInLogBuffer));
        statistics.put("stalledForMultiPartID", Long.toString(this.stalledForMultiPartID));
        statistics.put("totalPaddingBytesWritten", Long.toString(this.totalPaddingBytesWritten));
        statistics.put("totalPaddingRecords", Long.toString(this.totalPaddingRecords));
        String histogram = "(0-15 >15) ";
        for (n = 0; n < this.numberOfFlushWaitersFrequency.length; ++n) {
            histogram = histogram + this.numberOfFlushWaitersFrequency[n] + " ";
            this.numberOfFlushWaitersFrequency[n] = 0;
        }
        statistics.put("numberOfFlushWaitersFrequency", histogram);
        histogram = "(0-15 >15) ";
        for (n = 0; n < this.numberOfPagesWrittenFrequency.length; ++n) {
            histogram = histogram + this.numberOfPagesWrittenFrequency[n] + " ";
            this.numberOfPagesWrittenFrequency[n] = 0;
        }
        statistics.put("numberOfPagesWritttenFrequency", histogram);
        this.totalBytesWritten = 0L;
        this.totalNumberOfFlushRequests = 0L;
        this.totalNumberOfLogBufferWrites = 0L;
        this.totalNumberOfThreadsFindingFullLogBuffers = 0L;
        this.totalNumberOfFlushHelperWaits = 0L;
        this.totalNumberOfLogCycles = 0L;
        this.writeStalledMilliseconds = 0L;
        this.writeCopyingMilliseconds = 0L;
        this.flushingMilliseconds = 0L;
        this.otherMilliseconds = 0L;
        this.flushHelperWaitingMilliseconds = 0L;
        this.paddingStalledMilliseconds = 0L;
        this.writeUpdateStateMilliseconds = 0L;
        this.stalledForMultiPartID = 0L;
        this.totalPaddingBytesWritten = 0L;
        this.totalPaddingRecords = 0L;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", new Object[]{statistics});
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void simulateLogOutputFull(boolean isFull) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "simulateLogOutputFull", new Object[]{new Boolean(isFull)});
        }
        Object object = this.logFullReservedLock;
        synchronized (object) {
            if (isFull) {
                int numberOfZeros;
                this.objectManagerState.waitForCheckpoint(true);
                int zeroCount = numberOfZeros = 3;
                while (zeroCount > 0) {
                    long available = 0L;
                    LogBufferLock logBufferLock = this.logBufferLock;
                    synchronized (logBufferLock) {
                        available = this.getLogFileSpaceLeft();
                        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                            trace.debug((Object)this, cclass, "simulateLogOutputFull", new Object[]{new Long(available)});
                        }
                        if (this.reserveLogFileSpace(available) == 0L) {
                            this.logFullReserved += available;
                        }
                    }
                    if (available > 0L) {
                        this.flush();
                        zeroCount = numberOfZeros;
                        continue;
                    }
                    this.objectManagerState.waitForCheckpoint(true);
                    --zeroCount;
                }
            } else {
                this.reserveLogFileSpace(-this.logFullReserved);
                this.logFullReserved = 0L;
                this.flush();
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "simulateLogOutputFull", new Object[]{new Long(this.logFullReserved)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(PrintWriter printWriter) {
        FlushHelper flushHelper = this.flushHelper;
        synchronized (flushHelper) {
            NotifyHelper notifyHelper = this.notifyHelper;
            synchronized (notifyHelper) {
                LogBufferLock logBufferLock = this.logBufferLock;
                synchronized (logBufferLock) {
                    printWriter.println("State Dump for:" + cclass.getName() + " logFile=" + this.logFile + "(java.io.RandomaccessFile) fileLogHeader=" + this.fileLogHeader + "(FileLogHeader)\n filePosition=" + this.filePosition + "(long) filePositionSectorByte=" + this.filePositionSectorByte + "(byte) bufferFilePosition=" + this.bufferFilePosition + "(long) bufferSectorByte=" + this.bufferSectorByte + "(byte) fileSpaceLeft=" + this.fileSpaceLeft + "(long)");
                    printWriter.println(" firstPageToFlush=" + this.firstPageToFlush + "(int) lastPageNotified=" + this.lastPageNotified + "(int) nextPageToNotify=" + this.nextPageToNotify + "(int) firstPageFilling=" + this.firstPageFilling + "(int) lastPageFilling=" + this.lastPageFilling + "(int)\n nextFreeByteInLogBuffer=" + this.nextFreeByteInLogBuffer + "(int) newLogBufferPages=" + this.newLogBufferPages + "(int)");
                    printWriter.println();
                    this.logBuffer.print(printWriter);
                }
            }
        }
    }

    private class LogBufferLock {
        private LogBufferLock() {
        }
    }

    class LogBuffer {
        int numberOfPages;
        long sequenceNumberOfFirstPage;
        byte[] buffer;
        AtomicIntegerArray pageWritersActive;
        boolean[] pageFlushPending;
        boolean[] pageWaiterExists;
        int[] pageFlushWaiters;
        PageStateLock[] pageStateLock;
        PageWaitLock[] pageWaitLock;

        private LogBuffer(int numberOfPages) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{new Integer(numberOfPages)});
            }
            this.numberOfPages = numberOfPages;
            this.buffer = new byte[4096 * numberOfPages];
            this.pageWritersActive = new AtomicIntegerArrayImpl(numberOfPages);
            this.pageFlushPending = new boolean[numberOfPages];
            this.pageWaiterExists = new boolean[numberOfPages];
            this.pageFlushWaiters = new int[numberOfPages];
            this.pageStateLock = new PageStateLock[numberOfPages];
            this.pageWaitLock = new PageWaitLock[numberOfPages];
            for (int iPage = 0; iPage < numberOfPages; ++iPage) {
                this.pageWritersActive.set(iPage, 0);
                this.pageFlushPending[iPage] = false;
                this.pageWaiterExists[iPage] = false;
                this.pageFlushWaiters[iPage] = 0;
                this.pageStateLock[iPage] = new PageStateLock();
                this.pageWaitLock[iPage] = new PageWaitLock();
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        private void wrapped() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "wrapped", new Object[]{new Integer(FileLogOutput.this.newLogBufferPages), new Long(this.sequenceNumberOfFirstPage), new Long(FileLogOutput.this.bufferFilePosition)});
            }
            if (FileLogOutput.this.newLogBufferPages != 0) {
                FileLogOutput.this.logBuffer = new LogBuffer(FileLogOutput.this.newLogBufferPages);
                ((FileLogOutput)FileLogOutput.this).logBuffer.sequenceNumberOfFirstPage = this.sequenceNumberOfFirstPage + (long)this.numberOfPages;
                FileLogOutput.this.calculatePaddingSpaceTarget();
            } else {
                this.sequenceNumberOfFirstPage += (long)this.numberOfPages;
            }
            FileLogOutput.this.bufferFilePosition += (long)this.buffer.length;
            if (FileLogOutput.this.bufferFilePosition >= ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize) {
                FileLogOutput.this.bufferSectorByte = FileLogOutput.this.bufferSectorByte == 0 ? (byte)1 : 0;
                FileLogOutput.this.bufferFilePosition = FileLogOutput.this.bufferFilePosition - ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize + 8192L;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "wrapped", new Object[]{new Long(this.sequenceNumberOfFirstPage), new Long(FileLogOutput.this.bufferFilePosition)});
            }
        }

        private void write(int startPage, int endPage) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "write", new Object[]{new Integer(startPage), new Integer(endPage)});
            }
            if (startPage != endPage) {
                byte[] bufferToSet = this.buffer;
                int iPage = startPage;
                while (true) {
                    if (iPage == this.numberOfPages) {
                        iPage = 0;
                        bufferToSet = ((FileLogOutput)FileLogOutput.this).logBuffer.buffer;
                    }
                    if (iPage == endPage) break;
                    FileLogOutput.setSectorBits(bufferToSet, iPage * 4096, FileLogOutput.this.filePositionSectorByte);
                    ++iPage;
                }
                try {
                    if (endPage > startPage) {
                        FileLogOutput.this.logFile.write(this.buffer, startPage * 4096, (endPage - startPage) * 4096);
                        FileLogOutput.this.filePosition = FileLogOutput.this.filePosition + (long)((endPage - startPage) * 4096);
                    } else {
                        FileLogOutput.this.logFile.write(this.buffer, startPage * 4096, (this.numberOfPages - startPage) * 4096);
                        FileLogOutput.this.logFile.write(((FileLogOutput)FileLogOutput.this).logBuffer.buffer, 0, endPage * 4096);
                        FileLogOutput.this.filePosition = FileLogOutput.this.filePosition + (long)((this.numberOfPages - startPage + endPage) * 4096);
                    }
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "writeLogBuffer", exception, "1:2258:1.52");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "writeLogBuffer", exception);
                    }
                    throw new PermanentIOException((Object)this, exception);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "write", new Object[]{new Long(FileLogOutput.this.filePosition)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void waitForFlush(int page) throws ObjectManagerException {
            String methodName = "waitForFlush";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "waitForFlush", new Object[]{new Integer(page)});
            }
            FileLogOutput.this.totalNumberOfFlushRequests++;
            PageWaitLock pageWaitLock = this.pageWaitLock[page];
            synchronized (pageWaitLock) {
                if (this.pageWaiterExists[page]) {
                    int n = page;
                    this.pageFlushWaiters[n] = this.pageFlushWaiters[n] + 1;
                    if (page == FileLogOutput.this.firstPageFilling) {
                        FileLogOutput.this.flushHelper.startFlush();
                    }
                    if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                        trace.debug((Object)this, cclass, "waitForFlush", new Object[]{"wait:2314", new Integer(this.pageWritersActive.get(page))});
                    }
                    while (FileLogOutput.this.flushHelper.abnormalTerminationException == null) {
                        try {
                            this.pageWaitLock[page].wait();
                            break;
                        }
                        catch (InterruptedException exception) {
                            ObjectManager.ffdc.processException(this, cclass, "waitForFlush", exception, "1:2329:1.52");
                            if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) continue;
                            trace.event(this, cclass, "addBuffers", exception);
                        }
                    }
                }
            }
            if (FileLogOutput.this.flushHelper.abnormalTerminationException != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "waitForFlush", new Object[]{"via UnexpectedExceptionException", FileLogOutput.this.flushHelper.abnormalTerminationException});
                }
                throw new UnexpectedExceptionException((Object)this, FileLogOutput.this.flushHelper.abnormalTerminationException);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "waitForFlush", new Object[]{new Long(FileLogOutput.this.filePosition)});
            }
        }

        private void print(PrintWriter printWriter) {
            printWriter.println("LogBuffer numberOfPages=" + this.numberOfPages + "(int) sequenceNumberOfFirstPage=" + this.sequenceNumberOfFirstPage + "(long) buffer.length=" + this.buffer.length + "(int)");
            printWriter.println();
            printWriter.println("page\tWriters\tFlush\tWaiter\tFlush");
            printWriter.println(" \tActive\tPending\tExists\tWaiters");
            for (int i = 0; i < this.numberOfPages; ++i) {
                printWriter.println(i + "\t" + this.pageWritersActive.get(i) + "\t" + this.pageFlushPending[i] + "\t" + this.pageWaiterExists[i] + "\t" + this.pageFlushWaiters[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean getPageFlushPending(int pageToCheck) {
            String methodName = "getPageFlushPending";
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.entry((Object)this, cclass, methodName, new Integer(pageToCheck));
            }
            boolean pending = false;
            PageStateLock pageStateLock = this.pageStateLock[pageToCheck];
            synchronized (pageStateLock) {
                pending = this.pageFlushPending[pageToCheck];
            }
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.exit((Object)this, cclass, methodName, new Boolean(pending));
            }
            return pending;
        }

        private class PageStateLock {
            private PageStateLock() {
            }
        }

        private class PageWaitLock {
            private PageWaitLock() {
            }
        }
    }

    private class PaddingSpaceLock {
        private PaddingSpaceLock() {
        }
    }

    protected class FlushHelper
    implements Runnable {
        private boolean running = true;
        private boolean waiting = false;
        private volatile boolean flushActive = false;
        Thread flushThread = null;
        private Exception abnormalTerminationException = null;
        LogBuffer flushLogBuffer = FileLogOutput.access$1300(FileLogOutput.this);

        FlushHelper() {
            String methodName = "<init>";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            this.flushThread = new Thread(this);
            this.flushThread.setName("FlushHelper");
            this.flushThread.setPriority(6);
            this.flushThread.start();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                String methodName = "run";
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, cclass, "run");
                }
                FileLogOutput.this.lastFlushMilliseconds = System.currentTimeMillis();
                try {
                    while (this.running) {
                        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                            trace.debug((Object)this, cclass, "run", new Object[]{"flushLoop:2478", new Integer(FileLogOutput.this.firstPageToFlush), new Integer(FileLogOutput.this.firstPageFilling), new Integer(FileLogOutput.this.lastPageFilling)});
                        }
                        this.flushActive = false;
                        FlushHelper flushHelper = this;
                        synchronized (flushHelper) {
                            this.waiting = true;
                            while (!(this.flushLogBuffer.getPageFlushPending(FileLogOutput.this.firstPageToFlush) || this.flushLogBuffer.pageWaiterExists[FileLogOutput.this.firstPageToFlush] && FileLogOutput.this.firstPageToFlush == FileLogOutput.this.lastPageFilling && FileLogOutput.this.firstPageToFlush == FileLogOutput.this.nextPageToNotify)) {
                                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                    trace.debug((Object)this, cclass, "run", new Object[]{"flushLoop:2511 About to wait", new Integer(FileLogOutput.this.firstPageToFlush), new Integer(FileLogOutput.this.firstPageFilling), new Integer(FileLogOutput.this.lastPageFilling), new Integer(FileLogOutput.this.nextPageToNotify), new Boolean(this.flushLogBuffer.pageWaiterExists[FileLogOutput.this.firstPageToFlush]), new Boolean(this.flushLogBuffer.pageFlushPending[FileLogOutput.this.firstPageToFlush])});
                                }
                                if (!this.running) {
                                } else {
                                    this.wait();
                                    FileLogOutput.this.totalNumberOfFlushHelperWaits++;
                                    long now = System.currentTimeMillis();
                                    FileLogOutput.this.flushHelperWaitingMilliseconds += now - FileLogOutput.this.lastFlushMilliseconds;
                                    FileLogOutput.this.lastFlushMilliseconds = now;
                                    if (this.running) continue;
                                }
                                break block20;
                            }
                            this.waiting = false;
                        }
                        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                            trace.debug((Object)this, cclass, "run", new Object[]{"flushLoop:2546 woken", new Integer(FileLogOutput.this.firstPageToFlush), new Integer(FileLogOutput.this.firstPageFilling), new Integer(FileLogOutput.this.lastPageFilling), new Boolean(this.flushLogBuffer.pageWaiterExists[FileLogOutput.this.firstPageToFlush]), new Boolean(this.flushLogBuffer.pageFlushPending[FileLogOutput.this.firstPageToFlush])});
                        }
                        this.flushActive = true;
                        if (!this.flushLogBuffer.getPageFlushPending(FileLogOutput.this.firstPageToFlush) && FileLogOutput.this.firstPageToFlush == FileLogOutput.this.lastPageFilling) {
                            this.padLogBuffer();
                        }
                        int copyOfFirstPageFilling = FileLogOutput.this.firstPageFilling;
                        int copyOfFirstPageToFlush = FileLogOutput.this.firstPageToFlush;
                        this.performFlush(copyOfFirstPageFilling);
                        long now = System.currentTimeMillis();
                        FileLogOutput.this.flushingMilliseconds += now - FileLogOutput.this.lastFlushMilliseconds;
                        FileLogOutput.this.lastFlushMilliseconds = now;
                        if (FileLogOutput.this.firstPageToFlush != copyOfFirstPageToFlush) {
                            FileLogOutput.this.notifyHelper.doNotifyAll(copyOfFirstPageFilling);
                        }
                        now = System.currentTimeMillis();
                        FileLogOutput.this.otherMilliseconds += now - FileLogOutput.this.lastFlushMilliseconds;
                        FileLogOutput.this.lastFlushMilliseconds = now;
                    }
                }
                catch (Exception exception) {
                    ObjectManager.ffdc.processException(this, cclass, "run", exception, "1:2606:1.52");
                    if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                        trace.event(this, cclass, "run", exception);
                    }
                    this.running = false;
                    this.abnormalTerminationException = exception;
                    FileLogOutput.this.objectManagerState.requestShutdown();
                    try {
                        if (FileLogOutput.this.objectManagerState.inShutdown()) {
                            FileLogOutput.this.notifyHelper.doNotifyAll(FileLogOutput.this.firstPageFilling);
                        }
                    }
                    catch (ObjectManagerException e) {
                        ObjectManager.ffdc.processException(this, cclass, "run", e, "1:2633:1.52");
                        if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) break block20;
                        trace.event(this, cclass, "run", e);
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "run");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startFlush() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "startFlush");
            }
            if (this.abnormalTerminationException != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "startFlush", new Object[]{"via UnexpectedExceptionException", this.abnormalTerminationException});
                }
                throw new UnexpectedExceptionException((Object)this, this.abnormalTerminationException);
            }
            if (!this.running) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "startFlush", new Object[]{"via ThreadNotRunningException"});
                }
                throw new ThreadNotRunningException((Object)this, this.flushThread.getName(), "startFlush");
            }
            if (!this.flushActive) {
                FlushHelper flushHelper = this;
                synchronized (flushHelper) {
                    if (this.waiting) {
                        this.notify();
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "startFlush");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "shutdown");
            }
            FlushHelper flushHelper = this;
            synchronized (flushHelper) {
                this.running = false;
                if (this.waiting) {
                    this.notify();
                }
            }
            try {
                this.flushThread.join();
            }
            catch (InterruptedException exception) {
                ObjectManager.ffdc.processException(this, cclass, "shutdown", exception, "1:2714:1.52");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "shutdown", exception);
                }
                throw new UnexpectedExceptionException((Object)this, exception);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "shutdown");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void padLogBuffer() throws ObjectManagerException {
            String methodName = "padLogBuffer";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "padLogBuffer");
            }
            LogBufferLock logBufferLock = FileLogOutput.this.logBufferLock;
            synchronized (logBufferLock) {
                long now = System.currentTimeMillis();
                FileLogOutput.this.paddingStalledMilliseconds += now - FileLogOutput.this.lastFlushMilliseconds;
                FileLogOutput.this.lastFlushMilliseconds = now;
                if (!this.flushLogBuffer.getPageFlushPending(FileLogOutput.this.firstPageToFlush) && FileLogOutput.this.firstPageToFlush == FileLogOutput.this.lastPageFilling && FileLogOutput.this.firstPageToFlush == FileLogOutput.this.nextPageToNotify) {
                    int padding = 4096 - FileLogOutput.this.nextFreeByteInLogBuffer % 4096;
                    FileLogOutput.this.totalPaddingBytesWritten = FileLogOutput.this.totalPaddingBytesWritten + (long)padding;
                    FileLogOutput.this.totalPaddingRecords++;
                    FileLogOutput.this.paddingReserveLogSpace(padding);
                    int paddingLogRecordSize = padding - 4;
                    if (paddingLogRecordSize < 8) {
                        Arrays.fill(this.flushLogBuffer.buffer, FileLogOutput.this.nextFreeByteInLogBuffer, FileLogOutput.this.nextFreeByteInLogBuffer + padding, (byte)3);
                        FileLogOutput.this.nextFreeByteInLogBuffer = FileLogOutput.this.nextFreeByteInLogBuffer + padding;
                    } else {
                        PaddingLogRecord paddingLogRecord = new PaddingLogRecord(paddingLogRecordSize);
                        FileLogOutput.this.nextFreeByteInLogBuffer = FileLogOutput.this.addPart(paddingLogRecord, this.flushLogBuffer.buffer, true, FileLogOutput.this.nextFreeByteInLogBuffer, paddingLogRecordSize);
                    }
                    FileLogOutput.this.nextFreeByteInLogBuffer++;
                    if (FileLogOutput.this.nextFreeByteInLogBuffer >= this.flushLogBuffer.buffer.length) {
                        this.flushLogBuffer.wrapped();
                        FileLogOutput.this.nextFreeByteInLogBuffer = FileLogOutput.this.nextFreeByteInLogBuffer - this.flushLogBuffer.buffer.length;
                    }
                    FileLogOutput.this.lastPageFilling = FileLogOutput.this.nextFreeByteInLogBuffer / 4096;
                    LogBuffer.PageStateLock pageStateLock = this.flushLogBuffer.pageStateLock[FileLogOutput.this.firstPageToFlush];
                    synchronized (pageStateLock) {
                        if (this.flushLogBuffer.pageWritersActive.get(FileLogOutput.this.firstPageToFlush) == 0 && FileLogOutput.this.firstPageToFlush == FileLogOutput.this.firstPageFilling) {
                            this.flushLogBuffer.pageFlushPending[((FileLogOutput)FileLogOutput.this).firstPageToFlush] = true;
                            if (FileLogOutput.this.firstPageFilling + 1 == this.flushLogBuffer.numberOfPages) {
                                FileLogOutput.this.firstPageFilling = 0;
                            } else {
                                FileLogOutput.this.firstPageFilling++;
                            }
                        }
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "padLogBuffer", new Object[]{new Integer(FileLogOutput.this.firstPageToFlush), new Integer(FileLogOutput.this.firstPageFilling), new Integer(FileLogOutput.this.lastPageFilling), new Integer(this.flushLogBuffer.pageWritersActive.get(FileLogOutput.this.firstPageToFlush))});
            }
        }

        private final void performFlush(int flushFirstPageFilling) throws ObjectManagerException {
            int pagesToWrite;
            String methodName = "performFlush";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "performFlush", new Object[]{new Integer(FileLogOutput.this.firstPageToFlush), new Integer(flushFirstPageFilling), new Long(FileLogOutput.this.filePosition)});
            }
            if ((pagesToWrite = flushFirstPageFilling - FileLogOutput.this.firstPageToFlush) < 0) {
                pagesToWrite += this.flushLogBuffer.numberOfPages;
            }
            int bytesToWrite = pagesToWrite * 4096;
            FileLogOutput.this.totalNumberOfLogBufferWrites++;
            FileLogOutput.this.totalBytesWritten = FileLogOutput.this.totalBytesWritten + (long)bytesToWrite;
            if ((pagesToWrite & 0x7FFFFFF0) != 0) {
                int[] nArray = FileLogOutput.this.numberOfPagesWrittenFrequency;
                nArray[16] = nArray[16] + 1;
            } else {
                int[] nArray = FileLogOutput.this.numberOfPagesWrittenFrequency;
                int n = pagesToWrite & 0xF;
                nArray[n] = nArray[n] + 1;
            }
            boolean cycleLog = false;
            int endPage = flushFirstPageFilling;
            if (((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize - FileLogOutput.this.filePosition <= (long)bytesToWrite) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "performFlush", new Object[]{"cycle", new Byte(FileLogOutput.this.filePositionSectorByte)});
                }
                bytesToWrite = (int)(((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize - FileLogOutput.this.filePosition);
                endPage = FileLogOutput.this.firstPageToFlush + bytesToWrite / 4096;
                if (endPage >= this.flushLogBuffer.numberOfPages) {
                    endPage -= this.flushLogBuffer.numberOfPages;
                }
                cycleLog = true;
            }
            this.doWriteAndBufferCycle(FileLogOutput.this.firstPageToFlush, endPage);
            if (cycleLog) {
                FileLogOutput.this.filePositionSectorByte = FileLogOutput.this.filePositionSectorByte == 0 ? (byte)1 : 0;
                FileLogOutput.this.totalNumberOfLogCycles++;
                FileLogOutput.this.filePosition = 8192L;
                try {
                    FileLogOutput.this.logFile.seek(FileLogOutput.this.filePosition);
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "performFlush", exception, "1:2924:1.52");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "performFlush", exception);
                    }
                    throw new PermanentIOException((Object)this, exception);
                }
                this.doWriteAndBufferCycle(endPage, flushFirstPageFilling);
            }
            if (FileLogOutput.this.truncateRequested) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "performFlush", new Object[]{"truncate", new Long(FileLogOutput.this.fileMark), new Byte(FileLogOutput.this.fileMarkSectorByte)});
                }
                long fileSpaceRegained = FileLogOutput.this.offsetFromStart(FileLogOutput.this.fileMark) - 1L;
                ((FileLogOutput)FileLogOutput.this).fileLogHeader.startByteAddress = FileLogOutput.this.fileMark;
                ((FileLogOutput)FileLogOutput.this).fileLogHeader.sectorByte = FileLogOutput.this.fileMarkSectorByte;
                FileLogOutput.this.fileLogHeader.writeHeader(FileLogOutput.this.logFile);
                try {
                    FileLogOutput.this.logFile.seek(FileLogOutput.this.filePosition);
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "performFlush", exception, "1:2965:1.52");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "performFlush", exception);
                    }
                    throw new PermanentIOException((Object)this, exception);
                }
                FileLogOutput.this.paddingReserveLogSpace(FileLogOutput.this.uncheckedBytesUpToMarkPoint - fileSpaceRegained + fileSpaceRegained / 4096L);
                FileLogOutput.this.uncheckedBytesUpToMarkPoint = 0L;
                if (FileLogOutput.this.newFileSizeRequested) {
                    this.checkNewFileSizeRequest();
                }
                FileLogOutput.this.truncateRequested = false;
            }
            if (!((FileLogOutput)FileLogOutput.this).objectManagerState.nioAvailable) {
                try {
                    FileLogOutput.this.logFile.getFD().sync();
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "performFlush", exception, "1:2994:1.52");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "performFlush", exception);
                    }
                    throw new PermanentIOException((Object)this, exception);
                }
            }
            FileLogOutput.this.firstPageToFlush = flushFirstPageFilling;
            FileLogOutput.this.setFileSpaceLeft();
            this.checkOccupancy();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "performFlush", new Object[]{new Integer(FileLogOutput.this.firstPageToFlush), new Long(FileLogOutput.this.filePosition)});
            }
        }

        private void doWriteAndBufferCycle(int start, int end) throws ObjectManagerException {
            this.flushLogBuffer.write(start, end);
            if (end < start) {
                this.flushLogBuffer = FileLogOutput.this.logBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNewFileSizeRequest() throws ObjectManagerException {
            String methodName = "checkNewFileSizeRequest";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "checkNewFileSizeRequest", new Object[]{new Long(FileLogOutput.this.newFileSize), new Long(FileLogOutput.this.filePosition), new Long(((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize), new Byte(((FileLogOutput)FileLogOutput.this).fileLogHeader.sectorByte)});
            }
            LogBufferLock logBufferLock = FileLogOutput.this.logBufferLock;
            synchronized (logBufferLock) {
                if (((FileLogOutput)FileLogOutput.this).fileLogHeader.startByteAddress < FileLogOutput.this.filePosition) {
                    if (FileLogOutput.this.newFileSize < ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize) {
                        if (((FileLogOutput)FileLogOutput.this).fileLogHeader.startByteAddress < FileLogOutput.this.newFileSize && FileLogOutput.this.reserveLogFileSpace(-FileLogOutput.this.newFileSize + ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize + FileLogOutput.this.newFileSize / 4096L - ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize / 4096L) == 0L) {
                            FileLogOutput.this.newFileSizeRequested = false;
                            ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize = FileLogOutput.this.newFileSize;
                            FileLogOutput.this.fileLogHeader.writeHeader(FileLogOutput.this.logFile);
                            FileLogOutput.this.calculatePaddingSpaceTarget();
                            try {
                                FileLogOutput.this.logFile.seek(FileLogOutput.this.filePosition);
                                FileLogOutput.this.logFile.setLength(FileLogOutput.this.newFileSize);
                            }
                            catch (IOException exception) {
                                ObjectManager.ffdc.processException(this, cclass, "checkNewFileSizeRequest", exception, "1:3102:1.52");
                                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                    trace.exit((Object)this, cclass, "checkNewFileSizeRequest", exception);
                                }
                                throw new PermanentIOException((Object)this, exception);
                            }
                        }
                    } else {
                        FileLogOutput.this.newFileSizeRequested = false;
                        byte[] newPages = new byte[(int)Math.min(0x400000L, ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize)];
                        for (int istart = 0; istart < newPages.length; istart += 4096) {
                            if (((FileLogOutput)FileLogOutput.this).fileLogHeader.sectorByte == 0) {
                                FileLogOutput.setSectorBits(newPages, istart, (byte)1);
                                continue;
                            }
                            FileLogOutput.setSectorBits(newPages, istart, (byte)0);
                        }
                        try {
                            FileLogOutput.this.logFile.setLength(FileLogOutput.this.newFileSize);
                            FileLogOutput.this.logFile.seek(((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize);
                            for (long istart = ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize; istart < FileLogOutput.this.newFileSize; istart += (long)newPages.length) {
                                FileLogOutput.this.logFile.write(newPages, 0, (int)Math.min((long)newPages.length, FileLogOutput.this.newFileSize - istart));
                            }
                        }
                        catch (IOException exception) {
                            ObjectManager.ffdc.processException(this, cclass, "checkNewFileSizeRequest", exception, "1:3152:1.52");
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "checkNewFileSizeRequest", exception);
                            }
                            FileLogOutput.this.newFileSizeException = new PermanentIOException((Object)this, exception);
                            return;
                        }
                        FileLogOutput.this.reserveLogFileSpace(-FileLogOutput.this.newFileSize + ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize + FileLogOutput.this.newFileSize / 4096L - ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize / 4096L);
                        ((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize = FileLogOutput.this.newFileSize;
                        FileLogOutput.this.fileLogHeader.writeHeader(FileLogOutput.this.logFile);
                        FileLogOutput.this.calculatePaddingSpaceTarget();
                        try {
                            FileLogOutput.this.logFile.seek(FileLogOutput.this.filePosition);
                        }
                        catch (IOException exception) {
                            ObjectManager.ffdc.processException(this, cclass, "checkNewFileSizeRequest", exception, "1:3183:1.52");
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "checkNewFileSizeRequest", exception);
                            }
                            throw new PermanentIOException((Object)this, exception);
                        }
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "checkNewFileSizeRequest");
            }
        }

        private void checkOccupancy() throws ObjectManagerException {
            String methodName = "checkOccupancy";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "checkOccupancy", new Object[]{new Long(((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize)});
            }
            long fileSpaceLeft = FileLogOutput.this.getLogFileSpaceLeft();
            float occupancy = 1.0f - (float)fileSpaceLeft / (float)((FileLogOutput)FileLogOutput.this).fileLogHeader.fileSize;
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "checkOccupancy", new Object[]{new Long(fileSpaceLeft), new Float(occupancy), new Float(((FileLogOutput)FileLogOutput.this).objectManagerState.logFullTriggerCheckpointThreshold), new Float(((FileLogOutput)FileLogOutput.this).objectManagerState.logFullPostCheckpointThreshold)});
            }
            if (occupancy > ((FileLogOutput)FileLogOutput.this).objectManagerState.logFullPostCheckpointThreshold) {
                FileLogOutput.this.ocupancyHigh = true;
            } else {
                FileLogOutput.this.ocupancyHigh = false;
            }
            if (occupancy > ((FileLogOutput)FileLogOutput.this).objectManagerState.logFullTriggerCheckpointThreshold) {
                FileLogOutput.this.objectManagerState.suggestCheckpoint(true);
                FileLogOutput.this.logFullCheckpointsTriggered++;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "checkOccupancy");
            }
        }
    }

    protected class NotifyHelper
    implements Runnable {
        private boolean running = true;
        private boolean waiting = false;
        Thread notifyThread = null;
        private Exception abnormalTerminationException = null;
        private int requestedFirstPageFilling = 0;
        LogBuffer notifyLogBuffer = FileLogOutput.access$1300(FileLogOutput.this);

        NotifyHelper() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            this.notifyThread = new Thread(this);
            this.notifyThread.setName("NotifyHelper");
            this.notifyThread.setPriority(6);
            FileLogOutput.this.lastPageNotified = this.notifyLogBuffer.numberOfPages - 1;
            FileLogOutput.this.nextPageToNotify = 0;
            this.notifyThread.start();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block23: {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, cclass, "run");
                }
                try {
                    while (true) {
                        Object object = this;
                        synchronized (object) {
                            while (FileLogOutput.this.nextPageToNotify == this.requestedFirstPageFilling) {
                                if (!this.running) {
                                    break block23;
                                }
                                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                    trace.debug((Object)this, cclass, "run", new Object[]{"waitLoop:3320", new Integer(FileLogOutput.this.nextPageToNotify), new Integer(this.requestedFirstPageFilling)});
                                }
                                this.waiting = true;
                                this.wait();
                                this.waiting = false;
                            }
                        }
                        while (FileLogOutput.this.nextPageToNotify != this.requestedFirstPageFilling) {
                            object = this.notifyLogBuffer.pageWaitLock[FileLogOutput.this.nextPageToNotify];
                            synchronized (object) {
                                int waiters;
                                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                    trace.debug((Object)this, cclass, "run", new Object[]{"notifyLoop:3340", new Integer(FileLogOutput.this.nextPageToNotify), new Boolean(this.notifyLogBuffer.pageWaiterExists[FileLogOutput.this.nextPageToNotify])});
                                }
                                this.notifyLogBuffer.pageFlushPending[((FileLogOutput)FileLogOutput.this).nextPageToNotify] = false;
                                if (this.notifyLogBuffer.pageWaiterExists[FileLogOutput.this.nextPageToNotify]) {
                                    this.notifyLogBuffer.pageWaitLock[FileLogOutput.this.nextPageToNotify].notifyAll();
                                    this.notifyLogBuffer.pageWaiterExists[((FileLogOutput)FileLogOutput.this).nextPageToNotify] = false;
                                }
                                if (((waiters = this.notifyLogBuffer.pageFlushWaiters[FileLogOutput.this.nextPageToNotify]) & 0x7FFFFFF0) != 0) {
                                    int[] nArray = FileLogOutput.this.numberOfFlushWaitersFrequency;
                                    nArray[16] = nArray[16] + 1;
                                } else {
                                    int[] nArray = FileLogOutput.this.numberOfFlushWaitersFrequency;
                                    int n = waiters & 0xF;
                                    nArray[n] = nArray[n] + 1;
                                }
                                this.notifyLogBuffer.pageFlushWaiters[((FileLogOutput)FileLogOutput.this).nextPageToNotify] = 0;
                            }
                            FileLogOutput.this.lastPageNotified = FileLogOutput.this.nextPageToNotify;
                            FileLogOutput.this.nextPageToNotify++;
                            if (FileLogOutput.this.nextPageToNotify != this.notifyLogBuffer.numberOfPages) continue;
                            FileLogOutput.this.nextPageToNotify = 0;
                            if (this.notifyLogBuffer == FileLogOutput.this.logBuffer) continue;
                            object = FileLogOutput.this.logBufferLock;
                            synchronized (object) {
                                this.notifyLogBuffer = FileLogOutput.this.logBuffer;
                                FileLogOutput.this.newLogBufferPages = 0;
                            }
                        }
                        if (!this.notifyLogBuffer.pageWaiterExists[FileLogOutput.this.nextPageToNotify]) continue;
                        FileLogOutput.this.flushHelper.startFlush();
                    }
                }
                catch (Exception exception) {
                    ObjectManager.ffdc.processException(this, cclass, "run", exception, "1:3390:1.52");
                    if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                        trace.event(this, cclass, "run", exception);
                    }
                    this.running = false;
                    this.abnormalTerminationException = exception;
                    FileLogOutput.this.objectManagerState.requestShutdown();
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "run");
            }
        }

        synchronized void doNotifyAll(int requestedFirstPageFilling) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "doNotifyAll", new Object[]{new Integer(requestedFirstPageFilling), new Boolean(this.waiting)});
            }
            if (this.abnormalTerminationException != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "doNotifyAll", new Object[]{"via UnexpectedExceptionException", this.abnormalTerminationException});
                }
                throw new UnexpectedExceptionException((Object)this, this.abnormalTerminationException);
            }
            if (!this.running) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "doNotifyAll", new Object[]{"via ThreadNotRunningException"});
                }
                throw new ThreadNotRunningException((Object)this, this.notifyThread.getName(), "startFlush");
            }
            this.requestedFirstPageFilling = requestedFirstPageFilling;
            if (this.waiting) {
                this.notify();
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "doNotifyAll");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "shutdown");
            }
            NotifyHelper notifyHelper = this;
            synchronized (notifyHelper) {
                this.running = false;
                this.notify();
            }
            try {
                this.notifyThread.join();
            }
            catch (InterruptedException exception) {
                ObjectManager.ffdc.processException(this, cclass, "shutdown", exception, "1:3470:1.52");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "shutdown", exception);
                }
                throw new UnexpectedExceptionException((Object)this, exception);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "shutdown");
            }
        }
    }
}

