/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;

public final class ItemMap
implements Map,
XmlConstants {
    private final int _capacityMask;
    private final Entry[] _entry;
    private final Lock[] _lock;
    private int _size;

    ItemMap(int magnitude) {
        if (magnitude > 30) {
            magnitude = 30;
        } else if (magnitude < 8) {
            magnitude = 8;
        }
        int capacity = 2 << magnitude;
        this._entry = new Entry[capacity];
        this._lock = new Lock[capacity];
        this._capacityMask = capacity - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Lock _getLock(int i) {
        Lock lock = this._lock[i];
        if (null != lock) return lock;
        Lock[] lockArray = this._lock;
        synchronized (this._lock) {
            this._lock[i] = lock = new Lock();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return lock;
        }
    }

    private int _indexOfKey(long key) {
        int i = (int)(key & (long)this._capacityMask);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AbstractItemLink get(long key) {
        AbstractItemLink link = null;
        int i = this._indexOfKey(key);
        Lock lock = this._getLock(i);
        synchronized (lock) {
            Entry entry = this._entry[i];
            while (null == link && null != entry) {
                if (key == entry.id) {
                    link = entry.link;
                    continue;
                }
                entry = entry.next;
            }
        }
        return link;
    }

    public final int getSize() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(long key, AbstractItemLink link) {
        int i = this._indexOfKey(key);
        Lock lock = this._getLock(i);
        synchronized (lock) {
            Entry newEntry;
            Entry nextEntry = this._entry[i];
            this._entry[i] = newEntry = new Entry(key, link, nextEntry);
            ++this._size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AbstractItemLink remove(long key) {
        AbstractItemLink link = null;
        int i = this._indexOfKey(key);
        Lock lock = this._getLock(i);
        synchronized (lock) {
            Entry previousEntry;
            Entry thisEntry = previousEntry = this._entry[i];
            while (null != thisEntry && null == link) {
                Entry nextEntry = thisEntry.next;
                if (key == thisEntry.id) {
                    link = thisEntry.link;
                    --this._size;
                    if (previousEntry == thisEntry) {
                        this._entry[i] = nextEntry;
                    } else {
                        previousEntry.next = nextEntry;
                    }
                }
                previousEntry = thisEntry;
                thisEntry = nextEntry;
            }
        }
        return link;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this._entry.length; ++i) {
            this._entry[i] = null;
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.startTag("itemMap");
        writer.indent();
        for (int i = 0; i < this._entry.length; ++i) {
            Entry entry = this._entry[i];
            while (null != entry) {
                AbstractItemLink ail = entry.link;
                writer.newLine();
                ail.xmlShortWriteOn(writer);
                entry = entry.next;
            }
        }
        writer.outdent();
        writer.newLine();
        writer.endTag("itemMap");
    }

    private static final class Entry {
        private final long id;
        private final AbstractItemLink link;
        private Entry next;

        Entry(long i, AbstractItemLink l, Entry n) {
            this.link = l;
            this.next = n;
            this.id = i;
        }

        public String toString() {
            return "" + this.id + "=" + this.link;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

