/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.persistence.RangeManager;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;

public class UniqueKeyGeneratorImpl
implements UniqueKeyGenerator {
    private static TraceComponent tc = SibTr.register(UniqueKeyGeneratorImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private String _name;
    private long _range;
    private long _midrange;
    private long _globalUnique;
    private long _globalUniqueLimit;
    private long _globalUniqueThreshold;
    private final GlobalUniqueLock _globalUniqueLock = new GlobalUniqueLock();
    private long _instanceUnique = -100L;
    private final InstanceUniqueLock _instanceUniqueLock = new InstanceUniqueLock();
    private RangeManager _globalUniqueManager;

    public UniqueKeyGeneratorImpl(RangeManager rangeManager, String name, long range) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)("RangeManager=" + rangeManager + ", Name=" + name + ", Range=" + range));
        }
        this._name = name;
        this._range = range;
        this._midrange = this._range >> 1;
        this._globalUniqueManager = rangeManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        GlobalUniqueLock globalUniqueLock = this._globalUniqueLock;
        synchronized (globalUniqueLock) {
            this._globalUnique = this._globalUniqueManager.entryExists(this) ? this._globalUniqueManager.updateEntry(this) : this._globalUniqueManager.addEntry(this);
            this._globalUniqueThreshold = this._globalUnique + this._midrange;
            this._globalUniqueLimit = this._globalUnique + this._range;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public long getRange() {
        return this._range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUniqueValue() throws PersistenceException {
        long retval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUniqueValue");
        }
        GlobalUniqueLock globalUniqueLock = this._globalUniqueLock;
        synchronized (globalUniqueLock) {
            if (this._globalUnique == this._globalUniqueThreshold) {
                this._globalUniqueManager.scheduleUpdate(this);
            } else if (this._globalUnique == this._globalUniqueLimit) {
                this._globalUniqueManager.updateEntry(this);
                this.nextRangeMaximumAvailable();
            }
            retval = this._globalUnique++;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUniqueValue", (Object)("return=" + retval));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextRangeMaximumAvailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextRangeMaximumAvailable");
        }
        GlobalUniqueLock globalUniqueLock = this._globalUniqueLock;
        synchronized (globalUniqueLock) {
            this._globalUniqueThreshold = this._globalUniqueLimit + this._midrange;
            this._globalUniqueLimit += this._range;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextRangeMaximumAvailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPerInstanceUniqueValue() {
        long retval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPerInstanceUniqueValue");
        }
        InstanceUniqueLock instanceUniqueLock = this._instanceUniqueLock;
        synchronized (instanceUniqueLock) {
            retval = this._instanceUnique--;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPerInstanceUniqueValue", (Object)("return=" + retval));
        }
        return retval;
    }

    private static final class GlobalUniqueLock {
        private GlobalUniqueLock() {
        }
    }

    private static final class InstanceUniqueLock {
        private InstanceUniqueLock() {
        }
    }
}

