/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.crypto.ltpakeyutil.LTPACrypto;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyPair;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import java.security.MessageDigest;

final class LTPADigSignature {
    static int keySize = CryptoUtils.isFips140_3Enabled() ? 256 : 128;
    static byte[][] testRawPubKey = null;
    static byte[][] testRawPrivKey = null;
    static MessageDigest md1 = CryptoUtils.getMessageDigestForLTPA();
    private static Object lockObj1 = new Object();
    static long created = 0L;
    static long cacheHits = 0L;

    static void generateRSAKeys(byte[][] rsaPubKey, byte[][] rsaPrivKey) {
        byte[][] rsaKey = LTPACrypto.rsaKey(keySize, true, true);
        rsaPrivKey[0] = rsaKey[0];
        rsaPrivKey[2] = rsaKey[2];
        rsaPrivKey[4] = rsaKey[3];
        rsaPrivKey[3] = rsaKey[4];
        rsaPrivKey[5] = rsaKey[5];
        rsaPrivKey[6] = rsaKey[6];
        rsaPrivKey[7] = rsaKey[7];
        rsaPubKey[0] = rsaKey[0];
        rsaPubKey[1] = rsaKey[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean verify(byte[] mesg, byte[] signature, LTPAPublicKey pubKey) throws Exception {
        byte[] data;
        byte[][] rsaPubKey = pubKey.getRawKey();
        Object object = lockObj1;
        synchronized (object) {
            data = md1.digest(mesg);
        }
        return LTPACrypto.verifyISO9796(rsaPubKey, data, 0, data.length, signature, 0, signature.length);
    }

    static LTPAKeyPair generateLTPAKeyPair() {
        byte[][] rsaPubKey = new byte[2][];
        byte[][] rsaPrivKey = new byte[8][];
        LTPADigSignature.generateRSAKeys(rsaPubKey, rsaPrivKey);
        LTPAPublicKey pubKey = new LTPAPublicKey(rsaPubKey);
        LTPAPrivateKey privKey = new LTPAPrivateKey(rsaPrivKey);
        return new LTPAKeyPair(pubKey, privKey);
    }
}

