/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.common.crypto.CryptoUtils;
import java.security.PublicKey;

public final class LTPAPublicKey
implements PublicKey {
    private static final boolean fipsEnabled = CryptoUtils.isFips140_3Enabled();
    private static final long serialVersionUID = 6585779055758956436L;
    private static final int MODULUS = 0;
    private static final int EXPONENT = 1;
    private static final int MODULUS_LENGTH = fipsEnabled ? 257 : 129;
    private static final int EXPONENT_LENGTH = 3;
    private final byte[][] rawKey;
    private final byte[] encodedKey;

    LTPAPublicKey(byte[][] rawKey) {
        this.rawKey = rawKey;
        this.encodedKey = this.encode();
    }

    public LTPAPublicKey(byte[] encodedKey) {
        this.encodedKey = (byte[])encodedKey.clone();
        this.rawKey = this.decode(encodedKey);
    }

    private byte[][] decode(byte[] encodedPublicKey) {
        byte[][] decodedKey = new byte[][]{new byte[MODULUS_LENGTH], new byte[3]};
        System.arraycopy(encodedPublicKey, 0, decodedKey[0], 0, MODULUS_LENGTH);
        System.arraycopy(encodedPublicKey, MODULUS_LENGTH, decodedKey[1], 0, 3);
        return decodedKey;
    }

    private byte[] encode() {
        int publicKeyLength = MODULUS_LENGTH + 3;
        byte[] encodedPublicKey = new byte[publicKeyLength];
        System.arraycopy(this.rawKey[0], 0, encodedPublicKey, 0, MODULUS_LENGTH);
        System.arraycopy(this.rawKey[1], 0, encodedPublicKey, MODULUS_LENGTH, 3);
        return encodedPublicKey;
    }

    @Override
    public final String getAlgorithm() {
        return fipsEnabled ? "RSA/SHA-256" : "RSA/SHA-1";
    }

    @Override
    public final byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public final String getFormat() {
        return "LTPAFormat";
    }

    protected final byte[][] getRawKey() {
        if (this.rawKey == null) {
            return null;
        }
        return (byte[][])this.rawKey.clone();
    }
}

