/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;

class StringFieldDescriptor
extends FieldDescriptor {
    StringFieldDescriptor(Class owner, Class type, String name, Field f, TypeRepository repository) {
        super(owner, type, name, f, repository);
    }

    @Override
    public void read(ObjectReader reader, Object obj) throws IOException {
        try {
            String value = (String)reader.readValueObject();
            this.field.set(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    public void write(ObjectWriter writer, Object obj) throws IOException {
        try {
            writer.writeValueObject(this.field.get(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void copyState(Object orig, Object copy, CopyState state) {
        try {
            this.field.set(copy, this.field.get(orig));
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        String value = (String)reader.readValueObject();
        map.put(this.java_name, value);
    }

    @Override
    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        String value = (String)map.get(this.java_name);
        writer.writeValueObject(value);
    }
}

