/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.SecureClassLoader;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.StubHandler;
import org.apache.yoko.rmi.util.stub.BCELClassBuilder;
import org.apache.yoko.rmi.util.stub.MethodRef;
import org.apache.yoko.rmi.util.stub.Stub;
import org.apache.yoko.rmi.util.stub.Util;
import org.apache.yoko.util.PrivilegedActions;

public final class StubClass {
    static final Logger LOGGER = Logger.getLogger(StubClass.class.getName());
    static final AtomicInteger counter = new AtomicInteger();

    private static MethodRef[] getMethodRefs(Class<?> type) {
        return (MethodRef[])AccessController.doPrivileged(PrivilegedActions.action(() -> BCELClassBuilder.collectMethods(RMIStub.class, type)));
    }

    private static ClassLoader chooseLoader(ClassLoader loader, Class<?> type) {
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        loaders.add(StubClass.getClassLoader(Stub.class));
        loaders.add(StubClass.getClassLoader(StubInvokeMethodHolder.STUB_INVOKE_METHOD.getDeclaringClass()));
        Optional.ofNullable(loader).ifPresent(loaders::add);
        Optional.of(RMIStub.class).map(StubClass::getClassLoader).ifPresent(loaders::add);
        Optional.of(type).map(StubClass::getClassLoader).ifPresent(loaders::add);
        if (loaders.isEmpty()) {
            return null;
        }
        if (loaders.size() == 1) {
            return (ClassLoader)loaders.iterator().next();
        }
        return (ClassLoader)AccessController.doPrivileged(PrivilegedActions.action(() -> new MetaLoader(loaders)));
    }

    private static ClassLoader getClassLoader(Class<?> c) {
        return (ClassLoader)AccessController.doPrivileged(PrivilegedActions.getClassLoader(c));
    }

    public static <S extends Stub> Class<S> make(Class<?> type, MethodDescriptor[] descriptors, MethodRef[] methods, ClassLoader loader) {
        loader = StubClass.chooseLoader(loader, type);
        methods = Optional.ofNullable(methods).orElseGet(() -> StubClass.getMethodRefs(type));
        MethodRef handler = new MethodRef(StubInvokeMethodHolder.STUB_INVOKE_METHOD);
        String className = StubClass.stubClassName(Util.getPackageName(type));
        return BCELClassBuilder.makeStub(loader, type, methods, descriptors, handler, className);
    }

    static String stubClassName(String packageName) {
        if (packageName == null) {
            packageName = "org.apache.yoko.rmi.util.stub.gen";
        }
        return packageName + ".Stub$$" + counter.getAndIncrement();
    }

    static final class StubInvokeMethodHolder
    extends Enum<StubInvokeMethodHolder> {
        static final Method STUB_INVOKE_METHOD;
        private static final /* synthetic */ StubInvokeMethodHolder[] $VALUES;

        public static StubInvokeMethodHolder[] values() {
            return (StubInvokeMethodHolder[])$VALUES.clone();
        }

        public static StubInvokeMethodHolder valueOf(String name) {
            return Enum.valueOf(StubInvokeMethodHolder.class, name);
        }

        private static /* synthetic */ StubInvokeMethodHolder[] $values() {
            return new StubInvokeMethodHolder[0];
        }

        static {
            $VALUES = StubInvokeMethodHolder.$values();
            try {
                STUB_INVOKE_METHOD = (Method)AccessController.doPrivileged(PrivilegedActions.getDeclaredMethod(StubHandler.class, (String)"invoke", (Class[])new Class[]{RMIStub.class, MethodDescriptor.class, Object[].class}));
            }
            catch (PrivilegedActionException ex) {
                throw (Error)VerboseLogging.wrapped((Logger)LOGGER, (Throwable)ex, (String)("cannot initialize: \n" + ex.getMessage()), e -> new Error((Throwable)e));
            }
        }
    }

    static class MetaLoader
    extends SecureClassLoader {
        private final Iterable<ClassLoader> loaders;

        MetaLoader(Iterable<ClassLoader> loaders) {
            assert (loaders.iterator().hasNext());
            this.loaders = loaders;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Throwable mainException = null;
            for (ClassLoader loader : this.loaders) {
                try {
                    return null == loader ? this.loadSystemClass(name) : loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (null == mainException) {
                        mainException = new ClassNotFoundException(name);
                    }
                    mainException.addSuppressed(e);
                }
            }
            assert (mainException != null);
            throw mainException;
        }

        private Class<?> loadSystemClass(String name) throws ClassNotFoundException {
            return super.loadClass(name);
        }
    }
}

