/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.api.jms.impl.JmsManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.api.jmsra.JmsJcaActivationSpec;
import com.ibm.ws.sib.api.jmsra.JmsraConstants;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaEndpointInvokerImpl;
import com.ibm.ws.sib.ra.inbound.SibRaDurableSubscriptionSharing;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfigurationProvider;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.SibRaMessageDeletionMode;
import com.ibm.ws.sib.ra.inbound.SibRaReadAhead;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SelectorDomain;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class JmsJcaActivationSpecImpl
implements JmsJcaActivationSpec,
SibRaEndpointConfigurationProvider,
FFDCSelfIntrospectable {
    private transient ResourceAdapter _resourceAdapter;
    private String _destinationLookup;
    private String _connectionFactoryLookup;
    private String _userName;
    private String _password;
    private Destination _destination;
    private String _destinationName;
    private String _durableSubscriptionHome;
    private String _destinationType;
    private String _topicSpace;
    private String _messageSelector;
    private String _acknowledgeMode = "Auto-acknowledge";
    private String _subscriptionDurability = "NonDurable";
    private String _shareDurableSubscriptions = "NeverShared";
    private String _clientId;
    private String _subscriptionName;
    private Integer _maxBatchSize = DEFAULT_MAX_BATCH_SIZE;
    private Integer _maxConcurrency = DEFAULT_MAX_CONCURRENCY;
    private String _busName = "defaultBus";
    private Boolean _shareDataSourceWithCMP = Boolean.FALSE;
    private String _targetTransportChain;
    private String _readAhead = "Default";
    private String _providerEndpoints;
    private String _targetTransport;
    private Boolean _useServerSubject = Boolean.FALSE;
    private String _target;
    private String _targetType = "ME";
    private String _targetSignificance = "Required";
    private Boolean _alwaysActivateAllMDBs = Boolean.FALSE;
    private Integer _retryInterval = 30;
    private Long _failingMessageDelay = 0L;
    static final String QUEUE = "jakarta.jms.Queue";
    static final String TOPIC = "jakarta.jms.Topic";
    static final String AUTO_ACKNOWLEDGE = "Auto-acknowledge";
    static final String DUPS_OK_ACKNOWLEDGE = "Dups-ok-acknowledge";
    private static final String DEFAULT_ACKNOWLEDGE_MODE = "Auto-acknowledge";
    static final String DURABLE = "Durable";
    static final String DURABLE_SHARED = "DurableShared";
    static final String NON_DURABLE = "NonDurable";
    static final String NON_DURABLE_SHARED = "NonDurableShared";
    private static final String DEFAULT_DURABILITY = "NonDurable";
    private static final Integer DEFAULT_MAX_BATCH_SIZE = 1;
    private static final Integer DEFAULT_MAX_CONCURRENCY = 5;
    private static final int DEFAULT_RETRY_INTERVAL = 30;
    private static final long DEFAULT_FAILING_MESSAGE_DELAY = 0L;
    private Integer _maxSequentialMessageFailure = -1;
    private Integer _autoStopSequentialMessageFailure = 0;
    private String _consumerDoesNotModifyPayloadAfterGet = "false";
    private String _forwarderDoesNotModifyPayloadAfterSet = "false";
    private static final long serialVersionUID = -7593258810211123494L;
    private static final TraceComponent TRACE = SibTr.register(JmsJcaActivationSpecImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String CLASS_NAME = JmsJcaActivationSpecImpl.class.getName();

    @Override
    public String getUserName() {
        return this._userName;
    }

    @Override
    public void setUserName(String userName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setUserName", (Object)userName);
        }
        this._userName = userName;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setPassword", (Object)"***");
        }
        this._password = password;
    }

    @Override
    public Destination getDestination() {
        return this._destination;
    }

    @Override
    public void setDestination(Destination destination) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDestination", (Object)destination);
        }
        this._destination = destination;
    }

    @Override
    public String getDestinationName() {
        return this._destinationName;
    }

    @Override
    public void setDestinationName(String destinationName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDestinationName", (Object)destinationName);
        }
        this._destinationName = destinationName;
        this.dynamicallyCreateDestination();
    }

    public String getTopicSpace() {
        return this._topicSpace;
    }

    public void setTopicSpace(String topicSpace) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTopicSpace", (Object)topicSpace);
        }
        this._topicSpace = topicSpace;
        this.dynamicallyCreateDestination();
    }

    @Override
    public String getDestinationType() {
        return this._destinationType;
    }

    @Override
    public void setDestinationType(String destinationType) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDestinationType", (Object)destinationType);
        }
        this._destinationType = destinationType;
        this.dynamicallyCreateDestination();
    }

    @Override
    public String getMessageSelector() {
        return this._messageSelector;
    }

    @Override
    public void setMessageSelector(String messageSelector) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMessageSelector", (Object)messageSelector);
        }
        this._messageSelector = messageSelector;
    }

    @Override
    public String getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    @Override
    public void setAcknowledgeMode(String acknowledgeMode) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setAcknowledgeMode", (Object)acknowledgeMode);
        }
        this._acknowledgeMode = acknowledgeMode;
    }

    @Override
    public String getSubscriptionDurability() {
        return this._subscriptionDurability;
    }

    @Override
    public void setSubscriptionDurability(String subscriptionDurability) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setSubscriptionDurability", (Object)subscriptionDurability);
        }
        this._subscriptionDurability = subscriptionDurability;
    }

    @Override
    public String getDurableSubscriptionHome() {
        return this._durableSubscriptionHome;
    }

    @Override
    public void setDurableSubscriptionHome(String durableSubscriptionHome) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDurableSubscriptionHome", (Object)durableSubscriptionHome);
        }
        this._durableSubscriptionHome = durableSubscriptionHome;
    }

    @Override
    public String getShareDurableSubscriptions() {
        return this._shareDurableSubscriptions;
    }

    @Override
    public void setShareDurableSubscriptions(String shareDurableSubscriptions) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"shareDurableSubscriptions", (Object)shareDurableSubscriptions);
        }
        this._shareDurableSubscriptions = shareDurableSubscriptions;
    }

    @Override
    public void setShareDurableSubscription(Boolean shareDurSubs) {
        if (shareDurSubs.booleanValue()) {
            this.setShareDurableSubscriptions("AlwaysShared");
        } else {
            this.setShareDurableSubscriptions("NeverShared");
        }
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public void setClientId(String clientId) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setClientId", (Object)clientId);
        }
        this._clientId = clientId;
    }

    @Override
    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    @Override
    public void setSubscriptionName(String subscriptionName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setSubscriptionName", (Object)subscriptionName);
        }
        this._subscriptionName = subscriptionName;
    }

    @Override
    public Integer getMaxBatchSize() {
        return this._maxBatchSize;
    }

    @Override
    public void setMaxBatchSize(Integer maxBatchSize) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMaxBatchSize", (Object)maxBatchSize);
        }
        this._maxBatchSize = maxBatchSize;
    }

    @Override
    public void setMaxBatchSize(String maxBatchSize) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMaxBatchSize", (Object)maxBatchSize);
        }
        this._maxBatchSize = maxBatchSize == null ? null : Integer.valueOf(maxBatchSize);
    }

    @Override
    public Integer getMaxConcurrency() {
        return this._maxConcurrency;
    }

    @Override
    public void setMaxConcurrency(Integer maxConcurrency) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMaxConcurrency", (Object)maxConcurrency);
        }
        this._maxConcurrency = maxConcurrency;
    }

    @Override
    public void setMaxConcurrency(String maxConcurrency) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMaxConcurrency", (Object)maxConcurrency);
        }
        this._maxConcurrency = maxConcurrency == null ? null : Integer.valueOf(maxConcurrency);
    }

    @Override
    public String getBusName() {
        return this._busName;
    }

    @Override
    public void setBusName(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setBusName", (Object)busName);
        }
        this._busName = busName;
    }

    @Override
    public void setShareDataSourceWithCMP(Boolean sharing) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setShareDataSourceWithCMP", (Object)sharing);
        }
        this._shareDataSourceWithCMP = sharing;
    }

    @Override
    public Boolean getShareDataSourceWithCMP() {
        return this._shareDataSourceWithCMP;
    }

    @Override
    public void setTargetTransportChain(String targetTransportChain) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetTransportChain", (Object)targetTransportChain);
        }
        this._targetTransportChain = targetTransportChain;
    }

    @Override
    public String getTargetTransportChain() {
        return this._targetTransportChain;
    }

    @Override
    public void setUseServerSubject(Boolean useServerSubject) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setUseServerSubject", (Object)useServerSubject);
        }
        this._useServerSubject = useServerSubject;
    }

    @Override
    public Boolean getUseServerSubject() {
        return this._useServerSubject;
    }

    @Override
    public void setReadAhead(String readAhead) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setReadAhead", (Object)readAhead);
        }
        this._readAhead = readAhead;
    }

    @Override
    public String getReadAhead() {
        return this._readAhead;
    }

    public ResourceAdapter getResourceAdapter() {
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setResourceAdapter", (Object)resourceAdapter);
        }
        this._resourceAdapter = resourceAdapter;
    }

    @Override
    public void setTarget(String target) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTarget", (Object)target);
        }
        this._target = target;
    }

    @Override
    public String getTarget() {
        return this._target;
    }

    @Override
    public void setTargetType(String targetType) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetType", (Object)targetType);
        }
        this._targetType = targetType;
    }

    @Override
    public String getTargetType() {
        return this._targetType;
    }

    @Override
    public void setTargetSignificance(String targetSignificance) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetSignificance", (Object)targetSignificance);
        }
        this._targetSignificance = targetSignificance;
    }

    @Override
    public String getTargetSignificance() {
        return this._targetSignificance;
    }

    @Override
    public String getProviderEndpoints() {
        return this._providerEndpoints;
    }

    @Override
    public void setProviderEndpoints(String providerEndpoints) {
        this._providerEndpoints = providerEndpoints;
    }

    @Override
    public void setRemoteServerAddress(String remoteServerAddress) {
        this.setProviderEndpoints(remoteServerAddress);
    }

    @Override
    public String getRemoteServerAddress() {
        return this.getProviderEndpoints();
    }

    @Override
    public String getTargetTransport() {
        return this._targetTransport;
    }

    @Override
    public void setTargetTransport(String targetTransport) {
        this._targetTransport = targetTransport;
    }

    @Override
    public Integer getMaxSequentialMessageFailure() {
        return this._maxSequentialMessageFailure;
    }

    @Override
    public void setMaxSequentialMessageFailure(Integer maxSequentialMessageFailure) {
        this._maxSequentialMessageFailure = maxSequentialMessageFailure;
    }

    @Override
    public void setMaxSequentialMessageFailure(String maxSequentialMessageFailure) {
        this._maxSequentialMessageFailure = maxSequentialMessageFailure == null ? null : Integer.valueOf(maxSequentialMessageFailure);
    }

    @Override
    public Integer getAutoStopSequentialMessageFailure() {
        return this._autoStopSequentialMessageFailure;
    }

    @Override
    public void setAutoStopSequentialMessageFailure(Integer autoStopSequentialMessageFailure) {
        this._autoStopSequentialMessageFailure = autoStopSequentialMessageFailure;
    }

    @Override
    public void setAutoStopSequentialMessageFailure(String autoStopSequentialMessageFailure) {
        this._autoStopSequentialMessageFailure = autoStopSequentialMessageFailure == null ? null : Integer.valueOf(autoStopSequentialMessageFailure);
    }

    @Override
    public String getConsumerDoesNotModifyPayloadAfterGet() {
        return this._consumerDoesNotModifyPayloadAfterGet;
    }

    @Override
    public void setConsumerDoesNotModifyPayloadAfterGet(String propertyValue) {
        this._consumerDoesNotModifyPayloadAfterGet = propertyValue;
    }

    @Override
    public String getForwarderDoesNotModifyPayloadAfterSet() {
        return this._forwarderDoesNotModifyPayloadAfterSet;
    }

    @Override
    public void setForwarderDoesNotModifyPayloadAfterSet(String propertyValue) {
        this._forwarderDoesNotModifyPayloadAfterSet = propertyValue;
    }

    @Override
    public void setAlwaysActivateAllMDBs(Boolean alwaysActivateAllMDBs) {
        this._alwaysActivateAllMDBs = alwaysActivateAllMDBs;
    }

    @Override
    public Boolean getAlwaysActivateAllMDBs() {
        return this._alwaysActivateAllMDBs;
    }

    @Override
    public void setRetryInterval(Integer retryInterval) {
        this._retryInterval = retryInterval;
    }

    @Override
    public void setRetryInterval(String retryInterval) {
        this._retryInterval = retryInterval == null ? null : Integer.valueOf(retryInterval);
    }

    @Override
    public Integer getRetryInterval() {
        return this._retryInterval;
    }

    @Override
    public Long getFailingMessageDelay() {
        return this._failingMessageDelay;
    }

    @Override
    public void setFailingMessageDelay(Long delay) {
        this._failingMessageDelay = delay;
    }

    public void validate() throws InvalidPropertyException {
        String methodName = "validate";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
        ArrayList<String> failedPropsMessages = new ArrayList<String>();
        try {
            ArrayList<PropertyDescriptor> invalidProperties = new ArrayList<PropertyDescriptor>();
            if (null == this._busName || "".equals(this._busName)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid BusName - BusName was " + this._busName));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_BUSNAME_CWSJR1187", null, null));
                invalidProperties.add(new PropertyDescriptor("busName", JmsJcaActivationSpec.class));
            }
            if (null == this._destination) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Invalid Destination - Destination was null");
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_DESTINATION_CWSJR1188", null, null));
                invalidProperties.add(new PropertyDescriptor("destination", JmsJcaActivationSpec.class));
            }
            if (!QUEUE.equals(this._destinationType) && !TOPIC.equals(this._destinationType)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination Type - We expected a destination type of jakarta.jms.Queue or jakarta.jms.Topic but we got " + this._destinationType));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_DESTINATION_TYPE_CWSJR1189", new Object[]{QUEUE, TOPIC, this._destinationType}, null));
                invalidProperties.add(new PropertyDescriptor("destinationType", JmsJcaActivationSpec.class));
            }
            if (!"Auto-acknowledge".equals(this._acknowledgeMode) && !DUPS_OK_ACKNOWLEDGE.equals(this._acknowledgeMode)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Acknowledge Mode - We expected an acknowledge mode of Auto-acknowledge or Dups-ok-acknowledge but we got " + this._acknowledgeMode));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_ACKNOWLEDGE_MODE_CWSJR1190", new Object[]{"Auto-acknowledge", DUPS_OK_ACKNOWLEDGE, this._acknowledgeMode}, null));
                invalidProperties.add(new PropertyDescriptor("acknowledgeMode", JmsJcaActivationSpec.class));
            }
            if (!("Default".equals(this._readAhead) || "AlwaysOn".equals(this._readAhead) || "AlwaysOff".equals(this._readAhead))) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid ReadAhead - We expected a read ahead of Default, AlwaysOn or AlwaysOff but we got " + this._readAhead));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_READ_AHEAD_CWSJR1191", new Object[]{"Default", "AlwaysOn", "AlwaysOff", this._acknowledgeMode}, null));
                invalidProperties.add(new PropertyDescriptor("readAhead", JmsJcaActivationSpec.class));
            }
            if (QUEUE.equals(this._destinationType) && !(this._destination instanceof JmsQueue)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination - We expect a destination object to be a " + JmsQueue.class.getName() + " but we got " + this._destination == null ? "null" : this._destination.getClass().getName()));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_QUEUE_CWSJR1192", new Object[]{JmsQueue.class.getName(), this._destination == null ? "null" : this._destination.getClass().getName()}, null));
                invalidProperties.add(new PropertyDescriptor("destination", JmsJcaActivationSpec.class));
            }
            if (TOPIC.equals(this._destinationType)) {
                if (!(this._destination instanceof JmsTopic)) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination - We expect a destination object to be a " + JmsTopic.class.getName() + " but we got " + this._destination == null ? "null" : this._destination.getClass().getName()));
                    }
                    failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_TOPIC_CWSJR1193", new Object[]{JmsTopic.class.getName(), this._destination == null ? "null" : this._destination.getClass().getName()}, null));
                    invalidProperties.add(new PropertyDescriptor("destination", JmsJcaActivationSpec.class));
                }
                if (!(DURABLE.equals(this._subscriptionDurability) || DURABLE_SHARED.equals(this._subscriptionDurability) || "NonDurable".equals(this._subscriptionDurability) || NON_DURABLE_SHARED.equals(this._subscriptionDurability))) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid subscriptionDurability - We expect a value of Durable or DurableShared or NonDurable or NonDurableShared but we got " + this._subscriptionDurability));
                    }
                    failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_SUBDUR_CWSJR1194", new Object[]{DURABLE, DURABLE_SHARED, "NonDurable", NON_DURABLE_SHARED, this._subscriptionDurability}, null));
                    invalidProperties.add(new PropertyDescriptor("subscriptionDurability", JmsJcaActivationSpec.class));
                }
                if (DURABLE.equals(this._subscriptionDurability) && (null == this._clientId || "".equals(this._clientId))) {
                    failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_CLIENTID_CWSJR1183", null, null));
                    invalidProperties.add(new PropertyDescriptor("clientId", JmsJcaActivationSpec.class));
                }
                if (DURABLE.equals(this._subscriptionDurability) || DURABLE_SHARED.equals(this._subscriptionDurability) || NON_DURABLE_SHARED.equals(this._subscriptionDurability)) {
                    if (null == this._clientId || "".equals(this._clientId)) {
                        failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_CLIENTID_CWSJR1183", null, null));
                        invalidProperties.add(new PropertyDescriptor("clientId", JmsJcaActivationSpec.class));
                    }
                    if (null == this._subscriptionName || "".equals(this._subscriptionName)) {
                        failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_SUBNAME_CWSJR1196", null, null));
                        invalidProperties.add(new PropertyDescriptor("subscriptionName", JmsJcaActivationSpec.class));
                    }
                }
            }
            if (null == this._maxConcurrency || this._maxConcurrency < 1) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_MAXCONC_CWSJR1198", null, null));
                invalidProperties.add(new PropertyDescriptor("maxConcurrency", JmsJcaActivationSpec.class));
            }
            if (null == this._maxBatchSize || this._maxBatchSize < 1) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_MAXBATCH_CWSJR1199", null, null));
                invalidProperties.add(new PropertyDescriptor("maxBatchSize", JmsJcaActivationSpec.class));
            }
            if (null == this._shareDataSourceWithCMP) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_SHARECMP_CWSJR1200", null, null));
                invalidProperties.add(new PropertyDescriptor("shareDataSourceWithCMP", JmsJcaActivationSpec.class));
            }
            if ("".equals(this._target)) {
                this._target = JmsraConstants.DEFAULT_TARGET;
            }
            if (null == this._targetType || "".equals(this._targetType)) {
                this._targetType = "ME";
            } else if (!("BusMember".equals(this._targetType) || "ME".equals(this._targetType) || "Custom".equals(this._targetType))) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_TARGET_TYPE_CWSJR1180", new Object[]{"BusMember", "ME", "Custom", this._targetType}, null));
                invalidProperties.add(new PropertyDescriptor("targetType", JmsJcaActivationSpec.class));
            }
            if (null == this._targetSignificance || "".equals(this._targetSignificance)) {
                this._targetSignificance = "Required";
            } else if (!"Preferred".equals(this._targetSignificance) && !"Required".equals(this._targetSignificance)) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_TARGET_SIGNIFICANCE_CWSJR1179", new Object[]{"Preferred", "Required", this._targetSignificance}, null));
                invalidProperties.add(new PropertyDescriptor("targetSignificance", JmsJcaActivationSpec.class));
            }
            if (!invalidProperties.isEmpty()) {
                PropertyDescriptor[] invalidPropertyArray = invalidProperties.toArray(new PropertyDescriptor[invalidProperties.size()]);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Invalid properties found:", failedPropsMessages);
                }
                InvalidPropertyException exc = new InvalidPropertyException(NLS.getFormattedMessage("INVALID_PROPERTIES_CWSJR1181", new Object[]{failedPropsMessages}, null));
                exc.setInvalidPropertyDescriptors(invalidPropertyArray);
                throw exc;
            }
        }
        catch (IntrospectionException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "validate"), (String)FFDC_PROBE_1, (Object)this);
            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            throw new RuntimeException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1185", new Object[]{exception}, null), exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        buffer.append(this.getClass().getName());
        buffer.append("@");
        buffer.append(System.identityHashCode(this));
        buffer.append(" <userName=");
        buffer.append(this._userName);
        buffer.append("> <password=");
        buffer.append(this._password == null ? null : "*****");
        buffer.append("> <destination=");
        buffer.append(this._destination);
        buffer.append("> <durableSubscriptionHome=");
        buffer.append(this._durableSubscriptionHome);
        buffer.append("> <destinationType=");
        buffer.append(this._destinationType);
        buffer.append("> <messageSelector=");
        buffer.append(this._messageSelector);
        buffer.append("> <acknowledgeMode=");
        buffer.append(this._acknowledgeMode);
        buffer.append("> <subscriptionDurability=");
        buffer.append(this._subscriptionDurability);
        buffer.append("> <shareDurableSubscriptions=");
        buffer.append(this._shareDurableSubscriptions);
        buffer.append("> <clientId=");
        buffer.append(this._clientId);
        buffer.append("> <subscriptionName=");
        buffer.append(this._subscriptionName);
        buffer.append("> <maxBatchSize=");
        buffer.append(this._maxBatchSize);
        buffer.append("> <maxConcurrency=");
        buffer.append(this._maxConcurrency);
        buffer.append("> <busName=");
        buffer.append(this._busName);
        buffer.append("> <shareDataSourceWithCMP=");
        buffer.append(this._shareDataSourceWithCMP);
        buffer.append("> <targetTransportChain=");
        buffer.append(this._targetTransportChain);
        buffer.append("> <readAhead=");
        buffer.append(this._readAhead);
        buffer.append("> <target=");
        buffer.append(this._target);
        buffer.append("> <targetType=");
        buffer.append(this._targetType);
        buffer.append("> <targetSignificance=");
        buffer.append(this._targetSignificance);
        buffer.append("> <providerEndpoints=");
        buffer.append(this._providerEndpoints);
        buffer.append("> <targetTransport=");
        buffer.append(this._targetTransport);
        buffer.append("> <consumerDoesNotModifyPayloadAfterGet=");
        buffer.append(this._consumerDoesNotModifyPayloadAfterGet);
        buffer.append("> <forwarderDoesNotModifyPayloadAfterSet=");
        buffer.append(this._forwarderDoesNotModifyPayloadAfterSet);
        buffer.append("> <alwaysActivateAllMDBs=");
        buffer.append(this._alwaysActivateAllMDBs);
        buffer.append("> <retryInterval=");
        buffer.append(this._retryInterval);
        buffer.append("> <failingMessageDelay=");
        buffer.append(this._failingMessageDelay);
        buffer.append("> <useServerSubject=");
        buffer.append(this._useServerSubject);
        buffer.append("> <topicSpace=");
        buffer.append(this._topicSpace);
        buffer.append("> <destinationLookup=");
        buffer.append(this._destinationLookup);
        buffer.append("> <connectionFactoryLookup=");
        buffer.append(this._connectionFactoryLookup);
        buffer.append(">]");
        return buffer.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    public SibRaEndpointInvoker getEndpointInvoker() throws ResourceAdapterInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointInvoker");
        }
        HashMap<String, String> passThruProps = new HashMap<String, String>();
        passThruProps.put("consumerDoesNotModifyPayloadAfterGet", this.getConsumerDoesNotModifyPayloadAfterGet());
        passThruProps.put("producerDoesNotModifyPayloadAfterSet", this.getForwarderDoesNotModifyPayloadAfterSet());
        JmsJcaEndpointInvokerImpl epInvoker = new JmsJcaEndpointInvokerImpl(passThruProps);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointInvoker", (Object)epInvoker);
        }
        return epInvoker;
    }

    public SibRaEndpointConfiguration getEndpointConfiguration() throws InvalidPropertyException, ResourceAdapterInternalException {
        String methodName = "getEndpointConfiguration";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration");
        }
        JmsJcaEndpointConfigurationImpl configuration = new JmsJcaEndpointConfigurationImpl();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration", (Object)configuration);
        }
        return configuration;
    }

    private void dynamicallyCreateDestination() {
        block17: {
            block16: {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dynamicallyCreateDestination");
                }
                if (this._destination != null) {
                    return;
                }
                if (this._destinationType != null && this._destinationName != null) {
                    try {
                        if (this._destinationType.equals(QUEUE)) {
                            this._destination = JmsFactoryFactory.getInstance().createQueue(this._destinationName);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Dynamically created queue:" + this._destination));
                            }
                        } else if (this._destinationType.equals(TOPIC)) {
                            this._destination = JmsFactoryFactory.getInstance().createTopic(this._destinationName);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Dynamically created topic:" + this._destination));
                            }
                        }
                    }
                    catch (JMSException e) {
                        FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)FFDC_PROBE_4);
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break block16;
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)e));
                    }
                }
            }
            if (this._destination != null) {
                try {
                    if (this._destinationType.equals(TOPIC) && this._topicSpace != null) {
                        ((JmsTopic)this._destination).setTopicSpace(this._topicSpace);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Set topicSpace on destination");
                        }
                    }
                }
                catch (JMSException e) {
                    FFDCFilter.processException((Throwable)e, (String)CLASS_NAME, (String)FFDC_PROBE_5);
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break block17;
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dynamicallyCreateDestination");
        }
    }

    public String getDestinationLookup() {
        return this._destinationLookup;
    }

    @Override
    public void setDestinationLookup(String _destinationLookup) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setDestinationLookup", (Object)_destinationLookup);
            }
            if (!this.isValueCanBeSet(_destinationLookup)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)(" destinationLookup property value is " + _destinationLookup + ", so ignoring"));
                }
                return;
            }
            this._destinationLookup = _destinationLookup;
            try {
                this._destination = (Destination)new InitialContext().lookup(_destinationLookup);
            }
            catch (NamingException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break block6;
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination JNDI name " + _destinationLookup));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setDestinationLookup", (Object)_destinationLookup);
        }
    }

    public String getConnectionFactoryLookup() {
        return this._connectionFactoryLookup;
    }

    @Override
    public void setConnectionFactoryLookup(String _connectionFactoryLookup) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setConnectionFactoryLookup", (Object)_connectionFactoryLookup);
            }
            this._connectionFactoryLookup = _connectionFactoryLookup;
            JmsManagedConnectionFactoryImpl jmsManagedCF = null;
            try {
                Object object = new InitialContext().lookup(_connectionFactoryLookup);
                if (object instanceof JmsManagedConnectionFactoryImpl) {
                    jmsManagedCF = (JmsManagedConnectionFactoryImpl)object;
                    if (this.isValueCanBeSet(jmsManagedCF.getUserName())) {
                        this.setUserName(jmsManagedCF.getUserName());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getPassword())) {
                        this.setPassword(jmsManagedCF.getPassword());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getBusName())) {
                        this.setBusName(jmsManagedCF.getBusName());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getClientID())) {
                        this.setClientId(jmsManagedCF.getClientID());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getConsumerDoesNotModifyPayloadAfterGet())) {
                        this.setConsumerDoesNotModifyPayloadAfterGet(jmsManagedCF.getConsumerDoesNotModifyPayloadAfterGet());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getDurableSubscriptionHome())) {
                        this.setDurableSubscriptionHome(jmsManagedCF.getDurableSubscriptionHome());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getProviderEndpoints())) {
                        this.setProviderEndpoints(jmsManagedCF.getProviderEndpoints());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getReadAhead())) {
                        this.setReadAhead(jmsManagedCF.getReadAhead());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getShareDurableSubscriptions())) {
                        this.setShareDurableSubscriptions(jmsManagedCF.getShareDurableSubscriptions());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getTarget())) {
                        this.setTarget(jmsManagedCF.getTarget());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getTargetSignificance())) {
                        this.setTargetSignificance(jmsManagedCF.getTargetSignificance());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getTargetTransportChain())) {
                        this.setTargetTransportChain(jmsManagedCF.getTargetTransportChain());
                    }
                    if (this.isValueCanBeSet(jmsManagedCF.getTargetType())) {
                        this.setTargetType(jmsManagedCF.getTargetType());
                    }
                }
            }
            catch (NamingException exp) {
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break block18;
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Connection Factory JNDI name " + _connectionFactoryLookup));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setConnectionFactoryLookup", (Object)_connectionFactoryLookup);
        }
    }

    private boolean isValueCanBeSet(String value) {
        return value != null && !value.isEmpty();
    }

    private class JmsJcaEndpointConfigurationImpl
    implements SibRaEndpointConfiguration {
        private final SIDestinationAddressFactory _destinationAddressFactory;
        private final JmsSharedUtils _jmsUtils;

        private JmsJcaEndpointConfigurationImpl() throws InvalidPropertyException, ResourceAdapterInternalException {
            JmsJcaActivationSpecImpl.this.validate();
            try {
                this._destinationAddressFactory = JmsServiceFacade.getSIDestinationAddressFactory();
                this._jmsUtils = JmsInternalsFactory.getSharedUtils();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".JmsJcaEndpointConfigurationImpl.JmsJcaEndpointConfigurationImpl"), (String)JmsJcaActivationSpecImpl.FFDC_PROBE_2, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1182", new Object[]{exception}, null), (Throwable)exception);
            }
        }

        public SIDestinationAddress getDestination() {
            JmsDestination jmsDestination = (JmsDestination)JmsJcaActivationSpecImpl.this._destination;
            SIDestinationAddress addr = null;
            if (jmsDestination instanceof JmsQueue) {
                JmsQueue q = (JmsQueue)jmsDestination;
                String scopeToLocal = q.getScopeToLocalQP();
                boolean scope = "On".equals(scopeToLocal);
                addr = this._destinationAddressFactory.createSIDestinationAddress(jmsDestination.getDestName(), scope, jmsDestination.getBusName());
            } else {
                addr = this._destinationAddressFactory.createSIDestinationAddress(jmsDestination.getDestName(), jmsDestination.getBusName());
            }
            return addr;
        }

        public String getAllowMessageGathering() {
            JmsDestination jmsDestination = (JmsDestination)JmsJcaActivationSpecImpl.this._destination;
            String allow = null;
            if (jmsDestination instanceof JmsQueue) {
                JmsQueue q = (JmsQueue)jmsDestination;
                allow = q.getGatherMessages();
            }
            return allow;
        }

        public String getDestinationName() {
            return JmsJcaActivationSpecImpl.this._destinationName;
        }

        public DestinationType getDestinationType() {
            DestinationType destinationType = JmsJcaActivationSpecImpl.QUEUE.equals(JmsJcaActivationSpecImpl.this._destinationType) ? DestinationType.QUEUE : DestinationType.TOPICSPACE;
            return destinationType;
        }

        public String getDiscriminator() {
            JmsDestination jmsDestination = (JmsDestination)JmsJcaActivationSpecImpl.this._destination;
            return jmsDestination.getDestDiscrim();
        }

        public int getMaxConcurrency() {
            return JmsJcaActivationSpecImpl.this._maxConcurrency;
        }

        public int getMaxBatchSize() {
            return JmsJcaActivationSpecImpl.this._maxBatchSize;
        }

        public String getBusName() {
            return JmsJcaActivationSpecImpl.this._busName;
        }

        public String getUserName() {
            return JmsJcaActivationSpecImpl.this._userName;
        }

        public String getPassword() {
            return JmsJcaActivationSpecImpl.this._password;
        }

        public String getMessageSelector() {
            return JmsJcaActivationSpecImpl.this._messageSelector;
        }

        public String getDurableSubscriptionName() {
            return this._jmsUtils.getCoreDurableSubName(JmsJcaActivationSpecImpl.this._clientId, JmsJcaActivationSpecImpl.this._subscriptionName);
        }

        public String getDurableSubscriptionHome() {
            return JmsJcaActivationSpecImpl.this._durableSubscriptionHome;
        }

        public SibRaDurableSubscriptionSharing getShareDurableSubscriptions() {
            SibRaDurableSubscriptionSharing sharing = "AlwaysShared".equals(JmsJcaActivationSpecImpl.this._shareDurableSubscriptions) ? SibRaDurableSubscriptionSharing.ALWAYS : ("NeverShared".equals(JmsJcaActivationSpecImpl.this._shareDurableSubscriptions) ? SibRaDurableSubscriptionSharing.NEVER : SibRaDurableSubscriptionSharing.CLUSTER_ONLY);
            return sharing;
        }

        public SibRaMessageDeletionMode getMessageDeletionMode() {
            SibRaMessageDeletionMode messageDeletionMode = "Auto-acknowledge".equals(JmsJcaActivationSpecImpl.this._acknowledgeMode) ? SibRaMessageDeletionMode.SINGLE : SibRaMessageDeletionMode.BATCH;
            return messageDeletionMode;
        }

        public boolean isDurableSubscription() {
            return JmsJcaActivationSpecImpl.TOPIC.equals(JmsJcaActivationSpecImpl.this._destinationType) && (JmsJcaActivationSpecImpl.DURABLE.equalsIgnoreCase(JmsJcaActivationSpecImpl.this._subscriptionDurability) || JmsJcaActivationSpecImpl.DURABLE_SHARED.equalsIgnoreCase(JmsJcaActivationSpecImpl.this._subscriptionDurability));
        }

        public String getSubscriptionDurability() {
            return JmsJcaActivationSpecImpl.this._subscriptionDurability;
        }

        public SelectorDomain getSelectorDomain() {
            return SelectorDomain.JMS;
        }

        public boolean getShareDataSourceWithCMP() {
            return JmsJcaActivationSpecImpl.this._shareDataSourceWithCMP;
        }

        public String getTargetTransportChain() {
            return JmsJcaActivationSpecImpl.this._targetTransportChain;
        }

        public String getTarget() {
            return JmsJcaActivationSpecImpl.this._target;
        }

        public String getTargetType() {
            return JmsJcaActivationSpecImpl.this._targetType;
        }

        public String getTargetSignificance() {
            return JmsJcaActivationSpecImpl.this._targetSignificance;
        }

        public SibRaReadAhead getReadAhead() {
            SibRaReadAhead readAhead = "AlwaysOn".equals(JmsJcaActivationSpecImpl.this._readAhead) ? SibRaReadAhead.ON : ("AlwaysOff".equals(JmsJcaActivationSpecImpl.this._readAhead) ? SibRaReadAhead.OFF : SibRaReadAhead.DEFAULT);
            return readAhead;
        }

        public String getProviderEndpoints() {
            return JmsJcaActivationSpecImpl.this._providerEndpoints;
        }

        public ActivationSpec getActivationSpec() {
            return JmsJcaActivationSpecImpl.this;
        }

        public int getMaxSequentialMessageFailure() {
            return JmsJcaActivationSpecImpl.this._maxSequentialMessageFailure;
        }

        public int getAutoStopSequentialMessageFailure() {
            return JmsJcaActivationSpecImpl.this._autoStopSequentialMessageFailure;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("[");
            buffer.append(this.getClass().getName());
            buffer.append("@");
            buffer.append(System.identityHashCode(this));
            buffer.append(" <JmsJcaActivationSpecImpl.this=");
            buffer.append(JmsJcaActivationSpecImpl.this);
            buffer.append(">]");
            return buffer.toString();
        }

        public boolean isJMSRa() {
            return true;
        }

        public Boolean getAlwaysActivateAllMDBs() {
            return JmsJcaActivationSpecImpl.this._alwaysActivateAllMDBs;
        }

        public int getRetryInterval() {
            return JmsJcaActivationSpecImpl.this._retryInterval;
        }

        public Boolean getUseDestinationWildcard() {
            return Boolean.FALSE;
        }

        public boolean getUseServerSubject() {
            return JmsJcaActivationSpecImpl.this._useServerSubject;
        }

        public Long getFailingMessageDelay() {
            return JmsJcaActivationSpecImpl.this._failingMessageDelay;
        }

        public String getTargetTransport() {
            return JmsJcaActivationSpecImpl.this._targetTransport;
        }
    }
}

