/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

abstract class SibRaCommonEndpointActivation
extends SibRaEndpointActivation {
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaCommonEndpointActivation.class);
    private static final TraceComponent P2PTRACE = SibRaUtils.getTraceComponent(PointToPointStrategy.class);
    private static final TraceComponent DPSTRACE = SibRaUtils.getTraceComponent(PointToPointStrategy.class);
    private static final TraceComponent NDPSTRACE = SibRaUtils.getTraceComponent(PointToPointStrategy.class);
    private static final TraceComponent DESTTRACE = SibRaUtils.getTraceComponent(DestinationStrategy.class);
    private static final TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaDestinationListener.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaCommonEndpointActivation.class.getName();
    private static final Random _random = new Random();
    protected final DestinationStrategy _destinationStrategy;
    protected int _retryInterval;
    protected boolean _connectedRemotely;
    protected boolean _connectedToPreferred;
    protected String _targetType;
    protected String _targetSignificance;
    protected String _target;
    protected BootstrapContext _bootstrapContext;
    protected Timer _timer;
    private final Object _timerLock = new Object();

    public SibRaCommonEndpointActivation(SibRaResourceAdapterImpl resourceAdapter, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration endpointConfiguration, SibRaEndpointInvoker endpointInvoker) throws ResourceException {
        super(resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker);
        String methodName = "SibRaCommonEndpointActivation";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaCommonEndpointActivation", (Object)new Object[]{resourceAdapter, messageEndpointFactory, endpointConfiguration, endpointInvoker});
        }
        this._destinationStrategy = DestinationType.TOPICSPACE.equals(this._endpointConfiguration.getDestinationType()) ? (this._endpointConfiguration.isDurableSubscription() ? new DurablePubSubStrategy(this) : new NonDurablePubSubStrategy(this)) : new PointToPointStrategy(this);
        this._targetType = this._endpointConfiguration.getTargetType();
        this._targetSignificance = this._endpointConfiguration.getTargetSignificance();
        this._target = this._endpointConfiguration.getTarget();
        this._bootstrapContext = resourceAdapter.getBootstrapContext();
        this._retryInterval = this._endpointConfiguration.getRetryInterval() * 1000;
        if (this._retryInterval <= 0) {
            this._retryInterval = 30000;
        }
        SibRaEngineComponent.registerMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
        try {
            this.timerLoop();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + "." + "SibRaCommonEndpointActivation"), (String)"1:289:1.45", (Object)this);
            this.deactivate();
            if (t instanceof ResourceException) {
                throw (ResourceException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new ResourceException(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"SibRaCommonEndpointActivation");
        }
    }

    void timerLoop() throws ResourceException {
        String methodName = "timerLoop";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"timerLoop");
        }
        this.checkMEs(this.getMEsToCheck());
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"timerLoop");
        }
    }

    abstract JsMessagingEngine[] getMEsToCheck();

    abstract boolean onlyConnectToDSH();

    void checkMEs(JsMessagingEngine[] MEList) throws ResourceException {
        String methodName = "checkMEs";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"checkMEs", (Object)new Object[]{MEList});
        }
        JsMessagingEngine[] preferredMEs = this._destinationStrategy.getPreferredLocalMEs(MEList);
        try {
            this.connect(preferredMEs, this._targetType, this._targetSignificance, this._target, true);
            SibTr.info((TraceComponent)TRACE, (String)"TARGETTED_CONNECTION_SUCCESSFUL_CWSIV0556", (Object)new Object[]{((MDBMessageEndpointFactory)this._messageEndpointFactory).getActivationSpecId(), this._endpointConfiguration.getDestination().getDestinationName()});
        }
        catch (Exception e) {
            SibTr.warning((TraceComponent)TRACE, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE, (String)"CONNECT_FAILED_CWSIV0782", (Object)new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), ((MDBMessageEndpointFactory)this._messageEndpointFactory).getActivationSpecId(), e});
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Failed to obtain a connection - retry after a set interval");
            }
            this.clearTimer();
            this.deactivate();
            this.kickOffTimer();
        }
        if (this._destinationStrategy.isTimerNeeded()) {
            this.clearTimer();
            this.kickOffTimer();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"checkMEs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kickOffTimer() throws UnavailableException {
        String methodName = "kickOffTimer";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"kickOffTimer");
        }
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer != null) {
                return;
            }
            this._timer = this._bootstrapContext.createTimer();
            this._timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SibRaCommonEndpointActivation.this._timerLock;
                        synchronized (object) {
                            SibRaCommonEndpointActivation.this._timer.cancel();
                            SibRaCommonEndpointActivation.this._timer = null;
                            SibRaCommonEndpointActivation.this.timerLoop();
                        }
                    }
                    catch (ResourceException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "kickOffTimer"), (String)"1:420:1.45", (Object)this);
                        SibTr.error((TraceComponent)TRACE, (String)"CONNECT_FAILED_CWSIV0783", (Object)new Object[]{SibRaCommonEndpointActivation.this._endpointConfiguration.getDestination().getDestinationName(), SibRaCommonEndpointActivation.this._endpointConfiguration.getBusName(), this, exception});
                    }
                }
            }, this._retryInterval);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"kickOffTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimer() {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
        }
    }

    void connect(JsMessagingEngine[] MEList, String targetType, String targetSignificance, String target, boolean isPreferred) throws ResourceException {
        String methodName = "connect";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connect", (Object)new Object[]{MEList, targetType, targetSignificance, target, isPreferred});
        }
        this.connectUsingTrm(targetType, targetSignificance, target, isPreferred);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"connect");
        }
    }

    void connectUsingTrm(String targetType, String targetSignificance, String target, boolean isPreferred) throws ResourceException {
        String methodName = "connectUsingTrm";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectUsingTrm", (Object)new Object[]{targetType, targetSignificance, target, isPreferred});
        }
        this.connectUsingTrmWithTargetData(targetType, targetSignificance, target);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"connectUsingTrm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectUsingTrmWithTargetData(String targetType, String targetSignificance, String target) throws ResourceException {
        String methodName = "connectUsingTrmWithTargetData";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectUsingTrmWithTargetData", (Object)new Object[]{targetType, targetSignificance, target});
        }
        Map map = this._connections;
        synchronized (map) {
            if (!this._connectedToPreferred || this._connections.size() == 0) {
                SibRaMessagingEngineConnection newConnection = null;
                try {
                    newConnection = new SibRaMessagingEngineConnection(this, this._endpointConfiguration.getBusName(), targetType, "Required", target);
                    this.dropNonPreferredConnections();
                    if (newConnection.getConnection() != null) {
                        this._connections.put(newConnection.getConnection().getMeUuid(), newConnection);
                        this.createListener(newConnection);
                    }
                    if (this._connections.size() > 0) {
                        this._connectedRemotely = this.checkIfRemote((SibRaMessagingEngineConnection)this._connections.values().iterator().next());
                        this._connectedToPreferred = true;
                        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)TRACE, (String)("We have connect <remote=" + this._connectedRemotely + " > <preferred=" + this._connectedToPreferred + ">"));
                        }
                    }
                }
                catch (SIResourceException exception) {
                    SibTr.warning((TraceComponent)TRACE, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE, (String)"TARGETTED_CONNECTION_FAILED_CWSIV0787", (Object)new Object[]{targetType, targetSignificance, target, this._endpointConfiguration.getBusName()});
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)TRACE, (String)"Failed to obtain a connection - retry after a set interval");
                    }
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "connectUsingTrmWithTargetData"), (String)"1:711:1.45", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("CONNECT_FAILED_CWSIV0782", new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, exception}, null), (Throwable)exception);
                }
            }
        }
        if ((this._connections.size() == 0 || this._connectedRemotely && !this._connectedToPreferred && this._destinationStrategy.isDropRemoteNonPreferredForLocalNonPreferred()) && targetSignificance.equals("Preferred")) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Could not obtain the preferred connection - try again without any target preferences");
            }
            this.connect(this._destinationStrategy.isDurablePubsSub() ? null : this.getMEsToCheck(), null, null, null, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"connectUsingTrmWithTargetData");
        }
    }

    private void createSingleListener(SibRaMessagingEngineConnection connection) throws ResourceException {
        String methodName = "createSingleListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createSingleListener", (Object)connection);
        }
        SIDestinationAddress destination = this._endpointConfiguration.getDestination();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)("Creating a consumer to consume from destination " + destination + " on ME " + connection.getConnection().getMeName()));
        }
        try {
            connection.createListener(destination, this._messageEndpointFactory);
            SibTr.info((TraceComponent)TRACE, (String)"CONNECTED_CWSIV0777", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName()});
        }
        catch (IllegalStateException exception) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Failed to create a session - blowing away the connection - rethrow the exception");
            }
            this._connections.remove(connection.getConnection().getMeUuid());
            connection.close();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createSingleListener");
            }
            throw exception;
        }
        catch (ResourceException exception) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Failed to create a session - blowing away the connection - a retry should occur");
                SibTr.debug((TraceComponent)TRACE, (String)("Exception cause was " + exception.getCause()));
            }
            this._connections.remove(connection.getConnection().getMeUuid());
            connection.close();
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createSingleListener");
        }
    }

    private void createMultipleListeners(SibRaMessagingEngineConnection connection) throws ResourceException {
        String methodName = "createMultipleListeners";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createMultipleListeners", (Object)connection);
        }
        try {
            SICoreConnection coreConnection = connection.getConnection();
            SibRaDestinationListener destinationListener = new SibRaDestinationListener(connection, this._messageEndpointFactory);
            DestinationType destinationType = this._endpointConfiguration.getDestinationType();
            SIDestinationAddress[] destinations = coreConnection.addDestinationListener(this._endpointConfiguration.getDestinationName(), (DestinationListener)destinationListener, destinationType, DestinationAvailability.RECEIVE);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)P2PTRACE, (String)("Found " + destinations.length + " destinations that make the wildcard"));
            }
            for (int j = 0; j < destinations.length; ++j) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)P2PTRACE, (String)("Creating a consumer for destination " + destinations[j]));
                    }
                    connection.createListener(destinations[j], this._messageEndpointFactory);
                    continue;
                }
                catch (ResourceException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "createMultipleListeners"), (String)"1:877:1.45", (Object)this);
                    SibTr.error((TraceComponent)TRACE, (String)"CREATE_LISTENER_FAILED_CWSIV0803", (Object)new Object[]{exception, destinations[j].getDestinationName(), connection.getConnection().getMeName(), connection.getBusName()});
                }
            }
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "createMultipleListeners"), (String)"1:889:1.45", (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"ADD_DESTINATION_LISTENER_FAILED_CWSIV0804", (Object)new Object[]{exception, connection.getConnection().getMeName(), connection.getBusName()});
            this._connections.remove(connection.getConnection().getMeUuid());
            connection.close();
        }
        if (connection.getNumberListeners() == 0) {
            SibTr.warning((TraceComponent)TRACE, (String)"NO_LISTENERS_CREATED_CWSIV0809", (Object)new Object[]{this._endpointConfiguration.getDestinationName(), connection.getConnection().getMeName(), connection.getBusName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createMultipleListeners");
        }
    }

    private void createListener(SibRaMessagingEngineConnection connection) throws ResourceException {
        String methodName = "createListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)connection);
        }
        if (this._endpointConfiguration.getUseDestinationWildcard().booleanValue()) {
            this.createMultipleListeners(connection);
        } else {
            this.createSingleListener(connection);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener");
        }
    }

    boolean checkIfRemote(SibRaMessagingEngineConnection conn) {
        String methodName = "checkIfRemote";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"checkIfRemote", (Object)new Object[]{conn});
        }
        String meName = conn.getConnection().getMeName();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)("Connections's ME name " + meName));
        }
        boolean remote = true;
        JsMessagingEngine[] localMEs = SibRaEngineComponent.getActiveMessagingEngines((String)this._endpointConfiguration.getBusName());
        for (int i = 0; i < localMEs.length; ++i) {
            JsMessagingEngine me = localMEs[i];
            String localName = me.getName();
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)("Checking ME name " + localName));
            }
            if (!localName.equals(meName)) continue;
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Me name matched, the connection is local");
            }
            remote = false;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"checkIfRemote", (Object)remote);
        }
        return remote;
    }

    void dropNonPreferredConnections() {
        String methodName = "dropNonPreferredConnections";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dropNonPreferredConnections");
        }
        if (!this._connectedToPreferred) {
            this.closeConnections();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"dropNonPreferredConnections");
        }
    }

    void dropRemoteConnections() {
        String methodName = "dropRemoteConnections";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dropRemoteConnections");
        }
        if (this._connectedRemotely) {
            this.closeConnections();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"dropRemoteConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnections() {
        String methodName = "closeConnections";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeConnections");
        }
        Map map = this._connections;
        synchronized (map) {
            Collection cons = this._connections.values();
            for (SibRaMessagingEngineConnection connection : cons) {
                connection.close();
            }
            this._connections.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"closeConnections");
        }
    }

    boolean matchesTargetData(JsMessagingEngine ME) {
        return true;
    }

    @Override
    void deactivate() {
        String methodName = "deactivate";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
        this.clearTimer();
        super.deactivate();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
    }

    @Override
    void addMessagingEngine(JsMessagingEngine messagingEngine) throws ResourceException {
        String methodName = "addMessagingEngine";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine", (Object)messagingEngine);
        }
        if (this._destinationStrategy.isNonDurablePubSub() && this._connections.size() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine");
            }
            return;
        }
        this.clearTimer();
        this.checkMEs(new JsMessagingEngine[]{messagingEngine});
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine");
        }
    }

    @Override
    void connectionError(SibRaMessagingEngineConnection connection, SIException exception) {
        String methodName = "connectionError";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)methodName, (Object)new Object[]{connection, exception});
        }
        SibTr.warning((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0776", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this, exception});
        this.dropConnection(connection, false, true, true);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)methodName);
        }
    }

    @Override
    void messagingEngineQuiescing(SibRaMessagingEngineConnection connection) {
        String methodName = "messagingEngineQuiescing";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineQuiescing", (Object)connection);
        }
        SibTr.info((TraceComponent)TRACE, (String)"ME_QUIESCING_CWSIV0785", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getBusName()});
        this.dropConnection(connection, false, true, true);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineQuiescing");
        }
    }

    @Override
    void messagingEngineTerminated(SibRaMessagingEngineConnection connection) {
        String methodName = "messagingEngineTerminated";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineTerminated", (Object)connection);
        }
        SibTr.info((TraceComponent)TRACE, (String)"ME_TERMINATED_CWSIV0786", (Object)new Object[]{connection.getConnection().getMeName(), this._endpointConfiguration.getBusName()});
        this.dropConnection(connection, false, true, true);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineTerminated");
        }
    }

    @Override
    void sessionError(SibRaMessagingEngineConnection connection, ConsumerSession session, Throwable throwable) {
        String methodName = "sessionError";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"sessionError", (Object)new Object[]{connection, session});
        }
        SIDestinationAddress destination = session.getDestinationAddress();
        SibTr.warning((TraceComponent)TRACE, (String)"CONSUMER_FAILED_CWSIV0770", (Object)new Object[]{destination.getDestinationName(), this._endpointConfiguration.getBusName(), this, throwable});
        this.dropConnection(connection, true, true, false);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"sessionError");
        }
    }

    @Override
    public synchronized void messagingEngineStopping(JsMessagingEngine messagingEngine, int mode) {
        String methodName = "messagingEngineStopping";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping", (Object)new Object[]{messagingEngine, mode});
        }
        SibTr.info((TraceComponent)TRACE, (String)"ME_STOPPING_CWSIV0784", (Object)new Object[]{messagingEngine.getName(), messagingEngine.getBus()});
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropConnection(SibRaMessagingEngineConnection connection, boolean isSessionError, boolean retryImmediately, boolean alreadyClosed) {
        String methodName = "dropConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)methodName, (Object)new Object[]{connection, isSessionError, retryImmediately, alreadyClosed});
        }
        SibRaMessagingEngineConnection connectionCheck = null;
        String meUuid = connection.getConnection().getMeUuid();
        Object object = this._connections;
        synchronized (object) {
            connectionCheck = (SibRaMessagingEngineConnection)this._connections.get(meUuid);
            if (connection == connectionCheck) {
                this.closeConnection(meUuid, alreadyClosed);
            }
        }
        if (!isSessionError || !SibRaEngineComponent.isMessagingEngineReloading((String)meUuid)) {
            object = this._timerLock;
            synchronized (object) {
                Map map = this._connections;
                synchronized (map) {
                    if (this._connections.size() == 0) {
                        try {
                            this.clearTimer();
                            if (retryImmediately) {
                                this.timerLoop();
                            } else {
                                this.kickOffTimer();
                            }
                        }
                        catch (ResourceException resEx) {
                            FFDCFilter.processException((Throwable)resEx, (String)(CLASS_NAME + "." + methodName), (String)"1:1434:1.45", (Object)this);
                            SibTr.error((TraceComponent)TRACE, (String)"CONNECT_FAILED_CWSIV0783", (Object)new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, resEx});
                        }
                    }
                }
            }
        }
        this.clearTimer();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)methodName);
        }
    }

    public void messagingEngineDestroyed(JsMessagingEngine messagingEngine) {
        String methodName = "messagingEngineDestroyed";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed", (Object)messagingEngine);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed");
        }
    }

    public void messagingEngineInitializing(JsMessagingEngine messagingEngine) {
        String methodName = "messagingEngineInitializing";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineInitializing", (Object)messagingEngine);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineInitializing");
        }
    }

    public void messagingEngineReloaded(JsMessagingEngine engine) {
        String methodName = "messagingEngineReloaded";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineReloaded", (Object)engine);
        }
        try {
            this.clearTimer();
            this.timerLoop();
        }
        catch (ResourceException exception) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            SibTr.error((TraceComponent)TRACE, (String)"RELOAD_FAILED_CWSIV0773", (Object)new Object[]{exception, engine.getName(), engine.getBusName(), this});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineReloaded");
        }
    }

    private static String validateDestination(JsMessagingEngine messagingEngine, String busName, String destinationName, DestinationType destinationType) throws NotSupportedException, ResourceAdapterInternalException {
        String uuid;
        block11: {
            String methodName = "validateDestination";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((TraceComponent)TRACE, (String)"validateDestination", (Object)new Object[]{messagingEngine, busName, destinationName, destinationType});
            }
            String resolvedBusName = busName == null || "".equals(busName) ? messagingEngine.getBusName() : busName;
            try {
                BaseDestinationDefinition destinationDefinition = messagingEngine.getSIBDestination(busName, destinationName);
                if (destinationDefinition.isForeign()) {
                    throw new NotSupportedException(NLS.getFormattedMessage("FOREIGN_DESTINATION_CWSIV0754", new Object[]{destinationName, resolvedBusName}, null));
                }
                if (destinationDefinition.isLocal()) {
                    DestinationDefinition localDefinition = (DestinationDefinition)destinationDefinition;
                    if (destinationType.equals(localDefinition.getDestinationType())) {
                        uuid = destinationDefinition.getUUID().toString();
                        break block11;
                    }
                    throw new NotSupportedException(NLS.getFormattedMessage("INCORRECT_TYPE_CWSIV0755", new Object[]{destinationName, resolvedBusName, destinationType, localDefinition.getDestinationType()}, null));
                }
                if (destinationDefinition.isAlias()) {
                    DestinationAliasDefinition aliasDefinition = (DestinationAliasDefinition)destinationDefinition;
                    uuid = SibRaCommonEndpointActivation.validateDestination(messagingEngine, aliasDefinition.getTargetBus(), aliasDefinition.getTargetName(), destinationType);
                    break block11;
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNKNOWN_TYPE_CWSIV0756", new Object[]{destinationName, resolvedBusName}, null));
            }
            catch (SIBExceptionDestinationNotFound exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "validateDestination"), (String)"1:1653:1.45");
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new NotSupportedException(NLS.getFormattedMessage("NOT_FOUND_CWSIV0757", new Object[]{destinationName, resolvedBusName}, null), (Throwable)exception);
            }
            catch (SIBExceptionBase exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "validateDestination"), (String)"1:1664:1.45");
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIV0758", new Object[]{destinationName, resolvedBusName, exception}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"validateDestination", (Object)uuid);
        }
        return uuid;
    }

    class DurablePubSubStrategy
    extends DestinationStrategy {
        DurablePubSubStrategy(SibRaCommonEndpointActivation parent) {
            super(parent);
        }

        @Override
        JsMessagingEngine[] getPreferredLocalMEs(JsMessagingEngine[] MEList) {
            String methodName = "getPreferredLocalMEs";
            if (TraceComponent.isAnyTracingEnabled() && DPSTRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)DPSTRACE, (String)"getPreferredLocalMEs", (Object)new Object[]{MEList});
            }
            JsMessagingEngine[] preferredMEs = (SibRaCommonEndpointActivation.this._target == null || "".equals(SibRaCommonEndpointActivation.this._target)) && SibRaCommonEndpointActivation.this.onlyConnectToDSH() ? null : super.getPreferredLocalMEs(MEList);
            if (TraceComponent.isAnyTracingEnabled() && DPSTRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)DPSTRACE, (String)"getPreferredLocalMEs", (Object)preferredMEs);
            }
            return preferredMEs;
        }

        @Override
        public boolean isTimerNeeded() {
            boolean timerNeeded;
            String methodName = "isTimerNeeded";
            if (TraceComponent.isAnyTracingEnabled() && DPSTRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)DPSTRACE, (String)"isTimerNeeded");
            }
            boolean bl = timerNeeded = SibRaCommonEndpointActivation.this._connections.size() == 0 || !SibRaCommonEndpointActivation.this._connectedToPreferred;
            if (TraceComponent.isAnyTracingEnabled() && DPSTRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)DPSTRACE, (String)"isTimerNeeded", (Object)timerNeeded);
            }
            return timerNeeded;
        }
    }

    abstract class DestinationStrategy {
        SibRaCommonEndpointActivation _parent;

        DestinationStrategy(SibRaCommonEndpointActivation parent) {
            this._parent = parent;
        }

        public boolean isPointToPoint() {
            return this instanceof PointToPointStrategy;
        }

        public boolean isDropRemoteNonPreferredForLocalNonPreferred() {
            return false;
        }

        public boolean isDurablePubsSub() {
            return this instanceof DurablePubSubStrategy;
        }

        public boolean isNonDurablePubSub() {
            return this instanceof NonDurablePubSubStrategy;
        }

        JsMessagingEngine[] getPreferredLocalMEs(JsMessagingEngine[] MEList) {
            JsMessagingEngine[] preferredMEs;
            String methodName = "getPreferredLocalMEs";
            if (TraceComponent.isAnyTracingEnabled() && DESTTRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)DESTTRACE, (String)"getPreferredLocalMEs", (Object)new Object[]{MEList});
            }
            if (SibRaCommonEndpointActivation.this._target == null || "".equals(SibRaCommonEndpointActivation.this._target)) {
                preferredMEs = MEList;
            } else {
                ArrayList<JsMessagingEngine> prefList = new ArrayList<JsMessagingEngine>();
                for (int i = 0; i < MEList.length; ++i) {
                    JsMessagingEngine ME = MEList[i];
                    if (!SibRaCommonEndpointActivation.this.matchesTargetData(ME)) continue;
                    prefList.add(ME);
                }
                preferredMEs = new JsMessagingEngine[prefList.size()];
                prefList.toArray(preferredMEs);
            }
            if (TraceComponent.isAnyTracingEnabled() && DESTTRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)DESTTRACE, (String)"getPreferredLocalMEs", (Object)preferredMEs);
            }
            return preferredMEs;
        }

        public abstract boolean isTimerNeeded();
    }

    class NonDurablePubSubStrategy
    extends DestinationStrategy {
        NonDurablePubSubStrategy(SibRaCommonEndpointActivation parent) {
            super(parent);
        }

        public void connectToLocalMEs(JsMessagingEngine[] MEList) throws ResourceException {
            String methodName = "connectToLocalMEs";
            if (TraceComponent.isAnyTracingEnabled() && NDPSTRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)NDPSTRACE, (String)"connectToLocalMEs", (Object)new Object[]{MEList});
            }
            if (SibRaCommonEndpointActivation.this._connections.size() == 0) {
                int randomIndex = _random.nextInt(MEList.length);
                SibRaMessagingEngineConnection newConnection = SibRaCommonEndpointActivation.this.getConnection(MEList[randomIndex]);
                SibRaCommonEndpointActivation.this.createListener(newConnection);
            }
            if (TraceComponent.isAnyTracingEnabled() && NDPSTRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)NDPSTRACE, (String)"connectToLocalMEs");
            }
        }

        @Override
        public boolean isTimerNeeded() {
            boolean timerNeeded;
            String methodName = "isTimerNeeded";
            if (TraceComponent.isAnyTracingEnabled() && NDPSTRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)NDPSTRACE, (String)"isTimerNeeded");
            }
            boolean bl = timerNeeded = SibRaCommonEndpointActivation.this._connections.size() == 0;
            if (TraceComponent.isAnyTracingEnabled() && NDPSTRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)NDPSTRACE, (String)"isTimerNeeded", (Object)timerNeeded);
            }
            return timerNeeded;
        }
    }

    class PointToPointStrategy
    extends DestinationStrategy {
        PointToPointStrategy(SibRaCommonEndpointActivation parent) {
            super(parent);
        }

        @Override
        public boolean isDropRemoteNonPreferredForLocalNonPreferred() {
            return true;
        }

        @Override
        public boolean isTimerNeeded() {
            boolean timerNeeded;
            String methodName = "isTimerNeeded";
            if (TraceComponent.isAnyTracingEnabled() && P2PTRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)P2PTRACE, (String)"isTimerNeeded");
            }
            boolean bl = timerNeeded = SibRaCommonEndpointActivation.this._connections.size() == 0 || !SibRaCommonEndpointActivation.this._connectedToPreferred;
            if (TraceComponent.isAnyTracingEnabled() && P2PTRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)P2PTRACE, (String)"isTimerNeeded", (Object)timerNeeded);
            }
            return timerNeeded;
        }
    }

    private static final class SibRaDestinationListener
    implements DestinationListener {
        private final SibRaMessagingEngineConnection _connection;
        private final MessageEndpointFactory _messageEndpointFactory;

        private SibRaDestinationListener(SibRaMessagingEngineConnection connection, MessageEndpointFactory messageEndpointFactory) {
            String methodName = "SibRaDestinationListener";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"SibRaDestinationListener", (Object)new Object[]{connection, messageEndpointFactory});
            }
            this._connection = connection;
            this._messageEndpointFactory = messageEndpointFactory;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"SibRaDestinationListener");
            }
        }

        public void destinationAvailable(SICoreConnection connection, SIDestinationAddress destination, DestinationAvailability availability) {
            String methodName = "destinationAvailable";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"destinationAvailable", (Object)new Object[]{connection, destination, availability});
            }
            try {
                this._connection.createListener(destination, this._messageEndpointFactory);
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "destinationAvailable"), (String)"1:2400:1.45", (Object)this);
                SibTr.error((TraceComponent)TRACE, (String)"CREATE_LISTENER_FAILED_CWSIV0805", (Object)new Object[]{exception, destination.getDestinationName(), connection.getMeName(), destination.getBusName()});
            }
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"destinationAvailable");
            }
        }

        public String toString() {
            SibRaStringGenerator generator = new SibRaStringGenerator(this);
            return generator.getStringRepresentation();
        }
    }
}

