/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.jaxrs.monitor.JaxRsMonitorFilter;
import com.ibm.ws.jaxrs.monitor.metrics.service.RestMetricsCallback;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, property={"service.vendor=IBM"}, configurationPid={"com.ibm.ws.monitor.internal.MonitoringFrameworkExtender"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={ApplicationStateListener.class})
public class MonitorAppStateListener
implements ApplicationStateListener {
    private static final String MONITORING_GROUP_FILTER = "filter";
    private static final TraceComponent tc = Tr.register(MonitorAppStateListener.class, null, null);
    static RestMetricsCallback restMetricCallback;
    private static boolean isRESTEnabled;
    static final long serialVersionUID = -5951260841528442344L;

    public static boolean isRESTEnabled() {
        return isRESTEnabled;
    }

    public void applicationStarting(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        JaxRsMonitorFilter.RestMetricInfo metricInfo = JaxRsMonitorFilter.getMetricInfo(appName);
        if (appInfo.getClass().getName().endsWith("EARApplicationInfoImpl")) {
            metricInfo.setIsEar();
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        JaxRsMonitorFilter.cleanApplication(appInfo.getDeploymentName());
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    private void resolveMonitorFilter(Map<String, Object> properties) {
        String filter = (String)properties.get(MONITORING_GROUP_FILTER);
        if (filter != null && filter.length() != 0) {
            isRESTEnabled = filter.length() > 0 ? Stream.of(filter.split(",")).anyMatch(item -> item.equals("REST")) : true;
        } else if (filter == null) {
            isRESTEnabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("JAX-RS filter is enabled set to: [%s]", isRESTEnabled), (Object[])new Object[0]);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setRestMetricsCallback(RestMetricsCallback restMetricCallback) {
        MonitorAppStateListener.restMetricCallback = restMetricCallback;
    }

    public void unsetRestMetricsCallback(RestMetricsCallback restMetricCallback) {
        MonitorAppStateListener.restMetricCallback = null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        isRESTEnabled = true;
    }
}

