/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Provider;
import jakarta.xml.ws.Response;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.annotations.UseAsyncMethod;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public abstract class AbstractJAXWSMethodInvoker
extends FactoryInvoker {
    private static final String ASYNC_METHOD = "org.apache.cxf.jaxws.async.method";
    private static final String PARTIAL_RESPONSE_SENT_PROPERTY = "org.apache.cxf.ws.addressing.partial.response.sent";
    private static final Logger LOG = LogUtils.getLogger(AbstractJAXWSMethodInvoker.class);
    static final long serialVersionUID = -988986594940527384L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractJAXWSMethodInvoker(Object bean) {
        super((Factory)new SingletonFactory(bean));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "<init>", new Object[]{bean});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractJAXWSMethodInvoker(Factory factory) {
        super(factory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "<init>", new Object[]{factory});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "findSoapFaultException", new Object[]{ex});
        }
        if (ex instanceof SOAPFaultException) {
            SOAPFaultException sOAPFaultException = (SOAPFaultException)ex;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                sOAPFaultException = sOAPFaultException;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "findSoapFaultException", sOAPFaultException);
            }
            return sOAPFaultException;
        }
        if (ex.getCause() != null) {
            SOAPFaultException sOAPFaultException = this.findSoapFaultException(ex.getCause());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                sOAPFaultException = sOAPFaultException;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "findSoapFaultException", sOAPFaultException);
            }
            return sOAPFaultException;
        }
        SOAPFaultException sOAPFaultException = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sOAPFaultException = sOAPFaultException;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "findSoapFaultException", sOAPFaultException);
        }
        return sOAPFaultException;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Method adjustMethodAndParams(Method mOriginal, Exchange ex, List<Object> params, Class<?> serviceObjectClass) {
        block21: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "adjustMethodAndParams", new Object[]{mOriginal, ex, params, serviceObjectClass});
            }
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            Method mso = this.getProviderServiceObjectMethod(mOriginal, serviceObjectClass);
            UseAsyncMethod uam = mso.getAnnotation(UseAsyncMethod.class);
            if (isFinestEnabled) {
                LOG.finest("Annotation of UseAsyncMethod class from provider service object: " + uam);
            }
            if (uam != null) {
                BindingOperationInfo bop = ex.getBindingOperationInfo();
                Method ret = (Method)bop.getProperty(ASYNC_METHOD, Method.class);
                if (isFinestEnabled) {
                    LOG.finest("Method obtained from BindingOperationInfo is: " + ret);
                }
                if (ret == null) {
                    Class[] ptypes = new Class[mso.getParameterTypes().length + 1];
                    System.arraycopy(mso.getParameterTypes(), 0, ptypes, 0, mso.getParameterTypes().length);
                    ptypes[mso.getParameterTypes().length] = AsyncHandler.class;
                    if (isFinestEnabled) {
                        LOG.finest("Method parameters obtained from BindingOperationInfo are: " + ptypes);
                    }
                    try {
                        ret = mso.getDeclaringClass().getMethod(mso.getName() + "Async", ptypes);
                        bop.setProperty(ASYNC_METHOD, (Object)ret);
                        if (isFinestEnabled) {
                            LOG.finest("Async Method obtained from BindingOperationInfo is: " + ret);
                        }
                        break block21;
                    }
                    catch (Throwable t) {
                        if (isFinestEnabled) {
                            LOG.finest("Async version of the method is not found in the declaring class");
                        }
                        break block21;
                    }
                }
                JaxwsServerHandler h = (JaxwsServerHandler)ex.get(JaxwsServerHandler.class);
                if (h != null) {
                    Method method = ret;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        method = method;
                        LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "adjustMethodAndParams", method);
                    }
                    return method;
                }
                ContinuationProvider cp = (ContinuationProvider)ex.getInMessage().get(ContinuationProvider.class);
                if (isFinestEnabled) {
                    LOG.finest("ContinuationProvider obtained from inbound message is: " + cp);
                }
                boolean decoupledEndpoints = MessageUtils.getContextualBoolean((Message)ex.getInMessage(), (String)PARTIAL_RESPONSE_SENT_PROPERTY, (boolean)false);
                if (cp == null && uam.always() || decoupledEndpoints) {
                    JaxwsServerHandler handler = new JaxwsServerHandler(null);
                    ex.put(JaxwsServerHandler.class, (Object)handler);
                    params.add(handler);
                    if (isFinestEnabled) {
                        LOG.finest("Empty JaxwsServerHandler created and added to exchange with invoked parameters.");
                    }
                    Method method = ret;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        method = method;
                        LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "adjustMethodAndParams", method);
                    }
                    return method;
                }
                if (cp != null && cp.getContinuation() != null) {
                    Continuation c = cp.getContinuation();
                    if (isFinestEnabled) {
                        LOG.finest("Continuation: " + c);
                    }
                    c.suspend(0L);
                    JaxwsServerHandler handler = new JaxwsServerHandler(c);
                    ex.put(JaxwsServerHandler.class, (Object)handler);
                    params.add(handler);
                    if (isFinestEnabled) {
                        LOG.finest("Suspended Continuation. Empty JaxwsServerHandler created and added to exchange with invoked parameters.");
                    }
                    Method method = ret;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        method = method;
                        LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "adjustMethodAndParams", method);
                    }
                    return method;
                }
            }
        }
        Method method = mOriginal;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "adjustMethodAndParams", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Method getProviderServiceObjectMethod(Method m, Class<?> serviceObjectClass) {
        Method method;
        block11: {
            Class<?> currentSvcClass;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderServiceObjectMethod", new Object[]{m, serviceObjectClass});
            }
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            if (!Provider.class.isAssignableFrom(serviceObjectClass)) {
                if (isFinestEnabled) {
                    LOG.finest("Returning Method, " + m + ", because Provider is NOT assignable to service object");
                }
                Method method2 = m;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    method2 = method2;
                    LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderServiceObjectMethod", method2);
                }
                return method2;
            }
            Class<?> genericType = null;
            for (currentSvcClass = serviceObjectClass; currentSvcClass != null && (genericType = this.getProviderGenericType(currentSvcClass)) == null; currentSvcClass = currentSvcClass.getSuperclass()) {
            }
            if (isFinestEnabled) {
                LOG.finest("First service superclass after passing generic classes: " + currentSvcClass);
            }
            if (genericType == null) {
                if (isFinestEnabled) {
                    LOG.finest("Returning method, " + m + ", because the Service is not a generic type.");
                }
                Method method3 = m;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    method3 = method3;
                    LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderServiceObjectMethod", method3);
                }
                return method3;
            }
            try {
                method = serviceObjectClass.getMethod("invoke", genericType);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
            }
            catch (Exception e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            method = method;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderServiceObjectMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class<?> getProviderGenericType(Class<?> svcClass) {
        Type[] interfaces;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderGenericType", new Object[]{svcClass});
        }
        for (Type interfaceType : interfaces = svcClass.getGenericInterfaces()) {
            Type[] typeArgs;
            ParameterizedType paramInterface;
            if (!(interfaceType instanceof ParameterizedType) || !(paramInterface = (ParameterizedType)interfaceType).getRawType().equals(Provider.class) || (typeArgs = paramInterface.getActualTypeArguments()).length <= 0) continue;
            Class clazz = (Class)typeArgs[0];
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderGenericType", clazz);
            }
            return clazz;
        }
        Class<?> clazz = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getProviderGenericType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "invoke", new Object[]{exchange, serviceObject, m, params});
        }
        JaxwsServerHandler h = (JaxwsServerHandler)exchange.get(JaxwsServerHandler.class);
        if (h != null && h.isDone()) {
            Object object = this.getMessageContentsList(exchange, h, m, params);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "invoke", object);
            }
            return object;
        }
        Object o = super.invoke(exchange, serviceObject, m, params);
        if (h != null && !h.hasContinuation()) {
            h.waitForDone();
            Object object = this.getMessageContentsList(exchange, h, m, params);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "invoke", object);
            }
            return object;
        }
        Object object = o;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "invoke", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object getMessageContentsList(Exchange exchange, JaxwsServerHandler h, Method m, List<Object> params) {
        MessageContentsList messageContentsList;
        block9: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getMessageContentsList", new Object[]{exchange, h, m, params});
            }
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            BindingOperationInfo bop = exchange.getBindingOperationInfo();
            if (bop.isUnwrapped()) {
                exchange.put(BindingOperationInfo.class, (Object)bop.getWrappedOperation());
                if (isFinestEnabled) {
                    LOG.finest("BindingOperationInfo which was unwrapped, is replaced with wrapped BindingOperationInfo in exchange: " + bop.getWrappedOperation());
                }
            }
            try {
                if (isFinestEnabled) {
                    LOG.finest("Response field of JaxwsServerHandler returned as MessageContentList(Derived from ArrayList): " + h.getObject());
                }
                messageContentsList = new MessageContentsList(new Object[]{h.getObject()});
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
            }
            catch (ExecutionException ex) {
                exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
                if (isFinestEnabled) {
                    LOG.finest("Fault will be related with ExecutionException: " + ex.getStackTrace());
                }
                throw this.createFault(ex.getCause(), m, params, true);
            }
            catch (Exception ex) {
                if (isFinestEnabled) {
                    LOG.finest("Fault will be created with Exception: " + ex.getStackTrace());
                }
                throw this.createFault(ex.getCause(), m, params, false);
            }
            messageContentsList = messageContentsList;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "getMessageContentsList", messageContentsList);
        }
        return messageContentsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Fault createFault(Throwable ex, Method m, List<Object> params, boolean checked) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "createFault", new Object[]{ex, m, params, checked});
        }
        SOAPFaultException sfe = this.findSoapFaultException(ex);
        if (sfe != null) {
            SoapFault fault = new SoapFault(sfe.getFault().getFaultString(), ex, sfe.getFault().getFaultCodeAsQName());
            fault.setRole(sfe.getFault().getFaultActor());
            if (sfe.getFault().hasDetail()) {
                fault.setDetail((Element)sfe.getFault().getDetail());
            }
            SoapFault soapFault = fault;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                soapFault = soapFault;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "createFault", soapFault);
            }
            return soapFault;
        }
        Fault fault = super.createFault(ex, m, params, checked);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            fault = fault;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "createFault", fault);
        }
        return fault;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, Object> removeHandlerProperties(WrappedMessageContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "removeHandlerProperties", new Object[]{ctx});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        Map scopes = CastUtils.cast((Map)((Map)ctx.get(WrappedMessageContext.SCOPES)));
        HashMap<String, Object> handlerScopedStuff = new HashMap<String, Object>();
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                handlerScopedStuff.put((String)scope.getKey(), ctx.get(scope.getKey()));
            }
            for (String key : handlerScopedStuff.keySet()) {
                ctx.remove(key);
                if (!isFinestEnabled) continue;
                LOG.finest("Removed handler property from WrappedMessageContext - key: " + key + "  and value: " + handlerScopedStuff.get(key));
            }
        }
        HashMap<String, Object> hashMap = handlerScopedStuff;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "removeHandlerProperties", hashMap);
        }
        return hashMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addHandlerProperties(WrappedMessageContext ctx, Map<String, Object> handlerScopedStuff) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "addHandlerProperties", new Object[]{ctx, handlerScopedStuff});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        for (Map.Entry<String, Object> key : handlerScopedStuff.entrySet()) {
            ctx.put(key.getKey(), key.getValue(), MessageContext.Scope.HANDLER);
            if (!isFinestEnabled) continue;
            LOG.finest("Added handler property to WrappedMessageContext - key: " + key + "  and value: " + handlerScopedStuff.get(key));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "addHandlerProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Message createResponseMessage(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "createResponseMessage", new Object[]{exchange});
        }
        if (exchange == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Exchange is null, can not create response message!");
            }
            Message message = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                message = message;
                LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "createResponseMessage", message);
            }
            return message;
        }
        Message m = exchange.getOutMessage();
        if (m == null && !exchange.isOneWay()) {
            Endpoint ep = exchange.getEndpoint();
            m = new MessageImpl();
            m.setExchange(exchange);
            m = ep.getBinding().createMessage(m);
            exchange.setOutMessage(m);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Out message can not be found in the exchange and it's not one way. A new message is created and added to exchange: " + m);
            }
        }
        Message message = m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "createResponseMessage", message);
        }
        return message;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateWebServiceContext(Exchange exchange, MessageContext ctx) {
        Map heads;
        Message out;
        List list;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "updateWebServiceContext", new Object[]{exchange, ctx});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty()) {
            SoapMessage sm = (SoapMessage)this.createResponseMessage(exchange);
            if (isFinestEnabled) {
                LOG.finest("MessageContext contains headers. Response SOAP message is been created. ");
            }
            if (sm != null) {
                for (Header header : list) {
                    sm.getHeaders().add(header);
                    if (!isFinestEnabled) continue;
                    LOG.finest("Header found in MessageContext: " + header + " is added to response SOAP message");
                }
            }
        }
        if (exchange.getOutMessage() != null && (out = exchange.getOutMessage()).containsKey((Object)Message.PROTOCOL_HEADERS) && (heads = CastUtils.cast((Map)((Map)exchange.getOutMessage().get((Object)Message.PROTOCOL_HEADERS)))).containsKey("Content-Type")) {
            List ct = (List)heads.get("Content-Type");
            exchange.getOutMessage().put((Object)"Content-Type", ct.get(0));
            if (isFinestEnabled) {
                LOG.finest("Protocol header on outbound message, Content-Type, has been set to: " + (String)ct.get(0));
            }
            heads.remove("Content-Type");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "updateWebServiceContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateHeader(Exchange exchange, MessageContext ctx) {
        List list;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "updateHeader", new Object[]{exchange, ctx});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty()) {
            SoapMessage sm = (SoapMessage)this.createResponseMessage(exchange);
            if (isFinestEnabled) {
                LOG.finest("MessageContext contains headers. Response SOAP message is been created. ");
            }
            if (sm != null) {
                for (Header header : list) {
                    if (header.getDirection() == Header.Direction.DIRECTION_IN || header.getName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || header.getName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
                    sm.getHeaders().add(header);
                    if (!isFinestEnabled) continue;
                    LOG.finest("Header is copied over reponse SOAP message from message context:" + header);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker", "updateHeader");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    class JaxwsServerHandler
    implements AsyncHandler<Object> {
        Response<Object> r;
        Continuation continuation;
        boolean done;
        static final long serialVersionUID = -2343939586167178154L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        JaxwsServerHandler(Continuation c) {
            this.continuation = c;
        }

        public synchronized void handleResponse(Response<Object> res) {
            this.r = res;
            this.done = true;
            if (this.continuation != null) {
                this.continuation.resume();
            }
            this.notifyAll();
        }

        public boolean hasContinuation() {
            return this.continuation != null;
        }

        public synchronized void waitForDone() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public Object getObject() throws Exception {
            return this.r.get();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker$JaxwsServerHandler", JaxwsServerHandler.class, null, null);
        }
    }
}

