/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.activation.DataSource;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class MessageModeInInterceptor
extends AbstractPhaseInterceptor<Message> {
    Class<?> type;
    QName bindingName;
    Class<?> soapMsgClass;
    private static final Logger LOG = LogUtils.getLogger(MessageModeInInterceptor.class);
    static final long serialVersionUID = -7281327876715481644L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageModeInInterceptor(Class<?> c, QName bName) {
        block5: {
            super("post-logical");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "<init>", new Object[]{c, bName});
            }
            this.bindingName = bName;
            this.type = c;
            try {
                this.soapMsgClass = Class.forName("jakarta.xml.soap.SOAPMessage");
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("SOAPMessage class is found: " + this.soapMsgClass.getName());
                }
            }
            catch (Throwable t) {
                this.soapMsgClass = null;
                if (!LOG.isLoggable(Level.FINEST)) break block5;
                LOG.finest("SOAPMessage class is not found.");
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "handleMessage", objectArray);
        }
        BindingOperationInfo bop = message.getExchange().getBindingOperationInfo();
        if (bop == null || !this.bindingName.equals(bop.getBinding().getName())) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("BindingOperationInfo is null or binding qname is different than the one provided in constructor. Returning.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "handleMessage");
            }
            return;
        }
        Object o = message.getContent(this.soapMsgClass);
        if (o != null) {
            this.doFromSoapMessage(message, o);
        } else if (DataSource.class.isAssignableFrom(this.type)) {
            this.doDataSource(message);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doDataSource(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "doDataSource", new Object[]{message});
        }
        MessageContentsList list = (MessageContentsList)message.getContent(List.class);
        if (message.getAttachments() != null && !message.getAttachments().isEmpty() && list != null && !list.isEmpty() && list.get(0) instanceof DataSource) {
            list.set(0, (Object)new MultiPartDataSource(message, (DataSource)list.get(0)));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Data source that is obtained from MessageContentsList is set back as MultiPartDataSource: " + list.get(0));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "doDataSource");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void doFromSoapMessage(@Sensitive Message message, Object sm) {
        void var6_10;
        MessageContentsList list;
        boolean isFinestEnabled;
        block19: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                Object[] objectArray = new Object[2];
                objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
                objectArray[1] = sm;
                LOG.entering("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "doFromSoapMessage", objectArray);
            }
            isFinestEnabled = LOG.isLoggable(Level.FINEST);
            SOAPMessage m = (SOAPMessage)sm;
            list = (MessageContentsList)message.getContent(List.class);
            if (list == null) {
                list = new MessageContentsList();
                message.setContent(List.class, (Object)list);
                if (isFinestEnabled) {
                    LOG.finest("MessageContentsList that is obtained from null. Replaced with empty list.");
                }
            }
            SOAPMessage sOAPMessage = m;
            if (StreamSource.class.isAssignableFrom(this.type)) {
                try (CachedOutputStream out = new CachedOutputStream();){
                    XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter((OutputStream)out);
                    StaxUtils.copy((Source)new DOMSource((Node)m.getSOAPPart()), (XMLStreamWriter)xsw);
                    xsw.close();
                    StreamSource streamSource = new StreamSource(out.getInputStream());
                    if (isFinestEnabled) {
                        LOG.finest("SOAPPart of SOAPMessage is converted to StreamSource");
                    }
                    break block19;
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
            if (SAXSource.class.isAssignableFrom(this.type)) {
                StaxSource staxSource = new StaxSource((XMLStreamReader)new W3CDOMStreamReader((Document)m.getSOAPPart()));
                if (isFinestEnabled) {
                    LOG.finest("SOAPPart of SOAPMessage is converted to StaxSource");
                }
            } else if (Source.class.isAssignableFrom(this.type)) {
                DOMSource dOMSource = new DOMSource((Node)m.getSOAPPart());
                if (isFinestEnabled) {
                    LOG.finest("SOAPPart of SOAPMessage is converted to DOMSource");
                }
            }
        }
        list.set(0, (Object)var6_10);
        if (isFinestEnabled) {
            LOG.finest("Converted object is added to MessageContentsList: " + var6_10);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor", "doFromSoapMessage");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class MultiPartDataSource
    implements DataSource {
        final Iterator<Attachment> atts;
        final String contentType;
        final String boundary;
        final String start;
        final LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
        Writer writer;
        DataSource rootPart;
        InputStream current;
        boolean writingHeaders;
        Attachment att;
        static final long serialVersionUID = 8930855213778910209L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        MultiPartDataSource(Message message, DataSource root) {
            this.atts = message.getAttachments().iterator();
            String s = (String)message.get((Object)"Content-Type");
            this.boundary = this.findBoundary(s);
            this.start = this.findStart(s);
            if (!s.contains(this.boundary)) {
                s = s + "; boundary=\"" + this.boundary + "\"";
            }
            this.contentType = s;
            this.rootPart = root;
            try {
                this.writer = new OutputStreamWriter((OutputStream)this.bout, "ASCII");
                this.writer.append("Content-Type: ").append(this.contentType).append("\r\n\r\n");
                this.writer.flush();
                this.current = this.bout.createInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new InputStream(){
                static final long serialVersionUID = -3891170186718516387L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int read() throws IOException {
                    int i = current.read();
                    if (i == -1) {
                        this.nextCurrent();
                        i = current.read();
                    }
                    return i;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor$MultiPartDataSource$1", 1.class, null, null);
                }
            };
        }

        private void nextCurrent() throws IOException {
            if (this.rootPart != null) {
                if (this.writingHeaders) {
                    this.writingHeaders = false;
                    this.current = this.rootPart.getInputStream();
                    this.rootPart = null;
                } else {
                    this.writingHeaders = true;
                    this.bout.reset();
                    this.writer.append("--").append(this.boundary).append("\r\n");
                    this.writer.append("Content-Type: ").append(this.rootPart.getContentType()).append("\r\n");
                    this.writer.append("Content-ID: <").append(this.start).append(">\r\n\r\n");
                    this.writer.flush();
                    this.current = this.bout.createInputStream();
                }
            } else if (this.writingHeaders) {
                this.writingHeaders = false;
                this.current = this.att.getDataHandler().getInputStream();
            } else if (this.atts.hasNext()) {
                this.att = this.atts.next();
                this.writingHeaders = true;
                this.bout.reset();
                this.writer.append("\r\n");
                this.writer.append("--").append(this.boundary).append("\r\n");
                Iterator heads = this.att.getHeaderNames();
                while (heads.hasNext()) {
                    String s = (String)heads.next();
                    this.writer.append(s).append(": ").append(this.att.getHeader(s)).append("\r\n");
                }
                this.writer.append("\r\n");
                this.writer.flush();
                this.current = this.bout.createInputStream();
            }
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        private String findStart(String ct) {
            int idx = ct.indexOf("start=");
            if (idx == -1) {
                return "root";
            }
            if ((ct = ct.substring(idx + 6)).charAt(0) == '\"') {
                ct = ct.substring(1);
                idx = ct.indexOf(34);
                return ct.substring(0, idx);
            }
            idx = ct.indexOf(59);
            if (idx == -1) {
                return ct;
            }
            return ct.substring(0, idx);
        }

        private String findBoundary(String ct) {
            int idx = ct.indexOf("boundary=");
            if (idx == -1) {
                return AttachmentUtil.getUniqueBoundaryValue();
            }
            if ((ct = ct.substring(idx + 9)).charAt(0) == '\"') {
                ct = ct.substring(1);
                idx = ct.indexOf(34);
                return ct.substring(0, idx);
            }
            idx = ct.indexOf(59);
            if (idx == -1) {
                return ct;
            }
            return ct.substring(0, idx);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor$MultiPartDataSource", MultiPartDataSource.class, null, null);
        }
    }
}

