/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamControl;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.LinkedList;
import java.util.List;

public class ExpressTargetStream
extends ControllableStream
implements TargetStream {
    private MessageDeliverer deliverer;
    private static TraceComponent tc = SibTr.register(ExpressTargetStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long lastTick;
    private long messagesReceived;
    private long timeLastMsgReceived;
    private SIBUuid12 streamSetUUID;
    SIBUuid8 remoteEngineUUID;
    private ExpressTargetStreamState streamState = ExpressTargetStreamState.ACTIVE;

    public ExpressTargetStream(MessageDeliverer deliverer, SIBUuid8 remoteMEUuid, SIBUuid12 _streamSetUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ExpressTargetStream", (Object)new Object[]{deliverer, remoteMEUuid, _streamSetUuid});
        }
        this.remoteEngineUUID = remoteMEUuid;
        this.lastTick = -1L;
        this.deliverer = deliverer;
        this.streamSetUUID = _streamSetUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ExpressTargetStream", (Object)this);
        }
    }

    @Override
    public long getCompletedPrefix() {
        return this.lastTick;
    }

    private boolean isStreamFull(JsMessage msg) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStreamFull", (Object)msg);
        }
        boolean isStreamFull = false;
        int blockingReason = this.deliverer.checkAbleToAcceptMessage(msg.getRoutingDestination());
        if (blockingReason != 1) {
            isStreamFull = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStreamFull", (Object)new Boolean(isStreamFull));
        }
        return isStreamFull;
    }

    @Override
    public synchronized void writeValue(MessageItem msgItem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeValue", (Object)msgItem);
        }
        this.timeLastMsgReceived = System.currentTimeMillis();
        if (msgItem.getMessage().getGuaranteedValueValueTick() > this.lastTick) {
            try {
                if (this.isStreamFull(msgItem.getMessage())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"discarding message as the stream is full.");
                    }
                } else {
                    this.deliverer.deliverExpressMessage(msgItem, this);
                    ++this.messagesReceived;
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.ExpressTargetStream.writeValue", (String)"1:181:1.54", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue");
        }
    }

    @Override
    public long reconstituteCompletedPrefix(long prefix) {
        this.lastTick = prefix;
        return this.lastTick;
    }

    @Override
    public void setCompletedPrefix(long prefix) {
        this.lastTick = prefix;
    }

    @Override
    public void writeSilence(ControlSilence m) {
    }

    @Override
    public void writeSilence(MessageItem m) {
    }

    @Override
    public void processAckExpected(long stamp) {
    }

    @Override
    public void flush() {
    }

    public void batchPrecommit(TransactionCommon currentTran) {
    }

    public void batchCommitted() {
    }

    public void batchRolledBack() {
    }

    @Override
    public long getLastKnownTick() {
        return this.lastTick;
    }

    @Override
    public StateStream getStateStream() {
        return null;
    }

    @Override
    public void writeSilenceForced(long tick) {
    }

    @Override
    protected int getPriority() {
        return 0;
    }

    @Override
    protected Reliability getReliability() {
        return Reliability.EXPRESS_NONPERSISTENT;
    }

    @Override
    public TargetStreamControl getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        TargetStreamControl targetStreamControl = new TargetStreamControl(this.remoteEngineUUID, this, this.streamSetUUID, this.getReliability(), this.getPriority());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)targetStreamControl);
        }
        return targetStreamControl;
    }

    @Override
    public List<MessageItem> getAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList<MessageItem> returnValue = new LinkedList<MessageItem>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream", returnValue);
        }
        return returnValue;
    }

    @Override
    public long getNumberOfMessagesReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesReceived");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)new Long(this.messagesReceived));
        }
        return this.messagesReceived;
    }

    @Override
    public TargetStream.TargetStreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.streamState);
        }
        return this.streamState;
    }

    @Override
    public long countAllMessagesOnStream() {
        return 0L;
    }

    @Override
    public long getLastMsgReceivedTimestamp() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastMsgReceivedTimestamp");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgReceivedTimestamp", (Object)new Long(this.timeLastMsgReceived));
        }
        return this.timeLastMsgReceived;
    }

    public static class ExpressTargetStreamState
    extends TargetStream.TargetStreamState {
        public static final ExpressTargetStreamState ACTIVE = new ExpressTargetStreamState("Active", 1);

        private ExpressTargetStreamState(String _name, int _id) {
            super(_name, _id);
        }
    }
}

