/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.FlushAlreadyInProgressException;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.Reallocator;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamSetControl;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SourceStreamManager {
    private boolean pointTopoint = false;
    private SIMPTransactionManager txManager;
    private ProtocolItemStream protocolItemStream = null;
    private SIBUuid8 targetMEUuid = null;
    private DestinationHandler destinationHandler;
    private MessageProcessor messageProcessor;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(SourceStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DownstreamControl downControl;
    private StreamSet streamSet;
    private Reallocator reallocator = null;
    protected FlushComplete flushInProgress = null;

    public SourceStreamManager(MessageProcessor messageProcessor, DownstreamControl downControl, DestinationHandler destinationHandler, ProtocolItemStream protocolItemStream, SIBUuid8 targetMEUuid, Reallocator reallocator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SourceStreamManager", (Object)new Object[]{messageProcessor, downControl, destinationHandler, protocolItemStream, targetMEUuid, reallocator});
        }
        this.messageProcessor = messageProcessor;
        this.downControl = downControl;
        this.destinationHandler = destinationHandler;
        this.protocolItemStream = protocolItemStream;
        this.txManager = messageProcessor.getTXManager();
        this.targetMEUuid = targetMEUuid;
        this.reallocator = reallocator;
        if (reallocator != null) {
            this.pointTopoint = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SourceStreamManager", (Object)this);
        }
    }

    public synchronized StreamSet getStreamSet() throws SIResourceException {
        if (this.streamSet == null) {
            this.createNewPersistentStreamSet(null);
        }
        return this.streamSet;
    }

    public SourceStreamSetControl getStreamSetRuntimeControl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSetRuntimeControl");
        }
        SourceStreamSetControl control = null;
        try {
            control = (SourceStreamSetControl)this.getStreamSet().getControlAdapter();
            control.setSourceStreamManager(this);
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.getStreamSetRuntimeControl", (String)"1:188:1.102", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSetRuntimeControl", (Object)control);
        }
        return control;
    }

    private synchronized StreamSet getStreamSet(SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSet", (Object)streamID);
        }
        if (this.streamSet == null) {
            this.createNewPersistentStreamSet(streamID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSet", (Object)this.streamSet);
        }
        return this.streamSet;
    }

    private void createNewPersistentStreamSet(SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)streamID);
        }
        if (streamID == null) {
            streamID = new SIBUuid12();
        }
        try {
            LocalTransaction tran = this.txManager.createLocalTransaction(false);
            Transaction msTran = this.txManager.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
            long sendWindow = Long.MAX_VALUE;
            if (this.pointTopoint) {
                sendWindow = this.messageProcessor.getDefinedSendWindow();
            }
            StreamSet.Type type = StreamSet.Type.SOURCE;
            if (this.destinationHandler.isLink()) {
                type = this.destinationHandler.hasLocal() ? StreamSet.Type.LINK_SOURCE : StreamSet.Type.LINK_REMOTE_SOURCE;
            }
            this.streamSet = new StreamSet(streamID, this.targetMEUuid, this.destinationHandler.getUuid(), this.messageProcessor.getMessagingEngineBusUuid(), this.protocolItemStream, this.txManager, sendWindow, type, (TransactionCommon)tran, null);
            this.protocolItemStream.addItem(this.streamSet, msTran);
            tran.commit();
        }
        catch (SIConnectionLostException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (SIIncorrectCallException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.createNewPersistentStreamSet", (String)"1:294:1.102", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessage(SIMPMessage msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMessage", (Object)new Object[]{msgItem});
        }
        JsMessage jsMsg = msgItem.getMessage();
        StreamSet streamSet = this.getStreamSet();
        msgItem.setGuaranteedStreamUuid(streamSet.getStreamID());
        Reliability reliability = msgItem.getReliability();
        if (reliability == Reliability.BEST_EFFORT_NONPERSISTENT) {
            this.addBestEffortMessage(msgItem);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addMessage", (Object)false);
            }
            return false;
        }
        SourceStream sourceStream = null;
        int priority = msgItem.getPriority();
        Object object = streamSet;
        synchronized (object) {
            sourceStream = (SourceStream)streamSet.getStream(priority, reliability);
            if (sourceStream == null) {
                sourceStream = this.createStream(streamSet, priority, reliability, streamSet.getPersistentData(priority, reliability), false);
            }
        }
        object = sourceStream;
        synchronized (object) {
            long tick = this.messageProcessor.nextTick();
            if (msgItem.getRequiresNewId() || jsMsg.getSystemMessageId() == null) {
                jsMsg.setSystemMessageSourceUuid(this.messageProcessor.getMessagingEngineUuid());
                jsMsg.setSystemMessageValue(tick);
                msgItem.setRequiresNewId(false);
            }
            jsMsg.setGuaranteedValueEndTick(tick);
            jsMsg.setGuaranteedValueValueTick(tick);
            jsMsg.setGuaranteedValueRequestedOnly(false);
            jsMsg.setGuaranteedValueStartTick(sourceStream.getLastMsgAdded() + 1L);
            jsMsg.setGuaranteedValueCompletedPrefix(sourceStream.getCompletedPrefix());
            sourceStream.writeUncommitted(msgItem);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMessage", (Object)true);
        }
        return true;
    }

    private void addBestEffortMessage(SIMPMessage msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addBestEffortMessage", (Object)new Object[]{msgItem});
        }
        JsMessage jsMsg = msgItem.getMessage();
        long tick = this.messageProcessor.nextTick();
        if (msgItem.getRequiresNewId() || jsMsg.getSystemMessageId() == null) {
            jsMsg.setSystemMessageSourceUuid(this.messageProcessor.getMessagingEngineUuid());
            jsMsg.setSystemMessageValue(tick);
            msgItem.setRequiresNewId(false);
        }
        jsMsg.setGuaranteedValueEndTick(tick);
        jsMsg.setGuaranteedValueValueTick(tick);
        jsMsg.setGuaranteedValueRequestedOnly(false);
        jsMsg.setGuaranteedValueStartTick(-1L);
        jsMsg.setGuaranteedValueCompletedPrefix(-1L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addBestEffortMessage");
        }
    }

    public boolean removeMessage(SIMPMessage msgItem) throws SIResourceException {
        Reliability reliability;
        int priority;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{msgItem});
        }
        boolean msgRemoved = true;
        StreamSet streamSet = this.getStreamSet();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(priority = msgItem.getPriority(), reliability = msgItem.getReliability());
        if (sourceStream != null) {
            msgRemoved = sourceStream.writeSilenceForced(msgItem);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)msgRemoved);
        }
        return msgRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreMessage(SIMPMessage msgItem, boolean commit) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreMessage", (Object)new Object[]{msgItem});
        }
        int priority = msgItem.getPriority();
        Reliability reliability = msgItem.getReliability();
        SIBUuid12 streamID = msgItem.getGuaranteedStreamUuid();
        StreamSet streamSet = this.getStreamSet(streamID);
        SourceStream sourceStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            sourceStream = (SourceStream)streamSet.getStream(priority, reliability);
            if (sourceStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                sourceStream = this.createStream(streamSet, priority, reliability, streamSet.getPersistentData(priority, reliability), true);
            }
        }
        if (sourceStream != null) {
            if (!commit) {
                sourceStream.restoreUncommitted(msgItem);
            } else {
                sourceStream.restoreValue(msgItem);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreMessage");
        }
    }

    public void reallocate(boolean allMsgs) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocate");
        }
        if (this.pointTopoint) {
            this.reallocator.reallocateMsgs(this.destinationHandler, allMsgs, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocate");
        }
    }

    public List processAck(ControlAck ackMsg) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg});
        }
        long ackPrefix = ackMsg.getAckPrefix();
        List indexList = this.processAck(ackMsg, ackPrefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)indexList);
        }
        return indexList;
    }

    public List processAck(ControlAck ackMsg, long ackPrefix) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg, new Long(ackPrefix)});
        }
        List indexList = null;
        if (!this.hasStream(ackMsg.getGuaranteedStreamUUID())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)new Object[]{"unknown stream ID - returning null array list(message ignored)"});
            }
            return indexList;
        }
        int priority = ackMsg.getPriority();
        Reliability reliability = ackMsg.getReliability();
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            StreamSet streamSet = this.getStreamSet();
            SourceStream sourceStream = (SourceStream)streamSet.getStream(priority, reliability);
            if (sourceStream == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)new Object[]{"unknown priority - returning null array list(message ignored)"});
                }
                return indexList;
            }
            long completedPrefix = sourceStream.getAckPrefix();
            if (ackPrefix > completedPrefix) {
                indexList = sourceStream.writeAckPrefix(ackPrefix);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unexpected Ack message for BEST_EFFORT_NONPERSISTENT message ");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", indexList);
        }
        return indexList;
    }

    public void processNack(ControlNack nackMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)nackMsg);
        }
        if (!this.hasStream(nackMsg.getGuaranteedStreamUUID())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)"unknown stream ID - message ignored");
            }
            return;
        }
        int priority = nackMsg.getPriority();
        Reliability reliability = nackMsg.getReliability();
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            StreamSet streamSet = this.getStreamSet();
            SourceStream sourceStream = (SourceStream)streamSet.getStream(priority, reliability);
            if (sourceStream == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)"unknown priority - message ignored");
                }
                return;
            }
            sourceStream.processNack(nackMsg);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unexpected Nack message for BEST_EFFORT_NONPERSISTENT message ");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    public boolean isFlushed(SIBUuid12 streamID) {
        if (this.streamSet == null) {
            return true;
        }
        return !streamID.equals((Object)this.streamSet.getStreamID());
    }

    public boolean isReallocationRequired(SIMPMessage msg) throws SIResourceException {
        TickRange tr;
        Reliability reliability;
        StreamSet streamSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReallocationRequired", (Object)new Object[]{msg});
        }
        boolean reallocate = false;
        JsMessage jsMsg = msg.getMessage();
        SIBUuid12 streamID = msg.getGuaranteedStreamUuid();
        if (!streamID.equals((Object)(streamSet = this.getStreamSet()).getStreamID())) {
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:717:1.102"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.isReallocationRequired", (String)"1:724:1.102", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:731:1.102"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired", (Object)((Object)e));
            }
            throw e;
        }
        int priority = msg.getPriority();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(priority, reliability = msg.getReliability());
        if (sourceStream != null && (tr = sourceStream.getTickRange(jsMsg.getGuaranteedValueValueTick())).isReallocationRequired() && sourceStream.isOutsideSendWindow(jsMsg.getGuaranteedValueValueTick())) {
            reallocate = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired", (Object)reallocate);
        }
        return reallocate;
    }

    public boolean hasStream(SIBUuid12 streamID) {
        if (this.streamSet == null) {
            return false;
        }
        return streamID.equals((Object)this.streamSet.getStreamID());
    }

    private SourceStream createStream(StreamSet streamSet, int priority, Reliability reliability, long sendWindow, boolean restore) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, new Integer(priority), reliability, new Long(sendWindow), restore});
        }
        SourceStream stream = this.createStream(streamSet, priority, reliability);
        if (this.pointTopoint) {
            stream.initialiseSendWindow(sendWindow, this.messageProcessor.getDefinedSendWindow());
            if (restore && this.destinationHandler.isLink() && !this.destinationHandler.isMQLink()) {
                stream.guessesInStream();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", (Object)stream);
        }
        return stream;
    }

    private SourceStream createStream(StreamSet streamSet, int priority, Reliability reliability) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, new Integer(priority), reliability});
        }
        SourceStream stream = null;
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            stream = new SourceStream(priority, reliability, this.downControl, new ArrayList(), streamSet, this.messageProcessor.getAlarmManager(), this.destinationHandler);
        }
        streamSet.setStream(priority, reliability, stream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", stream);
        }
        return stream;
    }

    public void reconstituteStreamSet(StreamSet newStreamSet) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteStreamSet", (Object)this.streamSet);
        }
        if (this.streamSet != null) {
            this.streamSet.remove();
        }
        this.streamSet = newStreamSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteStreamSet");
        }
    }

    public ControlNotFlushed stampNotFlushed(ControlNotFlushed msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stampNotFlushed", (Object)new Object[]{msg});
        }
        int count = 0;
        int max = 10 * (Reliability.MAX_INDEX + 1);
        int[] ps = new int[max];
        int[] qs = new int[max];
        long[] cs = new long[max];
        StreamSet streamSet = this.getStreamSet();
        Iterator<Stream> itr = streamSet.iterator();
        while (itr.hasNext()) {
            SourceStream sourceStream = (SourceStream)itr.next();
            ps[count] = sourceStream.getPriority();
            qs[count] = sourceStream.getReliability().toInt();
            cs[count] = sourceStream.getCompletedPrefix();
            ++count;
        }
        int[] realps = new int[count];
        int[] realqs = new int[count];
        long[] realcs = new long[count];
        System.arraycopy(ps, 0, realps, 0, count);
        System.arraycopy(qs, 0, realqs, 0, count);
        System.arraycopy(cs, 0, realcs, 0, count);
        msg.setCompletedPrefixPriority(realps);
        msg.setCompletedPrefixQOS(realqs);
        msg.setCompletedPrefixTicks(realcs);
        msg.setDuplicatePrefixPriority(realps);
        msg.setDuplicatePrefixQOS(realqs);
        msg.setDuplicatePrefixTicks(realcs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stampNotFlushed", (Object)msg);
        }
        return msg;
    }

    public List consolidateStreams(int startMode) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consolidateStreams");
        }
        ArrayList sentMsgs = new ArrayList();
        StreamSet streamSet = this.getStreamSet();
        Iterator<Stream> itr = streamSet.iterator();
        List temp = null;
        while (itr.hasNext()) {
            SourceStream stream = (SourceStream)itr.next();
            temp = stream.restoreStream(startMode);
            if (temp != null) {
                sentMsgs.addAll(temp);
            }
            if (!this.pointTopoint) continue;
            stream.setDefinedSendWindow(this.messageProcessor.getDefinedSendWindow());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consolidateStreams", sentMsgs);
        }
        return sentMsgs;
    }

    public boolean flushable() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushable");
        }
        if (this.streamSet == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushable", (Object)Boolean.TRUE);
            }
            return true;
        }
        StreamSet streamSet = this.getStreamSet();
        Iterator<Stream> itr = streamSet.iterator();
        while (itr.hasNext()) {
            SourceStream stream = (SourceStream)itr.next();
            if (stream.flushable()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushable", (Object)Boolean.FALSE);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushable", (Object)Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFlush(FlushComplete complete) throws FlushAlreadyInProgressException, SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startFlush", (Object)new Object[]{complete});
        }
        SourceStreamManager sourceStreamManager = this;
        synchronized (sourceStreamManager) {
            if (this.flushInProgress != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"startFlush", (Object)"FlushAlreadyInProgressException");
                }
                throw new FlushAlreadyInProgressException();
            }
            this.flushInProgress = complete;
        }
        this.attemptFlush();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startFlush");
        }
    }

    public void attemptFlushIfNecessary() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (this.flushInProgress != null) {
            this.attemptFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptFlush() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attemptFlush");
        }
        FlushComplete callback = null;
        StreamSet oldStreamSet = null;
        SourceStreamManager sourceStreamManager = this;
        synchronized (sourceStreamManager) {
            if (this.flushInProgress == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attemptFlush");
                }
                return;
            }
            if (!this.flushable()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attemptFlush");
                }
                return;
            }
            callback = this.flushInProgress;
            this.flushInProgress = null;
            oldStreamSet = this.streamSet;
            this.streamSet = null;
            if (oldStreamSet != null) {
                oldStreamSet.remove();
            }
        }
        try {
            if (oldStreamSet != null) {
                this.downControl.sendFlushedMessage(null, oldStreamSet.getStreamID());
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.attemptFlush", (String)"1:1158:1.102", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"attemptFlush", (Object)e);
            }
            return;
        }
        finally {
            callback.flushComplete(this.destinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attemptFlush");
        }
    }

    public boolean updateSourceStream(SIMPMessage msg, boolean isSilence) throws SIResourceException {
        Reliability reliability;
        StreamSet streamSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateSourceStream", (Object)new Object[]{msg});
        }
        boolean sendMessage = false;
        SIBUuid12 streamID = msg.getGuaranteedStreamUuid();
        if (!streamID.equals((Object)(streamSet = this.getStreamSet()).getStreamID())) {
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:1244:1.102"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.updateSourceStream", (String)"1:1251:1.102", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:1258:1.102"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"updateSourceStream", (Object)((Object)e));
            }
            throw e;
        }
        int priority = msg.getPriority();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(priority, reliability = msg.getReliability());
        sendMessage = sourceStream != null ? (isSilence ? sourceStream.writeSilence(msg) : sourceStream.writeValue(msg)) : true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateSourceStream", (Object)sendMessage);
        }
        return sendMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlushQuery(ControlAreYouFlushed flushQuery) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushQuery", (Object)new Object[]{flushQuery});
        }
        SIBUuid12 streamID = flushQuery.getGuaranteedStreamUUID();
        try {
            SourceStreamManager sourceStreamManager = this;
            synchronized (sourceStreamManager) {
                SIBUuid8 requestor = flushQuery.getGuaranteedSourceMessagingEngineUUID();
                if (this.isFlushed(streamID)) {
                    this.downControl.sendFlushedMessage(requestor, streamID);
                } else {
                    this.downControl.sendNotFlushedMessage(requestor, streamID, flushQuery.getRequestID());
                }
            }
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.processFlushQuery", (String)"1:1333:1.102", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processFlushQuery", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushQuery");
        }
    }

    public synchronized void updateTargetCellule(SIBUuid8 targetMEUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateTargetCellule", (Object)targetMEUuid);
        }
        if (this.pointTopoint) {
            this.targetMEUuid = targetMEUuid;
            StreamSet streamSet = this.getStreamSet();
            if (streamSet != null) {
                streamSet.updateCellule(targetMEUuid);
                ExternalAutoCommitTransaction tran = this.txManager.createAutoCommitTransaction();
                try {
                    streamSet.requestUpdate((Transaction)tran);
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.updateTargetCellule", (String)"1:1384:1.102", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"updateTargetCellule", (Object)((Object)e));
                    }
                    throw new SIResourceException((Throwable)e);
                }
                Iterator<Stream> itr = streamSet.iterator();
                while (itr.hasNext()) {
                    SourceStream stream = (SourceStream)itr.next();
                    stream.noGuessesInStream();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateTargetCellule");
        }
    }

    public SourceStream getBatchListener(ControlAck ackMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchListener", (Object)new Object[]{ackMsg});
        }
        int priority = ackMsg.getPriority();
        Reliability reliability = ackMsg.getReliability();
        StreamSet streamSet = this.getStreamSet();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(priority, reliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchListener", (Object)sourceStream);
        }
        return sourceStream;
    }

    public DestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }
}

