/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.processor.impl.AbstractConsumerManager;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BrowserSessionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.GatheringBrowseCursor;
import com.ibm.ws.sib.processor.impl.GatheringConsumerKey;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport;
import com.ibm.ws.sib.processor.impl.exceptions.SIMPNoResponseException;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.MPDestinationChangeListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GatheringConsumerDispatcher
extends AbstractConsumerManager
implements JSConsumerManager {
    private static final TraceComponent tc = SibTr.register(GatheringConsumerDispatcher.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private JSConsumerManager localCD;
    private Map<SIBUuid8, JSConsumerManager> remoteCDs = new HashMap<SIBUuid8, JSConsumerManager>();
    private ConsumerDispatcherState consumerDispatcherState;
    protected HashMap<GatheringConsumerKey, AttachmentDetails> consumerPoints;

    public GatheringConsumerDispatcher(BaseDestinationHandler destination, JSConsumerManager localCD) {
        super(destination);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"GatheringConsumerDispatcher", (Object)new Object[]{destination, localCD});
        }
        this.localCD = localCD;
        this.consumerDispatcherState = new ConsumerDispatcherState();
        this.consumerPoints = new HashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"GatheringConsumerDispatcher", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reattachRemoteCD(RemoteConsumerDispatcher rcd) throws SINotPossibleInCurrentConfigurationException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reattachRemoteCD", (Object)new Object[]{rcd});
        }
        HashMap<GatheringConsumerKey, AttachmentDetails> hashMap = this.consumerPoints;
        synchronized (hashMap) {
            for (GatheringConsumerKey gck : this.consumerPoints.keySet()) {
                if (gck.isAttached(rcd.getUuid())) continue;
                AttachmentDetails details = this.consumerPoints.get(gck);
                ConsumerKey ck = rcd.attachConsumerPoint(gck.getConsumerPoint(), details.criteria, details.connectionUuid, details.readAhead, details.forwardScanning, details.consumerSet);
                gck.reattachConsumer(rcd.getLocalisationUuid(), (ConsumableKey)ck);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reattachRemoteCD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCD(SIBUuid8 meUuid, JSConsumerManager rcd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addRemoteCD", (Object)new Object[]{meUuid, rcd});
        }
        Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
        synchronized (map) {
            this.remoteCDs.put(meUuid, rcd);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addRemoteCD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCD(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeRemoteCD", (Object)new Object[]{meUuid});
        }
        Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
        synchronized (map) {
            this.remoteCDs.remove(meUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeRemoteCD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachBrowser(BrowserSessionImpl browserSession) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachBrowser", (Object)browserSession);
        }
        Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
        synchronized (map) {
            if (this.localCD != null) {
                this.localCD.attachBrowser(browserSession);
            }
            Iterator<JSConsumerManager> it = this.remoteCDs.values().iterator();
            while (it.hasNext()) {
                it.next().attachBrowser(browserSession);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerKey attachConsumerPoint(ConsumerPoint consumerPoint, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning, JSConsumerSet consumerSet) throws SINotPossibleInCurrentConfigurationException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachConsumerPoint", (Object)new Object[]{consumerPoint, criteria, connectionUuid, readAhead, forwardScanning, consumerSet});
        }
        HashMap<SIBUuid8, ConsumableKey> consumerKeys = new HashMap<SIBUuid8, ConsumableKey>();
        GatheringConsumerKey consumerKey = null;
        ArrayList<RemoteConsumerDispatcher> retryRCDs = new ArrayList<RemoteConsumerDispatcher>();
        HashMap<GatheringConsumerKey, AttachmentDetails> hashMap = this.consumerPoints;
        synchronized (hashMap) {
            Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
            synchronized (map) {
                if (this.localCD != null) {
                    consumerKeys.put(this._messageProcessor.getMessagingEngineUuid(), (ConsumableKey)this.localCD.attachConsumerPoint(consumerPoint, criteria, connectionUuid, readAhead, forwardScanning, consumerSet));
                }
                Iterator<SIBUuid8> it = this.remoteCDs.keySet().iterator();
                while (it.hasNext()) {
                    SIBUuid8 meUuid = it.next();
                    JSConsumerManager cm = this.remoteCDs.get(meUuid);
                    try {
                        consumerKeys.put(meUuid, (ConsumableKey)cm.attachConsumerPoint(consumerPoint, criteria, connectionUuid, readAhead, forwardScanning, consumerSet));
                    }
                    catch (SIMPNoResponseException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        it.remove();
                        retryRCDs.add((RemoteConsumerDispatcher)cm);
                    }
                    catch (SIResourceException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        it.remove();
                    }
                }
            }
            consumerKey = new GatheringConsumerKey((DispatchableConsumerPoint)consumerPoint, this, consumerKeys, criteria, connectionUuid, forwardScanning);
            this.consumerPoints.put(consumerKey, new AttachmentDetails(criteria, connectionUuid, readAhead, forwardScanning, consumerSet));
        }
        while (!retryRCDs.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Iterator it = retryRCDs.iterator();
            try {
                this.reattachRemoteCD((RemoteConsumerDispatcher)it.next());
                it.remove();
            }
            catch (SIMPNoResponseException sIMPNoResponseException) {
            }
            catch (SIResourceException e) {
                it.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)consumerKey);
        }
        return consumerKey;
    }

    @Override
    public void checkInitialIndoubts(DispatchableConsumerPoint point) throws SIResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachBrowser(BrowserSessionImpl browserSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachBrowser", (Object)browserSession);
        }
        Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
        synchronized (map) {
            if (this.localCD != null) {
                this.localCD.detachBrowser(browserSession);
            }
            Iterator<JSConsumerManager> it = this.remoteCDs.values().iterator();
            while (it.hasNext()) {
                it.next().detachBrowser(browserSession);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConsumerCount() {
        int consumerCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerCount");
        }
        HashMap<GatheringConsumerKey, AttachmentDetails> hashMap = this.consumerPoints;
        synchronized (hashMap) {
            consumerCount = this.consumerPoints.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerCount", (Object)consumerCount);
        }
        return consumerCount;
    }

    @Override
    public ConsumerDispatcherState getConsumerDispatcherState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatcherState");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatcherState", (Object)this.consumerDispatcherState);
        }
        return this.consumerDispatcherState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocked");
        }
        boolean isLocked = true;
        Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
        synchronized (map) {
            if (this.localCD != null) {
                isLocked &= this.localCD.isLocked();
            }
            Iterator<JSConsumerManager> it = this.remoteCDs.values().iterator();
            while (it.hasNext()) {
                isLocked &= it.next().isLocked();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocked", (Object)isLocked);
        }
        return isLocked;
    }

    @Override
    public boolean isNewTransactionAllowed(TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isNewTransactionAllowed");
            SibTr.exit((TraceComponent)tc, (String)"isNewTransactionAllowed", (Object)false);
        }
        return false;
    }

    @Override
    public BrowseCursor getBrowseCursor(SelectionCriteria selectionCriteria) throws SIResourceException, SISelectorSyntaxException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)selectionCriteria);
        }
        GatheringBrowseCursor cursor = new GatheringBrowseCursor(selectionCriteria, this.localCD, this.remoteCDs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)cursor);
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIMPMessage getMessageByValue(AOValue value) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageByValue", (Object)value.getMsgId());
        }
        SIMPMessage msgItem = null;
        SIBUuid8 sourceMEUuid = value.getSourceMEUuid();
        Map<SIBUuid8, JSConsumerManager> map = this.remoteCDs;
        synchronized (map) {
            if (sourceMEUuid.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
                msgItem = this.localCD.getMessageByValue(value);
            } else {
                AnycastInputHandler aih = this._baseDestHandler.getAnycastInputHandler(sourceMEUuid, null, false);
                if (aih != null) {
                    msgItem = aih.getRCD().getMessageByValue(value);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageByValue", (Object)msgItem);
        }
        return msgItem;
    }

    @Override
    public boolean isPubSub() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)false);
        }
        return false;
    }

    public void registerChangeListener(Set scopedMEs, SIBUuid12 uuid, DestinationDefinition definition, AbstractRemoteSupport support) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerChangeListener", (Object)new Object[]{uuid, definition, support});
        }
        new GatheringChangeListener(scopedMEs, uuid, definition, support);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerChangeListener");
        }
    }

    @Override
    protected JSKeyGroup createConsumerKeyGroup(JSConsumerSet consumerSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)consumerSet);
        }
        JSKeyGroup ckg = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKeyGroup", ckg);
        }
        return ckg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachConsumerPoint(ConsumerKey consumerKey) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachConsumerPoint", (Object)consumerKey);
        }
        HashMap<GatheringConsumerKey, AttachmentDetails> hashMap = this.consumerPoints;
        synchronized (hashMap) {
            this.consumerPoints.remove(consumerKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachConsumerPoint");
        }
    }

    @Override
    public List<DispatchableKey> getConsumerPoints() {
        return null;
    }

    class AttachmentDetails {
        private SIBUuid12 connectionUuid;
        private SelectionCriteria criteria;
        private boolean readAhead;
        private boolean forwardScanning;
        private JSConsumerSet consumerSet;

        AttachmentDetails(SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning, JSConsumerSet consumerSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AttachmentDetails", (Object)new Object[]{criteria, connectionUuid, readAhead, forwardScanning, consumerSet});
            }
            this.criteria = criteria;
            this.connectionUuid = connectionUuid;
            this.readAhead = readAhead;
            this.forwardScanning = forwardScanning;
            this.consumerSet = consumerSet;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AttachmentDetails");
            }
        }
    }

    class GatheringChangeListener
    implements MPDestinationChangeListener,
    AlarmListener {
        private SIBUuid12 destUuid;
        private DestinationDefinition definition;
        private AbstractRemoteSupport support;
        private Set scopedMEs;
        private long retryInterval;
        private ArrayList<SIBUuid8> unreachableMEs;
        private Alarm reattachAlarm;

        public GatheringChangeListener(Set scopedMEs, SIBUuid12 destUuid, DestinationDefinition definition, AbstractRemoteSupport support) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"GatheringChangeListener", (Object)new Object[]{scopedMEs, destUuid, definition, support});
            }
            this.destUuid = destUuid;
            this.definition = definition;
            this.support = support;
            this.scopedMEs = scopedMEs;
            this.unreachableMEs = new ArrayList();
            this.retryInterval = GatheringConsumerDispatcher.this._messageProcessor.getCustomProperties().get_gathering_reattach_interval();
            GatheringConsumerDispatcher.this._messageProcessor.getDestinationChangeListener().addMPDestinationChangeListener(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"GatheringChangeListener");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destinationLocationChange(SIBUuid12 destId, Set additions, Set deletions, Capability capability) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"destinationLocationChange", (Object)new Object[]{destId, additions, deletions, capability});
            }
            if (this.destUuid.equals((Object)destId) && capability == Capability.GET) {
                GatheringChangeListener gatheringChangeListener;
                for (SIBUuid8 meUuid : additions) {
                    if (meUuid.equals((Object)GatheringConsumerDispatcher.this._messageProcessor.getMessagingEngineUuid()) || this.scopedMEs != null && (this.scopedMEs == null || !this.scopedMEs.contains(meUuid))) continue;
                    GatheringConsumerDispatcher.this._messageProcessor.getMPIO().forceConnect(meUuid);
                    gatheringChangeListener = this;
                    synchronized (gatheringChangeListener) {
                        block15: {
                            AnycastInputHandler aih = this.support.getAnycastInputHandler(meUuid, null, this.definition, true);
                            try {
                                aih.getRCD().reachabilityChange(true);
                                GatheringConsumerDispatcher.this.reattachRemoteCD(aih.getRCD());
                                GatheringConsumerDispatcher.this.addRemoteCD(meUuid, aih.getRCD());
                                if (this.unreachableMEs.contains(meUuid)) {
                                    this.unreachableMEs.remove(meUuid);
                                }
                            }
                            catch (SIException e) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                this.unreachableMEs.add(meUuid);
                                if (this.reattachAlarm != null) break block15;
                                this.reattachAlarm = GatheringConsumerDispatcher.this._messageProcessor.getAlarmManager().create(this.retryInterval, this);
                            }
                        }
                    }
                }
                for (SIBUuid8 meUuid : deletions) {
                    if (meUuid.equals((Object)GatheringConsumerDispatcher.this._messageProcessor.getMessagingEngineUuid()) || this.scopedMEs != null && (this.scopedMEs == null || !this.scopedMEs.contains(meUuid))) continue;
                    gatheringChangeListener = this;
                    synchronized (gatheringChangeListener) {
                        if (this.unreachableMEs.contains(meUuid)) {
                            this.unreachableMEs.remove(meUuid);
                        }
                    }
                    GatheringConsumerDispatcher.this.removeRemoteCD(meUuid);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"destinationLocationChange");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object arg0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"GatheringChangeListener.alarm", (Object)arg0);
            }
            GatheringChangeListener gatheringChangeListener = this;
            synchronized (gatheringChangeListener) {
                this.reattachAlarm = null;
                Iterator<SIBUuid8> it = this.unreachableMEs.iterator();
                while (it.hasNext()) {
                    SIBUuid8 meUuid = it.next();
                    AnycastInputHandler aih = this.support.getAnycastInputHandler(meUuid, null, this.definition, true);
                    try {
                        aih.getRCD().reachabilityChange(true);
                        GatheringConsumerDispatcher.this.reattachRemoteCD(aih.getRCD());
                        GatheringConsumerDispatcher.this.addRemoteCD(meUuid, aih.getRCD());
                        it.remove();
                    }
                    catch (SIException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (this.reattachAlarm != null) continue;
                        this.reattachAlarm = GatheringConsumerDispatcher.this._messageProcessor.getAlarmManager().create(this.retryInterval, this);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"GatheringChangeListener.alarm", (Object)this);
            }
        }
    }
}

