/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.InternalOutputStream;
import com.ibm.ws.sib.processor.gd.InternalOutputStreamManager;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.runtime.impl.AttachedRemoteSubscriberControl;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.LinkRemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.runtime.impl.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PubSubOutputHandler
implements OutputHandler,
ControlHandler,
DownstreamControl,
UpstreamControl,
MessageEventListener,
ControllableResource {
    private static final TraceComponent tc = SibTr.register(PubSubOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerDispatcherState _subscriptionState;
    private InternalOutputStreamManager _internalOutputStreamManager;
    private ControlHandler _parentInputHandler;
    private SIBUuid8 _targetMEUuid;
    private MPIO _mpio;
    private Neighbour _neighbour;
    private ControlMessageFactory _cmf;
    private String _destName;
    private String _busName;
    private BaseDestinationHandler _destinationHandler;
    private String _foreignTSName = null;
    private boolean _isLink = false;
    private String _linkName = null;
    private boolean _linkSetOutboundUserId = false;
    private String _linkOutboundUserid = null;
    private VirtualLinkDefinition link = null;
    private JsDestinationAddress _routingDestination = null;
    private boolean _isGuess = false;
    private MessageProcessor _messageProcessor;
    private ControlAdapter _controlAdapter;
    private boolean isRegistered;

    public PubSubOutputHandler(MessageProcessor messageProcessor, Neighbour neighbour, BaseDestinationHandler baseDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubOutputHandler", (Object)new Object[]{messageProcessor, neighbour, baseDest});
        }
        this._messageProcessor = messageProcessor;
        this._destName = baseDest.getName();
        this._busName = baseDest.getBus();
        this._neighbour = neighbour;
        this._parentInputHandler = (ControlHandler)((Object)baseDest.getInputHandler());
        this._mpio = messageProcessor.getMPIO();
        this._targetMEUuid = neighbour.getUUID();
        this._cmf = MessageProcessor.getControlMessageFactory();
        this._destinationHandler = baseDest;
        if (!neighbour.getBusId().equals(messageProcessor.getMessagingEngineBus())) {
            this.link = messageProcessor.getDestinationManager().getLinkDefinition(neighbour.getBusId());
            if (this.link != null && this.link.getType().equals("SIBVirtualGatewayLink")) {
                this._linkName = this.link.getName();
                this._linkOutboundUserid = this.link.getOutboundUserid();
                this._isLink = true;
                if (this._linkOutboundUserid != null) {
                    this._linkSetOutboundUserId = true;
                }
            }
        }
        this._internalOutputStreamManager = new InternalOutputStreamManager(this, this, this._messageProcessor, this._targetMEUuid, this._isLink);
        this.createControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubOutputHandler", (Object)this);
        }
    }

    public void addTopic(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopic", (Object)topic);
        }
        SelectionCriteria criteria = this._messageProcessor.getSelectionCriteriaFactory().createSelectionCriteria(topic, null, SelectorDomain.SIMESSAGE);
        if (this._subscriptionState == null) {
            this._subscriptionState = new ConsumerDispatcherState(this._destinationHandler.getUuid(), criteria, this._destName, this._busName);
        } else {
            this._subscriptionState.addSelectionCriteria(criteria);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopic");
        }
    }

    public void removeTopic(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTopic", (Object)topic);
        }
        if (this._subscriptionState == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"removeTopic", (Object)"Topic not found");
            }
        } else {
            this._subscriptionState.removeTopic(topic);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTopic");
        }
    }

    public String[] getTopics() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopics");
        }
        String[] topics = null;
        if (this._subscriptionState != null) {
            topics = this._subscriptionState.getTopics();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopics", (Object)topics);
        }
        return topics;
    }

    public SIBUuid12 getTopicSpaceUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceUuid");
        }
        SIBUuid12 retval = this._destinationHandler.getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceUuid", (Object)retval);
        }
        return retval;
    }

    @Override
    public boolean put(SIMPMessage msg, TransactionCommon transaction, InputHandlerStore inputHandlerStore, boolean storedByIH) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{msg, transaction, inputHandlerStore, new Boolean(storedByIH)});
        }
        this._internalOutputStreamManager.addMessage(msg, false);
        if (this.link != null) {
            this.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)storedByIH);
        }
        return storedByIH;
    }

    public void putInsert(SIMPMessage msg, boolean commitInsert) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putInsert", (Object)new Object[]{msg, commitInsert});
        }
        this._internalOutputStreamManager.addMessage(msg, commitInsert);
        if (this.link != null) {
            this.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putInsert");
        }
    }

    public void putSilence(SIMPMessage msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putSilence", (Object)new Object[]{msg});
        }
        this._internalOutputStreamManager.addSilence(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putSilence");
        }
    }

    public boolean okToForward(MessageItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToForward", (Object)item);
        }
        boolean returnValue = false;
        if (this.isLink()) {
            returnValue = this.neighbourOnDifferentBus(item.getOriginatingBus());
            if (returnValue) {
                BusHandler bus = null;
                try {
                    bus = this._destinationHandler.getDestinationManager().findBus(this._neighbour.getBusId());
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.okToForward", (String)"1:446:1.164.1.5", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"PUBSUB_LINK_FORWARD_CWSIP0855", (Object)new Object[]{this._destinationHandler.getName(), this._neighbour.getBusId(), e});
                }
                if (bus != null) {
                    returnValue = bus.isSendAllowed();
                }
            }
        } else if (item.isFromRemoteBus()) {
            returnValue = true;
        } else {
            boolean bl = returnValue = !item.isFromRemoteME();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToForward", (Object)new Boolean(returnValue));
        }
        return returnValue;
    }

    public boolean neighbourOnDifferentBus(String busId) {
        return this._neighbour.okToForward(busId);
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:499:1.164.1.5"}, null));
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.registerForEvents", (String)"1:506:1.164.1.5", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:512:1.164.1.5"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents", (Object)((Object)e));
        }
        throw e;
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIConnectionLostException, SIRollbackException, SIIncorrectCallException, SIResourceException {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, cMsg});
        }
        if ((type = cMsg.getControlMessageType()) == ControlMessageType.REQUESTFLUSH) {
            this._parentInputHandler.handleControlMessage(this._targetMEUuid, cMsg);
        } else if (type == ControlMessageType.AREYOUFLUSHED) {
            this._internalOutputStreamManager.processFlushQuery((ControlAreYouFlushed)cMsg);
        } else if (type == ControlMessageType.ACK) {
            this._internalOutputStreamManager.processAck((ControlAck)cMsg);
        } else if (type == ControlMessageType.NACK) {
            this._internalOutputStreamManager.processNack((ControlNack)cMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    void processAckExpected(long ackExpStamp, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Long(ackExpStamp));
        }
        this._internalOutputStreamManager.processAckExpected(ackExpStamp, priority, reliability, stream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(event), msg, tran});
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:603:1.164.1.5"}, null));
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.messageEventOccurred", (String)"1:610:1.164.1.5", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:616:1.164.1.5"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
        }
        throw e;
    }

    public String toString() {
        return "PubSubOutputHandler: " + this._busName + ":" + this._destName + ":" + this._destinationHandler.getUuid().toString() + " on " + this._neighbour.toString();
    }

    @Override
    public SIBUuid8 getTargetMEUuid() {
        return this._neighbour.getUUID();
    }

    @Override
    public void sendAckExpectedMessage(long ackExpStamp, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        ControlAckExpected ackexpMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)new Object[]{new Long(ackExpStamp), this._targetMEUuid, new Integer(priority), reliability});
        }
        try {
            ackexpMsg = this._cmf.createNewControlAckExpected();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendAckExpectedMessage", (String)"1:676:1.164.1.5", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:683:1.164.1.5", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:694:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)ackexpMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        ackexpMsg.setTick(ackExpStamp);
        ackexpMsg.setPriority(priority);
        ackexpMsg.setReliability(reliability);
        InternalOutputStream sourceStream = (InternalOutputStream)this._internalOutputStreamManager.getStreamSet(stream, false).getStream(priority, reliability);
        if (sourceStream != null) {
            sourceStream.setLatestAckExpected(ackExpStamp);
            sourceStream.getControlAdapter().getHealthState().updateHealth(HealthStateListener.ACK_EXPECTED_STATE, 1);
        }
        if (this._isLink) {
            ackexpMsg = (ControlAckExpected)this.addLinkProps((ControlMessage)ackexpMsg);
        }
        SIBUuid8[] fromTo = new SIBUuid8[]{this._targetMEUuid};
        this._mpio.sendDownTree(fromTo, priority, (AbstractMessage)ackexpMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage");
        }
    }

    @Override
    public void sendSilenceMessage(long startStamp, long endStamp, long completedPrefix, boolean requestedOnly, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        ControlSilence sMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSilenceMessage", (Object)new Object[]{new Long(startStamp), new Long(endStamp), new Long(completedPrefix), new Integer(priority), reliability});
        }
        try {
            sMsg = this._cmf.createNewControlSilence();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendSilenceMessage", (String)"1:787:1.164.1.5", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:794:1.164.1.5", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:805:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)sMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        sMsg.setStartTick(startStamp);
        sMsg.setEndTick(endStamp);
        sMsg.setPriority(priority);
        sMsg.setReliability(reliability);
        sMsg.setCompletedPrefix(completedPrefix);
        sMsg.setRequestedOnly(requestedOnly);
        if (this._isLink) {
            sMsg = (ControlSilence)this.addLinkProps((ControlMessage)sMsg);
        }
        SIBUuid8[] fromTo = new SIBUuid8[]{this._targetMEUuid};
        if (requestedOnly) {
            this._mpio.sendDownTree(fromTo, priority + 1, (AbstractMessage)sMsg);
        } else {
            this._mpio.sendDownTree(fromTo, priority, (AbstractMessage)sMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage");
        }
    }

    @Override
    public MessageItem getValueMessage(long msgStoreID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getValueMessage", (Object)new Long(msgStoreID));
        }
        MessageItem msgItem = this._destinationHandler.getPubSubRealization().retrieveMessageFromItemStream(msgStoreID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getValueMessage", (Object)msgItem);
        }
        return msgItem;
    }

    @Override
    public List sendValueMessages(List msgList, long completedPrefix, boolean requestedOnly, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendValueMessages", (Object)new Object[]{msgList, new Long(completedPrefix), new Boolean(requestedOnly)});
        }
        SIBUuid8[] fromTo = new SIBUuid8[]{this._targetMEUuid};
        JsMessage jsMsg = null;
        TickRange tickRange = null;
        MessageItem msgItem = null;
        long msgId = -1L;
        ArrayList<TickRange> expiredMsgs = null;
        for (int i = 0; i < msgList.size(); ++i) {
            tickRange = (TickRange)msgList.get(i);
            msgId = tickRange.itemStreamIndex;
            msgItem = this._destinationHandler.getPubSubRealization().retrieveMessageFromItemStream(msgId);
            if (msgItem == null) {
                if (expiredMsgs == null) {
                    expiredMsgs = new ArrayList<TickRange>();
                }
                expiredMsgs.add(tickRange);
                ControlSilence cMsg = this.createSilenceMessage(tickRange.valuestamp, completedPrefix, priority, reliability, stream);
                cMsg.setRequestedOnly(requestedOnly);
                if (this._isLink) {
                    cMsg = this.addLinkProps((ControlMessage)cMsg);
                    cMsg.setRoutingDestination(this._routingDestination);
                }
                if (requestedOnly) {
                    this._mpio.sendDownTree(fromTo, priority + 1, (AbstractMessage)cMsg);
                    continue;
                }
                this._mpio.sendDownTree(fromTo, priority, (AbstractMessage)cMsg);
                continue;
            }
            try {
                jsMsg = msgItem.getMessage().getReceived();
            }
            catch (MessageCopyFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendValueMessages", (String)"1:960:1.164.1.5", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendValueMessages", (Object)("SIErrorException: " + (Object)((Object)e)));
                }
                throw new SIErrorException((Throwable)e);
            }
            if (jsMsg.getGuaranteedStreamUUID() != stream) {
                jsMsg.setGuaranteedStreamUUID(stream);
            }
            if (tickRange.endstamp > tickRange.valuestamp) {
                jsMsg.setGuaranteedValueEndTick(tickRange.endstamp);
            }
            jsMsg.setGuaranteedValueCompletedPrefix(completedPrefix);
            jsMsg.setGuaranteedValueRequestedOnly(requestedOnly);
            if (this._isLink) {
                jsMsg = this.addLinkProps(jsMsg);
                jsMsg.setRoutingDestination(this._routingDestination);
            }
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                DestinationHandler dest = this._messageProcessor.getDestinationManager().getDestinationInternal(this._destinationHandler.getUuid(), false);
                if (dest != null) {
                    UserTrace.traceOutboundSend(jsMsg, this._neighbour.getUUID(), dest.getName(), dest.isForeignBus() || dest.isLink(), dest.isMQLink(), dest.isTemporary());
                } else {
                    UserTrace.traceOutboundSend(jsMsg, this._neighbour.getUUID(), this._destinationHandler.getUuid().toString().toString(), false, false, false);
                }
            }
            if (requestedOnly) {
                this._mpio.sendDownTree(fromTo, priority + 1, (AbstractMessage)jsMsg);
                continue;
            }
            this._mpio.sendDownTree(fromTo, priority, (AbstractMessage)jsMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendValueMessages", expiredMsgs);
        }
        return expiredMsgs;
    }

    @Override
    public void sendFlushedMessage(SIBUuid8 ignore, SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushedMessage", (Object)new Object[]{ignore, streamID});
        }
        ControlFlushed flushMsg = this.createControlFlushed(this._targetMEUuid, streamID);
        if (this._isLink) {
            flushMsg = (ControlFlushed)this.addLinkProps((ControlMessage)flushMsg);
        }
        this._mpio.sendToMe(this._targetMEUuid, 9, (AbstractMessage)flushMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushedMessage");
        }
    }

    @Override
    public void sendNotFlushedMessage(SIBUuid8 ignore, SIBUuid12 streamID, long requestID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushedMessage", (Object)new Object[]{ignore, streamID, new Long(requestID)});
        }
        ControlNotFlushed notFlushed = this.createControlNotFlushed(this._targetMEUuid, streamID, requestID);
        notFlushed = this._internalOutputStreamManager.stampNotFlushed(notFlushed, streamID);
        if (this._isLink) {
            notFlushed = (ControlNotFlushed)this.addLinkProps((ControlMessage)notFlushed);
            notFlushed.setRoutingDestination(this._routingDestination);
        }
        this._mpio.sendToMe(this._targetMEUuid, 9, (AbstractMessage)notFlushed);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushedMessage");
        }
    }

    public void sendLinkMessage(MessageItem msgItem, boolean rollback) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendLinkMessage", (Object)msgItem);
        }
        JsMessage jsMsg = null;
        try {
            jsMsg = msgItem.getMessage().getReceived();
        }
        catch (MessageCopyFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendLinkMessage", (String)"1:1097:1.164.1.5", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendLinkMessage", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)e);
        }
        SIBUuid8[] fromTo = new SIBUuid8[]{this._targetMEUuid};
        if (rollback) {
            ControlSilence cMsg = this.createSilenceMessage(jsMsg.getGuaranteedValueValueTick(), jsMsg.getGuaranteedValueCompletedPrefix(), msgItem.getPriority(), msgItem.getReliability(), jsMsg.getGuaranteedStreamUUID());
            cMsg = this.addLinkProps((ControlMessage)cMsg);
            cMsg.setRoutingDestination(this._routingDestination);
            this._mpio.sendDownTree(fromTo, msgItem.getPriority(), (AbstractMessage)cMsg);
        } else {
            jsMsg = this.addLinkProps(jsMsg);
            jsMsg.setRoutingDestination(this._routingDestination);
            jsMsg.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
            this._mpio.sendDownTree(fromTo, msgItem.getPriority(), (AbstractMessage)jsMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendLinkMessage");
        }
    }

    @Override
    public boolean commitInsert(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInsert", (Object)msgItem);
        }
        this._internalOutputStreamManager.commitInsert(msgItem);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInsert");
        }
        return true;
    }

    @Override
    public boolean rollbackInsert(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackInsert", (Object)msgItem);
        }
        this._internalOutputStreamManager.rollbackInsert(msgItem);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackInsert");
        }
        return true;
    }

    private ControlNack createControlNackMessage(int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        ControlNack nackMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNackMessage");
        }
        try {
            nackMsg = this._cmf.createNewControlNack();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlNackMessage", (String)"1:1204:1.164.1.5", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1216:1.164.1.5", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1224:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)nackMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        nackMsg.setPriority(priority);
        nackMsg.setReliability(reliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage");
        }
        return nackMsg;
    }

    private ControlAck createControlAckMessage(int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        ControlAck ackMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAckMessage");
        }
        try {
            ackMsg = this._cmf.createNewControlAck();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlAckMessage", (String)"1:1279:1.164.1.5", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1291:1.164.1.5", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1299:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)ackMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        ackMsg.setPriority(priority);
        ackMsg.setReliability(reliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage");
        }
        return ackMsg;
    }

    private ControlSilence createSilenceMessage(long tick, long completedPrefix, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSilenceMessage", (Object)new Object[]{new Long(tick), new Long(completedPrefix), new Integer(priority), reliability, stream});
        }
        ControlSilence sMsg = null;
        try {
            sMsg = this._cmf.createNewControlSilence();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createSilenceMessage", (String)"1:1353:1.164.1.5", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1359:1.164.1.5", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1369:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)sMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        sMsg.setStartTick(tick);
        sMsg.setEndTick(tick);
        sMsg.setPriority(priority);
        sMsg.setReliability(reliability);
        sMsg.setCompletedPrefix(completedPrefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)sMsg);
        }
        return sMsg;
    }

    private ControlFlushed createControlFlushed(SIBUuid8 target, SIBUuid12 stream) throws SIResourceException {
        ControlFlushed flushedMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlFlushed", (Object)stream);
        }
        try {
            flushedMsg = this._cmf.createNewControlFlushed();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlFlushed", (String)"1:1424:1.164.1.5", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlFlushed", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1436:1.164.1.5", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1444:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)flushedMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        flushedMsg.setPriority(11);
        flushedMsg.setReliability(Reliability.ASSURED_PERSISTENT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlFlushed");
        }
        return flushedMsg;
    }

    private ControlNotFlushed createControlNotFlushed(SIBUuid8 target, SIBUuid12 stream, long reqID) throws SIResourceException {
        ControlNotFlushed notFlushedMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNotFlushed", (Object)new Object[]{target, stream, new Long(reqID)});
        }
        try {
            notFlushedMsg = this._cmf.createNewControlNotFlushed();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlNotFlushed", (String)"1:1498:1.164.1.5", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1510:1.164.1.5", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1518:1.164.1.5", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)notFlushedMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destinationHandler.getUuid(), ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        notFlushedMsg.setPriority(11);
        notFlushedMsg.setReliability(Reliability.ASSURED_PERSISTENT);
        notFlushedMsg.setRequestID(reqID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed");
        }
        return notFlushedMsg;
    }

    private JsMessage addLinkProps(JsMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps", (Object)msg);
        }
        msg.setGuaranteedCrossBusLinkName(this._linkName);
        msg.setGuaranteedCrossBusSourceBusUUID(this._messageProcessor.getMessagingEngineBusUuid());
        if (this._linkSetOutboundUserId && !this._messageProcessor.getAuthorisationUtils().sentBySIBServer(msg)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Set outbound userid: " + this._linkOutboundUserid + ", in message"));
            }
            this._messageProcessor.getAccessChecker().setSecurityIDInMessage(this._linkOutboundUserid, msg);
            msg.setApiUserId(this._linkOutboundUserid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return msg;
    }

    private ControlMessage addLinkProps(ControlMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps", (Object)msg);
        }
        msg.setGuaranteedCrossBusLinkName(this._linkName);
        msg.setGuaranteedCrossBusSourceBusUUID(this._messageProcessor.getMessagingEngineBusUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return msg;
    }

    @Override
    public void sendNackMessage(SIBUuid8 meUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long startTick, long endTick, int priority, Reliability reliability, SIBUuid12 streamID) throws SIResourceException {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendNackMessage", (Object)new Object[]{meUuid, new Long(startTick), new Long(endTick), new Integer(priority), reliability, streamID});
            }
            ControlNack newNackMsg = this.createControlNackMessage(priority, reliability, streamID);
            newNackMsg.setStartTick(startTick);
            newNackMsg.setEndTick(endTick);
            try {
                this._parentInputHandler.handleControlMessage(null, (ControlMessage)newNackMsg);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendNackMessage", (String)"1:1639:1.164.1.5", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"sendNackMessage", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNackMessage");
        }
    }

    @Override
    public long sendNackMessageWithReturnValue(SIBUuid8 meUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long startTick, long endTick, int priority, Reliability reliability, SIBUuid12 streamID) throws SIResourceException {
        long returnValue;
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendNackMessageWithReturnValue", (Object)new Object[]{meUuid, new Long(startTick), new Long(endTick), new Integer(priority), reliability, streamID});
            }
            returnValue = -1L;
            ControlNack newNackMsg = this.createControlNackMessage(priority, reliability, streamID);
            newNackMsg.setStartTick(startTick);
            newNackMsg.setEndTick(endTick);
            try {
                returnValue = this._parentInputHandler.handleControlMessageWithReturnValue(null, (ControlMessage)newNackMsg);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendNackMessageWithReturnValue", (String)"1:1621:1.165", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"sendNackMessageWithReturnValue", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNackMessageWithReturnValue", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    @Override
    public void sendAckMessage(SIBUuid8 meUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long ackPrefix, int priority, Reliability reliability, SIBUuid12 streamID, boolean consolidate) throws SIResourceException {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendAckMessage", (Object)new Object[]{meUuid, new Long(ackPrefix), new Integer(priority), reliability, streamID});
            }
            ControlAck newAckMsg = this.createControlAckMessage(priority, reliability, streamID);
            newAckMsg.setAckPrefix(ackPrefix);
            try {
                this._parentInputHandler.handleControlMessage(null, (ControlMessage)newAckMsg);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendAckMessage", (String)"1:1731:1.164.1.5", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"sendAckMessage", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckMessage");
        }
    }

    @Override
    public void sendAreYouFlushedMessage(SIBUuid8 meUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long queryID, SIBUuid12 streamID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)new Object[]{meUuid, new Long(queryID), streamID});
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1766:1.164.1.5"}, null));
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendAreYouFlushedMessage", (String)"1:1773:1.164.1.5", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1779:1.164.1.5"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)((Object)e));
        }
        throw e;
    }

    @Override
    public void sendRequestFlushMessage(SIBUuid8 meUuid, SIBUuid12 destUuid, SIBUuid8 busUuid, long queryID, SIBUuid12 streamID, boolean indoubtDiscard) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)new Object[]{meUuid, new Long(queryID), streamID});
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1804:1.164.1.5"}, null));
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendRequestFlushMessage", (String)"1:1811:1.164.1.5", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1817:1.164.1.5"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)((Object)e));
        }
        throw e;
    }

    public long checkAck(ControlAck ack, long min) throws SIResourceException {
        return this._internalOutputStreamManager.checkAck(ack, min);
    }

    public void registerForEventsPostAddItem(SIMPMessage msg) {
    }

    public void removeStream(SIBUuid12 stream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeStream", (Object)stream);
        }
        this._internalOutputStreamManager.remove(stream);
        this.deregisterControlAdapterMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeStream");
        }
    }

    @Override
    public boolean isWLMGuess() {
        return this._isGuess;
    }

    @Override
    public void setWLMGuess(boolean guess) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWLMGuess", (Object)new Boolean(guess));
        }
        this._isGuess = guess;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWLMGuess");
        }
    }

    public boolean isLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLink");
            SibTr.exit((TraceComponent)tc, (String)"isLink", (Object)new Boolean(this._isLink));
        }
        return this._isLink;
    }

    public String getTopicSpaceMapping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceMapping");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceMapping", (Object)this._foreignTSName);
        }
        return this._foreignTSName;
    }

    public void setTopicSpaceMapping(String foreignTSName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTopicSpaceMapping", (Object)foreignTSName);
        }
        this._routingDestination = SIMPUtils.createJsDestinationAddress(foreignTSName, null, this._neighbour.getBusId());
        this._foreignTSName = foreignTSName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTopicSpaceMapping");
        }
    }

    @Override
    public boolean isQHighLimit() {
        return false;
    }

    public ConsumerDispatcherState getConsumerDispatcherState() {
        return this._subscriptionState;
    }

    public String getBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusName");
            SibTr.exit((TraceComponent)tc, (String)"getBusName", (Object)this._busName);
        }
        return this._busName;
    }

    public InternalOutputStreamManager getInternalOutputStreamManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInternalOutputStreamManager");
            SibTr.exit((TraceComponent)tc, (String)"getInternalOutputStreamManager", (Object)this._internalOutputStreamManager);
        }
        return this._internalOutputStreamManager;
    }

    public String getDestinationName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationName");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationName", (Object)this._destName);
        }
        return this._destName;
    }

    @Override
    public ControlAdapter getControlAdapter() {
        return this._controlAdapter;
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        Map aihMap = this._destinationHandler.getPseudoDurableAIHMap();
        Iterator aihIterator = aihMap.values().iterator();
        SIBUuid8 psohRemoteMEUuid = this.getTargetMEUuid();
        while (aihIterator.hasNext()) {
            AnycastInputHandler aih = (AnycastInputHandler)aihIterator.next();
            SIBUuid8 aihRemoteMEUuid = aih.getLocalisationUuid();
            if (!aihRemoteMEUuid.equals((Object)psohRemoteMEUuid)) continue;
            AttachedRemoteSubscriberControl attachedRSControl = aih.getControlAdapter();
            this._controlAdapter = attachedRSControl.getRemoteTopicSpaceControl();
            this._controlAdapter.registerControlAdapterAsMBean();
            break;
        }
        if (this._controlAdapter == null) {
            if (this.link != null) {
                this._controlAdapter = new LinkRemoteTopicSpaceControl(this, this._messageProcessor, this.link.getName());
            } else {
                this._controlAdapter = new RemoteTopicSpaceControl(this, null, this._messageProcessor);
                this._controlAdapter.registerControlAdapterAsMBean();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (!this.isRegistered) {
            this._controlAdapter.registerControlAdapterAsMBean();
            this.isRegistered = true;
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        this._controlAdapter.deregisterControlAdapterMBean();
        this.isRegistered = false;
    }

    public DestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this._destinationHandler);
        }
        return this._destinationHandler;
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }
}

