/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.certclient.util.PkUtils;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public final class PkNewCertFactory {
    private PkNewCertFactory() {
        throw new UnsupportedOperationException();
    }

    public static PkNewCertificate newCert(String subjectDN, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
        return new PkNewCertImpl(subjectDN, signing_cert_chain, signing_cert_private_key);
    }

    public static PkNewCertificate newCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useShortSubjectKId, String provider, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
        return new PkNewCertImpl(keySize, subjectDN, numValidDays, notBefore, useShortSubjectKId, provider, signing_cert_chain, signing_cert_private_key);
    }

    public static PkNewCertificate newCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useShortSubjectKId, String provider, KeyPair keyPair, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
        return new PkNewCertImpl(keySize, subjectDN, numValidDays, notBefore, useShortSubjectKId, provider, keyPair, signing_cert_chain, signing_cert_private_key);
    }

    public static PkNewCertificate newCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
        return new PkNewCertImpl(keySize, subjectDN, numValidDays, notBefore, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, signing_cert_chain, signing_cert_private_key);
    }

    public static PkNewCertificate newCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
        return new PkNewCertImpl(keySize, subjectDN, numValidDays, notBefore, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, signing_cert_chain, signing_cert_private_key, false);
    }

    public static PkNewCertificate newCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key, boolean CA) throws PkRejectionException {
        return new PkNewCertImpl(keySize, subjectDN, numValidDays, notBefore, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, signing_cert_chain, signing_cert_private_key, CA);
    }

    private static final class PkNewCertImpl
    implements PkNewCertificate,
    PkConstants {
        private KeyPair newKey;
        private X509Certificate newCert;
        private Date notBefore;
        private X509Certificate[] newCertChain;
        private X509Certificate[] signingChain;
        private byte[] newKeyIdentifier = null;
        private static List<ObjectIdentifier> algList = new ArrayList<ObjectIdentifier>(16);
        private static final String DEFAULT_PROVIDER = "IBMJCE";
        private static final String DEFAULT_RNG = "IBMSecureRandom";
        private static final int DEFAULT_KEY_SIZE = 1024;
        private static final int DEFAULT_LIFETIME = 365;
        private static Debug debug = Debug.getInstance("keycertmanage");
        private static final Object className = "com.ibm.security.certclient.PkNewCertImpl";

        PkNewCertImpl(String subjectDN, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
            PrivateKey signingKey = signing_cert_private_key;
            if (signingKey == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String keyType = signingKey.getAlgorithm();
            X500Name subject = this.validSubject(subjectDN);
            this.notBefore = null;
            this.signingChain = this.validChain(signing_cert_chain);
            X500Name issuer = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String signAlgorithm = this.signingChain[0].getSigAlgName();
            this.newKey = this.generateLocalKey(keyType, 1024, DEFAULT_RNG, DEFAULT_PROVIDER);
            this.newCert = this.generatenewCertificate(2, signAlgorithm, subject, issuer, this.newKey.getPublic(), 365, this.generateKID(false), null, null, null, DEFAULT_PROVIDER, false);
            this.newCertSign(signAlgorithm, DEFAULT_PROVIDER, signingKey);
        }

        PkNewCertImpl(int keySize, String subjectDN, int numValidDays, Date nb2, boolean useShortSubjectKId, String provider, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
            PrivateKey signingKey = signing_cert_private_key;
            if (signingKey == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String keyType = signingKey.getAlgorithm();
            X500Name subject = this.validSubject(subjectDN);
            this.notBefore = nb2;
            this.signingChain = this.validChain(signing_cert_chain);
            X500Name issuer = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String signAlgorithm = this.signingChain[0].getSigAlgName();
            this.newKey = this.generateLocalKey(keyType, keySize, DEFAULT_RNG, provider);
            this.newCert = this.generatenewCertificate(2, signAlgorithm, subject, issuer, this.newKey.getPublic(), numValidDays, this.generateKID(useShortSubjectKId), null, null, null, provider, false);
            this.newCertSign(signAlgorithm, provider, signingKey);
        }

        PkNewCertImpl(int keySize, String subjectDN, int numValidDays, Date nb2, boolean useShortSubjectKId, String provider, KeyPair keyPair, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
            PrivateKey signingKey = signing_cert_private_key;
            if (signingKey == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String keyType = signingKey.getAlgorithm();
            X500Name subject = this.validSubject(subjectDN);
            this.notBefore = nb2;
            this.signingChain = this.validChain(signing_cert_chain);
            X500Name issuer = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String signAlgorithm = this.signingChain[0].getSigAlgName();
            if (keyPair == null) {
                this.newKey = this.generateLocalKey(keyType, keySize, DEFAULT_RNG, provider);
            } else {
                if (!keyPair.getPublic().getAlgorithm().equals(signingKey.getAlgorithm())) {
                    if (debug != null) {
                        debug.text(0L, className, "PkNewCertImpl", "Keypair type not same as signer key {0}", keyPair.getPublic().getAlgorithm());
                    }
                    throw new PkRejectionException(PkNLSConstants.INVALID_KEY_TYPE);
                }
                this.newKey = keyPair;
            }
            this.newCert = this.generatenewCertificate(2, signAlgorithm, subject, issuer, this.newKey.getPublic(), numValidDays, this.generateKID(useShortSubjectKId), null, null, null, provider, false);
            this.newCertSign(signAlgorithm, provider, signingKey);
        }

        PkNewCertImpl(int keySize, String subjectDN, int numValidDays, Date nb2, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key) throws PkRejectionException {
            PrivateKey signingKey = signing_cert_private_key;
            if (signingKey == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String keyType = signingKey.getAlgorithm();
            X500Name subject = this.validSubject(subjectDN);
            this.notBefore = nb2;
            this.signingChain = this.validChain(signing_cert_chain);
            X500Name issuer = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String signAlgorithm = this.signingChain[0].getSigAlgName();
            this.newKey = this.generateLocalKey(keyType, keySize, DEFAULT_RNG, provider);
            this.newCert = this.generatenewCertificate(2, signAlgorithm, subject, issuer, this.newKey.getPublic(), numValidDays, this.generateKID(useShortSubjectKId), subjectAltNames, kUsage, extKUsage, provider, false);
            this.newCertSign(signAlgorithm, provider, signingKey);
        }

        PkNewCertImpl(int keySize, String subjectDN, int numValidDays, Date nb2, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, X509Certificate[] signing_cert_chain, PrivateKey signing_cert_private_key, boolean CA) throws PkRejectionException {
            boolean wantCA = CA;
            PrivateKey signingKey = signing_cert_private_key;
            if (signingKey == null) {
                if (debug != null) {
                    debug.text(0L, className, "PkNewCertImpl", "Null signingKey");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_PRIVATE_KEY);
            }
            String keyType = signingKey.getAlgorithm();
            X500Name subject = this.validSubject(subjectDN);
            this.notBefore = nb2;
            this.signingChain = this.validChain(signing_cert_chain);
            X500Name issuer = this.validIssuer(this.signingChain[0].getSubjectX500Principal().getName());
            String signAlgorithm = this.signingChain[0].getSigAlgName();
            if (keyPair == null) {
                this.newKey = this.generateLocalKey(keyType, keySize, DEFAULT_RNG, provider);
            } else {
                if (!keyPair.getPublic().getAlgorithm().equals(signingKey.getAlgorithm())) {
                    if (debug != null) {
                        debug.text(0L, className, "PkNewCertImpl", "Keypair type not same as signer key {0}", keyPair.getPublic().getAlgorithm());
                    }
                    throw new PkRejectionException(PkNLSConstants.INVALID_KEY_TYPE);
                }
                this.newKey = keyPair;
            }
            this.newCert = this.generatenewCertificate(2, signAlgorithm, subject, issuer, this.newKey.getPublic(), numValidDays, this.generateKID(useShortSubjectKId), subjectAltNames, kUsage, extKUsage, provider, wantCA);
            this.newCertSign(signAlgorithm, provider, signingKey);
        }

        private byte[] generateKID(boolean shortFormKID) throws PkRejectionException {
            try {
                byte[] kIDTmp = PkUtils.computeKID(this.newKey.getPublic(), shortFormKID);
                if (debug != null) {
                    debug.text(0L, className, "generateKID", "Subject Key Identifier is {0}", (Object)kIDTmp);
                }
                return kIDTmp;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
        }

        private X500Name validSubject(String rawSubject) throws PkRejectionException {
            X500Name subject;
            try {
                subject = new X500Name(rawSubject);
                if (debug != null) {
                    debug.text(0L, className, "validSubject", "X500Name is {0}", subject);
                }
            }
            catch (IOException ex) {
                throw new PkRejectionException(PkNLSConstants.INVALID_SUBJECT_NAME, ex);
            }
            return subject;
        }

        private X500Name validIssuer(String rawIssuer) throws PkRejectionException {
            X500Name issuer;
            try {
                issuer = new X500Name(rawIssuer);
                if (debug != null) {
                    debug.text(0L, className, "validIssuer", "X500Name is {0}", issuer);
                }
            }
            catch (IOException ex) {
                throw new PkRejectionException(PkNLSConstants.INVALID_SUBJECT_NAME, ex);
            }
            return issuer;
        }

        private X509Certificate[] validChain(X509Certificate[] signing_cert_chain) throws PkRejectionException {
            if (signing_cert_chain == null || signing_cert_chain.length == 0) {
                if (debug != null) {
                    debug.text(0L, className, "validCert", "Signing Cert is null");
                }
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE);
            }
            X509Certificate[] signingChain = new X509Certificate[signing_cert_chain.length];
            for (int i2 = 0; i2 < signing_cert_chain.length; ++i2) {
                signingChain[i2] = signing_cert_chain[i2];
                if (signingChain[i2] != null) continue;
                if (debug != null) {
                    debug.text(0L, className, "validCert", "Signing Cert is null {0}", i2);
                }
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE);
            }
            if (debug != null) {
                debug.text(0L, className, "validCert", "Signing Cert is {0}", signingChain[0]);
            }
            return signingChain;
        }

        private KeyPair generateLocalKey(String keyType, int keySz, String randomNoGenerator, String provider) throws PkRejectionException {
            KeyPair keyPair;
            int locKeySz;
            String locProvider = provider == null || provider.length() == 0 ? DEFAULT_PROVIDER : provider;
            int n2 = locKeySz = keySz == 0 ? 1024 : keySz;
            if (!keyType.contains("EC") && locKeySz < 512) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + keySz);
            }
            if (debug != null) {
                debug.text(0L, className, "generateLocalKey", "Keytype is {0}", keyType);
                debug.text(0L, className, "generateLocalKey", "Provider is {0}", locProvider);
                debug.text(0L, className, "generateLocalKey", "KeySize is {0}", new Integer(locKeySz));
            }
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyType, provider);
                SecureRandom secureRandom = randomNoGenerator == null || randomNoGenerator.length() == 0 ? SecureRandom.getInstance(locProvider) : SecureRandom.getInstance(randomNoGenerator, locProvider);
                if (debug != null) {
                    debug.text(0L, className, "generateLocalKey", "RNG is {0}", secureRandom);
                }
                keyPairGenerator.initialize(keySz, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            catch (NoSuchProviderException nspe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, nspe);
            }
            catch (InvalidParameterException e2) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + keySz, e2);
            }
            return keyPair;
        }

        private X509Certificate generatenewCertificate(int version, String signatureAlgorithm, X500Name subjectName, X500Name issuerName, PublicKey key, int lifeSpan, byte[] kID, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String provider, boolean wantCA) throws PkRejectionException {
            X509CertImpl newCert;
            BigInteger serial_no;
            AlgorithmId algId;
            String locProvider;
            X509CertInfo newCertInfo = new X509CertInfo();
            if (debug != null) {
                debug.text(0L, className, "generatenewCertificate", "Version is {0}", new Integer(version));
            }
            if (version != 2) {
                throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_INVALID);
            }
            if (debug != null) {
                debug.text(0L, className, "generatenewCertificate", "Validity Period is {0}", new Integer(lifeSpan));
            }
            if (lifeSpan <= 0) {
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            String string = locProvider = provider == null || provider.length() == 0 ? DEFAULT_PROVIDER : provider;
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Signing algorithm is {0}", signatureAlgorithm);
                debug.text(0L, className, "createSubjectAltName", "Provider is {0}", locProvider);
                debug.text(0L, className, "createSubjectAltName", "Issuer is {0}", issuerName);
            }
            try {
                algId = AlgorithmId.get(signatureAlgorithm, locProvider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            ObjectIdentifier locOid = algId.getOID();
            if (!algList.contains(locOid)) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM);
            }
            Date date = new Date();
            Date date1 = new Date();
            if (this.notBefore != null) {
                Date currentDate = new Date();
                if (this.notBefore.getTime() < currentDate.getTime() - 259200000L) {
                    throw new PkRejectionException("notBefore Time cannot exceed more than 3 days prior to the UTC time");
                }
                date.setTime(this.notBefore.getTime());
                date1.setTime(this.notBefore.getTime());
            }
            date1.setTime(date1.getTime() + (long)(lifeSpan * 24 * 60 * 60) * 1000L);
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Start date {0}", date);
                debug.text(0L, className, "createSubjectAltName", "End date {0}", date1);
            }
            CertificateValidity certValidity = new CertificateValidity(date, date1);
            CertificateExtensions cexts = new CertificateExtensions();
            try {
                newCertInfo.set("version", new CertificateVersion(version));
                serial_no = BigInteger.valueOf(System.nanoTime());
                newCertInfo.set("serialNumber", new CertificateSerialNumber(serial_no));
                newCertInfo.set("algorithmID", new CertificateAlgorithmId(algId));
                newCertInfo.set("subject", new CertificateSubjectName(subjectName));
                newCertInfo.set("issuer", new CertificateIssuerName(issuerName));
                newCertInfo.set("key", new CertificateX509Key(key));
                newCertInfo.set("validity", certValidity);
                if (subjectAltNames != null && subjectAltNames.size() > 0) {
                    SubjectAlternativeNameExtension sane = this.createSubjectAltName(subjectAltNames);
                    cexts.set("x509.info.extensions.SubjectAlternativeName", sane);
                }
                if (kID != null) {
                    this.newKeyIdentifier = kID;
                    SubjectKeyIdentifierExtension skie = new SubjectKeyIdentifierExtension(kID);
                    cexts.set("x509.info.extensions.SubjectKeyIdentifier", skie);
                }
                if (kUsage != null && !kUsage.isEmpty()) {
                    KeyUsageExtension KUsage = this.setKeyUsageExt(kUsage);
                    cexts.set("x509.info.extensions.KeyUsage", KUsage);
                }
                if (wantCA) {
                    BasicConstraintsExtension basicConstraintsExt = new BasicConstraintsExtension(true, -1);
                    cexts.set("x509.info.extensions.BasicConstraints", basicConstraintsExt);
                }
                if (extkUsage != null && !extkUsage.isEmpty()) {
                    ExtKeyUsageExtension xKUsage = this.setextKeyUsageExt(extkUsage);
                    cexts.set("x509.info.extensions.ExtKeyUsage", xKUsage);
                }
                newCertInfo.set("extensions", cexts);
            }
            catch (CertificateException ce) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ce);
            }
            catch (IOException ioe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ioe);
            }
            catch (Exception ex) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ex);
            }
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Raw certificate request created with serial {0}", serial_no);
            }
            try {
                newCert = new X509CertImpl(newCertInfo, locProvider);
            }
            catch (CertificateParsingException cpe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, cpe);
            }
            catch (CertificateEncodingException cee) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, cee);
            }
            return newCert;
        }

        private KeyUsageExtension setKeyUsageExt(List<String> kUsage) throws IOException, PkRejectionException {
            KeyUsageExtension keyUsage = new KeyUsageExtension();
            for (String uKeyString : kUsage) {
                if (debug != null) {
                    debug.text(0L, className, "setKeyUsageExt", "Processing {0}", uKeyString);
                }
                if (uKeyString.equalsIgnoreCase("digital_signature")) {
                    keyUsage.set("digital_signature", Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("data_encipherment")) {
                    keyUsage.set("data_encipherment", Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("encipher_only")) {
                    keyUsage.set("encipher_only", Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("decipher_only")) {
                    keyUsage.set("decipher_only", Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("non_repudiation")) {
                    keyUsage.set("non_repudiation", Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("key_encipherment")) {
                    keyUsage.set("key_encipherment", Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("key_agreement")) {
                    keyUsage.set("key_agreement", Boolean.TRUE);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            return keyUsage;
        }

        private ExtKeyUsageExtension setextKeyUsageExt(List<String> extkUsage) throws IOException, PkRejectionException {
            ExtKeyUsageExtension extkeyUsage = null;
            Vector<ObjectIdentifier> v2 = new Vector<ObjectIdentifier>();
            for (String extUKeyString : extkUsage) {
                if (debug != null) {
                    debug.text(0L, className, "setextKeyUsageExt", "Processing {0}", extUKeyString);
                }
                if (extUKeyString.equalsIgnoreCase("ServerAuth_Id")) {
                    v2.add(PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("ClientAuth_Id")) {
                    v2.add(PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("CodeSigning_Id")) {
                    v2.add(PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("EmailProtection_Id")) {
                    v2.add(PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("IPSecEndSystem_Id")) {
                    v2.add(PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("IPSecTunnel_Id")) {
                    v2.add(PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("IPSecUser_Id")) {
                    v2.add(PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("TimeStamping_Id")) {
                    v2.add(PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            if (v2.size() > 0) {
                extkeyUsage = new ExtKeyUsageExtension(v2);
            }
            return extkeyUsage;
        }

        private byte[] getIPAddress(String ipString) {
            String[] splitString = PkString.split(ipString, ".");
            byte[] ipAddress = new byte[]{new Integer(splitString[0]).byteValue(), new Integer(splitString[1]).byteValue(), new Integer(splitString[2]).byteValue(), new Integer(splitString[3]).byteValue()};
            return ipAddress;
        }

        private SubjectAlternativeNameExtension createSubjectAltName(List<String> subjectAltNames) throws Exception {
            SubjectAlternativeNameExtension sub = null;
            if (subjectAltNames != null) {
                GeneralNames gen = new GeneralNames();
                boolean altnameSpecified = false;
                int length = subjectAltNames.size();
                if (subjectAltNames.get(0) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", subjectAltNames.get(0));
                    }
                    gen.addElement(new RFC822Name(subjectAltNames.get(0)));
                    altnameSpecified = true;
                }
                if (length > 1 && subjectAltNames.get(1) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", subjectAltNames.get(1));
                    }
                    gen.addElement(new DNSName(subjectAltNames.get(1)));
                    altnameSpecified = true;
                }
                if (length > 2 && subjectAltNames.get(2) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", subjectAltNames.get(2));
                    }
                    gen.addElement(new URIName(subjectAltNames.get(2)));
                    altnameSpecified = true;
                }
                if (length > 3 && subjectAltNames.get(3) != null) {
                    if (debug != null) {
                        debug.text(0L, className, "createSubjectAltName", "Processing {0}", subjectAltNames.get(3));
                    }
                    gen.addElement(new IPAddressName(this.getIPAddress(subjectAltNames.get(3))));
                    altnameSpecified = true;
                }
                if (altnameSpecified) {
                    sub = new SubjectAlternativeNameExtension(gen);
                }
            } else if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "No subject Alt Names provided");
            }
            return sub;
        }

        private void newCertSign(String signAlgorithm, String provider, PrivateKey signingKey) throws PkRejectionException {
            if (debug != null) {
                debug.text(0L, className, "newCertSign", "Signing with {0}", signAlgorithm);
            }
            try {
                ((X509CertImpl)this.newCert).sign(signingKey, signAlgorithm, provider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            catch (InvalidKeyException ike) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE, ike);
            }
            catch (NoSuchProviderException nspe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, nspe);
            }
            catch (SignatureException se) {
                throw new PkRejectionException(PkNLSConstants.BAD_SS_CERT_SIGNATURE, se);
            }
            catch (CertificateException ce) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, ce);
            }
            if (debug != null) {
                debug.text(0L, className, "newCertSign", "Signed OK by provider {0}", provider);
            }
            this.newCertChain = new X509Certificate[this.signingChain.length + 1];
            System.arraycopy(this.signingChain, 0, this.newCertChain, 1, this.signingChain.length);
            this.newCertChain[0] = this.newCert;
        }

        @Override
        public PrivateKey getKey() {
            return this.newKey.getPrivate();
        }

        @Override
        public X509Certificate[] getCertificateChain() {
            return this.newCertChain;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.newKey.getPublic();
        }

        @Override
        public String getSubjectName() {
            return this.newCert.getSubjectDN().getName();
        }

        @Override
        public String getSigAlg() {
            return this.newCert.getSigAlgName();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.newKeyIdentifier;
        }

        @Override
        public void setToKeyStore(String alias, String password, KeyStore ks) throws PkException {
            if (alias == null || alias.length() == 0) {
                throw new PkException(PkNLSConstants.HTTP_BAD_OR_MISSING_ALIAS);
            }
            if (ks == null) {
                throw new PkException(PkNLSConstants.MISSING_KEYSTORE);
            }
            if (password == null || password.length() == 0) {
                throw new PkException(PkNLSConstants.TUI_INVALIDPWD);
            }
            try {
                ks.setKeyEntry(alias, this.newKey.getPrivate(), password.toCharArray(), this.newCertChain);
            }
            catch (KeyStoreException ke) {
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE);
            }
        }

        static {
            algList.add(AlgorithmId.sha1WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithRSAEncryption_OIW_oid);
            algList.add(AlgorithmId.sha1WithDSA_oid);
            algList.add(AlgorithmId.sha1WithDSA_OIW_oid);
            algList.add(AlgorithmId.shaWithDSA_OIW_oid);
            algList.add(AlgorithmId.md5WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithECDSA_oid);
            algList.add(AlgorithmId.sha224WithECDSA_oid);
            algList.add(AlgorithmId.sha256WithECDSA_oid);
            algList.add(AlgorithmId.sha384WithECDSA_oid);
            algList.add(AlgorithmId.sha512WithECDSA_oid);
            algList.add(AlgorithmId.md2WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha256WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha384WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha512WithRSAEncryption_oid);
        }
    }
}

