/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class CertOrEncCert
extends CMPDerObject {
    private boolean debug = false;
    private Certificate certificate;
    private EncryptedValue encryptedCert;
    boolean bCertificate;
    private static final byte TAG_CERTIFICATE = 0;
    private static final byte TAG_ENCRYPTED_CERT = 1;
    private byte[] certBytes = null;

    public CertOrEncCert(EncryptedValue encryptedValue) {
        if (encryptedValue == null) {
            throw new IllegalArgumentException("CertOrEncCert error, encrypted certificate not specified");
        }
        this.encryptedCert = encryptedValue;
        this.certificate = null;
        this.bCertificate = false;
    }

    public CertOrEncCert(Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("CertOrEncCert error, certificate not specified");
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("CertOrEncCert error, invalid certificate type. Only X509 certificate is supported");
        }
        this.certificate = certificate;
        this.encryptedCert = null;
        this.bCertificate = true;
    }

    public CertOrEncCert(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertOrEncCert(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getData().available() == 0) {
            throw new IOException("CertOrEncCert parsing error, missing data");
        }
        this.certificate = null;
        this.encryptedCert = null;
        if (derValue.isContextSpecific((byte)0) && derValue.isConstructed()) {
            try {
                if (this.debug) {
                    System.out.println("Parsing CertOrEncCert: Certificate=");
                }
                DerValue derValue2 = derValue.getData().getDerValue();
                this.certBytes = derValue2.toByteArray();
                if (this.debug) {
                    FileOutputStream fileOutputStream = new FileOutputStream("c:\\debug\\cert" + new Date().getTime() + ".cer");
                    fileOutputStream.write(this.certBytes);
                    fileOutputStream.close();
                }
                this.certificate = new X509CertImpl(derValue2);
                this.bCertificate = true;
            }
            catch (CertificateException certificateException) {
                throw new IOException("CertOrEncCert parsing error, " + certificateException);
            }
        } else if (derValue.isContextSpecific((byte)1) && derValue.isConstructed()) {
            this.encryptedCert = new EncryptedValue(derValue.getData().getDerValue().toByteArray());
            this.bCertificate = false;
        } else {
            throw new IOException("CertOrEncCert parsing error, invalid tag");
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("CertOrEncCert parsing error, missing data");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.bCertificate) {
            if (this.certificate == null) throw new IOException("CertOrEncCert encoding error, certificate not specified");
            try {
                if (!(this.certificate instanceof X509Certificate)) {
                    throw new IOException("Certificate has a type of " + this.certificate.getClass().getName() + ". Only instances of java.secuirty.cert.X509Certificate are supported.");
                }
                derOutputStream.write(this.certificate.getEncoded());
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("CertOrEncCert encoding error, " + certificateEncodingException);
            }
        } else {
            if (this.encryptedCert == null) throw new IOException("CertOrEncCert encoding error, encrypted certificate not specified");
            this.encryptedCert.encode(derOutputStream);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CertOrEncCert certOrEncCert) {
        DerValue derValue;
        DerValue derValue2;
        if (certOrEncCert == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certOrEncCert.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertOrEncCert) {
            return this.equals((CertOrEncCert)object);
        }
        return false;
    }

    public byte[] getCertBytes() {
        return this.certBytes;
    }

    public EncryptedValue getCertOrEncCert() throws IOException {
        if (this.encryptedCert == null) {
            return null;
        }
        return (EncryptedValue)this.encryptedCert.clone();
    }

    public Certificate getCertificate() {
        if (this.certificate == null) {
            return null;
        }
        return this.certificate;
    }

    public boolean isCertificate() {
        return this.bCertificate;
    }

    public String toString() {
        String string = "CertOrEncCert:";
        string = this.bCertificate ? String.valueOf(string) + "\r\n\tCertificate: " + this.certificate.toString() : String.valueOf(string) + "\r\n\tEncrypted Certificate: " + this.encryptedCert.toString();
        return string;
    }
}

