/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CertTemplate;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRLException;

public final class RevDetailsv2
extends CMPDerObject {
    private CertTemplate certDetails;
    private CRLExtensions crlEntryDetails;

    public RevDetailsv2(CertTemplate certTemplate, CRLExtensions cRLExtensions) {
        if (certTemplate == null) {
            throw new IllegalArgumentException("RevDetailsv2 error, cert details not specified");
        }
        this.certDetails = certTemplate;
        this.crlEntryDetails = cRLExtensions;
    }

    public RevDetailsv2(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new RevDetailsv2(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("RevDetailsv2 parsing error, not a SEQUENCE");
        }
        this.certDetails = null;
        this.crlEntryDetails = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("RevDetailsv2 parsing error, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.certDetails = new CertTemplate(derValue2.toByteArray());
        if (derValue.getData().available() == 0) {
            return;
        }
        derValue2 = derValue.getData().getDerValue();
        try {
            this.crlEntryDetails = new CRLExtensions(new DerInputStream(derValue2.toByteArray()));
        }
        catch (CRLException cRLException) {
            throw new IOException("RevDetailsv2 parsing error, " + cRLException);
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("RevDetailsv2 parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.certDetails == null) {
            throw new IOException("RevDetailsv2 encoding error, cert details not specified");
        }
        this.certDetails.encode(derOutputStream);
        if (this.crlEntryDetails != null) {
            try {
                this.crlEntryDetails.encode(derOutputStream, true);
            }
            catch (CRLException cRLException) {
                throw new IOException("RevDetailsv2 encoding error, " + cRLException);
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(RevDetailsv2 revDetailsv2) {
        DerValue derValue;
        DerValue derValue2;
        if (revDetailsv2 == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            revDetailsv2.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof RevDetailsv2) {
            return this.equals((RevDetailsv2)object);
        }
        return false;
    }

    public CertTemplate getCertDetails() {
        return (CertTemplate)this.certDetails.clone();
    }

    public CRLExtensions getCrlEntryDetails() throws IOException {
        if (this.crlEntryDetails == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.crlEntryDetails.encode(derOutputStream, true);
            return new CRLExtensions(new DerInputStream(derOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public String toString() {
        String string = "RevDetailsv2:\r\n";
        string = String.valueOf(string) + "\r\n\tCert Details: " + this.certDetails;
        if (this.crlEntryDetails != null) {
            string = String.valueOf(string) + "\r\n\tcrl entry details: " + this.crlEntryDetails;
        }
        return string;
    }
}

