/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.keystoreski;

import com.ibm.misc.Debug;
import com.ibm.security.keystoreski.KeyStoreSKI;
import com.ibm.security.keystoreski.SKIDefinition;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public final class KeyStoreSKIFactory {
    private KeyStoreSKIFactory() {
        throw new UnsupportedOperationException();
    }

    public static KeyStoreSKI newKeyStoreSKI(KeyStore ks) {
        if (ks == null) {
            throw new NullPointerException();
        }
        return new KeyStoreSKIImpl(ks);
    }

    private static final class KeyStoreSKIImpl
    implements KeyStoreSKI {
        private static Debug debug = Debug.getInstance("keycertmanage");
        private final Object className = this.toString();
        private final KeyStore ks;

        KeyStoreSKIImpl(KeyStore ks) {
            this.ks = ks;
        }

        @Override
        public PrivateKey getPrivateKey(String subjectKeyIdentifier, SKIDefinition definition, char[] password) throws KeyStoreException {
            if (debug != null) {
                debug.text(1L, this.className, "getPrivateKey", "entering method");
            }
            if (subjectKeyIdentifier == null || subjectKeyIdentifier.length() == 0 || definition == null || password == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPrivateKey", new NullPointerException());
                }
                throw new NullPointerException();
            }
            try {
                Enumeration<String> aliases = this.ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!this.ks.isKeyEntry(alias)) continue;
                    try {
                        String ski;
                        Key key = this.ks.getKey(alias, password);
                        Certificate[] chain = this.ks.getCertificateChain(alias);
                        if (!(key instanceof PrivateKey) || chain == null || chain.length <= 0 || (ski = definition.getSubjectKeyIdentifier((X509Certificate)chain[0])) == null || !ski.equals(subjectKeyIdentifier)) continue;
                        if (debug != null) {
                            debug.text(1L, this.className, "getPrivateKey", "exiting method");
                        }
                        return (PrivateKey)key;
                    }
                    catch (UnrecoverableKeyException e2) {
                        if (debug == null) continue;
                        debug.text(1L, this.className, "getPrivateKey", "password couldn't get key");
                    }
                }
                if (debug != null) {
                    debug.text(1L, this.className, "getPrivateKey", "returning null");
                }
                return null;
            }
            catch (NoSuchAlgorithmException e3) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPrivateKey", e3);
                }
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }

        @Override
        public Certificate getCertificate(String subjectKeyIdentifier, SKIDefinition definition) throws KeyStoreException {
            if (debug != null) {
                debug.text(1L, this.className, "getCertificate", "entering method");
            }
            if (subjectKeyIdentifier == null || subjectKeyIdentifier.length() == 0 || definition == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getCertificate", new NullPointerException());
                }
                throw new NullPointerException();
            }
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                String ski;
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                if (cert == null || (ski = definition.getSubjectKeyIdentifier(cert)) == null || !ski.equals(subjectKeyIdentifier)) continue;
                if (debug != null) {
                    debug.text(1L, this.className, "getCertificate", "exiting method");
                }
                return cert;
            }
            if (debug != null) {
                debug.text(1L, this.className, "getCertificate", "returning null");
            }
            return null;
        }

        @Override
        public String getAlias(String subjectKeyIdentifier, SKIDefinition definition) throws KeyStoreException {
            if (debug != null) {
                debug.text(1L, this.className, "getAlias", "entering method");
            }
            if (subjectKeyIdentifier == null || subjectKeyIdentifier.length() == 0 || definition == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getAlias", new NullPointerException());
                }
                throw new NullPointerException();
            }
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                String ski;
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                if (cert == null || (ski = definition.getSubjectKeyIdentifier(cert)) == null || !ski.equals(subjectKeyIdentifier)) continue;
                if (debug != null) {
                    debug.text(1L, this.className, "getAlias", "exiting method");
                }
                return alias;
            }
            if (debug != null) {
                debug.text(1L, this.className, "getAlias", "returning null");
            }
            return null;
        }
    }
}

