/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.msgstore.expiry.ExpirableReference;
import com.ibm.ws.sib.msgstore.expiry.ExpiryIndex;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Expirer
implements AlarmListener,
XmlConstants {
    private static TraceComponent tc = SibTr.register(Expirer.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int BATCH_SIZE = 20;
    private static final int CLEANUP_EVERY_N_CYCLES = 5;
    private static final int MAX_DIAG_LOG = 30;
    private static final int MAX_CONSECUTIVE_FAILURES = 3;
    private final ExpiryIndex expiryIndex = new ExpiryIndex();
    private Alarm expiryAlarm = null;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ReentrantReadWriteLock expiryAlarmLock = new ReentrantReadWriteLock();
    private long interval = 0L;
    private byte consecutiveFailures = 0;
    private final MessageStoreImpl messageStore;
    private JsMessagingEngine messagingEngine = null;
    private Exception lastException = null;
    private long lastExceptionTime = 0L;
    private long expirerStartTime = 0L;
    private long expirerStopTime = 0L;
    private long startTime = 0L;
    private boolean cleanupDeletedItems = false;
    private int diagIndex = 0;
    private long[] alarmTime = new long[30];
    private long[] logIndexSize = new long[30];
    private long[] logProcessed = new long[30];
    private long[] logExpired = new long[30];
    private long[] logRemain = new long[30];
    private long[] logGone = new long[30];
    private long[] logCleaned = new long[30];
    private int countForCleanup = 0;
    private int batchCount = 0;
    private int cleanupLimit = 5;

    public Expirer(MessageStoreImpl messageStore) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)((Object)messageStore));
        }
        this.messageStore = messageStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public final void addExpirable(Expirable expirable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addExpirable", (Object)("objId=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetID())) + " started=" + this.started));
        }
        if (expirable != null && this.started.get() && expirable.expirableIsInStore()) {
            ExpirableReference expirableRef = new ExpirableReference(expirable);
            if (this.expiryIndex.put(expirableRef)) {
                this.scheduleAlarm(this.interval);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Added: expiryTime=" + expirableRef.getExpiryTime() + ", objectId=" + expirableRef.getID()));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Duplicate expirable: ExpirtTime=" + expirableRef.getExpiryTime() + ", obectId=" + expirableRef.getID()));
                }
                this.stop();
                Object[] o = new Object[]{expirableRef.getExpiryTime() + " : " + expirableRef.getID()};
                SevereMessageStoreException severeMessageStoreException = new SevereMessageStoreException("DUPLICATE_EXPIRABLE_SIMS2000", o);
                this.lastException = severeMessageStoreException;
                this.lastExceptionTime = System.currentTimeMillis();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addExpirable");
                }
                throw severeMessageStoreException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addExpirable");
        }
    }

    public final boolean isRunning() {
        return this.started.get();
    }

    public final boolean removeExpirable(Expirable expirable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeExpirable", (Object)("objId=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetID())) + " ET=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetExpiryTime())) + " started=" + this.started));
        }
        boolean removed = false;
        if (expirable != null) {
            ExpirableReference expirableRef = new ExpirableReference(expirable);
            removed = this.expiryIndex.remove(expirableRef);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeExpirable", (Object)("removed=" + removed));
        }
        return removed;
    }

    public final int size() {
        return this.expiryIndex.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(long expiryInterval, JsMessagingEngine jsMessagingEngine) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)("expityInterval=" + expiryInterval + " jsMessagingEngine=" + jsMessagingEngine + " indexSize=" + this.expiryIndex.size()));
        }
        this.messagingEngine = jsMessagingEngine;
        if (expiryInterval >= 0L) {
            this.interval = expiryInterval;
        } else {
            String value = this.messageStore.getProperty("expiryInterval", "1000");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Value from property=<" + value + ">"));
            }
            try {
                this.interval = Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                this.lastException = e;
                this.lastExceptionTime = System.currentTimeMillis();
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("Unable to parse property: " + e));
                this.interval = 1000L;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"start", (Object)("expiryInterval=" + this.interval));
        }
        if (this.interval < 1L) {
            this.stop();
        } else {
            this.expiryAlarmLock.writeLock().lock();
            try {
                if (this.started.get()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Expiry already started");
                    }
                    SevereMessageStoreException e = new SevereMessageStoreException("EXPIRY_THREAD_ALREADY_RUNNING_SIMS2004");
                    this.lastException = e;
                    this.lastExceptionTime = System.currentTimeMillis();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"start");
                    }
                    throw e;
                }
                this.started.set(true);
                this.expirerStartTime = System.currentTimeMillis();
                if (!this.expiryIndex.isEmpty()) {
                    this.scheduleAlarm(this.interval);
                }
            }
            finally {
                this.expiryAlarmLock.writeLock().unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)("started=" + this.started + " interval=" + this.interval));
        }
    }

    public final void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)("started=" + this.started + " expiryAlarm=" + this.expiryAlarm));
        }
        this.expiryAlarmLock.writeLock().lock();
        try {
            this.started.set(false);
            if (this.expiryAlarm != null) {
                this.expiryAlarm.cancel();
                this.expiryAlarm = null;
            }
        }
        finally {
            this.expiryAlarmLock.writeLock().unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object obj) {
        if (this.messagingEngine != null) {
            SibTr.push((Object)this.messagingEngine);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("expiryIndex.isEmpty()=" + this.expiryIndex.isEmpty()));
        }
        if (!this.started.get()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)(" started=" + this.started + this.expiryIndex.size()));
            }
            if (this.messagingEngine != null) {
                SibTr.pop();
            }
            return;
        }
        ExternalLocalTransaction transaction = null;
        int indexUsed = 0;
        long processed = 0L;
        long expired = 0L;
        long cleaned = 0L;
        long gone = 0L;
        long remain = 0L;
        try {
            block47: {
                ++this.countForCleanup;
                if (this.countForCleanup >= this.cleanupLimit) {
                    this.countForCleanup = 0;
                    this.cleanupDeletedItems = true;
                } else {
                    this.cleanupDeletedItems = false;
                }
                this.startTime = System.currentTimeMillis();
                indexUsed = this.saveStartTime(this.startTime);
                try {
                    Iterator<ExpirableReference> iterator = this.expiryIndex.iterator();
                    ExpirableReference expirableRef = iterator.next();
                    while (expirableRef.getExpiryTime() <= this.startTime) {
                        ++processed;
                        Expirable expirable = (Expirable)expirableRef.get();
                        if (expirable != null && expirable.expirableIsInStore()) {
                            if (transaction == null) {
                                transaction = this.messageStore.getTransactionFactory().createLocalTransaction();
                            }
                            if (expirable.expirableExpire((PersistentTransaction)transaction)) {
                                iterator.remove();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Removed (expired) ExpiryTime=" + expirableRef.getExpiryTime() + " objectId=" + expirableRef.getID()));
                                }
                                ++expired;
                                ++this.batchCount;
                                if (this.batchCount >= 20) {
                                    transaction.commit();
                                    transaction = null;
                                    this.batchCount = 0;
                                }
                            } else {
                                ++remain;
                            }
                        } else {
                            iterator.remove();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Removed (gone) ExpiryTime=" + expirableRef.getExpiryTime() + " objectId=" + expirableRef.getID()));
                            }
                            ++gone;
                        }
                        expirableRef = iterator.next();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block47;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("No more ExpirableReferences, processed=" + processed + " expired=" + expired + " gone=" + gone));
                }
            }
            if (this.cleanupDeletedItems) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Expiry cleanup in progress");
                }
                if ((cleaned = this.expiryIndex.clean()) < 10L && this.cleanupLimit < 100) {
                    this.cleanupLimit += 5;
                } else if (cleaned > 1000L && this.cleanupLimit > 5) {
                    this.cleanupLimit = 5;
                } else if (cleaned > 100L && this.cleanupLimit > 5) {
                    this.cleanupLimit -= 5;
                }
            }
            if (transaction != null) {
                if (this.batchCount == 0) {
                    transaction.rollback();
                } else {
                    transaction.commit();
                    this.batchCount = 0;
                }
                transaction = null;
            }
            this.consecutiveFailures = 0;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.expiry.Expirer.run", (String)"441", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("Expiry thread exception: " + e));
            }
            this.consecutiveFailures = (byte)(this.consecutiveFailures + 1);
            this.lastException = e;
            this.lastExceptionTime = System.currentTimeMillis();
            if (this.consecutiveFailures > 3) {
                this.stop();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)e);
                }
                throw new MessageStoreRuntimeException("EXPIRY_DAEMON_TERMINATED_SIMS2001", new Object[]{e}, (Throwable)e);
            }
        }
        finally {
            long currIndexSize = 0L;
            this.expiryAlarmLock.writeLock().lock();
            try {
                if (this.started.get() && !this.expiryIndex.isEmpty()) {
                    this.expiryAlarm = AlarmManager.createNonDeferrable((long)this.interval, (AlarmListener)this);
                    currIndexSize = this.expiryIndex.size();
                } else {
                    this.expiryAlarm = null;
                }
            }
            finally {
                this.expiryAlarmLock.writeLock().unlock();
            }
            this.logIndexSize[indexUsed] = currIndexSize;
            this.logProcessed[indexUsed] = processed;
            this.logExpired[indexUsed] = expired;
            this.logGone[indexUsed] = gone;
            this.logRemain[indexUsed] = remain;
            this.logCleaned[indexUsed] = cleaned;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)(" processed=" + processed + " gone=" + gone + " expired=" + expired + " remain=" + remain + " cleaned=" + cleaned + " expiry=" + this.expiryIndex.size() + " cleanupLimit=" + this.cleanupLimit));
        }
        if (this.messagingEngine != null) {
            SibTr.pop();
        }
    }

    private int saveStartTime(long time) {
        int indexUsed = this.diagIndex;
        this.alarmTime[this.diagIndex++] = time;
        if (this.diagIndex >= 30) {
            this.diagIndex = 0;
        }
        return indexUsed;
    }

    /*
     * Unable to fully structure code
     */
    private void scheduleAlarm(long timeOut) {
        if (TraceComponent.isAnyTracingEnabled() && Expirer.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)Expirer.tc, (String)"scheduleAlarm", (Object)("timeOut=" + timeOut + " started=" + this.started + " expiryAlarm=" + this.expiryAlarm));
        }
        this.expiryAlarmLock.readLock().lock();
        if (this.started.get() && this.expiryAlarm == null) {
            this.expiryAlarmLock.readLock().unlock();
            this.expiryAlarmLock.writeLock().lock();
            try {
                if (!this.started.get() || this.expiryAlarm != null) ** GOTO lbl15
                this.expiryAlarm = AlarmManager.createNonDeferrable((long)timeOut, (AlarmListener)this);
            }
            finally {
                this.expiryAlarmLock.writeLock().unlock();
            }
        } else {
            this.expiryAlarmLock.readLock().unlock();
        }
lbl15:
        // 3 sources

        if (TraceComponent.isAnyTracingEnabled() && Expirer.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)Expirer.tc, (String)"scheduleAlarm", (Object)("started=" + this.started + " expiryAlarm=" + this.expiryAlarm));
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd @ HH:mm:ss.SSS");
        writer.newLine();
        writer.startTag("expirer");
        writer.indent();
        writer.newLine();
        writer.taggedValue("timeNow", (Object)dateFormat.format(new Date()));
        writer.newLine();
        writer.taggedValue("interval", this.interval);
        writer.newLine();
        writer.taggedValue("started", (Object)this.started);
        writer.newLine();
        writer.taggedValue("cleanupFlag", (Object)this.cleanupDeletedItems);
        writer.newLine();
        writer.taggedValue("expirerStartTime", (Object)dateFormat.format(new Date(this.expirerStartTime)));
        writer.newLine();
        writer.taggedValue("expirerStopTime", (Object)dateFormat.format(new Date(this.expirerStopTime)));
        writer.newLine();
        writer.taggedValue("nextLogIndex", (long)this.diagIndex);
        writer.newLine();
        for (int i = 0; i < 30; ++i) {
            String str = "Cycle=" + i + (this.diagIndex == i ? ":*" : ": ") + dateFormat.format(new Date(this.alarmTime[i])) + " size=" + this.logIndexSize[i] + " processed=" + this.logProcessed[i] + " expired=" + this.logExpired[i] + " remain=" + this.logRemain[i] + " gone=" + this.logGone[i] + " cleaned=" + this.logCleaned[i];
            writer.taggedValue("info", (Object)str);
            writer.newLine();
        }
        writer.startTag("storedException");
        if (this.lastException == null) {
            writer.write("No exceptions recorded");
        } else {
            writer.indent();
            writer.newLine();
            writer.taggedValue("time", (Object)new Date(this.lastExceptionTime));
            writer.outdent();
            writer.write((Throwable)this.lastException);
            writer.newLine();
        }
        writer.endTag("storedException");
        writer.outdent();
        writer.newLine();
        writer.endTag("expirer");
    }
}

