/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.common.utils.internal.RepositoryCommonUtils;
import com.ibm.ws.repository.transport.client.HasBreakingChanges;
import com.ibm.ws.repository.transport.client.JSONIgnore;
import com.ibm.ws.repository.transport.client.VersionableContent;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class DataModelSerializer {
    private static final String DATA_MODEL_PACKAGE = "com.ibm.ws.repository.transport.model";
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final String DATA_MODEL_ERROR_ARRAY = "Data Model Error: Simple parser does not understand nested arrays, or true/false in an array.";
    public static final String DATA_MODEL_ERROR_NUMBER = "Data Model Error: Simple parser does not understand numbers in arrays.";
    public static volatile boolean IGNORE_UNKNOWN_FIELDS = true;

    private static void addFieldToJsonObject(Method getter, Object o, String fieldName, JsonObjectBuilder j) {
        block22: {
            try {
                Object fieldValue = getter.invoke(o, new Object[0]);
                if (fieldValue == null) break block22;
                if (fieldValue instanceof String) {
                    j.add(fieldName, (String)fieldValue);
                    break block22;
                }
                if (fieldValue instanceof Boolean) {
                    j.add(fieldName, ((Boolean)fieldValue).booleanValue());
                    break block22;
                }
                if (fieldValue instanceof BigInteger) {
                    j.add(fieldName, (BigInteger)fieldValue);
                    break block22;
                }
                if (fieldValue instanceof BigDecimal) {
                    j.add(fieldName, (BigDecimal)fieldValue);
                    break block22;
                }
                if (fieldValue instanceof Double) {
                    j.add(fieldName, ((Double)fieldValue).doubleValue());
                    break block22;
                }
                if (fieldValue instanceof Integer) {
                    j.add(fieldName, ((Integer)fieldValue).intValue());
                    break block22;
                }
                if (fieldValue instanceof Long) {
                    j.add(fieldName, ((Long)fieldValue).longValue());
                    break block22;
                }
                if (fieldValue instanceof Short) {
                    j.add(fieldName, (int)((Short)fieldValue).shortValue());
                    break block22;
                }
                if (fieldValue instanceof Byte) {
                    j.add(fieldName, (int)((Byte)fieldValue).byteValue());
                    break block22;
                }
                if (fieldValue instanceof Enum) {
                    try {
                        Method getValueForEnumMethod = fieldValue.getClass().getMethod("getValue", new Class[0]);
                        Object valueFromGetValueMethod = getValueForEnumMethod.invoke(fieldValue, new Object[0]);
                        j.add(fieldName, valueFromGetValueMethod.toString());
                    }
                    catch (NoSuchMethodException e) {
                        j.add(fieldName, fieldValue.toString());
                    }
                    break block22;
                }
                if (fieldValue instanceof Collection || fieldValue.getClass().getName().startsWith(DATA_MODEL_PACKAGE)) {
                    JSONArtrifactPair fieldObjects = DataModelSerializer.findFieldsToSerialize(fieldValue);
                    j.add(fieldName, (JsonValue)fieldObjects.mainObject);
                    if (fieldObjects.incompatibleFieldsObject != null && !fieldObjects.incompatibleFieldsObject.isEmpty()) {
                        j.add(fieldName + "2", (JsonValue)fieldObjects.incompatibleFieldsObject);
                    }
                    break block22;
                }
                if (fieldValue instanceof Calendar) {
                    Date date = ((Calendar)fieldValue).getTime();
                    j.add(fieldName, DataModelSerializer.getDateFormat().format(date));
                    break block22;
                }
                if (fieldValue instanceof Date) {
                    j.add(fieldName, DataModelSerializer.getDateFormat().format((Date)fieldValue));
                    break block22;
                }
                if (fieldValue instanceof Locale) {
                    String localeString = ((Locale)fieldValue).toString();
                    j.add(fieldName, localeString);
                    break block22;
                }
                throw new IllegalStateException("Data Model Error: Unknown data model entity " + getter.getName() + " of type " + fieldValue.getClass().getName() + " on " + o.getClass().getName());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Data Model Error: unable to invoke getter " + getter.getName() + " on " + o.getClass().getName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Data Model Error: unable to invoke getter " + getter.getName() + " on " + o.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Data Model Error: unable to invoke getter " + getter.getName() + " on " + o.getClass().getName(), e);
            }
            catch (JsonException e) {
                throw new IllegalStateException("Data Model Error: unable to invoke getter " + getter.getName() + " on " + o.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static JSONArtrifactPair findFieldsToSerialize(Object o) {
        void var8_16;
        if (o instanceof Collection) {
            Collection listOfO = (Collection)o;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (Object listObject : listOfO) {
                if (listObject instanceof String) {
                    arrayBuilder.add((String)listObject);
                    continue;
                }
                if (listObject.getClass().getName().startsWith(DATA_MODEL_PACKAGE)) {
                    arrayBuilder.add((JsonValue)DataModelSerializer.findFieldsToSerialize(listObject).mainObject);
                    continue;
                }
                throw new IllegalStateException("Data Model Error: serialization only supported for Collections of String, or other Data Model elements");
            }
            JsonArray result = arrayBuilder.build();
            return new JSONArtrifactPair((JsonStructure)result, null);
        }
        JsonObjectBuilder mainObjectBuilder = Json.createObjectBuilder();
        TreeMap<String, Method> gettersFromO = new TreeMap<String, Method>();
        Class<?> classOfO = o.getClass();
        JsonObjectBuilder incompatibleFieldsObjectBuilder = null;
        Collection<String> fieldsToPutInIncompatibleObject = null;
        boolean haveIncompatibleFields = false;
        if (HasBreakingChanges.class.isAssignableFrom(classOfO) && !(fieldsToPutInIncompatibleObject = ((HasBreakingChanges)o).attributesThatCauseBreakingChanges()).isEmpty()) {
            incompatibleFieldsObjectBuilder = Json.createObjectBuilder();
            haveIncompatibleFields = true;
        }
        for (Method methodFromO : classOfO.getMethods()) {
            Method old;
            if (!methodFromO.getName().startsWith("get") || methodFromO.getName().length() <= 3 || methodFromO.getParameterTypes().length != 0 || (old = gettersFromO.put(methodFromO.getName(), methodFromO)) == null) continue;
            throw new IllegalStateException("Data Model Error: duplicate getter for " + methodFromO + "(" + old + ") on " + o.getClass().getName());
        }
        for (Map.Entry entry : gettersFromO.entrySet()) {
            String getterName = (String)entry.getKey();
            if ("getClass".equals(getterName) || ((Method)entry.getValue()).isAnnotationPresent(JSONIgnore.class)) continue;
            String nameOfField = getterName.substring(3, 4).toLowerCase() + getterName.substring(4);
            if (haveIncompatibleFields && fieldsToPutInIncompatibleObject.contains(nameOfField)) {
                DataModelSerializer.addFieldToJsonObject((Method)entry.getValue(), o, nameOfField, incompatibleFieldsObjectBuilder);
                continue;
            }
            DataModelSerializer.addFieldToJsonObject((Method)entry.getValue(), o, nameOfField, mainObjectBuilder);
        }
        JsonObject mainObject = mainObjectBuilder.build();
        Object var8_14 = null;
        if (incompatibleFieldsObjectBuilder != null) {
            JsonObject jsonObject = incompatibleFieldsObjectBuilder.build();
        }
        return new JSONArtrifactPair((JsonStructure)mainObject, (JsonObject)var8_16);
    }

    public static String serializeAsString(Object o) throws IOException {
        try {
            JsonStructure builtJsonObject = DataModelSerializer.findFieldsToSerialize((Object)o).mainObject;
            return builtJsonObject.toString();
        }
        catch (IllegalStateException ise) {
            throw new IOException("Unable to build JSON for Object", ise);
        }
        catch (JsonException e) {
            throw new IOException("Unable to build JSON for Object", e);
        }
    }

    public static void serializeAsStream(Object o, OutputStream s) throws IOException {
        try {
            JsonStructure builtJsonObject = DataModelSerializer.findFieldsToSerialize((Object)o).mainObject;
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(config);
            JsonWriter streamWriter = writerFactory.createWriter(s);
            streamWriter.write(builtJsonObject);
        }
        catch (IllegalStateException ise) {
            throw new IOException("Unable to build JSON for Object", ise);
        }
        catch (JsonException e) {
            throw new IOException("Unable to build JSON for Object", e);
        }
    }

    public static JsonValue serializeAsJson(Object o) throws IOException {
        try {
            return DataModelSerializer.findFieldsToSerialize((Object)o).mainObject;
        }
        catch (IllegalStateException ise) {
            throw new IOException("Unable to build JSON for Object", ise);
        }
        catch (JsonException e) {
            throw new IOException("Unable to build JSON for Object", e);
        }
    }

    private static Class<?> getClassForType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return DataModelSerializer.getClassForType(pt.getActualTypeArguments()[0]);
        }
        if (t instanceof GenericArrayType) {
            throw new IllegalStateException("Data Model Error: Simple deserializer does not handle arrays, please use Collection instead.");
        }
        throw new IllegalStateException("Data Model Error: Unknown type " + t.toString() + ".");
    }

    private static ClassAndMethod getClassForFieldName(String fieldName, Class<?> classToLookForFieldIn) {
        return DataModelSerializer.internalGetClassForFieldName(fieldName, classToLookForFieldIn, false);
    }

    private static ClassAndMethod getClassForCollectionOfFieldName(String fieldName, Class<?> classToLookForFieldIn) {
        return DataModelSerializer.internalGetClassForFieldName(fieldName, classToLookForFieldIn, true);
    }

    private static ClassAndMethod internalGetClassForFieldName(String fieldName, Class<?> classToLookForFieldIn, boolean isForArray) {
        Method found = null;
        String fieldNameAsASetter = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        for (Method m : classToLookForFieldIn.getMethods()) {
            String methodName = m.getName();
            if (m.getParameterTypes().length != 1 || !methodName.equals(fieldNameAsASetter)) continue;
            found = m;
            break;
        }
        if (found == null) {
            if (IGNORE_UNKNOWN_FIELDS) {
                return null;
            }
            throw new IllegalStateException("Data Model Error: Found unexpected JSON field " + fieldName + " supposedly for in class " + classToLookForFieldIn.getName());
        }
        ClassAndMethod cm = new ClassAndMethod();
        cm.m = found;
        if (isForArray) {
            Type t = found.getGenericParameterTypes()[0];
            cm.cls = DataModelSerializer.getClassForType(t);
            return cm;
        }
        cm.cls = found.getParameterTypes()[0];
        return cm;
    }

    private static void invokeSetter(Method setter, Object targetObject, Object value) {
        try {
            if (!setter.isAnnotationPresent(JSONIgnore.class)) {
                setter.invoke(targetObject, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Data Model Error: unable to invoke setter for data model element " + setter.getName() + " on " + targetObject.getClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Data Model Error: unable to invoke setter for data model element " + setter.getName() + " on " + targetObject.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Data Model Error: unable to invoke setter for data model element " + setter.getName() + " on " + targetObject.getClass().getName(), e);
        }
    }

    private static <T> T processJsonObjectBackIntoDataModelInstance(JsonObject json, Class<? extends T> typeOfObject, Verification verify) throws IOException, BadVersionException {
        Set jsonSet = json.entrySet();
        Object targetObject = null;
        try {
            targetObject = typeOfObject.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Data Model Error: unable to instantiate data model element " + typeOfObject.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Data Model Error: unable to instantiate data model element " + typeOfObject.getName(), e);
        }
        if (verify.equals((Object)Verification.VERIFY) && targetObject instanceof VersionableContent) {
            String version = null;
            try {
                version = json.getString(((VersionableContent)targetObject).nameOfVersionAttribute(), null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (version != null) {
                ((VersionableContent)targetObject).validate(version);
            }
        }
        for (Map.Entry keyEntry : jsonSet) {
            Date d;
            ClassAndMethod fieldType;
            String keyString = (String)keyEntry.getKey();
            JsonValue value = (JsonValue)keyEntry.getValue();
            if (value == null || value.getValueType().equals((Object)JsonValue.ValueType.NULL)) continue;
            String valueString = null;
            valueString = value.getValueType().equals((Object)JsonValue.ValueType.STRING) ? ((JsonString)value).getString() : value.toString();
            if (value instanceof JsonObject) {
                JsonObject incompatibleFields;
                fieldType = DataModelSerializer.getClassForFieldName(keyString, targetObject.getClass());
                if (fieldType == null) continue;
                if (HasBreakingChanges.class.isAssignableFrom(fieldType.cls) && (incompatibleFields = json.getJsonObject(keyString + "2")) != null) {
                    Object entry2;
                    JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
                    Set valueSet = ((JsonObject)value).entrySet();
                    for (Object entry2 : valueSet) {
                        jsonObjectBuilder.add((String)entry2.getKey(), (JsonValue)entry2.getValue());
                    }
                    Set incompatibleFieldsSet = incompatibleFields.entrySet();
                    entry2 = incompatibleFieldsSet.iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry3 = (Map.Entry)entry2.next();
                        jsonObjectBuilder.add((String)entry3.getKey(), (JsonValue)entry3.getValue());
                    }
                    value = jsonObjectBuilder.build();
                }
                Object newChild = DataModelSerializer.processJsonObjectBackIntoDataModelInstance((JsonObject)value, fieldType.cls, verify);
                DataModelSerializer.invokeSetter(fieldType.m, targetObject, newChild);
                continue;
            }
            if (value instanceof JsonArray) {
                fieldType = DataModelSerializer.getClassForFieldName(keyString, targetObject.getClass());
                if (fieldType == null) continue;
                if (fieldType.cls.equals(Collection.class) || fieldType.cls.equals(List.class)) {
                    ArrayList newList = new ArrayList();
                    ClassAndMethod listElementType = DataModelSerializer.getClassForCollectionOfFieldName(keyString, targetObject.getClass());
                    if (listElementType == null) {
                        throw new IllegalStateException("Data Model Error: unable to deserialize a JSON array into a field with no generic information. " + keyString);
                    }
                    DataModelSerializer.processJsonArray((JsonArray)value, newList, listElementType.cls, verify, ListVersionHandling.THROW_EXCEPTION);
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, newList);
                    continue;
                }
                throw new IllegalStateException("Data Model Error: unable to deserialize a JSON array into a field that is not of type List/Collection " + keyString);
            }
            fieldType = DataModelSerializer.getClassForFieldName(keyString, targetObject.getClass());
            if (fieldType == null) continue;
            if (fieldType.cls.isEnum()) {
                Object o = null;
                if (keyString.indexOf(32) == -1) {
                    try {
                        Field enumInstance = fieldType.cls.getField(valueString.toUpperCase());
                        if (enumInstance != null) {
                            o = enumInstance.get(null);
                        }
                    }
                    catch (NoSuchFieldException enumInstance) {
                    }
                    catch (SecurityException enumInstance) {
                    }
                    catch (IllegalArgumentException enumInstance) {
                    }
                    catch (IllegalAccessException enumInstance) {
                        // empty catch block
                    }
                }
                if (o == null) {
                    for (Method m : fieldType.cls.getMethods()) {
                        if (!Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].equals(String.class)) continue;
                        if ("valueOf".equals(m.getName())) {
                            try {
                                o = m.invoke(null, valueString);
                            }
                            catch (IllegalArgumentException entry3) {
                            }
                            catch (InvocationTargetException entry3) {
                            }
                            catch (IllegalAccessException entry3) {}
                        } else {
                            try {
                                o = m.invoke(null, valueString);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalStateException("Data Model Error: unable to invoke setter " + fieldType.m.getName() + " for data model element " + fieldType.cls.getName() + " on " + targetObject.getClass().getName(), e);
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalStateException("Data Model Error: unable to invoke setter " + fieldType.m.getName() + " for data model element " + fieldType.cls.getName() + " on " + targetObject.getClass().getName(), e);
                            }
                            catch (InvocationTargetException e) {
                                throw new IllegalStateException("Data Model Error: unable to invoke setter " + fieldType.m.getName() + " for data model element " + fieldType.cls.getName() + " on " + targetObject.getClass().getName(), e);
                            }
                        }
                        if (o != null) break;
                    }
                }
                if (o == null) {
                    throw new IllegalStateException("Data Model Error: unable to handle Enum value of " + value + " for enum " + fieldType.cls.getName());
                }
                DataModelSerializer.invokeSetter(fieldType.m, targetObject, o);
                continue;
            }
            if (fieldType.cls.isPrimitive()) {
                JsonNumber n;
                String type = fieldType.cls.getName();
                if ("int".equals(type)) {
                    n = (JsonNumber)value;
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, n.intValue());
                    continue;
                }
                if ("byte".equals(type)) {
                    n = (JsonNumber)value;
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, (byte)n.intValue());
                    continue;
                }
                if ("short".equals(type)) {
                    n = (JsonNumber)value;
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, (short)n.intValue());
                    continue;
                }
                if ("long".equals(type)) {
                    n = (JsonNumber)value;
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, n.longValue());
                    continue;
                }
                if ("boolean".equals(type)) {
                    Boolean b = Boolean.valueOf(valueString);
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, b);
                    continue;
                }
                throw new IllegalStateException("Data Model Error: unsupported primitive type used " + type + " in setter " + fieldType.m.getName());
            }
            if (fieldType.cls.equals(Calendar.class)) {
                try {
                    d = DataModelSerializer.getDateFormat().parse(valueString);
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, c);
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalStateException("JSON Error: date was not correctly formatted, got " + value, e);
                }
            }
            if (fieldType.cls.equals(Date.class)) {
                try {
                    d = DataModelSerializer.getDateFormat().parse(valueString);
                    DataModelSerializer.invokeSetter(fieldType.m, targetObject, d);
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalStateException("JSON Error: date was not correctly formatted, got " + value, e);
                }
            }
            if (fieldType.cls.equals(Locale.class)) {
                Locale l = RepositoryCommonUtils.localeForString(valueString);
                DataModelSerializer.invokeSetter(fieldType.m, targetObject, l);
                continue;
            }
            if (fieldType.cls.equals(String.class)) {
                DataModelSerializer.invokeSetter(fieldType.m, targetObject, valueString);
                continue;
            }
            throw new IllegalArgumentException("Data Model Error: unable to invoke setter for data model element " + fieldType.m.getName() + " on " + targetObject.getClass().getName());
        }
        return (T)targetObject;
    }

    private static <T> void processJsonArray(JsonArray jsonArray, List<T> list, Class<? extends T> listClass, Verification verify, ListVersionHandling versionHandler) throws IOException, BadVersionException {
        block9: for (JsonValue value : jsonArray) {
            switch (value.getValueType()) {
                case TRUE: 
                case FALSE: 
                case ARRAY: {
                    throw new IllegalStateException(DATA_MODEL_ERROR_ARRAY);
                }
                case OBJECT: {
                    try {
                        T newArrayElement = DataModelSerializer.processJsonObjectBackIntoDataModelInstance((JsonObject)value, listClass, verify);
                        list.add(newArrayElement);
                        break;
                    }
                    catch (BadVersionException e) {
                        if (ListVersionHandling.IGNORE_ELEMENT.equals((Object)versionHandler)) continue block9;
                        throw e;
                    }
                }
                case STRING: {
                    list.add(listClass.cast(((JsonString)value).getString()));
                    break;
                }
                case NULL: {
                    list.add(null);
                    break;
                }
                case NUMBER: {
                    throw new IllegalStateException(DATA_MODEL_ERROR_NUMBER);
                }
                default: {
                    throw new IllegalStateException("Data Model Error: Unknown Json value type returned: " + value.getValueType().toString());
                }
            }
        }
    }

    public static <T> T deserializeObject(InputStream i, Class<? extends T> typeOfObject) throws IOException, BadVersionException {
        return DataModelSerializer.doDeserializeObject(i, typeOfObject, Verification.VERIFY);
    }

    public static <T> T deserializeObjectWithoutVerification(InputStream i, Class<? extends T> typeOfObject) throws IOException {
        T result = null;
        try {
            result = DataModelSerializer.doDeserializeObject(i, typeOfObject, Verification.DO_NOT_VERIFY);
        }
        catch (BadVersionException badVersionException) {
            // empty catch block
        }
        return result;
    }

    public static <T> T deserializeObject(JsonObject jsonObject, Class<? extends T> typeOfObject, Verification verify) throws IOException, BadVersionException {
        return DataModelSerializer.processJsonObjectBackIntoDataModelInstance(jsonObject, typeOfObject, verify);
    }

    private static <T> T doDeserializeObject(InputStream i, Class<? extends T> typeOfObject, Verification verify) throws IOException, BadVersionException {
        try {
            JsonReader jsonReader = Json.createReader((InputStream)i);
            JsonObject parsedObject = jsonReader.readObject();
            jsonReader.close();
            T newT = DataModelSerializer.processJsonObjectBackIntoDataModelInstance(parsedObject, typeOfObject, verify);
            return newT;
        }
        catch (JsonException e) {
            throw new IOException("Failed to deserialize object of type " + typeOfObject.getName(), e);
        }
    }

    public static <T> List<T> deserializeList(InputStream i, Class<? extends T> listElementType) throws IOException {
        ArrayList newT = new ArrayList();
        try {
            JsonReader jsonReader = Json.createReader((InputStream)i);
            JsonArray parsedArray = jsonReader.readArray();
            jsonReader.close();
            DataModelSerializer.processJsonArray(parsedArray, newT, listElementType, Verification.VERIFY, ListVersionHandling.IGNORE_ELEMENT);
        }
        catch (BadVersionException jsonReader) {
        }
        catch (JsonException e) {
            throw new IOException("Failed to deserialize list", e);
        }
        return newT;
    }

    private static DateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        dateFormat.setTimeZone(UTC);
        return dateFormat;
    }

    private static class ClassAndMethod {
        Class<?> cls;
        Method m;

        private ClassAndMethod() {
        }
    }

    public static class JSONArtrifactPair {
        public final JsonStructure mainObject;
        public final JsonObject incompatibleFieldsObject;

        public JSONArtrifactPair(JsonStructure mainObject, JsonObject incompatibleFieldsObject) {
            this.mainObject = mainObject;
            this.incompatibleFieldsObject = incompatibleFieldsObject;
        }
    }

    private static enum ListVersionHandling {
        IGNORE_ELEMENT,
        THROW_EXCEPTION;

    }

    public static enum Verification {
        VERIFY,
        DO_NOT_VERIFY;

    }
}

