/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.RepositoryConfig;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.cmdline.InstallExecutor;
import com.ibm.ws.install.utility.cmdline.ReturnCode;
import com.ibm.ws.install.utility.internal.cmdline.Action;
import com.ibm.ws.install.utility.internal.cmdline.CmdUtils;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.liberty.MainRepository;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryHttpException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TestConnectionAction
implements ActionHandler {
    private Properties repoProperties;
    private File repoPropertiesFile;
    private String repoId;
    private static ReturnCode returnCode = ReturnCode.OK;
    private static Map<String, TestConnectionResults> repoConnResults = new ConcurrentHashMap<String, TestConnectionResults>();
    private static Map<String, RepositoryConfig> repoMap = new ConcurrentHashMap<String, RepositoryConfig>();
    private static List<RepositoryConfig> repoAuthenticationList;

    ReturnCode initialize(Arguments args) {
        if (args.getPositionalArguments().size() > 1) {
            System.out.println(CmdUtils.getMessage("ERROR_MORE_THAN_0_OR_1_ARGUMENTS", new Object[]{Action.testConnection, args.getPositionalArguments().size()}));
            return ReturnCode.BAD_ARGUMENT;
        }
        this.repoId = args.getPositionalArguments().isEmpty() ? null : (String)args.getPositionalArguments().get(0);
        return ReturnCode.OK;
    }

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        ReturnCode rc = this.initialize(args);
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        this.repoPropertiesFile = new File(RepositoryConfigUtils.getRepoPropertiesFileLocation());
        if (this.repoPropertiesFile.exists()) {
            try {
                this.repoProperties = RepositoryConfigUtils.loadRepoProperties();
            }
            catch (InstallException e) {
                System.out.println(e.getMessage());
                return ReturnCode.IO_FAILURE;
            }
        }
        try {
            return this.testRepositories();
        }
        catch (InstallException e) {
            System.out.println(e.getMessage());
            return InstallExecutor.returnCode((int)e.getRc());
        }
    }

    private static ReturnCode testRepository(RepositoryConfig rc, RestRepositoryConnectionProxy proxy, String proxyStatus) {
        URL url;
        RestRepositoryConnection lie = null;
        TestConnectionResults results = new TestConnectionResults(null, null, null);
        if (rc.isLibertyRepository()) {
            if (proxyStatus != null) {
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                results.setTestReason(proxyStatus);
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
            try {
                lie = MainRepository.createConnection((RestRepositoryConnectionProxy)proxy);
            }
            catch (RepositoryBackendIOException e) {
                Throwable cause = e;
                Throwable rootCause = e;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                if (e instanceof RepositoryHttpException && ((RepositoryHttpException)e).get_httpRespCode() == 407) {
                    repoAuthenticationList.add(rc);
                    return ReturnCode.OK;
                }
                while ((rootCause = cause.getCause()) != null && cause != rootCause) {
                    if (rootCause instanceof UnknownHostException && proxy != null) {
                        results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                        results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_UNKNOWN_PROXY_HOST", new Object[]{proxy.getProxyURL().getHost()}));
                        repoConnResults.put(rc.getId(), results);
                        return ReturnCode.CONNECTION_FAILED;
                    }
                    if (rootCause instanceof ConnectException && rootCause.getMessage() != null && rootCause.getMessage().contains("Connection refused") && proxy != null) {
                        results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                        results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_INCORRECT_PROXY_PORT", new Object[]{String.valueOf(proxy.getProxyURL().getPort())}));
                        repoConnResults.put(rc.getId(), results);
                        return ReturnCode.CONNECTION_FAILED;
                    }
                    cause = rootCause;
                }
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                if (sw.toString().contains("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
                    results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT_JDK_WRONG", new Object[0]));
                } else {
                    results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT", new Object[0]));
                }
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
        }
        try {
            url = new URL(rc.getUrl());
            String protocol = url.getProtocol();
            if (!(protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("file"))) {
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                results.setTestReason(CmdUtils.getMessage("ERROR_REPO_UNSUPPORT_PROTOCOL", rc.getUrl()));
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
        }
        catch (MalformedURLException e) {
            results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
            results.setTestReason(CmdUtils.getMessage("ERROR_REPO_INVALID_URL", rc.getUrl()));
            repoConnResults.put(rc.getId(), results);
            return ReturnCode.CONNECTION_FAILED;
        }
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                File f = new File(url.toURI());
                if (!f.exists()) {
                    results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                    results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_NOT_EXISTS", new Object[]{f.getAbsolutePath()}));
                    repoConnResults.put(rc.getId(), results);
                    return ReturnCode.CONNECTION_FAILED;
                }
                if (!f.isDirectory()) {
                    if (!CmdUtils.isValidZipBasedRepo(f)) {
                        results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                        results.setTestReason(CmdUtils.getMessage("ERROR_REPO_IS_INVALID", f.getAbsolutePath()));
                        repoConnResults.put(rc.getId(), results);
                        return ReturnCode.CONNECTION_FAILED;
                    }
                } else if (!CmdUtils.isValidDirectoryRepo(f)) {
                    results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                    results.setTestReason(CmdUtils.getMessage("ERROR_REPO_IS_INVALID", f.getAbsolutePath()));
                    repoConnResults.put(rc.getId(), results);
                    return ReturnCode.CONNECTION_FAILED;
                }
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]));
                repoConnResults.put(rc.getId(), results);
            }
            catch (Exception e) {
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                results.setTestReason(CmdUtils.getMessage("ERROR_REPO_INVALID_URL", rc.getUrl()));
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
            return ReturnCode.OK;
        }
        String decodedPwd = rc.getUserPwd();
        if (decodedPwd != null && !decodedPwd.isEmpty()) {
            try {
                decodedPwd = PasswordUtil.decode((String)rc.getUserPwd());
            }
            catch (InvalidPasswordDecodingException ipde) {
                decodedPwd = rc.getUserPwd();
                results.setWarning(CmdUtils.getMessage("MSG_PASSWORD_NOT_ENCODED", rc.getId()));
                repoConnResults.put(rc.getId(), results);
            }
            catch (UnsupportedCryptoAlgorithmException ucae) {
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_CRYPTO_UNSUPPORTED", new Object[0]));
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
        }
        lie = new RestRepositoryConnection(rc.getUser(), decodedPwd, rc.getApiKey(), rc.getUrl().toString());
        if (lie != null) {
            if (proxyStatus != null) {
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                results.setTestReason(proxyStatus);
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
            if (proxy != null) {
                lie.setProxy(proxy);
            }
            try {
                lie.checkRepositoryStatus();
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]));
                repoConnResults.put(rc.getId(), results);
            }
            catch (IOException ioe) {
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                if (ioe.getClass().getName().contains("UnknownHostException") && proxy != null) {
                    results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_UNKNOWN_PROXY_HOST", new Object[]{proxy.getProxyURL().getHost()}));
                } else if (ioe.getClass().getName().contains("ConnectException") && ioe.getMessage() != null && ioe.getMessage().contains("Connection refused") && proxy != null) {
                    results.setTestReason(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_INCORRECT_PROXY_PORT", new Object[]{String.valueOf(proxy.getProxyURL().getPort())}));
                } else if (ExceptionUtils.isCertPathBuilderException((Throwable)ioe.getCause())) {
                    results.setTestReason(CmdUtils.getMessage("ERROR_FAILED_TO_CONNECT_REPO_CAUSED_BY_CERT", new Object[0]));
                } else {
                    results.setTestReason(CmdUtils.getMessage("ERROR_FAILED_TO_CONNECT_REPO", new Object[0]));
                }
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
            catch (RequestFailureException rfe) {
                if (rfe.getResponseCode() == 401 || rfe.getResponseCode() == 407) {
                    repoAuthenticationList.add(rc);
                }
                results.setTestStatus(CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]));
                results.setTestReason(CmdUtils.getMessage("ERROR_FAILED_TO_CONNECT_REPO", RepositoryConfigUtils.getRepoPropertiesFileLocation()));
                repoConnResults.put(rc.getId(), results);
                return ReturnCode.CONNECTION_FAILED;
            }
        }
        return ReturnCode.OK;
    }

    private ReturnCode testRepositories() throws InstallException {
        List repositoryConfigs = null;
        String proxyStatus = null;
        try {
            repositoryConfigs = RepositoryConfigUtils.getRepositoryConfigs((Properties)this.repoProperties);
        }
        catch (InstallException e) {
            System.out.println(e.getMessage());
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        RestRepositoryConnectionProxy proxy = null;
        try {
            proxy = RepositoryConfigUtils.getProxyInfo((Properties)this.repoProperties);
        }
        catch (InstallException e) {
            proxyStatus = e.getMessage();
        }
        repoAuthenticationList = Collections.synchronizedList(new ArrayList(repositoryConfigs.size()));
        if (this.repoId == null) {
            ExecutorService executor = Executors.newFixedThreadPool(repositoryConfigs.size());
            System.out.println(CmdUtils.getMessage("MSG_TESTING_ALL", new Object[0]));
            try {
                for (RepositoryConfig rc : repositoryConfigs) {
                    repoMap.put(rc.getId(), rc);
                    if (rc.isLibertyRepository() && !RepositoryConfigUtils.isWlpRepoEnabled((Properties)this.repoProperties)) {
                        this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_NOT_TESTED", new Object[0]), CmdUtils.getMessage("MSG_DEFAULT_NOT_ENABLED", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
                        continue;
                    }
                    TestConnectionActionRunnable worker = new TestConnectionActionRunnable(rc, proxy, proxyStatus);
                    executor.execute(worker);
                }
                executor.shutdown();
                while (!executor.isTerminated()) {
                }
            }
            catch (Exception e) {
                throw new InstallException(CmdUtils.getMessage("ERROR_NO_CONNECTION", new Object[0]), (Throwable)e, 21);
            }
        } else {
            for (RepositoryConfig rc : repositoryConfigs) {
                repoMap.put(rc.getId(), rc);
                if (!rc.getId().equalsIgnoreCase(this.repoId)) continue;
                System.out.println(CmdUtils.getMessage("MSG_TESTING", rc.getId()));
                if (rc.isLibertyRepository() && !RepositoryConfigUtils.isWlpRepoEnabled((Properties)this.repoProperties)) {
                    this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_NOT_TESTED", new Object[0]), CmdUtils.getMessage("MSG_DEFAULT_NOT_ENABLED", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
                    break;
                }
                returnCode = TestConnectionAction.testRepository(rc, proxy, proxyStatus);
            }
        }
        if (repoConnResults != null && !repoConnResults.isEmpty() || repoAuthenticationList != null && !repoAuthenticationList.isEmpty()) {
            if (repoAuthenticationList != null && !repoAuthenticationList.isEmpty()) {
                int promptCode = 200;
                List orderedList = RepositoryConfigUtils.getRepositoryConfigs((Properties)this.repoProperties);
                block9: for (RepositoryConfig rc : orderedList) {
                    for (RepositoryConfig authList : repoAuthenticationList) {
                        if (!authList.getId().equalsIgnoreCase(rc.getId())) continue;
                        if (promptCode == 407) {
                            this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]), CmdUtils.getMessage("ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
                            continue block9;
                        }
                        promptCode = this.promptUser(rc, proxy);
                        if (promptCode == -1) {
                            return ReturnCode.USER_ABORT;
                        }
                        if (promptCode == 200) continue block9;
                        returnCode = ReturnCode.CONNECTION_FAILED;
                        continue block9;
                    }
                }
            }
            this.showConnectionResults();
            return returnCode;
        }
        System.out.println(CmdUtils.getMessage("ERROR_REPO_NOT_IN_LIST", this.repoId, RepositoryConfigUtils.getRepoPropertiesFileLocation()));
        return ReturnCode.REPOSITORY_NOT_FOUND;
    }

    private void showConnectionResults() throws InstallException {
        List orderedList;
        if (this.repoId == null) {
            System.out.println(CmdUtils.getMessage("MSG_CONFIG_REPO_LABEL", new Object[0]));
            System.out.println("----------------------------------------------------------------------");
        }
        if (!(orderedList = RepositoryConfigUtils.getOrderList((Properties)this.repoProperties)).contains("default")) {
            orderedList.add("default");
        }
        block4: for (String repoList : orderedList) {
            for (Map.Entry<String, TestConnectionResults> connectionResults : repoConnResults.entrySet()) {
                String line;
                BufferedReader reader;
                StringBuffer sb;
                if (!connectionResults.getKey().equalsIgnoreCase(repoList)) continue;
                this.showRepoHeader(repoMap.get(connectionResults.getKey()), repoConnResults.get(connectionResults.getKey()));
                String testReason = connectionResults.getValue().getTestReason();
                String testWarning = connectionResults.getValue().getWarning();
                if (testReason != null && !testReason.isEmpty()) {
                    String failReason = CmdUtils.getMessage("FIELD_REPO_REASON", testReason);
                    sb = new StringBuffer();
                    reader = new BufferedReader(new StringReader(failReason));
                    try {
                        while ((line = reader.readLine()) != null) {
                            InstallUtils.wordWrap((StringBuffer)sb, (String)line, (String)"    ");
                        }
                        System.out.print(sb.toString());
                    }
                    catch (IOException e) {
                        System.out.println(failReason);
                    }
                }
                if (testWarning != null && !testWarning.isEmpty()) {
                    String warning = CmdUtils.getMessage("FIELD_REPO_WARNING", testWarning);
                    sb = new StringBuffer();
                    reader = new BufferedReader(new StringReader(warning));
                    try {
                        while ((line = reader.readLine()) != null) {
                            InstallUtils.wordWrap((StringBuffer)sb, (String)line, (String)"    ");
                        }
                        System.out.print(sb.toString() + InstallUtils.NEWLINE);
                    }
                    catch (IOException e) {
                        System.out.println(warning);
                    }
                    continue block4;
                }
                System.out.print(InstallUtils.NEWLINE);
                continue block4;
            }
        }
    }

    private void showRepoHeader(RepositoryConfig repo, TestConnectionResults connResults) {
        StringBuffer sb = new StringBuffer();
        sb.append(CmdUtils.getMessage("FIELD_REPO_NAME", repo.isLibertyRepository() ? CmdUtils.getMessage("MSG_DEFAULT_REPO_LABEL", new Object[0]) : repo.getId())).append(InstallUtils.NEWLINE);
        if (repo.isLibertyRepository()) {
            sb.append(CmdUtils.getMessage("FIELD_REPO_STATUS", connResults.getTestStatus())).append(InstallUtils.NEWLINE);
            System.out.print(sb.toString());
            return;
        }
        sb.append(CmdUtils.getMessage("FIELD_REPO_LOCATION", repo.getUrl())).append(InstallUtils.NEWLINE);
        sb.append(CmdUtils.getMessage("FIELD_REPO_STATUS", connResults.getTestStatus())).append(InstallUtils.NEWLINE);
        System.out.print(sb.toString());
    }

    private int promptUser(RepositoryConfig rc, RestRepositoryConnectionProxy proxy) throws InstallException {
        int connectionStatus;
        RestRepositoryConnection lie = null;
        if (rc.isLibertyRepository()) {
            connectionStatus = CmdUtils.promptProxyDefaultRepo(proxy, this.repoProperties, "testConnection");
        } else {
            lie = new RestRepositoryConnection(rc.getUser(), rc.getUserPwd(), rc.getApiKey(), rc.getUrl().toString());
            lie.setProxy(proxy);
            connectionStatus = CmdUtils.credentialsPrompt(lie, this.repoProperties, "testConnection");
        }
        if (connectionStatus == -1) {
            return connectionStatus;
        }
        if (connectionStatus == 200) {
            this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_REPO_SUCCESS", new Object[0]), null, null);
        } else if (connectionStatus == 407) {
            this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]), CmdUtils.getMessage("ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
        } else if (connectionStatus == 401) {
            this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]), CmdUtils.getMessage("ERROR_REPO_REQUIRES_AUTH", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
        } else if (connectionStatus == -3) {
            this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]), rc.isLibertyRepository() ? InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT_WRONG_JDK", new Object[0]) : CmdUtils.getMessage("ERROR_FAILED_TO_CONNECT_REPO", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
        } else {
            this.insertRepoConnResultsEntry(rc, CmdUtils.getMessage("MSG_CONNECT_REPO_FAILED", new Object[0]), rc.isLibertyRepository() ? InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_FAILED_TO_CONNECT", new Object[0]) : CmdUtils.getMessage("ERROR_FAILED_TO_CONNECT_REPO", RepositoryConfigUtils.getRepoPropertiesFileLocation()), null);
        }
        return connectionStatus;
    }

    private void insertRepoConnResultsEntry(RepositoryConfig rc, String testStatus, String failReason, String warning) {
        if (repoConnResults.get(rc.getId()) == null) {
            repoConnResults.put(rc.getId(), new TestConnectionResults(testStatus, failReason, warning));
        } else {
            TestConnectionResults result = repoConnResults.get(rc.getId());
            if (testStatus != null) {
                result.setTestStatus(testStatus);
            }
            if (failReason != null) {
                result.setTestReason(failReason);
            }
            if (warning != null) {
                result.setWarning(warning);
            }
            repoConnResults.put(rc.getId(), result);
        }
    }

    private static class TestConnectionActionRunnable
    implements Runnable {
        private final RepositoryConfig repositoryConfig;
        private final RestRepositoryConnectionProxy proxy;
        private final String proxyStatus;

        TestConnectionActionRunnable(RepositoryConfig rc, RestRepositoryConnectionProxy proxy, String proxyStatus) {
            this.repositoryConfig = rc;
            this.proxy = proxy;
            this.proxyStatus = proxyStatus;
        }

        @Override
        public void run() {
            ReturnCode rc = TestConnectionAction.testRepository(this.repositoryConfig, this.proxy, this.proxyStatus);
            if (!rc.equals((Object)ReturnCode.OK)) {
                returnCode = rc;
            }
        }
    }

    private static class TestConnectionResults {
        private String testStatus;
        private String failReason;
        private String warning;

        private TestConnectionResults(String status, String reason, String warning) {
            this.testStatus = status;
            this.failReason = reason;
            this.warning = warning;
        }

        private void setTestStatus(String status) {
            this.testStatus = status;
        }

        private void setTestReason(String reason) {
            this.failReason = reason;
        }

        private void setWarning(String warning) {
            this.warning = warning;
        }

        private String getTestStatus() {
            return this.testStatus;
        }

        private String getTestReason() {
            return this.failReason;
        }

        private String getWarning() {
            return this.warning;
        }
    }
}

