/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility;

import com.ibm.ws.bluemix.utility.BluemixUtilityAction;
import com.ibm.ws.bluemix.utility.actions.BindServiceAction;
import com.ibm.ws.bluemix.utility.actions.CreateServiceAction;
import com.ibm.ws.bluemix.utility.actions.DeleteServiceAction;
import com.ibm.ws.bluemix.utility.actions.ImportServiceAction;
import com.ibm.ws.bluemix.utility.actions.InfoAction;
import com.ibm.ws.bluemix.utility.actions.ListImportsAction;
import com.ibm.ws.bluemix.utility.actions.ListServicesAction;
import com.ibm.ws.bluemix.utility.actions.LoginAction;
import com.ibm.ws.bluemix.utility.actions.LogoutAction;
import com.ibm.ws.bluemix.utility.actions.MarketplaceAction;
import com.ibm.ws.bluemix.utility.actions.ShowImportAction;
import com.ibm.ws.bluemix.utility.actions.ShowServiceAction;
import com.ibm.ws.bluemix.utility.actions.SwitchAction;
import com.ibm.ws.bluemix.utility.actions.UnbindServiceAction;
import com.ibm.ws.bluemix.utility.utils.ConsoleWrapper;
import com.ibm.ws.bluemix.utility.utils.NLS;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BluemixUtility {
    private static final Logger logger = Logger.getLogger(BluemixUtility.class.getName());
    private static final boolean DISCONTINUED = true;
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final Map<String, BluemixUtilityAction> actions = new LinkedHashMap<String, BluemixUtilityAction>();

    public BluemixUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerAction(BluemixUtilityAction action) {
        String actionName = action.getActionName();
        if (this.actions.get(actionName) != null) {
            throw new IllegalArgumentException();
        }
        this.actions.put(actionName, action);
    }

    public BluemixUtilityAction getAction(String actionName) {
        BluemixUtilityAction action = this.actions.get(actionName);
        return action;
    }

    public Collection<BluemixUtilityAction> getActions() {
        return this.actions.values();
    }

    int runProgram(String[] args) {
        if (this.stdin == null) {
            this.stderr.println(NLS.getOption("error.missingIO", "stdin"));
            return 254;
        }
        if (this.stdout == null) {
            this.stderr.println(NLS.getOption("error.missingIO", "stdout"));
            return 253;
        }
        if (this.stderr == null) {
            this.stdout.println(NLS.getOption("error.missingIO", "stderr"));
            return 252;
        }
        this.stdout.println();
        this.stdout.println(NLS.getOption("global.discontinue.error", new Object[0]));
        return 0;
    }

    private void printError(Throwable e) {
        String message = e.getMessage() == null ? e.toString() : e.getMessage();
        this.stderr.println(NLS.getOption("error", message));
        logger.log(Level.FINE, "Action generated exception", e);
    }

    private void printUnknownError(BluemixUtilityAction action, Throwable e) {
        this.stderr.println(NLS.getOption("error.unknownException", action.getActionName(), e.toString()));
        e.printStackTrace(this.stderr);
        logger.log(Level.FINE, "Action generated unknown exception", e);
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        BluemixUtility utility = new BluemixUtility(console, System.out, System.err);
        utility.registerAction(new LoginAction());
        utility.registerAction(new MarketplaceAction());
        utility.registerAction(new CreateServiceAction());
        utility.registerAction(new ListServicesAction());
        utility.registerAction(new ShowServiceAction());
        utility.registerAction(new ImportServiceAction());
        utility.registerAction(new ListImportsAction());
        utility.registerAction(new ShowImportAction());
        utility.registerAction(new BindServiceAction());
        utility.registerAction(new UnbindServiceAction());
        utility.registerAction(new DeleteServiceAction());
        utility.registerAction(new SwitchAction());
        utility.registerAction(new InfoAction());
        utility.registerAction(new LogoutAction());
        int rc = utility.runProgram(args);
        System.exit(rc);
    }
}

